/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.tools.biztools.cadre.validate;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.ext.IMultiViewConfigCadreEntityService;

public class CadreFileToolSaveValidator
extends HDTCDataBaseValidator {
    private final IMultiViewConfigCadreEntityService iMultiViewConfigCadreEntityService = (IMultiViewConfigCadreEntityService)ServiceFactory.getService(IMultiViewConfigCadreEntityService.class);
    private final String multiViewConfigErrorMsg = ResManager.loadKDString((String)"\u6863\u6848\u7c7b\u578b\u4e0d\u9002\u7528\u6240\u9009\u6863\u6848\u591a\u89c6\u56fe\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5", (String)"CadreFileToolSaveValidator_0", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);

    public void validate() {
        this.validateMultiViewConfigFileType();
    }

    private void validateMultiViewConfigFileType() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject personFileTool = dy.getDataEntity();
            long fileTypeId = personFileTool.getLong("filetype.id");
            DynamicObjectCollection dynamicObjectCollection = personFileTool.getDynamicObjectCollection("cadrefileviews");
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
                List multiViewConfigIdList = dynamicObjectCollection.stream().map(dd -> dd.getLong("fbasedataid_id")).collect(Collectors.toList());
                List dynamicObjectList = this.iMultiViewConfigCadreEntityService.queryOriginalList(multiViewConfigIdList);
                dynamicObjectList.forEach(dm -> {
                    long currentFileTypeId = dm.getLong("erfiletype");
                    if (currentFileTypeId != fileTypeId) {
                        this.addErrorMessage((ExtendedDataEntity)dy, this.multiViewConfigErrorMsg);
                    }
                });
            }
        });
    }
}

