/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.tools.biztools.person.validate;

import java.util.Arrays;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.ext.IInfoGroupPageRegisterEntityService;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.IMulPersonFileToolDomainService;

public class MulPersonFileRepeatRegisterValidator
extends HDTCDataBaseValidator {
    private final IMulPersonFileToolDomainService mulPersonFileToolDomainService = (IMulPersonFileToolDomainService)ServiceFactory.getService(IMulPersonFileToolDomainService.class);
    private final IInfoGroupPageRegisterEntityService infoGroupPageRegisterEntityService = (IInfoGroupPageRegisterEntityService)ServiceFactory.getService(IInfoGroupPageRegisterEntityService.class);
    private final String repeatRegisterErrorMsg = ResManager.loadKDString((String)"%1$s:\u201c\u6863\u6848\u7c7b\u578b\u201d \u503c %2$s \u5df2\u6ce8\u518c\uff0c\u4e0d\u80fd\u91cd\u590d\u6ce8\u518c\u3002", (String)"MulPersonFileRepeatRegisterValidator_0", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);

    public void validate() {
        this.repeatRegisterValidate();
    }

    protected void repeatRegisterValidate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject dyn = dy.getDataEntity();
            String entityNumber = dyn.getString("bizmodel.mainentity.number");
            String entityName = dyn.getString("bizmodel.name");
            DynamicObjectCollection dynamicObjectCollection = dyn.getDynamicObjectCollection("personfileentry");
            if (dynamicObjectCollection != null) {
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    long fileTypeId;
                    String bizType = dynamicObject.getString("biztype");
                    String infoGroupPageRegisterNumber = this.mulPersonFileToolDomainService.generateInfoGroupPageRegisterNumber(entityNumber, bizType, fileTypeId = dynamicObject.getLong("filetype.id"));
                    boolean existInfoGroupPageRegister = this.infoGroupPageRegisterEntityService.isExistInfoGroupPageRegister(infoGroupPageRegisterNumber);
                    if (!existInfoGroupPageRegister) continue;
                    String repeatRegisterErrorInfo = String.format(Locale.ROOT, this.repeatRegisterErrorMsg, entityName, dynamicObject.getString("filetype.name"));
                    this.addErrorMessage((ExtendedDataEntity)dy, repeatRegisterErrorInfo);
                }
            }
        });
    }
}

