/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.tools.biztools.person.validate;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.entity.IMulPersonFileToolEntityService;

public class MulPersonFileToolRepeatValidator
extends HDTCDataBaseValidator {
    private final IMulPersonFileToolEntityService iMulPersonFileToolEntityService = (IMulPersonFileToolEntityService)ServiceFactory.getService(IMulPersonFileToolEntityService.class);

    public void validate() {
        this.checkCombinationFiledRepeat();
    }

    private void checkCombinationFiledRepeat() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet bizModelIdSet = new HashSet(16);
        String showInfo = ResManager.loadKDString((String)"\u5206\u5f55%1$s\uff1a\u8be5\u6570\u636e\u7684\u4e1a\u52a1\u6a21\u578b\u5b9e\u4f53\u3001\u6863\u6848\u7c7b\u578b\u3001\u4e1a\u52a1\u7c7b\u578b\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"MulPersonFileToolSaveValidator_3", (String)"hdtc-hrdt-formplugin", (Object[])new Object[0]);
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObjectCollection dynamicObjectCollection = dy.getDataEntity().getDynamicObjectCollection("personfileentry");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                String message = ResManager.loadKDString((String)"\u6863\u6848\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"MulPersonFileToolSaveValidator_0", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);
                this.addErrorMessage((ExtendedDataEntity)dy, message);
                return;
            }
            bizModelIdSet.add(dy.getDataEntity().getLong("bizmodel.id"));
        });
        QFilter bizModelIdsQFilter = new QFilter("bizmodel.id", "in", bizModelIdSet);
        DynamicObject[] personFileEntrys = this.iMulPersonFileToolEntityService.query("id,number,personfileentry.fid,personfileentry.filetype,personfileentry.biztype,bizmodel", new QFilter[]{bizModelIdsQFilter});
        HashMap personFileDBMap = new HashMap(16);
        Arrays.asList(personFileEntrys).stream().forEach(personFileEntry -> personFileEntry.getDynamicObjectCollection("personfileentry").forEach(dy -> personFileDBMap.put(this.buildKey((DynamicObject)personFileEntry, (DynamicObject)dy), personFileEntry.getLong("id"))));
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject dynamicObject = dy.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = dy.getDataEntity().getDynamicObjectCollection("personfileentry");
            Map<String, List<String>> map = dynamicObjectCollection.stream().map(it -> this.buildKey(dynamicObject, (DynamicObject)it)).collect(Collectors.groupingBy(it -> it));
            for (DynamicObject entryData : dynamicObjectCollection) {
                String key = this.buildKey(dynamicObject, entryData);
                List<String> list = map.get(key);
                if (CollectionUtils.isNotEmpty(list) && list.size() > 1) {
                    this.addErrorMessage((ExtendedDataEntity)dy, String.format(Locale.ROOT, showInfo, entryData.get("seq")));
                    continue;
                }
                Long personFileEntryId = (Long)personFileDBMap.get(key);
                if (personFileEntryId == null || personFileEntryId.equals(entryData.getLong("id"))) continue;
                this.addErrorMessage((ExtendedDataEntity)dy, String.format(Locale.ROOT, showInfo, entryData.get("seq")));
            }
        });
    }

    private String buildKey(DynamicObject dynamicObject, DynamicObject personFileEntry) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(dynamicObject.getString("bizmodel.id"));
        stringBuilder.append(personFileEntry.getString("filetype.id"));
        stringBuilder.append(personFileEntry.getString("biztype"));
        return stringBuilder.toString();
    }
}

