/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.tools.biztools.person.validate;

import java.util.Arrays;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.ext.IMultiViewConfigEmpEntityService;
import kd.hdtc.hrdt.business.domain.ext.IMultiViewConfigEntityService;

public class MulPersonFileToolSaveValidator
extends HDTCDataBaseValidator {
    private final IMultiViewConfigEmpEntityService iMultiViewConfigEmpEntityService = (IMultiViewConfigEmpEntityService)ServiceFactory.getService(IMultiViewConfigEmpEntityService.class);
    private final IMultiViewConfigEntityService iMultiViewConfigEntityService = (IMultiViewConfigEntityService)ServiceFactory.getService(IMultiViewConfigEntityService.class);
    private final String multiViewConfigErrorMsg = ResManager.loadKDString((String)"\u6863\u6848\u7c7b\u578b\uff1a%1$s\uff0c\u4e0d\u9002\u7528\u6240\u9009\u6863\u6848\u591a\u89c6\u56fe\u65b9\u6848\uff1a%2$s\uff0c\u8bf7\u68c0\u67e5", (String)"MulPersonFileToolSaveValidator_4", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);

    public void validate() {
        this.validateMultiViewConfigFileType();
    }

    private void validateMultiViewConfigFileType() {
        Arrays.stream(this.dataEntities).forEach(dy -> {
            DynamicObjectCollection dynamicObjectCollection = dy.getDataEntity().getDynamicObjectCollection("personfileentry");
            if (CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                String message = ResManager.loadKDString((String)"\u6863\u6848\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (String)"MulPersonFileToolSaveValidator_0", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);
                this.addErrorMessage((ExtendedDataEntity)dy, message);
                return;
            }
            dynamicObjectCollection.forEach(dyObj -> {
                long fileTypeId = dyObj.getLong("filetype.id");
                String bizType = dyObj.getString("biztype");
                String fileViews = "1".equals(bizType) ? "pcfileviews" : "personfileviews";
                DynamicObjectCollection fileViewsCollection = dyObj.getDynamicObjectCollection(fileViews);
                if (CollectionUtils.isNotEmpty((Collection)fileViewsCollection)) {
                    fileViewsCollection.forEach(dm -> {
                        long erFileTypeId = dm.getLong("fbasedataid.erfiletype.id");
                        if (erFileTypeId != fileTypeId) {
                            this.addErrorMessage((ExtendedDataEntity)dy, String.format(this.multiViewConfigErrorMsg, dyObj.getString("filetype.name"), dm.getDynamicObject("fbasedataid").getLocaleString("name")));
                            return;
                        }
                    });
                }
            });
        });
    }
}

