/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.tools.biztools.person.validate;

import java.util.Arrays;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.IPersonFileToolDomainService;

public class PersonFileToolRepeatRegisterValidator
extends HDTCDataBaseValidator {
    private final IPersonFileToolDomainService iPersonFileToolDomainService = (IPersonFileToolDomainService)ServiceFactory.getService(IPersonFileToolDomainService.class);
    private final String repeatRegisterErrorMsg = ResManager.loadKDString((String)"\u201c\u540d\u79f0\u201d \u503c %s \u5df2\u6ce8\u518c\uff0c\u4e0d\u80fd\u91cd\u590d\u6ce8\u518c\u3002", (String)"PersonFileToolSaveValidate_0", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);

    public void validate() {
        this.repeatRegisterValidate();
    }

    protected void repeatRegisterValidate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            long fileTypeId;
            DynamicObject dyn = dy.getDataEntity();
            String bizType = dyn.getString("biztype");
            String entityNumber = dyn.getString("bizmodel.mainentity.number");
            String infoGroupPageRegisterNumber = this.iPersonFileToolDomainService.generateInfoGroupPageRegisterNumber(entityNumber, bizType, fileTypeId = dyn.getLong("filetype.id"));
            boolean existInfoGroupPageRegister = this.iPersonFileToolDomainService.isExistInfoGroupPageRegister(infoGroupPageRegisterNumber);
            if (existInfoGroupPageRegister) {
                String repeatRegisterErrorInfo = String.format(Locale.ROOT, this.repeatRegisterErrorMsg, dyn.getString("bizmodel.name"));
                this.addErrorMessage((ExtendedDataEntity)dy, repeatRegisterErrorInfo);
            }
        });
    }
}

