/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.tools.biztools.person.validate;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.ext.IMultiViewConfigEmpEntityService;
import kd.hdtc.hrdt.business.domain.ext.IMultiViewConfigEntityService;

public class PersonFileToolSaveValidator
extends HDTCDataBaseValidator {
    private final IMultiViewConfigEmpEntityService iMultiViewConfigEmpEntityService = (IMultiViewConfigEmpEntityService)ServiceFactory.getService(IMultiViewConfigEmpEntityService.class);
    private final IMultiViewConfigEntityService iMultiViewConfigEntityService = (IMultiViewConfigEntityService)ServiceFactory.getService(IMultiViewConfigEntityService.class);
    private final String multiViewConfigErrorMsg = ResManager.loadKDString((String)"\u6863\u6848\u7c7b\u578b\u4e0d\u9002\u7528\u6240\u9009\u6863\u6848\u591a\u89c6\u56fe\u65b9\u6848\uff0c\u8bf7\u68c0\u67e5", (String)"PersonFileToolSaveValidator_0", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);

    public void validate() {
        this.validateMultiViewConfigFileType();
    }

    private void validateMultiViewConfigFileType() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Arrays.stream(dataEntities).forEach(dy -> {
            DynamicObject personFileTool = dy.getDataEntity();
            long fileTypeId = personFileTool.getLong("filetype.id");
            String bizType = personFileTool.getString("biztype");
            String fileName = "1".equals(bizType) ? "pcfileviews" : "personfileviews";
            DynamicObjectCollection dynamicObjectCollection = personFileTool.getDynamicObjectCollection(fileName);
            if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
                List multiViewConfigIdList = dynamicObjectCollection.stream().map(dd -> dd.getLong("fbasedataid_id")).collect(Collectors.toList());
                List dynamicObjectList = "1".equals(bizType) ? this.iMultiViewConfigEmpEntityService.queryOriginalList(multiViewConfigIdList) : this.iMultiViewConfigEntityService.queryOriginalList(multiViewConfigIdList);
                dynamicObjectList.forEach(dm -> {
                    long currentFileTypeId = dm.getLong("erfiletype");
                    if (currentFileTypeId != fileTypeId) {
                        this.addErrorMessage((ExtendedDataEntity)dy, this.multiViewConfigErrorMsg);
                    }
                });
            }
        });
    }
}

