/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.tools.commontools.op;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.commontools.IBizModelToolApplicationService;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.utils.BizModelToolUtils;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelRecordDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.INumberGenerateDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.impl.NumberGenerateDomainServiceImpl;
import kd.hdtc.hrdt.opplugin.web.extendplatform.tools.commontools.validate.BizModelToolEffectValidator;
import kd.hdtc.hrdt.opplugin.web.extendplatform.tools.commontools.validate.BizModelToolISVNumberValidator;
import kd.hdtc.hrdt.opplugin.web.extendplatform.tools.commontools.validate.BizModelToolSaveValidator;
import kd.hr.hbp.common.util.HRStringUtils;

public class BizModelToolEffectOp
extends HDTCDataBaseOp {
    private static final Log LOG = LogFactory.getLog(BizModelToolEffectOp.class);
    private static final String SEPARATE = ";";
    private static final String[] PREPARE_PROPERTY = new String[]{"entryentity.fieldtype", "entryentity.fieldcode", "entryentity.fieldname", "entryentity.fieldconfig", "entryentity.fieldextattrname", "entryentity.mustinput"};
    private IBizModelToolApplicationService bizModelToolApplicationService = (IBizModelToolApplicationService)ServiceFactory.getService(IBizModelToolApplicationService.class);
    private INumberGenerateDomainService numberGenerateDomainService = new NumberGenerateDomainServiceImpl();
    private IBizModelRecordDomainService bizModelRecordDomainService = (IBizModelRecordDomainService)ServiceFactory.getService(IBizModelRecordDomainService.class);

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("bizmodel");
        fieldKeys.add("effectivestatus");
        fieldKeys.add("inherittpl");
        fieldKeys.add("isv");
        fieldKeys.add("bizunit");
        fieldKeys.add("bizapp");
        fieldKeys.add("issyn");
        fieldKeys.add("metanumber");
        fieldKeys.add("versionnumber");
        fieldKeys.add("entryentity");
        fieldKeys.add("errormessage");
        fieldKeys.add("enable");
        fieldKeys.add("result");
        fieldKeys.add("result_tag");
        fieldKeys.add("description");
        fieldKeys.add("number");
        fieldKeys.addAll(Arrays.asList(PREPARE_PROPERTY));
    }

    public void onAddValidators(AddValidatorsEventArgs addValidatorsEventArgs) {
        addValidatorsEventArgs.addValidator((AbstractValidator)new BizModelToolEffectValidator());
        addValidatorsEventArgs.addValidator((AbstractValidator)new BizModelToolISVNumberValidator());
        addValidatorsEventArgs.addValidator((AbstractValidator)new BizModelToolSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        Object[] dataEntities = args.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        Arrays.stream(dataEntities).forEach(bizModelTool -> bizModelTool.set("effectivestatus", (Object)"2"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        Object[] dataEntities = args.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        ArrayList successBizModelTools = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        ArrayList errorBizModelTools = Lists.newArrayListWithExpectedSize((int)dataEntities.length);
        this.handleBizModelToolMetaNumber((DynamicObject[])dataEntities);
        Arrays.stream(dataEntities).forEach(bizModelTool -> {
            MetadataGenResult metadataGenResult = this.bizModelToolApplicationService.dynamicMetadataEffect(bizModelTool);
            if (metadataGenResult != null && metadataGenResult.isSuccess()) {
                bizModelTool.set("effectivestatus", (Object)"2");
                bizModelTool.set("errormessage", null);
                bizModelTool.set("metanumber", (Object)bizModelTool.getString("metanumber"));
                bizModelTool.set("versionnumber", (Object)metadataGenResult.getVersionNumber());
                successBizModelTools.add(bizModelTool);
                LOG.error("BizModelToolEffectOp effect has create metanumber is : {}", (Object)metadataGenResult.getEntityNumber());
            } else {
                bizModelTool.set("effectivestatus", (Object)"0");
                String errorMessage = HRStringUtils.arrayToString((Object[])metadataGenResult.getMsgList().toArray(), (String)SEPARATE);
                if (CollectionUtils.isNotEmpty((Collection)metadataGenResult.getMsgList())) {
                    bizModelTool.set("errormessage", (Object)errorMessage.substring(0, Math.min(errorMessage.length(), 2000)));
                }
                LOG.error("BizModelToolEffectOp operate dynamicMetadataEffect method has error : {} ", (Object)errorMessage);
                this.bizModelRecordDomainService.rollBackModelRecord(BizModelToolUtils.generateToolResultBos((DynamicObject)bizModelTool));
                bizModelTool.set("metanumber", null);
                errorBizModelTools.add(bizModelTool);
            }
        });
        if (CollectionUtils.isNotEmpty((Collection)errorBizModelTools)) {
            this.getOperationResult().setMessage(ResManager.loadKDString((String)"\u6a21\u578b\u751f\u6548\u5931\u8d25\uff0c\u8bf7\u5728\u5217\u8868\u4e2d\u67e5\u770b\u5931\u8d25\u8be6\u60c5", (String)"BizModelToolEffectOp_0", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]));
            this.getOperationResult().setShowMessage(true);
        }
        this.bizModelToolEffect(successBizModelTools, errorBizModelTools);
    }

    private void bizModelToolEffect(List<DynamicObject> successBizModelTools, List<DynamicObject> errorBizModelTools) {
        List toolResultBos = null;
        try (TXHandle txHandle = TX.requiresNew();){
            if (CollectionUtils.isNotEmpty(successBizModelTools)) {
                LOG.error("BizModelToolEffectOp operate bizModelToolEffect method has success");
                toolResultBos = this.bizModelToolApplicationService.bizModelToolEffect(successBizModelTools);
            }
            if (CollectionUtils.isNotEmpty(errorBizModelTools)) {
                LOG.error("BizModelToolEffectOp operate bizModelToolEffect method has error");
                this.bizModelToolApplicationService.updateBizModelTool(errorBizModelTools);
            }
        }
    }

    private void handleBizModelToolMetaNumber(DynamicObject[] bizModelTools) {
        if (ObjectUtils.isEmpty((Object[])bizModelTools)) {
            return;
        }
        Set bizModelToolNumbers = Arrays.stream(bizModelTools).map(BizModelToolUtils::getSourceNumberFromDyn).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(bizModelToolNumbers)) {
            return;
        }
        Map mulBySourceNumber = this.numberGenerateDomainService.generateMulBySourceNumber(bizModelToolNumbers);
        Arrays.stream(bizModelTools).forEach(bizModelTool -> {
            Map subNumbers = (Map)mulBySourceNumber.get(BizModelToolUtils.getSourceNumberFromDyn((DynamicObject)bizModelTool));
            if (!CollectionUtils.isEmpty((Map)subNumbers)) {
                bizModelTool.set("metanumber", subNumbers.get("current_entity_number_func"));
            }
        });
    }
}

