/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.tools.commontools.op;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.hdtc.hrdbs.opplugin.web.HDTCDataBaseOp;
import kd.hdtc.hrdt.business.common.utils.platform.ISVServiceUtils;
import kd.hdtc.hrdt.opplugin.web.extendplatform.tools.commontools.validate.BizModelToolSaveValidator;
import kd.hdtc.hrdt.opplugin.web.workbench.validate.FieldCodeLegalityValidator;
import kd.hdtc.hrdt.opplugin.web.workbench.validate.NameLegalityValidator;
import kd.hdtc.hrdt.opplugin.web.workbench.validate.NumberLegalityValidator;
import kd.hr.hbp.common.util.HRObjectUtils;

public class BizModelToolSaveOp
extends HDTCDataBaseOp {
    public void onAddValidators(AddValidatorsEventArgs eventArgs) {
        eventArgs.addValidator((AbstractValidator)new NameLegalityValidator());
        eventArgs.addValidator((AbstractValidator)new NumberLegalityValidator());
        eventArgs.addValidator((AbstractValidator)new FieldCodeLegalityValidator());
        eventArgs.addValidator((AbstractValidator)new BizModelToolSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        Object[] dataEntities = args.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        Arrays.stream(dataEntities).forEach(dataEntity -> {
            DynamicObject bizModel = dataEntity.getDynamicObject("bizmodel");
            String number = dataEntity.getString("number");
            if (!HRObjectUtils.isEmpty((Object)bizModel)) {
                dataEntity.set("isv", (Object)ISVServiceUtils.getCurrentISV());
                dataEntity.set("bizunit", (Object)bizModel.getString("bizunit"));
                dataEntity.set("bizapp", (Object)bizModel.getDynamicObject("bizapp"));
                dataEntity.set("issyn", (Object)Boolean.TRUE);
            }
            dataEntity.set("number", (Object)number.toLowerCase());
            DynamicObjectCollection fieldCollection = dataEntity.getDynamicObjectCollection("entryentity");
            if (fieldCollection != null) {
                for (DynamicObject field : fieldCollection) {
                    String fieldCode = field.getString("fieldcode");
                    field.set("fieldcode", (Object)fieldCode.toLowerCase());
                }
            }
        });
    }
}

