/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.tools.commontools.validate;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdt.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrdt.business.common.utils.platform.ISVServiceUtils;

public class BizModelToolSaveValidator
extends HDTCDataBaseValidator {
    private final String FieldConfigMessage = ResManager.loadKDString((String)"%s:\u5b57\u6bb5\u5c5e\u6027\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BizModelToolSaveValidator_1", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);
    private final String fieldNumberMessage = ResManager.loadKDString((String)"%s:\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BizModelToolSaveValidator_3", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);
    private final String fieldNameMessage = ResManager.loadKDString((String)"%s:\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BizModelToolSaveValidator_4", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);
    private final String fieldNumberPreMessage = ResManager.loadKDString((String)"%s:\u5b57\u6bb5\u7f16\u7801\u5fc5\u987b\u4ee5{\u5f00\u53d1\u5546\u6807\u8bc6}\u4f5c\u4e3a\u524d\u7f00\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BizModelToolSaveValidator_5", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);
    private final String fieldNumberValidateMessage = ResManager.loadKDString((String)"%s:\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u3010-\u3011\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BizModelToolSaveValidator_6", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);

    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        for (Object dataEntity : dataEntities) {
            this.validateEntryFieldLegality((ExtendedDataEntity)dataEntity);
        }
    }

    private void validateEntryFieldLegality(ExtendedDataEntity dataEntity) {
        DynamicObject bizModelTool = dataEntity.getDataEntity();
        DynamicObjectCollection fieldEntryEntity = bizModelTool.getDynamicObjectCollection("entryentity");
        if (ObjectUtils.isEmpty((Object)fieldEntryEntity)) {
            return;
        }
        ArrayList fieldNumbers = Lists.newArrayListWithExpectedSize((int)fieldEntryEntity.size());
        ArrayList fieldNames = Lists.newArrayListWithExpectedSize((int)fieldEntryEntity.size());
        String currentISV = ISVServiceUtils.getCurrentISV();
        for (DynamicObject fieldEntry : fieldEntryEntity) {
            String fieldName;
            String fieldNumber;
            String mustInputMessage = this.getMustInputMessage(fieldEntry, fieldNumber = fieldEntry.getString("fieldcode"));
            if (StringUtils.isNotEmpty((CharSequence)mustInputMessage)) {
                this.addErrorMessage(dataEntity, mustInputMessage);
            }
            if (fieldNumbers.contains(fieldNumber)) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, this.fieldNumberMessage, fieldNumber));
            } else {
                fieldNumbers.add(fieldNumber);
            }
            if (fieldNumber.contains("-")) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, this.fieldNumberValidateMessage, fieldNumber));
            }
            if (!"kingdee".equals(currentISV) && !fieldNumber.startsWith(currentISV)) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, this.fieldNumberPreMessage, fieldNumber));
            }
            if (fieldNames.contains(fieldName = fieldEntry.getString("fieldname"))) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, this.fieldNameMessage, fieldNumber));
                continue;
            }
            fieldNames.add(fieldName);
        }
    }

    private String getMustInputMessage(DynamicObject fieldEntry, String fieldNumber) {
        String fieldConfig;
        String fieldType = fieldEntry.getString("fieldtype");
        if (FieldTypeEnum.getExtField((String)fieldType) && StringUtils.isEmpty((CharSequence)(fieldConfig = fieldEntry.getString("fieldconfig")))) {
            return String.format(Locale.ROOT, this.FieldConfigMessage, fieldNumber);
        }
        return null;
    }
}

