/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.validate;

import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.utils.HRDTValidatorUtils;
import kd.hdtc.hrdt.business.domain.extendplatform.base.entity.IBizModelTypeEntityService;
import kd.hr.hbp.common.util.HRObjectUtils;

public class BizModelAbilityValidator
extends HDTCDataBaseValidator {
    private IBizModelTypeEntityService bizModelTypeEntityService = (IBizModelTypeEntityService)ServiceFactory.getService(IBizModelTypeEntityService.class);

    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        for (Object dataEntity : dataEntities) {
            this.validateEntryEntityRepeat((ExtendedDataEntity)dataEntity);
            this.validateBizModelRange((ExtendedDataEntity)dataEntity);
        }
    }

    private void validateEntryEntityRepeat(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        String entryMessage = HRDTValidatorUtils.validateEntryEntityRepeat((DynamicObjectCollection)entryEntity, (String)"bizmodel.id", (String)"bizmodel.name");
        if (StringUtils.isNotEmpty((CharSequence)entryMessage)) {
            this.addErrorMessage(dataEntity, entryMessage);
        }
    }

    private void validateBizModelRange(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection("entryentity");
        DynamicObject bizModelType = dynamicObject.getDynamicObject("bizmodeltype");
        if (HRObjectUtils.isEmpty((Object)bizModelType)) {
            return;
        }
        Integer bizModelTypeLevel = bizModelType.getInt("level");
        if (!ObjectUtils.isEmpty((Object)entryEntity)) {
            Set bizModelTypeIds = entryEntity.stream().map(dy -> dy.getDynamicObject("bizmodel").getLong("bizmodeltype.id")).collect(Collectors.toSet());
            DynamicObject[] bizModelTypes = this.bizModelTypeEntityService.query("id, number, name, level", bizModelTypeIds.toArray());
            Map<Long, Integer> bizModelTypeLevelMap = Arrays.stream(bizModelTypes).collect(Collectors.toMap(key -> key.getLong("id"), value -> value.getInt("level")));
            if (CollectionUtils.isEmpty(bizModelTypeLevelMap)) {
                return;
            }
            String defaultMessage = ResManager.loadKDString((String)"\u9002\u7528\u6a21\u578b\u3010%1$s\u3011\u7684\u4e1a\u52a1\u6a21\u578b\u7c7b\u578b\u4e0d\u80fd\u5c0f\u4e8e\u4e1a\u52a1\u6a21\u578b\u7c7b\u578b\u3010%2$s\u3011\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BizModelAbilityValidator_1", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);
            for (DynamicObject entity : entryEntity) {
                DynamicObject bizModel = entity.getDynamicObject("bizmodel");
                Integer bizModelLevel = bizModelTypeLevelMap.get(bizModel.getLong("bizmodeltype.id"));
                if (bizModelLevel.compareTo(bizModelTypeLevel) <= 0) continue;
                String message = String.format(defaultMessage, bizModel.getString("name"), bizModelType.getString("name"));
                this.addErrorMessage(dataEntity, message);
            }
        }
    }
}

