/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.validate;

import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdt.business.common.utils.HRDTValidatorUtils;

public class BizModelConfigValidator
extends HDTCDataBaseValidator {
    private final String SUB_ENTITY_REPEAT_MESSAGE = ResManager.loadKDString((String)"\u5173\u8054\u4e3b\u6570\u636e\u5b9e\u4f53\u3010%1$s\u3011\u4e0e\u5173\u8054\u5b50\u6570\u636e\u5b9e\u4f53\u3010%2$s\u3011\u4e0d\u80fd\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BizModelConfigValidator_1", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);

    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        this.validateEntryEntityRepeat((ExtendedDataEntity[])dataEntities);
    }

    private void validateEntryEntityRepeat(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection subEntryEntity;
            String subMessage;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObject bizModelType = dynamicObject.getDynamicObject("bizmodeltype");
            DynamicObjectCollection inheritEntryEntity = dynamicObject.getDynamicObjectCollection("inheritentryentity");
            String inheritMessage = HRDTValidatorUtils.validateEntryEntityRepeat((DynamicObjectCollection)inheritEntryEntity, (String)"inheritpath.id", (String)"inheritpath.name");
            if (StringUtils.isNotEmpty((CharSequence)inheritMessage)) {
                this.addErrorMessage(dataEntity, inheritMessage);
            }
            if (StringUtils.isNotEmpty((CharSequence)(subMessage = HRDTValidatorUtils.validateEntryEntityRepeat((DynamicObjectCollection)(subEntryEntity = dynamicObject.getDynamicObjectCollection("subentryentity")), (String)"subentity.id", (String)"subentity.name")))) {
                this.addErrorMessage(dataEntity, subMessage);
            }
            if (bizModelType == null || !"entity".equals(bizModelType.getString("number"))) continue;
            this.validateSubEntityRepeat(dataEntity, subEntryEntity);
        }
    }

    private void validateSubEntityRepeat(ExtendedDataEntity dataEntity, DynamicObjectCollection subEntryEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        DynamicObject mainEntity = dynamicObject.getDynamicObject("mainentity");
        if (ObjectUtils.isEmpty((Object)subEntryEntity) || ObjectUtils.isEmpty((Object)mainEntity)) {
            return;
        }
        String mainEntityId = mainEntity.getString("id");
        for (DynamicObject subEntry : subEntryEntity) {
            DynamicObject subEntity = subEntry.getDynamicObject("subEntity");
            if (subEntity == null || !StringUtils.equals((CharSequence)mainEntityId, (CharSequence)subEntity.getString("id"))) continue;
            String mainEntityName = mainEntity.getString("name");
            String subEntityName = subEntity.getString("name");
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, this.SUB_ENTITY_REPEAT_MESSAGE, mainEntityName, subEntityName));
        }
    }
}

