/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.extendplatform.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.impl.NumberGenerateDomainServiceImpl;

public class CommonISVNumberValidator
extends HDTCDataBaseValidator {
    private IMetadataDomainService metadataDomainService = (IMetadataDomainService)ServiceFactory.getService(IMetadataDomainService.class);
    private final String EXIST_NUMBER_ERROR = ResManager.loadKDString((String)"\u9884\u751f\u6210\u7684%s\u5b9e\u4f53\u7f16\u7801\u5df2\u5b58\u5728", (String)"CommonISVNumberValidator_0", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);

    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (!ObjectUtils.isEmpty((Object[])dataEntities)) {
            Set<String> sourceNumbers = Arrays.stream(dataEntities).map(data -> this.getSourceNumberFromDyn(data.getDataEntity())).collect(Collectors.toSet());
            Map<String, Map<String, String>> numbers = this.generateNumbers(sourceNumbers);
            Set<String> validNumbers = this.getValidNumbers(numbers);
            Map validResult = this.metadataDomainService.isExistMetaData(validNumbers);
            Arrays.stream(dataEntities).forEach(dataEntity -> {
                String sourceNumber = this.getSourceNumberFromDyn(dataEntity.getDataEntity());
                Map sourceNumberMap = (Map)numbers.get(sourceNumber);
                if (CollectionUtils.isNotEmpty((Map)sourceNumberMap)) {
                    Collection numList;
                    if (!this.isValidCurrentNumber() && sourceNumberMap.containsKey("current_entity_number_func")) {
                        sourceNumberMap.remove("current_entity_number_func");
                    }
                    if (CollectionUtils.isNotEmpty(numList = sourceNumberMap.values())) {
                        ArrayList<String> existNumList = new ArrayList<String>(4);
                        for (String num : numList) {
                            Boolean exist = (Boolean)validResult.get(num);
                            if (exist == null || !exist.booleanValue()) continue;
                            existNumList.add(num);
                        }
                        if (CollectionUtils.isNotEmpty(existNumList)) {
                            this.addErrorMessage((ExtendedDataEntity)dataEntity, String.format(Locale.ROOT, this.EXIST_NUMBER_ERROR, String.join((CharSequence)",", existNumList)));
                        }
                    }
                }
            });
        }
    }

    protected String getSourceNumberFromDyn(DynamicObject dyn) {
        return dyn.getString("bizmodel.mainentity.number");
    }

    protected Map<String, Map<String, String>> generateNumbers(Set<String> sourceNumbers) {
        NumberGenerateDomainServiceImpl numberGenerateDomainService = new NumberGenerateDomainServiceImpl();
        return numberGenerateDomainService.generateMulBySourceNumber(sourceNumbers);
    }

    protected boolean isValidCurrentNumber() {
        return true;
    }

    private Set<String> getValidNumbers(Map<String, Map<String, String>> numbers) {
        HashSet<String> resultNumber = new HashSet<String>();
        if (CollectionUtils.isEmpty(numbers)) {
            return resultNumber;
        }
        for (Map.Entry<String, Map<String, String>> number : numbers.entrySet()) {
            resultNumber.addAll(number.getValue().values());
        }
        return resultNumber;
    }
}

