/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.transferconf.validate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.transfer.configitem.IConfigItemDomainService;
import kd.hdtc.hrdt.common.msgenum.BizModeMsgEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfItemValidator
extends HDTCDataBaseValidator {
    IConfigItemDomainService configItemDomainService = (IConfigItemDomainService)ServiceFactory.getService(IConfigItemDomainService.class);

    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        this.checkNumber((ExtendedDataEntity[])dataEntities);
        this.checkGroup((ExtendedDataEntity[])dataEntities);
    }

    private void checkGroup(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            DynamicObject dyc = dataEntity.getDynamicObject("group");
            if (dyc != null) continue;
            this.addErrorMessage(entity, BizModeMsgEnum.GROUP_NOT_EXIST.get());
        }
    }

    private void checkNumber(ExtendedDataEntity[] dataEntities) {
        HashMap<String, ExtendedDataEntity> numberExDataMap = new HashMap<String, ExtendedDataEntity>(16);
        ArrayList<String> confItemNumList = new ArrayList<String>(16);
        LinkedHashMap<String, Integer> confNumVsIdxMap = new LinkedHashMap<String, Integer>(16);
        boolean isConfItemSync = false;
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            IDataEntityType dataEntityType = dataEntity.getDataEntityType();
            if ("hrdt_configitems".equals(dataEntityType.getName())) {
                if (!dataEntity.getBoolean("issyspreset")) continue;
                isConfItemSync = true;
                break;
            }
            int idx = 1;
            DynamicObjectCollection confItemCol = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject confItemDyn : confItemCol) {
                String confNumber = confItemDyn.getString("confignumber");
                confItemNumList.add(confNumber);
                confNumVsIdxMap.put(confNumber, idx);
                numberExDataMap.put(confNumber, entity);
                ++idx;
            }
        }
        if (ObjectUtils.isEmpty(confItemNumList) || isConfItemSync) {
            return;
        }
        List confItemDynList = this.configItemDomainService.getAllConfItemInfoByEntityNumbers("id,confignumber", new HashSet(confItemNumList), "hrdt_configitems", "confignumber");
        if (!ObjectUtils.isEmpty(confItemNumList)) {
            Set dbConfNumSet = confItemDynList.stream().map(dyn -> dyn.getString("confignumber")).collect(Collectors.toSet());
            for (Map.Entry confNumVsIdxEntry : confNumVsIdxMap.entrySet()) {
                String message;
                String confNum = (String)confNumVsIdxEntry.getKey();
                Integer confNumIdx = (Integer)confNumVsIdxEntry.getValue();
                ExtendedDataEntity dataEntity = (ExtendedDataEntity)numberExDataMap.get(confNum);
                if (HRStringUtils.isNotEmpty((String)confNum) && !confNum.startsWith("c_")) {
                    message = String.format(ResManager.loadKDString((String)"\u65b0\u589e\u914d\u7f6e\u9879\uff0c\u7b2c%d\u6761\u914d\u7f6e\u7f16\u7801\u4e3a%s\u4e3a\u975e\u9884\u7f6e\u6570\u636e\uff0c\u9700\u4ee5\u201cc_\u201d\u5f00\u5934", (String)"ConfItemValidator_0", (String)"hdtc-hrdt-opplugin", (Object[])new Object[]{confNumIdx, confNum}), new Object[0]);
                    this.addErrorMessage(dataEntity, message);
                }
                if (!dbConfNumSet.contains(confNum)) continue;
                message = ResManager.loadKDString((String)"\u65b0\u589e\u914d\u7f6e\u9879\uff0c\u7b2c%d\u6761\u7f16\u7801\u4e3a%s\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (String)"ConfigTreeValidator_1", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]);
                this.addErrorMessage((ExtendedDataEntity)numberExDataMap.get(confNum), String.format(message, confNumIdx, confNum));
            }
        }
    }
}

