/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.workbench.validate;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;

public class WorkItemSetValidator
extends HDTCDataBaseValidator {
    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        this.validateEntryEntityRepeat((ExtendedDataEntity[])dataEntities);
    }

    private void validateEntryEntityRepeat(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            if (ObjectUtils.isEmpty((Object)dynamicObjectCollection)) continue;
            HashSet workItemIds = Sets.newHashSetWithExpectedSize((int)dynamicObjectCollection.size());
            for (DynamicObject workItem : dynamicObjectCollection) {
                long workItemId = workItem.getLong("workitem.id");
                String workItemName = workItem.getString("workitem.name");
                if (workItemIds.contains(workItemId)) {
                    String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s:\u5de5\u4f5c\u4e8b\u9879\u660e\u7ec6\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkItemSetValidator_1", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]), workItemName);
                    this.addErrorMessage(dataEntity, message);
                    continue;
                }
                workItemIds.add(workItemId);
            }
        }
    }
}

