/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.opplugin.web.workbench.validate;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.hdtc.hrdbs.opplugin.validator.HDTCDataBaseValidator;

public class WorkItemValidator
extends HDTCDataBaseValidator {
    public void validate() {
        super.validate();
        Object[] dataEntities = this.getDataEntities();
        if (ObjectUtils.isEmpty((Object[])dataEntities)) {
            return;
        }
        this.validateEntryEntityRepeat((ExtendedDataEntity[])dataEntities);
    }

    private void validateEntryEntityRepeat(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection knowledgeEntryEntity;
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            DynamicObjectCollection toolEntryEntity = dynamicObject.getDynamicObjectCollection("tentryentity");
            if (!ObjectUtils.isEmpty((Object)toolEntryEntity)) {
                HashSet toolIds = Sets.newHashSetWithExpectedSize((int)toolEntryEntity.size());
                for (DynamicObject tool : toolEntryEntity) {
                    long toolId = tool.getLong("tool.id");
                    String toolName = tool.getString("tool.name");
                    if (toolIds.contains(toolId)) {
                        String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s:\u5de5\u5177\u7bb1\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkItemValidator_1", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]), toolName);
                        this.addErrorMessage(dataEntity, message);
                        continue;
                    }
                    toolIds.add(toolId);
                }
            }
            if (ObjectUtils.isEmpty((Object)(knowledgeEntryEntity = dynamicObject.getDynamicObjectCollection("kentryentity")))) continue;
            HashSet knowledgeIds = Sets.newHashSetWithExpectedSize((int)knowledgeEntryEntity.size());
            for (DynamicObject knowledge : knowledgeEntryEntity) {
                long knowledgeId = knowledge.getLong("knowledge.id");
                String knowledgeName = knowledge.getString("knowledge.name");
                if (knowledgeIds.contains(knowledgeId)) {
                    String message = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s:\u5de5\u5177\u77e5\u8bc6\u5e93\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"WorkItemValidator_2", (String)"hdtc-hrdt-opplugin", (Object[])new Object[0]), knowledgeName);
                    this.addErrorMessage(dataEntity, message);
                    continue;
                }
                knowledgeIds.add(knowledgeId);
            }
        }
    }
}

