/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.extendplatform.base.impl;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdt.business.application.service.extendplatform.base.IBizModelRecordApplicationService;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.entity.IBizModelRecordEntityService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultBo;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultDataBo;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultDynBo;
import kd.hdtc.hrdt.business.domain.file.IFilePackageDomainService;
import kd.hdtc.hrdt.business.domain.file.IMetaDataPresetDataDomainService;
import kd.hdtc.hrdt.common.util.HRDyObjectUtils;

public class BizModelRecordApplicationServiceImpl
implements IBizModelRecordApplicationService {
    private static final String QUERY_FIELD = "bizmodel,entryentity.result,entryentity.ability,result_tag,objectid,entryentity.operator,entryentity.operatetime";
    private static final Log LOG = LogFactory.getLog(BizModelRecordApplicationServiceImpl.class);
    IBizModelRecordEntityService iBizModelRecordEntityService = ServiceFactory.getService(IBizModelRecordEntityService.class);
    IMetaDataPresetDataDomainService metaDataPresetDataDomainService = ServiceFactory.createInstance(IMetaDataPresetDataDomainService.class);
    IFilePackageDomainService iFilePackageDomainService = ServiceFactory.getService(IFilePackageDomainService.class);
    IMetadataDomainService iMetadataDomainService = ServiceFactory.getService(IMetadataDomainService.class);
    private static final String Q_FILTER_STRING = "fid in (";
    private static final String ENTRY_Q_FILTER_STRING = " in (";
    private static final String ZIP_NAME = "datamodel.zip";
    private static final String ROLL_BACK_ZIP_NAME = "rollback.zip";
    private static final String PRE_INS_DATA_PATH = "/preinsdata/";
    private static final String META_DATA_PATH = "/metadata/";
    private static final String ROLLBACK_NAME_SUFFIX = "_delete";
    private static final String META_DATA_SUFFIX = "_metadata";
    private static final String PRE_DATA_SUFFIX = "_preinsdata";
    private static final String SUFFIX_SQL = ".sql";

    @Override
    public boolean downloadRecordByIds(List<Object> ids, IFormView view) {
        ArrayList<ToolResultDynBo> metaList = new ArrayList<ToolResultDynBo>(10);
        ArrayList<ToolResultDataBo> dataList = new ArrayList<ToolResultDataBo>(10);
        this.getJsonById(ids, metaList, dataList);
        if (CollectionUtils.isEmpty(dataList) && CollectionUtils.isEmpty(metaList)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e\u53ef\u4e0b\u8f7d", (String)"BizModelRecordDomainServiceImpl_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
            view.getPageCache().put("datanumber", "0");
            return true;
        }
        List<ToolResultDynBo> dealMetaList = this.distinctMetaData(metaList);
        List<String> entityNumberList = dealMetaList.stream().map(ToolResultDynBo::getNumber).distinct().collect(Collectors.toList());
        List<String> metaPathList = this.metaDataPresetDataDomainService.downloadMeteFileByNumbers(entityNumberList);
        HashMap indexMap = new HashMap(16);
        dataList.forEach(it -> {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)it.getNumber());
            StringBuilder sb = new StringBuilder();
            sb.append(Q_FILTER_STRING).append(Joiner.on((char)',').join(it.getIds())).append(')');
            String metePreInsDataString = "";
            List<ToolResultDataBo> subDataList = it.getSubDataList();
            metePreInsDataString = this.metaDataPresetDataDomainService.getPresetDataString(it.getNumber(), sb.toString());
            if (StringUtils.isNotEmpty((String)metePreInsDataString)) {
                metaPathList.add(this.iFilePackageDomainService.createFileByString(metePreInsDataString, entityType.getBizAppNumber() + PRE_INS_DATA_PATH + this.getFileName(it.getNumber(), indexMap) + SUFFIX_SQL));
            } else {
                LOG.warn("has no data to export,number:{}", (Object)it.getNumber());
            }
        });
        return this.iFilePackageDomainService.compress(metaPathList, ZIP_NAME, view);
    }

    @Override
    public boolean downloadRollbackStrByIds(List<Object> ids, IFormView view) {
        ArrayList<ToolResultDynBo> metaList = new ArrayList<ToolResultDynBo>(10);
        ArrayList<ToolResultDataBo> dataList = new ArrayList<ToolResultDataBo>(10);
        this.getJsonById(ids, metaList, dataList);
        dataList.add(new ToolResultDataBo("hrdt_bizmodelrecord", ids));
        if (CollectionUtils.isEmpty(dataList) && CollectionUtils.isEmpty(metaList)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u6570\u636e\u53ef\u4e0b\u8f7d", (String)"BizModelRecordDomainServiceImpl_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
            return true;
        }
        List<ToolResultDynBo> dealMetaList = this.distinctMetaData(metaList);
        List entityNumberList = dealMetaList.stream().map(ToolResultDynBo::getNumber).distinct().collect(Collectors.toList());
        DynamicObject[] metas = this.iMetadataDomainService.getBosFormMetaByEntityNumbers(entityNumberList.stream().collect(Collectors.toList()));
        Set<String> metaDataIds = Arrays.stream(metas).map(it -> it.getString("bizappid")).collect(Collectors.toSet());
        DynamicObject[] bizApps = this.iMetadataDomainService.getBosFormBizAppNumberByBizAppIds(metaDataIds);
        Map<String, String> bizAppMap = Arrays.stream(bizApps).collect(Collectors.toMap(it -> it.getString("id"), it -> it.getString("number")));
        ArrayList<String> rollbackPathList = new ArrayList<String>(10);
        HashMap bizAppAndSqlResultMap = Maps.newHashMapWithExpectedSize((int)metaDataIds.size());
        Arrays.stream(metas).forEach(it -> {
            String metaRollbackContentString = this.metaDataPresetDataDomainService.getMetaRollbackContentString(it.getString("number"), it.getString("id"));
            String tableStr = "t_" + it.getString("number") + META_DATA_SUFFIX + ROLLBACK_NAME_SUFFIX + SUFFIX_SQL;
            List sqlResultList = bizAppAndSqlResultMap.computeIfAbsent(bizAppMap.get(it.getString("bizappid")), k -> new ArrayList());
            sqlResultList.add(this.sqlResultStr(tableStr, metaRollbackContentString));
        });
        for (Map.Entry rollbackSqlMap : bizAppAndSqlResultMap.entrySet()) {
            List sqlList = (List)rollbackSqlMap.getValue();
            rollbackPathList.add(this.iFilePackageDomainService.createFileByString(this.sqlResultStr(sqlList), (String)rollbackSqlMap.getKey() + META_DATA_PATH + (String)rollbackSqlMap.getKey() + META_DATA_SUFFIX + ROLLBACK_NAME_SUFFIX + SUFFIX_SQL));
        }
        HashMap indexMap = new HashMap(16);
        HashMap bizAppAndDataResultMap = Maps.newHashMapWithExpectedSize((int)dataList.size());
        dataList.forEach(it -> {
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)it.getNumber());
            StringBuilder sb = new StringBuilder();
            sb.append(Q_FILTER_STRING).append(Joiner.on((char)',').join(it.getIds())).append(')');
            String metePreInsDataString = "";
            List<ToolResultDataBo> subDataList = it.getSubDataList();
            if (CollectionUtils.isNotEmpty(it.getSubDataList())) {
                Map<String, String> entryQFilter = this.buildEntryFilter(entityType, subDataList);
                metePreInsDataString = this.metaDataPresetDataDomainService.getPresetDataRollbackStringOnlyEntry(it.getNumber(), sb.toString(), entryQFilter);
            } else {
                metePreInsDataString = this.metaDataPresetDataDomainService.getPresetDataRollbackString(it.getNumber(), sb.toString());
            }
            String tableStr = "t_" + this.getFileName(it.getNumber(), indexMap) + PRE_DATA_SUFFIX + ROLLBACK_NAME_SUFFIX + SUFFIX_SQL;
            List sqlResultList = bizAppAndDataResultMap.computeIfAbsent(entityType.getBizAppNumber(), k -> new ArrayList());
            sqlResultList.add(this.sqlResultStr(tableStr, metePreInsDataString));
        });
        for (Map.Entry rollbackDataMap : bizAppAndDataResultMap.entrySet()) {
            List sqlList = (List)rollbackDataMap.getValue();
            rollbackPathList.add(this.iFilePackageDomainService.createFileByString(this.sqlResultStr(sqlList), (String)rollbackDataMap.getKey() + PRE_INS_DATA_PATH + (String)rollbackDataMap.getKey() + PRE_DATA_SUFFIX + ROLLBACK_NAME_SUFFIX + SUFFIX_SQL));
        }
        return this.iFilePackageDomainService.compress(rollbackPathList, ROLL_BACK_ZIP_NAME, view);
    }

    private void getJsonById(List<Object> ids, List<ToolResultDynBo> metaList, List<ToolResultDataBo> dataList) {
        DynamicObject[] records;
        for (DynamicObject record : records = this.iBizModelRecordEntityService.query(QUERY_FIELD, new QFilter("id", "in", ids).toArray())) {
            DynamicObjectCollection entryCollect = record.getDynamicObjectCollection("entryentity");
            entryCollect.forEach(it -> {
                dataList.addAll(ToolResultBo.analysisJsonToData(HRDyObjectUtils.getBigText((DynamicObject)it, (String)"result")));
                metaList.addAll(ToolResultBo.analysisJsonToMeta(HRDyObjectUtils.getBigText((DynamicObject)it, (String)"result")));
            });
        }
    }

    private String sqlResultStr(String tableStr, String RollbackContentString) {
        StringBuilder stringBuilder = new StringBuilder("--------------------------------------------- ");
        stringBuilder.append(tableStr);
        stringBuilder.append(" ---------------------------------------------").append("\n");
        stringBuilder.append(RollbackContentString);
        return stringBuilder.toString();
    }

    private String sqlResultStr(List<String> sqlList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String sqlResult : sqlList) {
            stringBuilder.append(sqlResult);
        }
        return stringBuilder.toString();
    }

    private List<ToolResultDynBo> distinctMetaData(List<ToolResultDynBo> metaList) {
        if (CollectionUtils.isNotEmpty(metaList)) {
            Map<String, ToolResultDynBo> map = metaList.stream().collect(Collectors.toMap(ToolResultDynBo::getNumber, kk -> kk, (v1, v2) -> v2));
            return new ArrayList<ToolResultDynBo>(map.values());
        }
        return metaList;
    }

    private String getFileName(String number, Map<String, Integer> indexMap) {
        Integer info = indexMap.get(number);
        if (info != null) {
            StringBuilder stringBuilder = new StringBuilder();
            indexMap.put(number, ConvertUtils.toInt((Object)info) + 1);
            return stringBuilder.append(number).append('_').append(info).toString();
        }
        indexMap.put(number, ConvertUtils.toInt((Object)info) + 1);
        return number;
    }

    private Map<String, String> buildEntryFilter(MainEntityType entityType, List<ToolResultDataBo> subDataList) {
        HashMap<String, String> filters = new HashMap<String, String>(subDataList.size());
        for (ToolResultDataBo bo : subDataList) {
            String entryNumber = bo.getNumber();
            DynamicProperty type = entityType.getProperty(entryNumber);
            if (type == null || !(type instanceof EntryProp)) continue;
            EntryProp entryType = (EntryProp)type;
            String entryId = entryType.getDynamicCollectionItemPropertyType().getPrimaryKey().getAlias();
            StringBuilder sb = new StringBuilder();
            sb.append(entryId).append(ENTRY_Q_FILTER_STRING).append(Joiner.on((char)',').join(bo.getIds())).append(')');
            filters.put(entryNumber, sb.toString());
        }
        return filters;
    }
}

