/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.extendplatform.client.impl;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdt.business.application.service.extendplatform.base.model.BizModelAbilityBo;
import kd.hdtc.hrdt.business.application.service.extendplatform.base.model.BizModelTreeBo;
import kd.hdtc.hrdt.business.application.service.extendplatform.client.IExtendPlatformClientServiceApplication;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.utils.OpenPageCommonUtils;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelAbilityDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelDomainService;

public class ExtendPlatformClientServiceApplicationImpl
implements IExtendPlatformClientServiceApplication {
    private IBizModelDomainService bizModelDomainService = ServiceFactory.getService(IBizModelDomainService.class);
    private IBizModelAbilityDomainService bizModelAbilityDomainService = ServiceFactory.getService(IBizModelAbilityDomainService.class);

    @Override
    public Map<String, Object> buildExtendPlatformTree() {
        DynamicObject[] allEnableBizModel = this.bizModelDomainService.queryAllBizModel();
        if (allEnableBizModel == null || allEnableBizModel.length <= 0) {
            return null;
        }
        ArrayList<BizModelTreeBo> bos = new ArrayList<BizModelTreeBo>(allEnableBizModel.length);
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        for (DynamicObject bizModel : allEnableBizModel) {
            BizModelTreeBo bizModelTreeBo = new BizModelTreeBo();
            bizModelTreeBo.setKey(bizModel.getString("longnumber"));
            bizModelTreeBo.setId(bizModel.getString("id"));
            bizModelTreeBo.setTitle(bizModel.getString("name"));
            bizModelTreeBo.setName(bizModel.getString("name"));
            bizModelTreeBo.setNumber(bizModel.getString("number"));
            bizModelTreeBo.setBizModelType(bizModel.getString("bizmodeltype.number"));
            bizModelTreeBo.setIsv(bizModel.getString("isv"));
            bizModelTreeBo.setExtData(bizModel.getBoolean("isextdata"));
            if (bizModel.getBoolean("isextdata")) {
                bizModelTreeBo.setClassName("exttitle");
            }
            bizModelTreeBo.setLevel(bizModel.getInt("level"));
            bizModelTreeBo.setParentId(bizModel.getString("parent.id"));
            bizModelTreeBo.setDescription(bizModel.getString("description"));
            bizModelTreeBo.setChildren(new ArrayList<BizModelTreeBo>(4));
            bos.add(bizModelTreeBo);
        }
        result.put("data", bos);
        result.put("tree", this.buildTree(bos));
        return result;
    }

    @Override
    public List<BizModelAbilityBo> getAbilitiesByBizModel(long bizModelId) {
        DynamicObject[] allEnableBizModelAbility;
        DynamicObject bizModel = this.bizModelDomainService.queryById(bizModelId);
        if (bizModel != null && (allEnableBizModelAbility = this.bizModelAbilityDomainService.queryAllEnableBizModelAbility()) != null && allEnableBizModelAbility.length > 0) {
            Object address;
            List<BizModelAbilityBo> abilities = this.getAbilityByBizModel(bizModel, allEnableBizModelAbility);
            HashMap<String, String> addressesMap = new HashMap<String, String>(abilities.size());
            for (BizModelAbilityBo bo : abilities) {
                String formId;
                Map<String, Object> tool = bo.getTool();
                if (tool == null || ObjectUtils.isEmpty((Object)(address = tool.get("toolpageaddr"))) || StringUtils.isEmpty((String)(formId = this.getCodeByLinkJson(String.valueOf(address))))) continue;
                addressesMap.put(bo.getId(), formId);
            }
            Map<String, Integer> countInfo = this.bizModelAbilityDomainService.queryToolNoEffectCount(bizModel.getString("longnumber"), addressesMap.values().stream().collect(Collectors.toSet()));
            for (BizModelAbilityBo bo : abilities) {
                bo.getTool().put("count", 0);
                if (!CollectionUtils.isNotEmpty(countInfo) || !StringUtils.isNotEmpty((String)(address = (String)addressesMap.get(bo.getId())))) continue;
                int count = countInfo.get(address);
                bo.getTool().put("count", count);
            }
            return abilities;
        }
        return null;
    }

    private List<BizModelTreeBo> buildTree(List<BizModelTreeBo> boList) {
        if (CollectionUtils.isEmpty(boList)) {
            return null;
        }
        NavigableMap boMap = boList.stream().collect(Collectors.groupingBy(bo -> bo.getLevel(), TreeMap::new, Collectors.toList())).descendingMap();
        List<BizModelTreeBo> subs = new ArrayList<BizModelTreeBo>(4);
        Integer maxLevel = (Integer)boMap.keySet().stream().findFirst().get();
        for (int index = maxLevel.intValue(); index > 0; --index) {
            if (index == maxLevel) {
                subs = (List)boMap.get(index);
            }
            List parents = (List)boMap.get(index - 1);
            subs = this.buildParentTree(parents, subs);
        }
        return subs;
    }

    private List<BizModelTreeBo> buildParentTree(List<BizModelTreeBo> parents, List<BizModelTreeBo> subs) {
        if (CollectionUtils.isEmpty(parents)) {
            return subs;
        }
        if (CollectionUtils.isEmpty(subs)) {
            return parents;
        }
        Map<String, List<BizModelTreeBo>> subBoMap = subs.stream().collect(Collectors.groupingBy(BizModelTreeBo::getParentId));
        for (BizModelTreeBo parent : parents) {
            String parentId = parent.getId();
            List<BizModelTreeBo> sub = subBoMap.get(parentId);
            if (!CollectionUtils.isNotEmpty(sub)) continue;
            parent.getChildren().addAll(sub);
        }
        return parents;
    }

    private List<BizModelAbilityBo> getAbilityByBizModel(DynamicObject bizModel, DynamicObject[] allEnableBizModelAbility) {
        ArrayList<BizModelAbilityBo> abilityBos = new ArrayList<BizModelAbilityBo>(4);
        String longNumber = bizModel.getString("longnumber");
        String bizModelTypeNumber = bizModel.getString("bizmodeltype.number");
        Set<String> numberSet = this.splitLongNumber(longNumber);
        for (DynamicObject enableBizModelAbility : allEnableBizModelAbility) {
            DynamicObject knowledgeEntity;
            DynamicObjectCollection useRanges;
            String bizModelTypeNumberAbility = enableBizModelAbility.getString("bizmodeltype.number");
            if (!bizModelTypeNumberAbility.equals(bizModelTypeNumber) || CollectionUtils.isEmpty((Collection)(useRanges = enableBizModelAbility.getDynamicObjectCollection("entryentity")))) continue;
            boolean hasThisAbility = false;
            for (DynamicObject useRange : useRanges) {
                DynamicObject bizModelAbility = useRange.getDynamicObject("bizmodel");
                if (bizModelAbility == null || !numberSet.contains(bizModelAbility.getString("number"))) continue;
                hasThisAbility = true;
                break;
            }
            if (!hasThisAbility) continue;
            BizModelAbilityBo bizModelAbilityBo = new BizModelAbilityBo();
            bizModelAbilityBo.setId(enableBizModelAbility.getString("id"));
            bizModelAbilityBo.setName(enableBizModelAbility.getString("name"));
            bizModelAbilityBo.setDescription(enableBizModelAbility.getString("description"));
            DynamicObject tooEntity = enableBizModelAbility.getDynamicObject("tool");
            if (tooEntity != null) {
                bizModelAbilityBo.setTool(this.buildToolModel(tooEntity));
            }
            if ((knowledgeEntity = enableBizModelAbility.getDynamicObject("knowledge")) != null) {
                bizModelAbilityBo.setKnowledge(this.buildKnowledgeModel(knowledgeEntity));
            }
            abilityBos.add(bizModelAbilityBo);
        }
        return abilityBos;
    }

    private Map<String, Object> buildToolModel(DynamicObject tooEntity) {
        HashMap<String, Object> tool = new HashMap<String, Object>(16);
        tool.put("id", String.valueOf(tooEntity.getLong("id")));
        tool.put("name", tooEntity.getString("name"));
        tool.put("toolpageaddr", tooEntity.getString("toolpageaddr"));
        tool.put("formtoolpageaddr", tooEntity.getString("formtoolpageaddr"));
        tool.put("description", tooEntity.getString("description"));
        tool.put("type", "tool");
        return tool;
    }

    private Map<String, Object> buildKnowledgeModel(DynamicObject knowledgeEntity) {
        HashMap<String, Object> knowledge = new HashMap<String, Object>(16);
        knowledge.put("id", String.valueOf(knowledgeEntity.getLong("id")));
        knowledge.put("name", knowledgeEntity.getString("name"));
        knowledge.put("linktype", knowledgeEntity.getString("linktype"));
        knowledge.put("knowledgelink", knowledgeEntity.getString("knowledgelink"));
        knowledge.put("type", "knowledge");
        return knowledge;
    }

    private Set<String> splitLongNumber(String longNumber) {
        if (StringUtils.isBlank((CharSequence)longNumber) || longNumber.indexOf(46) < 0) {
            return ImmutableSet.of((Object)longNumber);
        }
        String[] numbers = longNumber.split("\\.");
        return Arrays.stream(numbers).collect(Collectors.toSet());
    }

    private String getCodeByLinkJson(String address) {
        Map<String, String> params = OpenPageCommonUtils.getParamsFromPageUrl(address);
        if (CollectionUtils.isEmpty(params)) {
            return null;
        }
        return params.get("formid");
    }
}

