/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.cadre.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.ContainerParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FormPluginParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.cadre.ICadreFileToolApplicationService;
import kd.hdtc.hrdt.business.common.constants.PersonFileToolConstants;
import kd.hdtc.hrdt.business.common.model.MetadataBo;
import kd.hdtc.hrdt.business.common.utils.FieldRuleHandleUtils;
import kd.hdtc.hrdt.business.common.utils.MetaFieldTypeUtils;
import kd.hdtc.hrdt.business.common.utils.platform.HRDTMetadataUtils;
import kd.hdtc.hrdt.business.domain.ext.ICadreInfoGroupFieldEntityService;
import kd.hdtc.hrdt.business.domain.ext.ICadreInfoGroupPageRegisterEntityService;
import kd.hdtc.hrdt.business.domain.ext.IEntityForbidEntityService;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hdtc.hrdt.business.domain.ext.IMultiViewConfigCadreEntityService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelRecordDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultBo;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultDataBo;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.ICadreFileToolDomainService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;

public class CadreFileToolApplicationServiceImpl
implements ICadreFileToolApplicationService {
    private static final Log LOG = LogFactory.getLog(CadreFileToolApplicationServiceImpl.class);
    private final ICadreInfoGroupPageRegisterEntityService iCadreInfoGroupPageRegisterEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(ICadreInfoGroupPageRegisterEntityService.class);
    private final IMultiViewConfigCadreEntityService iMultiViewConfigCadreEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IMultiViewConfigCadreEntityService.class);
    private final ICadreInfoGroupFieldEntityService iCadreInfoGroupFieldEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(ICadreInfoGroupFieldEntityService.class);
    private final IEntityForbidEntityService iEntityForbidEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IEntityForbidEntityService.class);
    private IBizModelRecordDomainService bizModelRecordDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IBizModelRecordDomainService.class);
    private ICadreFileToolDomainService cadreFileToolDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(ICadreFileToolDomainService.class);
    private final IMetadataDomainService metadataDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IMetadataDomainService.class);
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);

    @Override
    public ToolResultBo effect(DynamicObject dynamicObject) {
        ToolResultBo toolResultBo = new ToolResultBo();
        try {
            LOG.info("CadreFileToolApplicationServiceImpl effect start");
            toolResultBo.setBizModelId(dynamicObject.getLong("bizmodel.id"));
            toolResultBo.setAbilityId(1813974162247768064L);
            String entityNumber = dynamicObject.getString("bizmodel.mainentity.number");
            String entityName = dynamicObject.getString("bizmodel.mainentity.name");
            Map<String, List<String>> viewTypeAndMetaDataNumberMap = this.generateMetaData(dynamicObject, toolResultBo);
            boolean existPersonEntityConfig = this.cadreFileToolDomainService.isExistPersonEntityConfig(entityNumber);
            if (!existPersonEntityConfig) {
                LOG.info("CadreFileToolApplicationServiceImpl savePersonEntityConfig start");
                DynamicObject personEntityConfigDyn = this.cadreFileToolDomainService.toPersonEntityConfigDyn(entityNumber, entityName);
                OperationResult savePersonEntityConfigResult = this.cadreFileToolDomainService.savePersonEntityConfig(new DynamicObject[]{personEntityConfigDyn});
                toolResultBo.addData("hrpi_personentityconf", savePersonEntityConfigResult != null ? savePersonEntityConfigResult.getSuccessPkIds() : new ArrayList());
                LOG.info("CadreFileToolApplicationServiceImpl savePersonEntityConfig end");
            }
            LOG.info("CadreFileToolApplicationServiceImpl saveInfoGroupPageRegister start");
            DynamicObject infoGroupPageRegisterDyn = this.cadreFileToolDomainService.toInfoGroupPageRegisterDyn(dynamicObject, viewTypeAndMetaDataNumberMap);
            OperationResult infoGroupPageRegisterResult = this.cadreFileToolDomainService.saveInfoGroupPageRegister(infoGroupPageRegisterDyn, toolResultBo);
            LOG.info("CadreFileToolApplicationServiceImpl saveInfoGroupPageRegister end");
            String dialogPc = infoGroupPageRegisterDyn.getString("dialogpc");
            String dyViewPc = infoGroupPageRegisterDyn.getString("dyviewpc");
            if (StringUtils.isNotEmpty((String)dialogPc)) {
                LOG.info("CadreFileToolApplicationServiceImpl savePermRelate start");
                String bizType = dynamicObject.getString("biztype");
                List<DynamicObject> permRelateEntityList = this.cadreFileToolDomainService.toPermRelateEntityDynList(dyViewPc, PersonFileToolConstants.CARD_PERM_ID_LIST, Collections.singletonList(dialogPc), bizType);
                OperationResult operationResult = this.cadreFileToolDomainService.savePermRelate(permRelateEntityList.toArray(new DynamicObject[0]));
                toolResultBo.addData("hrcs_permrelat", operationResult != null ? operationResult.getSuccessPkIds() : new ArrayList());
                LOG.info("CadreFileToolApplicationServiceImpl savePermRelate end");
            }
            LOG.info("CadreFileToolApplicationServiceImpl saveEntityForbid start dialogPc:{} dyViewPc:{}", (Object)dialogPc, (Object)dyViewPc);
            List<DynamicObject> forbidEntityDynList = this.cadreFileToolDomainService.toEntityForbidEntityDynList(Arrays.asList(dialogPc, dyViewPc), "358CTM781OMD", "3");
            Object[] result = this.iEntityForbidEntityService.save(forbidEntityDynList.toArray(new DynamicObject[0]));
            if (result != null) {
                ArrayList ids = Lists.newArrayListWithExpectedSize((int)result.length);
                for (Object entityFory : result) {
                    if (!(entityFory instanceof DynamicObject)) continue;
                    ids.add(((DynamicObject)entityFory).getLong("id"));
                }
                toolResultBo.addData("hrcs_entityforbid", ids);
                LOG.info("CadreFileToolApplicationServiceImpl saveEntityForbid end");
            }
            List<Object> infoGroupFieldIdList = this.iCadreInfoGroupFieldEntityService.getInfoGroupFieldIdListByGroupId(infoGroupPageRegisterDyn.getLong("id"));
            toolResultBo.addData("soebs_infogroupfield", infoGroupFieldIdList);
            ToolResultDataBo toolResultDataBo = new ToolResultDataBo();
            Object[] multiViewConfigs = this.getMultiViewConfigDyns(dynamicObject, infoGroupPageRegisterDyn.getLong("id"), toolResultDataBo);
            if (!ObjectUtils.isEmpty((Object[])multiViewConfigs)) {
                LOG.info("CadreFileToolApplicationServiceImpl multiViewConfigs start");
                toolResultDataBo.setNumber(multiViewConfigs[0].getDataEntityType().getName());
                OperationResult saveMultiViewConfigResult = this.cadreFileToolDomainService.saveMultiViewConfigDyn((DynamicObject[])multiViewConfigs);
                if (saveMultiViewConfigResult.isSuccess()) {
                    toolResultDataBo.setIds(saveMultiViewConfigResult.getSuccessPkIds());
                    if (infoGroupPageRegisterResult != null && infoGroupPageRegisterResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)infoGroupPageRegisterResult.getSuccessPkIds())) {
                        LOG.info("CadreFileToolApplicationServiceImpl ISOEBSInfoGroupService saveInfoGroupField  end");
                        HRMServiceHelper.invokeBizService((String)"sihc", (String)"soebs", (String)"ISOEBSInfoGroupService", (String)"saveInfoGroupField", (Object[])new Object[]{infoGroupPageRegisterResult.getSuccessPkIds().get(0)});
                        LOG.info("CadreFileToolApplicationServiceImpl ISOEBSInfoGroupService saveInfoGroupField  end");
                    }
                    toolResultBo.addData(toolResultDataBo);
                }
                LOG.info("CadreFileToolApplicationServiceImpl multiViewConfigs end");
            }
            toolResultBo.setEffectiveStatus("2");
        }
        catch (Exception e) {
            this.bizModelRecordDomainService.rollBackModelRecord(Collections.singletonList(toolResultBo));
            toolResultBo.setEffectiveStatus("0");
            toolResultBo.setErrorMsg(e.getMessage());
            LOG.error("CadreFileToolApplicationServiceImpl effect error {} {}", (Object)e.getCause(), (Object)e.getMessage());
            return toolResultBo;
        }
        toolResultBo.addData("hrdt_cadrefiletool", Collections.singletonList(dynamicObject.getLong("id")));
        this.bizModelRecordDomainService.saveBizModelRecord(Collections.singletonList(toolResultBo));
        return toolResultBo;
    }

    private DynamicObject[] getMultiViewConfigDyns(DynamicObject personFileToolDyn, Long infoGroupPageRegisterId, ToolResultDataBo toolResultDataBo) {
        DynamicObject infoGroupPageRegister = this.iCadreInfoGroupPageRegisterEntityService.queryOriginalOneById(infoGroupPageRegisterId);
        List<DynamicObject> infoGroupFieldList = this.iCadreInfoGroupFieldEntityService.getInfoGroupFieldListByGroupId(infoGroupPageRegisterId);
        String dialogPc = infoGroupPageRegister.getString("dialogpc");
        if (CollectionUtils.isNotEmpty(infoGroupFieldList)) {
            Object[] multiViewConfigs = this.getMultiViewConfigs(personFileToolDyn);
            if (!ObjectUtils.isEmpty((Object[])multiViewConfigs)) {
                long[] entityIds = ID.genLongIds((int)multiViewConfigs.length);
                ToolResultDataBo entryData = new ToolResultDataBo("groupentity", Arrays.stream(entityIds).boxed().collect(Collectors.toList()));
                for (int index = 0; index < multiViewConfigs.length; ++index) {
                    long entityId = entityIds[index];
                    Object multiViewConfig = multiViewConfigs[index];
                    DynamicObjectCollection groupEntityCollection = multiViewConfig.getDynamicObjectCollection("groupentity");
                    DynamicObject dynamicObject = groupEntityCollection.addNew();
                    dynamicObject.set("id", (Object)entityId);
                    dynamicObject.set("groupid", (Object)infoGroupPageRegisterId);
                    dynamicObject.set("groupname", (Object)infoGroupPageRegister.getString("name"));
                    dynamicObject.set("relation", (Object)infoGroupPageRegisterId);
                    dynamicObject.set("allisedit", (Object)Boolean.FALSE);
                    dynamicObject.set("allisrequired", (Object)Boolean.FALSE);
                    dynamicObject.set("allisaudit", (Object)Boolean.FALSE);
                    dynamicObject.set("isallowadd", (Object)Boolean.FALSE);
                    dynamicObject.set("configarea", (Object)personFileToolDyn.getString("region"));
                    DynamicObjectCollection fieldEntityCollection = dynamicObject.getDynamicObjectCollection("fieldentity");
                    int seq = 1;
                    long[] subEntityIds = ID.genLongIds((int)infoGroupFieldList.size());
                    ToolResultDataBo subEntryData = new ToolResultDataBo("groupentity", Arrays.stream(entityIds).boxed().collect(Collectors.toList()));
                    entryData.addSubData(subEntryData);
                    int idx = 0;
                    for (DynamicObject field : infoGroupFieldList) {
                        if ("description".equals(field.getString("number")) || StringUtils.isEmpty((String)dialogPc) && "18".equals(field.getString("type"))) continue;
                        long subEntityId = subEntityIds[idx++];
                        DynamicObject fieldEntity = fieldEntityCollection.addNew();
                        fieldEntity.set("id", (Object)subEntityId);
                        fieldEntity.set("field", (Object)field);
                        fieldEntity.set("seq", (Object)seq++);
                        fieldEntity.set("isedit", (Object)field.getBoolean("isedit"));
                        fieldEntity.set("isrequired", (Object)field.getBoolean("isrequired"));
                        fieldEntity.set("isaudit", (Object)Boolean.FALSE);
                        if ("18".equals(field.getString("type"))) {
                            fieldEntity.set("fieldtype", (Object)"3");
                            continue;
                        }
                        if ("12".equals(field.getString("type"))) {
                            fieldEntity.set("fieldtype", (Object)"2");
                            continue;
                        }
                        fieldEntity.set("fieldtype", (Object)"1");
                    }
                }
                toolResultDataBo.addSubData(entryData);
            }
            return multiViewConfigs;
        }
        return new DynamicObject[0];
    }

    private DynamicObject[] getMultiViewConfigs(DynamicObject personFileToolDyn) {
        String fileName = "cadrefileviews";
        DynamicObjectCollection dynamicObjectCollection = personFileToolDyn.getDynamicObjectCollection(fileName);
        ArrayList multiViewConfigIdList = Lists.newArrayListWithExpectedSize((int)dynamicObjectCollection.size());
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
            dynamicObjectCollection.forEach(dy -> multiViewConfigIdList.add(dy.getLong("fbasedataid_id")));
        }
        return this.iMultiViewConfigCadreEntityService.queryMultiViewConfigCadreByIdList(multiViewConfigIdList);
    }

    private Map<String, List<String>> generateMetaData(DynamicObject dataEntity, ToolResultBo toolResultBo) {
        LOG.info("CadreFileToolApplicationServiceImpl generateMetaData start");
        String entityNumber = dataEntity.getString("bizmodel.mainentity.number");
        String entityName = dataEntity.getString("bizmodel.name");
        ArrayList pageFieldNameList = Lists.newArrayList((Object[])new String[]{"pcview"});
        HashSet sourceNumbers = Sets.newHashSet((Object[])new String[]{entityNumber});
        long fileTypeId = dataEntity.getLong("filetype.id");
        Map<String, Map<String, String>> sourceNumberMetaNumberMap = this.cadreFileToolDomainService.generateNumbers(sourceNumbers, fileTypeId);
        Map<String, String> metaDataNumberMap = sourceNumberMetaNumberMap.get(entityNumber);
        LinkedHashMap viewTypeAndMetaDataNumberMap = Maps.newLinkedHashMapWithExpectedSize((int)3);
        pageFieldNameList.forEach(pageView -> {
            String paramNumber;
            Map<String, String> numberValueMap;
            boolean condition;
            String viewValue = dataEntity.getString(pageView);
            boolean bl = condition = StringUtils.isNotEmpty((String)viewValue) && ("1".equals(viewValue) || "2".equals(viewValue));
            if (condition && CollectionUtils.isNotEmpty(numberValueMap = this.cadreFileToolDomainService.getPersonFilePages(paramNumber = pageView + "." + viewValue))) {
                Map<String, String> pluginMap = this.cadreFileToolDomainService.getPersonFileFormPlugin(numberValueMap.keySet());
                for (Map.Entry<String, String> numberValue : numberValueMap.entrySet()) {
                    String metaDataNumber = (String)metaDataNumberMap.get(PersonFileToolConstants.CADRE_BASE_CONFIG_KEY_MEAT_DATA_NUMBER_KEY_MAP.getOrDefault(numberValue.getKey(), ""));
                    LOG.info("CadreFileToolApplicationServiceImpl generateMetaData generate metaDataNumber {}", (Object)metaDataNumber);
                    String plugin = CollectionUtils.isEmpty(pluginMap) ? "" : pluginMap.get(numberValue.getKey() + ".plugin");
                    LOG.info("CadreFileToolApplicationServiceImpl generateMetaData generate plugin {}", (Object)plugin);
                    String filePlugin = CollectionUtils.isEmpty(pluginMap) ? "" : pluginMap.get(numberValue.getKey() + ".plugin" + ".file");
                    MetadataGenParam metadataGenParam = this.getMetadataGenParam(metaDataNumber, entityName, numberValue.getValue(), paramNumber, numberValue.getKey(), entityNumber, plugin, filePlugin);
                    MetadataGenResult metadataGenResult = this.dynamicMetadataApplicationService.generate(metadataGenParam);
                    List metaDataNumberList = viewTypeAndMetaDataNumberMap.getOrDefault(paramNumber, new ArrayList());
                    if (StringUtils.isNotEmpty((String)metadataGenResult.getEntityNumber())) {
                        LOG.info("CadreFileToolApplicationServiceImpl generateMetaData generate entityNumber {}", (Object)metadataGenResult.getEntityNumber());
                        metaDataNumberList.add(metadataGenResult.getEntityNumber());
                        toolResultBo.addDyn(metadataGenResult.getEntityNumber());
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)metaDataNumberList)) continue;
                    viewTypeAndMetaDataNumberMap.put(paramNumber, metaDataNumberList);
                }
            }
        });
        LOG.info("CadreFileToolApplicationServiceImpl generateMetaData end");
        return viewTypeAndMetaDataNumberMap;
    }

    private MetadataGenParam getMetadataGenParam(String metaDataNumber, String metaDataName, String parentFilePage, String paramNumber, String baseConfigKey, String entityNumber, String pluginParam, String filePluginParam) {
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        BaseParam baseParam = new BaseParam();
        metadataGenParam.setBaseParam(baseParam);
        baseParam.setMetadataName(metaDataName);
        baseParam.setMetadataNumber(metaDataNumber);
        Map<String, Object> parentNode = HRDTMetadataUtils.getDesignerMetadata(parentFilePage);
        if (CollectionUtils.isNotEmpty(parentNode)) {
            Object parentModelType;
            Object parentId = parentNode.get("id");
            if (parentId != null) {
                baseParam.setParentId(String.valueOf(parentId));
            }
            if ((parentModelType = parentNode.get("modelType")) != null) {
                baseParam.setModelType(String.valueOf(parentModelType));
            }
        }
        baseParam.setBizUnitId(CadreFileToolApplicationServiceImpl.getBizUnitIdByParamNumber(paramNumber));
        baseParam.setAppId("soebs");
        baseParam.setType(MetadataGenTypeEnum.NORMAL_METADATA);
        List formMetadata = MetadataUtils.getFormMetadata((String)entityNumber);
        List<ControlAp> fileAps = null;
        if (CollectionUtils.isNotEmpty((Collection)formMetadata)) {
            fileAps = formMetadata.stream().filter(form -> form instanceof AttachmentPanelAp).collect(Collectors.toList());
        }
        MetadataBo metadataBo = this.metadataDomainService.getMetaInfoByNumber(entityNumber, true, false);
        if (baseConfigKey.equals("soebs_basecard_dyview") || baseConfigKey.equals("soebs_pagebase_dyview")) {
            List<EntityItem<?>> metadataBoItems = metadataBo.getItems();
            metadataBoItems.forEach(dy -> {
                if (!dy.isInherit()) {
                    String fieldType = MetaFieldTypeUtils.getFieldType(dy);
                    FieldParam fieldParam = this.getFieldParam((EntityItem<?>)dy, fieldType);
                    metadataGenParam.getFieldParamList().add(fieldParam);
                }
            });
            if (fileAps != null && fileAps.size() > 0) {
                fileAps.forEach(ap -> {
                    FieldParam fieldParam = this.getAttachmentFieldParam((ControlAp<?>)ap);
                    metadataGenParam.getFieldParamList().add(fieldParam);
                });
            }
        }
        if (baseConfigKey.equals("soebs_basecard_dyview")) {
            String containerNumber = "contentap" + entityNumber.substring(entityNumber.lastIndexOf(95) + 1);
            ContainerParam containerParam1 = this.getContainerParam(containerNumber, PersonFileToolConstants.CONTENT, "FlexPanelAp", 3, false);
            metadataGenParam.getContainerParamList().add(containerParam1);
        }
        if (StringUtils.isNotEmpty((String)pluginParam)) {
            String[] plugins = pluginParam.split(";");
            ArrayList formPluginParamList = Lists.newArrayListWithExpectedSize((int)plugins.length);
            for (String plugin : plugins) {
                FormPluginParam formPluginParam = new FormPluginParam();
                formPluginParam.setClassName(plugin);
                formPluginParam.setDescription(plugin);
                formPluginParam.setEnable(Boolean.TRUE);
                formPluginParamList.add(formPluginParam);
            }
            metadataGenParam.setFormPluginParamList((List)formPluginParamList);
        }
        return metadataGenParam;
    }

    private FieldParam getAttachmentFieldParam(ControlAp<?> ap) {
        FieldParam fieldParam = new FieldParam();
        fieldParam.setName(ap.getName().getLocaleValue());
        fieldParam.setNumber(ap.getKey());
        HashMap fieldRuleMap = Maps.newHashMapWithExpectedSize((int)1);
        fieldRuleMap.put("MustInput", 0);
        fieldParam.setFieldRuleMap((Map)fieldRuleMap);
        fieldParam.setType(AttachmentField.class.getSimpleName());
        fieldParam.setContainerNumber("fieldspermflex");
        return fieldParam;
    }

    private ContainerParam getContainerParam(String containerNumber, String containerName, String type, int index, boolean collapsible) {
        ContainerParam containerParam1 = new ContainerParam();
        containerParam1.setName(containerName);
        containerParam1.setNumber(containerNumber);
        containerParam1.setType(type);
        containerParam1.setIndex(index);
        containerParam1.setCollapsible(collapsible);
        return containerParam1;
    }

    private FieldParam getFieldParam(EntityItem<?> dy, String fieldType) {
        FieldParam fieldParam = new FieldParam();
        fieldParam.setName(dy.getName().getLocaleValue());
        fieldParam.setNumber(dy.getKey());
        Map<String, Object> fieldRuleMap = CadreFileToolApplicationServiceImpl.getFieldRuleMap(dy);
        fieldParam.setFieldRuleMap(fieldRuleMap);
        fieldParam.setType(fieldType);
        fieldParam.setContainerNumber("fieldspermflex");
        return fieldParam;
    }

    public static Map<String, Object> getFieldRuleMap(EntityItem<?> entityItem) {
        return FieldRuleHandleUtils.getFieldRuleMap(entityItem);
    }

    private static String getBizUnitIdByParamNumber(String paramNumber) {
        String bizUnitId = "3OQ69PF5+A6P";
        switch (paramNumber) {
            case "pcview.2": {
                bizUnitId = "3OQ6DQRK+FBI";
                break;
            }
            case "pcview.1": {
                bizUnitId = "3OQ6CUVSDG6A";
                break;
            }
        }
        return bizUnitId;
    }
}

