/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.handler;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.metadata.model.plugin.AbstractModelOperater;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.common.entity.handler.ExtAppInfoHandler;
import kd.hdtc.hrdt.business.domain.config.IHRDTBaseConfigDomainService;

public class PersonMassMaintenanceFormHandler {
    private final IHRDTBaseConfigDomainService ihrdtBaseConfigDomainService = ServiceFactory.getService(IHRDTBaseConfigDomainService.class);
    Map<String, String> params = Maps.newHashMapWithExpectedSize((int)8);
    private static final String HSPM_INFO_CLASSIFY_VIEW_ID = "3A3M76K=YY4R";
    private static final String HSPM_INFO_CLASSIFY_VIEW_FS_FORM_INFO = "TfFgRChC5j";
    private static final String HSPM_INFOCLASSIFYVIEW_FS_PARENTHIDENINFO = "NOXQwObT9N";
    private static final String HSPM_INFOCLASSIFYVIEW_FLEX_PANEL_FORM_INFO = "sEpnDmWVNR";
    private static final String HSPM_INFO_CLASSIFY_VIEW_BIZ_UNIT_ID = "3AFH/LKOBE6L";
    private static final String HSPM_INFO_CLASSIFY_VIEW_FORM_PLUGIN = "kd.sdk.hr.hspm.formplugin.infoclassify.InfoClassifyEditPlugin";
    private static final String HSPM_INFO_CLASSIFY_VIEW_FORM_PLUGIN_HAVE_ATTACHMENT = "kd.sdk.hr.hspm.formplugin.infoclassify.ext.InfoClassifyAttachmentExtEditPlugin";
    private static final String HSPM_INFO_CLASSIFY_VIEW_OP_SAVE_PLUGIN = "kd.sdk.hr.hspm.opplugin.ext.InfoClassifyExtSaveOp";
    public String dataModelNumber;
    public String dataModelName;
    public String sourceNumber;
    private String metaDataNumber;
    private String metaDataName;
    public String bizUnitId;
    private Map<String, Object> metaData;

    public PersonMassMaintenanceFormHandler(String dataModelNumber, String dataModelName) {
        this.dataModelNumber = dataModelNumber;
        this.dataModelName = dataModelName;
        this.sourceNumber = this.getSourceNumber(dataModelNumber);
        this.bizUnitId = this.getMassMaintenanceUnit();
        this.metaDataNumber = this.getMassMaintenanceNumber();
        this.metaDataName = this.buildName();
        this.initParams();
    }

    public Map<String, Object> buildTplInfo() {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("parentId", this.getMassMaintenanceFormTpl());
        param.put("bizappid", this.getCurrentAppId());
        param.put("modelType", AbstractModelOperater.OBJECT_TYPE.BaseFormModel.name());
        param.put("id", this.metaDataNumber);
        param.put("name", this.metaDataName);
        return param;
    }

    public String getCurrentAppId() {
        return ExtAppInfoHandler.getExtAppId("hspm");
    }

    private String getMassMaintenanceFormTpl() {
        String param = this.params.get("hspm_infoclassifyview_id");
        return StringUtils.isEmpty((String)param) ? HSPM_INFO_CLASSIFY_VIEW_ID : param;
    }

    private String getMassMaintenanceUnit() {
        String param = this.params.get("hspm_infoclassifyview_bizunitid");
        return StringUtils.isEmpty((String)param) ? HSPM_INFO_CLASSIFY_VIEW_BIZ_UNIT_ID : param;
    }

    private String getMassMaintenanceNumber() {
        if (StringUtils.isNotEmpty((String)this.dataModelNumber)) {
            String info = this.dataModelNumber.toLowerCase().replace("hrpi", "hspm");
            return info;
        }
        return this.dataModelNumber;
    }

    public String getFsFormApId() {
        String param = this.params.get("hspm_infoclassifyview_fsforminfo");
        return StringUtils.isEmpty((String)param) ? HSPM_INFO_CLASSIFY_VIEW_FS_FORM_INFO : param;
    }

    public String getFsHideFormApId() {
        String param = this.params.get("hspm_infoclassifyview_fs_parenthideninfo");
        return StringUtils.isEmpty((String)param) ? HSPM_INFOCLASSIFYVIEW_FS_PARENTHIDENINFO : param;
    }

    public String getFormApId() {
        String param = this.params.get("hspm_infoclassifyview_flexpanel_forminfo");
        return StringUtils.isEmpty((String)param) ? HSPM_INFOCLASSIFYVIEW_FLEX_PANEL_FORM_INFO : param;
    }

    private String buildName() {
        return this.dataModelName;
    }

    private String getFormPlugin() {
        String param = this.params.get("hspm_info_classify_view_form_plugin");
        return StringUtils.isEmpty((String)param) ? HSPM_INFO_CLASSIFY_VIEW_FORM_PLUGIN : param;
    }

    private String getFormPluginHaveAttachment() {
        String param = this.params.get("hspm_info_classify_view_form_plugin_haveattachment");
        return StringUtils.isEmpty((String)param) ? HSPM_INFO_CLASSIFY_VIEW_FORM_PLUGIN_HAVE_ATTACHMENT : param;
    }

    private String getSaveOpPlugin() {
        String param = this.params.get("hspm_info_classify_view_op_save_plugin");
        return StringUtils.isEmpty((String)param) ? HSPM_INFO_CLASSIFY_VIEW_OP_SAVE_PLUGIN : param;
    }

    private String getSourceNumber(String fullNumber) {
        if (StringUtils.isBlank((CharSequence)fullNumber)) {
            return fullNumber;
        }
        int index = fullNumber.indexOf(95);
        if (index < 0) {
            return fullNumber;
        }
        return fullNumber.substring(index + 1);
    }

    public String getMetaDataNumber() {
        return this.metaDataNumber;
    }

    public Map<String, Object> getMetaData() {
        return this.metaData;
    }

    public void setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
    }

    public List<Map<String, Object>> buildPlugins(boolean haveAttachment) {
        ArrayList<Map<String, Object>> plugins = new ArrayList<Map<String, Object>>(4);
        String className = haveAttachment ? this.getFormPluginHaveAttachment() : this.getFormPlugin();
        ImmutableMap plugin = ImmutableMap.builder().put((Object)"FPK", (Object)"").put((Object)"_Type_", (Object)"Plugin").put((Object)"Description", (Object)"plugin").put((Object)"ClassName", (Object)className).put((Object)"Enabled", (Object)Boolean.TRUE).put((Object)"BizAppId", (Object)"").build();
        plugins.add((Map<String, Object>)plugin);
        return plugins;
    }

    public List<Map<String, Object>> buildSaveOpPlugins() {
        ArrayList<Map<String, Object>> plugins = new ArrayList<Map<String, Object>>(4);
        ImmutableMap plugin = ImmutableMap.builder().put((Object)"FPK", (Object)"").put((Object)"_Type_", (Object)"Plugin").put((Object)"Description", (Object)"plugin").put((Object)"ClassName", (Object)this.getSaveOpPlugin()).put((Object)"Enabled", (Object)Boolean.TRUE).put((Object)"BizAppId", (Object)"").build();
        plugins.add((Map<String, Object>)plugin);
        return plugins;
    }

    private void initParams() {
        this.params = this.ihrdtBaseConfigDomainService.queryBaseConfigValueByNumberList(Arrays.asList("hspm_infoclassifyview_id", "hspm_infoclassifyview_fsforminfo", "hspm_infoclassifyview_fs_parenthideninfo", "hspm_infoclassifyview_bizunitid", "hspm_info_classify_view_form_plugin", "hspm_info_classify_view_op_save_plugin"));
    }
}

