/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.handler;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FormShowParameter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.handler.PersonQueryInfo;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.common.entity.handler.ExtAppInfoHandler;
import kd.hdtc.hrdt.business.domain.config.IHRDTBaseConfigDomainService;
import kd.hdtc.hrdt.business.domain.ext.ICommonBosDomainService;

public class PersonMassMaintenanceQueryHandler {
    private final IHRDTBaseConfigDomainService ihrdtBaseConfigDomainService = ServiceFactory.getService(IHRDTBaseConfigDomainService.class);
    Map<String, String> params = Maps.newHashMapWithExpectedSize((int)4);
    private static final String HSPM_INFO_CLASSIFY_QUERY_BIZ_UNIT_ID = "3AFH/LKOBE6L";
    private ICommonBosDomainService commonBosDomainService = ServiceFactory.getService(ICommonBosDomainService.class);
    private static final String HRPI_EMP_ENT_REL = "hrpi_empentrel";
    private static final String HRPI_EMP_POS_ORG_REL = "hrpi_empposorgrel";
    private static final String HSPM_ERM_AN_FILE = "hspm_ermanfile";
    private static final String HRPI_PERSON = "hrpi_person";
    private static final String[] INNER_OPERATION_KEYS = new String[]{"new", "copy", "modify", "delete", "submit", "audit", "unaudit", "refresh", "unsubmit", "disable", "enable", "exportlist", "importdata", "printpreview", "printsetting", "close", "save", "submitandnew", "exportlistbyselectfields", "view", "first", "previous", "next", "last", "donothing"};
    private List<PersonQueryInfo> initData = new ArrayList<PersonQueryInfo>(8);
    private DynamicObject sourceData;
    private DynamicObject queryDyn;
    private MainEntityType queryDataEntityType;
    private String metaDataNumber;
    private String metaDataName;

    public PersonMassMaintenanceQueryHandler(String number, String queryNumber) {
        if (StringUtils.isBlank((CharSequence)number)) {
            throw new HDTCBizException("number con not be null");
        }
        DynamicObject sourceData = this.commonBosDomainService.getEntityObjectByNumber(number);
        if (sourceData == null) {
            throw new HDTCBizException("this number con not find object");
        }
        this.metaDataNumber = queryNumber;
        this.metaDataName = this.buildQueryName(sourceData.getString("name"));
        this.sourceData = sourceData;
        this.initParams();
    }

    public FormShowParameter buildTplInfo() {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("cts_querydynsource");
        parameter.setAppId("cts");
        parameter.setCustomParam("currentBizAppId", (Object)this.getCurrentAppId());
        parameter.setCustomParam("currentUnitId", (Object)this.getMassMaintenanceQueryUnit());
        return parameter;
    }

    public String getCurrentAppId() {
        return ExtAppInfoHandler.getExtAppId("hspm");
    }

    public DynamicObject buildQueryDyn() {
        this.initPersonQueryInfo();
        this.queryDyn.set("dstype", (Object)"QueryList");
        this.queryDyn.set("currentappid", (Object)this.getCurrentAppId());
        this.queryDyn.set("group", (Object)this.getMassMaintenanceQueryUnit());
        this.queryDyn.set("enableimport", (Object)Boolean.FALSE);
        this.queryDyn.set("number", (Object)this.metaDataNumber);
        this.queryDyn.set("editentityaliasname", (Object)this.sourceData.getString("number"));
        this.queryDyn.set("name", (Object)this.metaDataName);
        this.queryDyn.set("mainentityname", (Object)this.sourceData);
        this.queryDyn.set("mainentityalias", (Object)this.sourceData.getString("number"));
        this.queryDyn.set("queryentityentry", (Object)this.buildPersonMassMaintenanceQueryEntityEntry());
        this.queryDyn.set("queryrelationenrtry", (Object)this.buildPersonMassMaintenanceQueryRelationEntry());
        this.queryDyn.set("queryrelaconditionentry", (Object)this.buildPersonMassMaintenanceQueryRelationConditionEntry());
        this.queryDyn.set("queryselectfieldsentry", (Object)this.buildPersonMassMaintenanceQuerySelectFieldEntry());
        return this.queryDyn;
    }

    private List<PersonQueryInfo> initPersonQueryInfo() {
        this.queryDataEntityType = MetadataServiceHelper.getDataEntityType((String)"cts_querydynsource");
        this.queryDyn = new DynamicObject((DynamicObjectType)this.queryDataEntityType);
        this.initData.add(this.buildEmp());
        this.initData.add(this.buildEmpPos());
        this.initData.add(this.buildErmFile());
        this.initData.add(this.buildPerson());
        return this.initData;
    }

    private PersonQueryInfo buildEmp() {
        PersonQueryInfo personQueryInfo_emp = new PersonQueryInfo();
        personQueryInfo_emp.setNumber(HRPI_EMP_ENT_REL);
        MainEntityType empType = MetadataServiceHelper.getDataEntityType((String)HRPI_EMP_ENT_REL);
        personQueryInfo_emp.setName(empType.getDisplayName().getLocaleValue());
        personQueryInfo_emp.setMainEntityType(empType);
        personQueryInfo_emp.setParentNumber(this.sourceData.getString("number"));
        personQueryInfo_emp.setParentName(this.sourceData.getString("name"));
        ArrayList<Map<String, String>> conditions_emp = new ArrayList<Map<String, String>>(4);
        conditions_emp.add((Map<String, String>)ImmutableMap.builder().put((Object)"relaparententityprop", (Object)"person").put((Object)"relaparentdisplayname", (Object)ResManager.loadKDString((String)"\u59d3\u540d(person)", (String)"PersonMassMaintenanceQueryHandler_1", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relachildentityprop", (Object)"hrpi_empentrel.person").put((Object)"relachilddisplayname", (Object)ResManager.loadKDString((String)"\u804c\u4e1a\u4fe1\u606f\u57fa\u7840\u9875\u9762.\u4eba\u5458(hrpi_empentrel.person)", (String)"PersonMassMaintenanceQueryHandler_2", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relaconditiontype", (Object)"=").build());
        conditions_emp.add((Map<String, String>)ImmutableMap.builder().put((Object)"relaparententityprop", (Object)"hrpi_empentrel.iscurrentversion").put((Object)"relaparentdisplayname", (Object)ResManager.loadKDString((String)"\u804c\u4e1a\u4fe1\u606f\u57fa\u7840\u9875\u9762.\u662f\u5426\u5f53\u524d\u7248\u672c(hrpi_empentrel.iscurrentversion)", (String)"PersonMassMaintenanceQueryHandler_3", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relachildentityprop", (Object)"'1'").put((Object)"relachilddisplayname", (Object)"'1'").put((Object)"relaconditiontype", (Object)"=").build());
        conditions_emp.add((Map<String, String>)ImmutableMap.builder().put((Object)"relaparententityprop", (Object)"hrpi_empentrel.businessstatus").put((Object)"relaparentdisplayname", (Object)ResManager.loadKDString((String)"\u804c\u4e1a\u4fe1\u606f\u57fa\u7840\u9875\u9762.\u4e1a\u52a1\u72b6\u6001", (String)"PersonMassMaintenanceQueryHandler_4", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relachildentityprop", (Object)"'1'").put((Object)"relachilddisplayname", (Object)"'1'").put((Object)"relaconditiontype", (Object)"=").build());
        personQueryInfo_emp.setConditions(conditions_emp);
        return personQueryInfo_emp;
    }

    private PersonQueryInfo buildEmpPos() {
        PersonQueryInfo personQueryInfo_emp = new PersonQueryInfo();
        personQueryInfo_emp.setNumber(HRPI_EMP_POS_ORG_REL);
        MainEntityType empType = MetadataServiceHelper.getDataEntityType((String)HRPI_EMP_POS_ORG_REL);
        personQueryInfo_emp.setName(empType.getDisplayName().getLocaleValue());
        personQueryInfo_emp.setMainEntityType(empType);
        personQueryInfo_emp.setParentNumber(this.sourceData.getString("number"));
        personQueryInfo_emp.setParentName(this.sourceData.getString("name"));
        ArrayList<Map<String, String>> conditions_emp = new ArrayList<Map<String, String>>(4);
        conditions_emp.add((Map<String, String>)ImmutableMap.builder().put((Object)"relaparententityprop", (Object)"person").put((Object)"relaparentdisplayname", (Object)ResManager.loadKDString((String)"\u59d3\u540d(person)", (String)"PersonMassMaintenanceQueryHandler_1", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relachildentityprop", (Object)"hrpi_empposorgrel.person").put((Object)"relachilddisplayname", (Object)ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386\u57fa\u7840\u9875\u9762.\u4eba\u5458(hrpi_empposorgrel.person)", (String)"PersonMassMaintenanceQueryHandler_5", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relaconditiontype", (Object)"=").build());
        conditions_emp.add((Map<String, String>)ImmutableMap.builder().put((Object)"relaparententityprop", (Object)"hrpi_empposorgrel.iscurrentversion").put((Object)"relaparentdisplayname", (Object)ResManager.loadKDString((String)"\u4efb\u804c\u7ecf\u5386\u57fa\u7840\u9875\u9762.\u662f\u5426\u5f53\u524d\u7248\u672c(hrpi_empposorgrel.iscurrentversion)", (String)"PersonMassMaintenanceQueryHandler_6", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relachildentityprop", (Object)"'1'").put((Object)"relachilddisplayname", (Object)"'1'").put((Object)"relaconditiontype", (Object)"=").build());
        personQueryInfo_emp.setConditions(conditions_emp);
        return personQueryInfo_emp;
    }

    private PersonQueryInfo buildErmFile() {
        PersonQueryInfo personQueryInfo_emp = new PersonQueryInfo();
        personQueryInfo_emp.setNumber(HSPM_ERM_AN_FILE);
        MainEntityType empType = MetadataServiceHelper.getDataEntityType((String)HSPM_ERM_AN_FILE);
        personQueryInfo_emp.setName(empType.getDisplayName().getLocaleValue());
        personQueryInfo_emp.setMainEntityType(empType);
        personQueryInfo_emp.setParentNumber(this.sourceData.getString("number"));
        personQueryInfo_emp.setParentName(this.sourceData.getString("name"));
        ArrayList<Map<String, String>> conditions_emp = new ArrayList<Map<String, String>>(4);
        conditions_emp.add((Map<String, String>)ImmutableMap.builder().put((Object)"relaparententityprop", (Object)"person").put((Object)"relaparentdisplayname", (Object)ResManager.loadKDString((String)"\u59d3\u540d(person)", (String)"PersonMassMaintenanceQueryHandler_1", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relachildentityprop", (Object)"hspm_ermanfile.person").put((Object)"relachilddisplayname", (Object)ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848.\u4eba\u5458(hspm_ermanfile.person)", (String)"PersonMassMaintenanceQueryHandler_7", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relaconditiontype", (Object)"=").build());
        conditions_emp.add((Map<String, String>)ImmutableMap.builder().put((Object)"relaparententityprop", (Object)"hspm_ermanfile.iscurrentversion").put((Object)"relaparentdisplayname", (Object)ResManager.loadKDString((String)"\u4eba\u4e8b\u4e1a\u52a1\u6863\u6848.\u662f\u5426\u5f53\u524d\u7248\u672c(hspm_ermanfile.iscurrentversion)", (String)"PersonMassMaintenanceQueryHandler_8", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relachildentityprop", (Object)"'1'").put((Object)"relachilddisplayname", (Object)"'1'").put((Object)"relaconditiontype", (Object)"=").build());
        personQueryInfo_emp.setConditions(conditions_emp);
        return personQueryInfo_emp;
    }

    private PersonQueryInfo buildPerson() {
        PersonQueryInfo personQueryInfo_emp = new PersonQueryInfo();
        personQueryInfo_emp.setNumber(HRPI_PERSON);
        MainEntityType empType = MetadataServiceHelper.getDataEntityType((String)HRPI_PERSON);
        personQueryInfo_emp.setName(empType.getDisplayName().getLocaleValue());
        personQueryInfo_emp.setMainEntityType(empType);
        personQueryInfo_emp.setParentNumber(this.sourceData.getString("number"));
        personQueryInfo_emp.setParentName(this.sourceData.getString("name"));
        ArrayList<Map<String, String>> conditions_emp = new ArrayList<Map<String, String>>(4);
        conditions_emp.add((Map<String, String>)ImmutableMap.builder().put((Object)"relaparententityprop", (Object)"person").put((Object)"relaparentdisplayname", (Object)ResManager.loadKDString((String)"\u59d3\u540d(person)", (String)"PersonMassMaintenanceQueryHandler_1", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relachildentityprop", (Object)"hrpi_person.id").put((Object)"relachilddisplayname", (Object)ResManager.loadKDString((String)"HR\u4eba\u5458\u4fe1\u606f.\u4eba\u5458(hrpi_person.id)", (String)"PersonMassMaintenanceQueryHandler_9", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relaconditiontype", (Object)"=").build());
        conditions_emp.add((Map<String, String>)ImmutableMap.builder().put((Object)"relaparententityprop", (Object)"hrpi_person.iscurrentversion").put((Object)"relaparentdisplayname", (Object)ResManager.loadKDString((String)"HR\u4eba\u5458\u4fe1\u606f.\u662f\u5426\u5f53\u524d\u7248\u672c(hrpi_person.iscurrentversion)", (String)"PersonMassMaintenanceQueryHandler_10", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relachildentityprop", (Object)"'1'").put((Object)"relachilddisplayname", (Object)"'1'").put((Object)"relaconditiontype", (Object)"=").build());
        conditions_emp.add((Map<String, String>)ImmutableMap.builder().put((Object)"relaparententityprop", (Object)"hrpi_person.datastatus").put((Object)"relaparentdisplayname", (Object)ResManager.loadKDString((String)"HR\u4eba\u5458\u4fe1\u606f.\u6570\u636e\u7248\u672c\u72b6\u6001(hrpi_person.datastatus)", (String)"PersonMassMaintenanceQueryHandler_11", (String)"hdtc-hrdt-business", (Object[])new Object[0])).put((Object)"relachildentityprop", (Object)"'1'").put((Object)"relachilddisplayname", (Object)"'1'").put((Object)"relaconditiontype", (Object)"=").build());
        personQueryInfo_emp.setConditions(conditions_emp);
        return personQueryInfo_emp;
    }

    private DynamicObjectCollection buildPersonMassMaintenanceQueryEntityEntry() {
        Map entityType = this.queryDataEntityType.getAllEntities();
        EntityType entryType = (EntityType)entityType.get("queryentityentry");
        DynamicObjectCollection queryEntityEntryCollection = new DynamicObjectCollection((DynamicObjectType)entryType, (Object)this.queryDyn);
        for (PersonQueryInfo personQueryInfo : this.initData) {
            DynamicObject queryEntityEntry = new DynamicObject((DynamicObjectType)entryType);
            queryEntityEntry.set("entityalias", (Object)personQueryInfo.getNumber());
            queryEntityEntry.set("entitynumber", (Object)personQueryInfo.getNumber());
            queryEntityEntry.set("entityname", (Object)personQueryInfo.getName());
            queryEntityEntryCollection.add((Object)queryEntityEntry);
        }
        return queryEntityEntryCollection;
    }

    private DynamicObjectCollection buildPersonMassMaintenanceQueryRelationEntry() {
        Map entityType = this.queryDataEntityType.getAllEntities();
        EntityType entryType = (EntityType)entityType.get("queryrelationenrtry");
        DynamicObjectCollection entryCollection = new DynamicObjectCollection((DynamicObjectType)entryType, (Object)this.queryDyn);
        for (PersonQueryInfo personQueryInfo : this.initData) {
            DynamicObject entry = new DynamicObject((DynamicObjectType)entryType);
            entry.set("parententityalias", this.sourceData.get("number"));
            entry.set("childentityalias", (Object)personQueryInfo.getNumber());
            entry.set("childentitynumber", (Object)personQueryInfo.getNumber());
            entry.set("combinationtype", (Object)"LeftJoin");
            entryCollection.add((Object)entry);
        }
        return entryCollection;
    }

    private DynamicObjectCollection buildPersonMassMaintenanceQueryRelationConditionEntry() {
        Map entityType = this.queryDataEntityType.getAllEntities();
        EntityType entryType = (EntityType)entityType.get("queryrelaconditionentry");
        DynamicObjectCollection entryCollection = new DynamicObjectCollection((DynamicObjectType)entryType, (Object)this.queryDyn);
        for (PersonQueryInfo personQueryInfo : this.initData) {
            List<Map<String, String>> conditions = personQueryInfo.getConditions();
            if (CollectionUtils.isEmpty(conditions)) continue;
            for (Map<String, String> condition : conditions) {
                DynamicObject entry = new DynamicObject((DynamicObjectType)entryType);
                entry.set("relaparententityprop", (Object)condition.get("relaparententityprop"));
                entry.set("relaparentdisplayname", (Object)condition.get("relaparentdisplayname"));
                entry.set("relachildentityprop", (Object)condition.get("relachildentityprop"));
                entry.set("relachilddisplayname", (Object)condition.get("relachilddisplayname"));
                entry.set("relaconditiontype", (Object)condition.get("relaconditiontype"));
                entryCollection.add((Object)entry);
            }
        }
        return entryCollection;
    }

    public Map<String, List<Map<String, Object>>> buildPersonMassMaintenanceQueryRelationConditionCache() {
        HashMap queryDataMap = Maps.newHashMapWithExpectedSize((int)16);
        for (PersonQueryInfo personQueryInfo : this.initData) {
            List<Map<String, String>> conditions = personQueryInfo.getConditions();
            if (CollectionUtils.isEmpty(conditions)) continue;
            String parentNumber = personQueryInfo.getParentNumber();
            ArrayList cons = Lists.newArrayListWithExpectedSize((int)conditions.size());
            for (Map<String, String> condition : conditions) {
                HashMap<String, String> conditionMap = new HashMap<String, String>(16);
                conditionMap.put("id", null);
                conditionMap.put("parentField", condition.get("relaparententityprop"));
                conditionMap.put("conditionField", condition.get("relaconditiontype"));
                conditionMap.put("childField", condition.get("relachildentityprop"));
                cons.add(conditionMap);
            }
            queryDataMap.put(parentNumber + ":" + personQueryInfo.getNumber(), cons);
        }
        return queryDataMap;
    }

    private DynamicObjectCollection buildPersonMassMaintenanceQuerySelectFieldEntry() {
        Map entityType = this.queryDataEntityType.getAllEntities();
        EntityType entryType = (EntityType)entityType.get("queryselectfieldsentry");
        DynamicObjectCollection entryCollection = new DynamicObjectCollection((DynamicObjectType)entryType, (Object)this.queryDyn);
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)this.sourceData.getString("number"));
        this.buildField(mainEntityType, entryType, entryCollection, true);
        for (PersonQueryInfo personQueryInfo : this.initData) {
            this.buildField(personQueryInfo.getMainEntityType(), entryType, entryCollection, false);
        }
        return entryCollection;
    }

    private void buildField(MainEntityType mainEntityType, EntityType entryType, DynamicObjectCollection entryCollection, boolean isSelf) {
        Map fields = mainEntityType.getAllFields();
        if (CollectionUtils.isEmpty((Map)fields)) {
            return;
        }
        String mainEntityTypeName = isSelf ? "" : mainEntityType.getName() + ".";
        String mainEntityTypeDisplayName = isSelf ? "" : mainEntityType.getDisplayName().getLocaleValue() + ".";
        for (Map.Entry filed : fields.entrySet()) {
            IDataEntityProperty prop = (IDataEntityProperty)filed.getValue();
            if (prop instanceof BasedataProp) {
                BasedataProp basedataProp = (BasedataProp)prop;
                DataEntityPropertyCollection baseDataProps = basedataProp.getComplexType().getProperties();
                if (!CollectionUtils.isNotEmpty((Collection)baseDataProps)) continue;
                for (IDataEntityProperty pp : baseDataProps) {
                    String ppName = pp.getName();
                    if ("id".equals(ppName) || "multilanguagetext".equals(ppName) || StringUtils.isBlank((CharSequence)ppName)) continue;
                    DynamicObject entry = new DynamicObject((DynamicObjectType)entryType);
                    entry.set("selectfieldalias", (Object)(mainEntityTypeName + prop.getName() + "." + pp.getName()));
                    entry.set("selectfielddisplayname", (Object)(mainEntityTypeDisplayName + prop.getDisplayName() + "." + pp.getDisplayName()));
                    entry.set("selectfieldentityname", (Object)mainEntityType.getDisplayName());
                    entryCollection.add((Object)entry);
                }
                continue;
            }
            DynamicObject entry = new DynamicObject((DynamicObjectType)entryType);
            entry.set("selectfieldalias", (Object)(mainEntityTypeName + prop.getName()));
            entry.set("selectfielddisplayname", (Object)(mainEntityTypeDisplayName + prop.getDisplayName()));
            entry.set("selectfieldentityname", (Object)mainEntityTypeDisplayName);
            entryCollection.add((Object)entry);
        }
    }

    public Map<String, Object> buildOps(Map<String, Object> sourceMetaData) {
        DesignMetadataParser sourceDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        List editParamList = sourceDesignMetadataParser.getEntityMetadata();
        ArrayList<Map> operationListMap = new ArrayList<Map>();
        ArrayList<Map> curPermList = new ArrayList<Map>();
        List entityOperationList = (List)((Map)editParamList.get(0)).get("Operations");
        List permissionItemsList = (List)((Map)editParamList.get(0)).get("PermissionItems");
        if (entityOperationList != null) {
            List<String> innerOperationKeysList = Arrays.asList(INNER_OPERATION_KEYS);
            ArrayList<String> innerPermissionKeysList = new ArrayList<String>();
            for (Map permMap : entityOperationList) {
                if (!innerOperationKeysList.contains(permMap.get("OperationType"))) continue;
                operationListMap.add(permMap);
                innerPermissionKeysList.add((String)permMap.get("PermissionItemId"));
            }
            if (permissionItemsList != null) {
                for (Map permMap : permissionItemsList) {
                    if (!innerPermissionKeysList.contains(permMap.get("ItemId"))) continue;
                    curPermList.add(permMap);
                }
            }
        }
        return ImmutableMap.builder().put((Object)"operations_control_val", operationListMap).put((Object)"permission_control_val", curPermList).build();
    }

    public String getMassMaintenanceQueryUnit() {
        String param = this.params.get("hspm_info_classify_query_biz_unit_id");
        return StringUtils.isEmpty((String)param) ? HSPM_INFO_CLASSIFY_QUERY_BIZ_UNIT_ID : param;
    }

    private String buildQueryNumber(String number) {
        return number + "query";
    }

    private String buildQueryName(String name) {
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"%1$s\u67e5\u8be2", (String)"PersonMassMaintenanceQueryHandler_0", (String)"hdtc-hrdt-business", (Object[])new Object[0]), name);
    }

    public String getMetaDataNumber() {
        return this.metaDataNumber;
    }

    public String getMetaDataName() {
        return this.metaDataName;
    }

    private void initParams() {
        this.params = this.ihrdtBaseConfigDomainService.queryBaseConfigValueByNumberList(Collections.singletonList("hspm_info_classify_query_biz_unit_id"));
    }
}

