/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.handler;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.id.ID;
import kd.bos.list.SeqColumnType;
import kd.bos.metadata.model.plugin.AbstractModelOperater;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.common.entity.handler.ExtAppInfoHandler;
import kd.hdtc.hrdt.business.domain.config.IHRDTBaseConfigDomainService;

public class PersonMassMaintenanceQueryListHandler {
    private final IHRDTBaseConfigDomainService ihrdtBaseConfigDomainService = ServiceFactory.getService(IHRDTBaseConfigDomainService.class);
    Map<String, String> params = Maps.newHashMapWithExpectedSize((int)4);
    private static final String HSPM_INFO_CLASSIFY_QUERY_LIST_BIZ_UNIT_ID = "3AFH/LKOBE6L";
    private static final String HSPM_INFO_CLASSIFY_COPY_LIST_NUMBER = "hspm_massmglist_ext";
    private static final String HSPM_INFO_CLASSIFY_QUERY_LIST_PLUGINS = "kd.hr.hbp.formplugin.web.newhismodel.HisCommonListPlugin;kd.sdk.hr.hspm.formplugin.infoclassify.ext.InfoClassifyExtListPlugin";
    private String metaDataNumber;
    private String metaDataName;
    private String entityId;
    public String bizUnitId;
    private final Set<String> excludeColumns = new HashSet<String>(Arrays.asList("boid", "iscurrentversion", "datastatus", "ismodify", "sourcevid", "hisversion", "initstatus", "initbatch", "initdatasource", "creator", "createtime", "modifytime", "modifier", "description", "changedescription", "person", "issingle", "datastatus", "sourcevid", "firstbsed", "changebsed", "bred", "brled", "brfd", "ismodify", "bsed", "bsled", "changedescription", "hisversion"));

    public PersonMassMaintenanceQueryListHandler(String listNumber, String sourceMetaDataName, String entityId) {
        this.metaDataNumber = listNumber;
        this.metaDataName = sourceMetaDataName;
        this.entityId = entityId;
        this.bizUnitId = this.getUnit();
        this.initParams();
    }

    public Map<String, Object> buildTplInfo() {
        HashMap<String, Object> param = new HashMap<String, Object>(16);
        param.put("bizappid", this.getCurrentAppId());
        param.put("modelType", AbstractModelOperater.OBJECT_TYPE.QueryListModel.name());
        param.put("id", this.metaDataNumber);
        param.put("name", this.metaDataName);
        param.put("entityId", this.entityId);
        return param;
    }

    public String getCurrentAppId() {
        return ExtAppInfoHandler.getExtAppId("hspm");
    }

    private String buildQueryListNumber(String number) {
        return number + "list";
    }

    public String getMetaDataNumber() {
        return this.metaDataNumber;
    }

    public String getMetaDataName() {
        return this.metaDataName;
    }

    private String getUnit() {
        String param = this.params.get("hspm_info_classify_query_list_biz_unit_id");
        return StringUtils.isEmpty((String)param) ? HSPM_INFO_CLASSIFY_QUERY_LIST_BIZ_UNIT_ID : param;
    }

    public String getCopyQueryListNumber() {
        String param = this.params.get("hspm_info_classify_copy_list_number");
        return StringUtils.isEmpty((String)param) ? HSPM_INFO_CLASSIFY_COPY_LIST_NUMBER : param;
    }

    public List<Map<String, Object>> buildPlugins() {
        String[] paramArr;
        String param = this.params.get("hspm_info_classify_query_list_plugins");
        ArrayList<Map<String, Object>> plugins = new ArrayList<Map<String, Object>>(4);
        param = StringUtils.isEmpty((String)param) ? HSPM_INFO_CLASSIFY_QUERY_LIST_PLUGINS : param;
        for (String pluginClass : paramArr = param.split(";")) {
            ImmutableMap plugin = ImmutableMap.builder().put((Object)"FPK", (Object)"").put((Object)"_Type_", (Object)"Plugin").put((Object)"Description", (Object)"plugin").put((Object)"ClassName", (Object)pluginClass).put((Object)"Enabled", (Object)Boolean.TRUE).put((Object)"BizAppId", (Object)Boolean.TRUE).build();
            plugins.add((Map<String, Object>)plugin);
        }
        return plugins;
    }

    public List<Map<String, Object>> buildNewDataColumns(String number) {
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        Map allFields = mainType.getAllFields();
        ArrayList<Map<String, Object>> nodes = new ArrayList<Map<String, Object>>(4);
        int index = 1;
        if (CollectionUtils.isNotEmpty((Map)allFields)) {
            for (Map.Entry prop : allFields.entrySet()) {
                IDataEntityProperty pp;
                if (this.excludeColumns.contains(prop.getKey()) || (pp = (IDataEntityProperty)prop.getValue()).isDbIgnore()) continue;
                LinkedHashMap listNodeMap = Maps.newLinkedHashMap();
                listNodeMap.put("ParentId", "gridview");
                listNodeMap.put("_Type_", "ListColumnAp");
                listNodeMap.put("Name", pp.getDisplayName().getLocaleValue());
                listNodeMap.put("Order", "NotOrder");
                listNodeMap.put("SeqColumnType", SeqColumnType.NotSeq.name());
                listNodeMap.put("Index", 3);
                listNodeMap.put("ListFieldId", pp.getName());
                listNodeMap.put("ColumnOrderAndFilter", Boolean.TRUE);
                listNodeMap.put("Id", ID.genStringId());
                listNodeMap.put("Key", "listcolumnapext" + index);
                nodes.add(listNodeMap);
                ++index;
            }
        }
        return nodes;
    }

    private void initParams() {
        this.params = this.ihrdtBaseConfigDomainService.queryBaseConfigValueByNumberList(Arrays.asList("hspm_info_classify_query_list_biz_unit_id", "hspm_info_classify_copy_list_number", "hspm_info_classify_query_list_plugins"));
    }
}

