/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.ContainerParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FormPluginParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.IMulPersonFileToolApplicationService;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.IPersonMassMaintenanceApplicationService;
import kd.hdtc.hrdt.business.common.constants.PersonFileToolConstants;
import kd.hdtc.hrdt.business.common.model.MetadataBo;
import kd.hdtc.hrdt.business.common.utils.EntityInfoUtils;
import kd.hdtc.hrdt.business.common.utils.FieldRuleHandleUtils;
import kd.hdtc.hrdt.business.common.utils.MetaFieldTypeUtils;
import kd.hdtc.hrdt.business.common.utils.platform.HRDTMetadataUtils;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelRecordDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultBo;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.IMulPersonFileToolDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.IPersonFileToolDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.impl.MulPersonFileNumberGenerateDomainServiceImpl;
import kd.hdtc.hrdt.common.enums.HRPITplEnum;
import kd.hr.hbp.common.util.HRStringUtils;

public class MulPersonFileToolApplicationServiceImpl
implements IMulPersonFileToolApplicationService {
    private static final Log LOG = LogFactory.getLog(MulPersonFileToolApplicationServiceImpl.class);
    private IBizModelRecordDomainService bizModelRecordDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IBizModelRecordDomainService.class);
    private IPersonFileToolDomainService personFileToolDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IPersonFileToolDomainService.class);
    private IMulPersonFileToolDomainService mulPersonFileToolDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IMulPersonFileToolDomainService.class);
    private final IPersonMassMaintenanceApplicationService iPersonMassMaintenanceApplicationService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IPersonMassMaintenanceApplicationService.class);
    private final IMetadataDomainService metadataDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IMetadataDomainService.class);
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);

    @Override
    public ToolResultBo effect(DynamicObject mulPersonFileData) {
        ToolResultBo toolResultBo = new ToolResultBo();
        try {
            toolResultBo.setBizModelId(mulPersonFileData.getLong("bizmodel.id"));
            toolResultBo.setAbilityId(1827609938260771840L);
            String entityNumber = mulPersonFileData.getString("bizmodel.mainentity.number");
            String entityName = mulPersonFileData.getString("bizmodel.mainentity.name");
            String viewType = this.getViewType(entityNumber);
            Map<String, List<String>> viewTypeAndMetaDataNumberMap = this.generateMetaData(mulPersonFileData, toolResultBo);
            boolean existPersonEntityConfig = this.personFileToolDomainService.isExistPersonEntityConfig(entityNumber);
            if (!existPersonEntityConfig) {
                DynamicObject personEntityConfigDyn = this.personFileToolDomainService.toPersonEntityConfigDyn(entityNumber, entityName);
                OperationResult savePersonEntityConfigResult = this.personFileToolDomainService.savePersonEntityConfig(new DynamicObject[]{personEntityConfigDyn});
                toolResultBo.addData("hrpi_personentityconf", savePersonEntityConfigResult != null ? savePersonEntityConfigResult.getSuccessPkIds() : new ArrayList());
            }
            Map<DynamicObject, DynamicObject> mulPersonFileAndInfoGroupMap = this.mulPersonFileToolDomainService.registerPersonInfoGroupPage(mulPersonFileData, viewTypeAndMetaDataNumberMap, toolResultBo);
            this.mulPersonFileToolDomainService.addPermRelate(viewType, mulPersonFileAndInfoGroupMap, toolResultBo);
            this.mulPersonFileToolDomainService.registerMultiViewConfig(mulPersonFileAndInfoGroupMap, toolResultBo);
            if (mulPersonFileData.getBoolean("isbatchmenu")) {
                ToolResultBo toolResultBo1 = this.iPersonMassMaintenanceApplicationService.generateMassMaintenanceInfoByNumber(entityNumber, mulPersonFileData.getLong("bizmodel.id"), false);
                if (toolResultBo1.getEffectiveStatus().equals("2")) {
                    toolResultBo.addAllDyns(toolResultBo1.getDyns());
                    toolResultBo.addDatas(toolResultBo1.getDatas());
                } else {
                    throw new HRDBSBizException(toolResultBo1.getErrorMsg());
                }
            }
            toolResultBo.setEffectiveStatus("2");
        }
        catch (Exception e) {
            this.bizModelRecordDomainService.rollBackModelRecord(Collections.singletonList(toolResultBo));
            toolResultBo.setEffectiveStatus("0");
            toolResultBo.setErrorMsg(e.getMessage());
            LOG.error("effect error {} {}", (Object)e.getCause(), (Object)e.getMessage());
            return toolResultBo;
        }
        toolResultBo.addData("hrdt_mulpersonfiletool", Collections.singletonList(mulPersonFileData.getLong("id")));
        this.bizModelRecordDomainService.saveBizModelRecord(Collections.singletonList(toolResultBo));
        return toolResultBo;
    }

    private Map<String, List<String>> generateMetaData(DynamicObject mulPersonFileData, ToolResultBo toolResultBo) {
        String entityNumber = mulPersonFileData.getString("bizmodel.mainentity.number");
        String entityName = mulPersonFileData.getString("bizmodel.name");
        DynamicObjectCollection fileEntryEntity = mulPersonFileData.getDynamicObjectCollection("personfileentry");
        List<String> pageFieldNameList = this.getPageFieldNameList(fileEntryEntity);
        Map<String, String> metaDataNumberMap = this.personFileToolDomainService.generateEntityNumbers(Sets.newHashSet((Object[])new String[]{entityNumber}), new MulPersonFileNumberGenerateDomainServiceImpl()).get(entityNumber);
        LinkedHashMap viewTypeAndMetaDataNumberMap = Maps.newLinkedHashMapWithExpectedSize((int)4);
        String viewType = this.getViewType(entityNumber);
        for (String pageView : pageFieldNameList) {
            String paramNumber = pageView + "." + viewType;
            Map<String, String> entityNumberMap = this.personFileToolDomainService.getPersonFilePages(paramNumber);
            if (CollectionUtils.isEmpty(entityNumberMap)) continue;
            Map<String, String> entityPluginMap = this.personFileToolDomainService.getPersonFileFormPlugin(entityNumberMap.keySet());
            for (Map.Entry<String, String> numberValue : entityNumberMap.entrySet()) {
                String metaDataNumber = metaDataNumberMap.get(PersonFileToolConstants.BASE_CONFIG_KEY_MEAT_DATA_NUMBER_KEY_MAP.getOrDefault(numberValue.getKey(), ""));
                metaDataNumber = this.doGenerateMetaData(metaDataNumber, entityName, paramNumber, entityNumber, numberValue, entityPluginMap, toolResultBo);
                List metaDataNumberList = viewTypeAndMetaDataNumberMap.computeIfAbsent(paramNumber, k -> new ArrayList());
                metaDataNumberList.add(metaDataNumber);
            }
        }
        return viewTypeAndMetaDataNumberMap;
    }

    private String doGenerateMetaData(String metaDataNumber, String entityName, String paramNumber, String entityNumber, Map.Entry<String, String> numberValue, Map<String, String> entityPluginMap, ToolResultBo toolResultBo) {
        if (MetadataUtils.isExist((String)metaDataNumber)) {
            return metaDataNumber;
        }
        String plugin = CollectionUtils.isEmpty(entityPluginMap) ? "" : entityPluginMap.get(numberValue.getKey() + ".plugin");
        String filePlugin = CollectionUtils.isEmpty(entityPluginMap) ? "" : entityPluginMap.get(numberValue.getKey() + ".plugin" + ".file");
        MetadataGenParam metadataGenParam = this.getMetadataGenParam(metaDataNumber, entityName, numberValue.getValue(), paramNumber, numberValue.getKey(), entityNumber, plugin, filePlugin);
        MetadataGenResult metadataGenResult = this.dynamicMetadataApplicationService.generate(metadataGenParam);
        metaDataNumber = metadataGenResult.getEntityNumber();
        toolResultBo.addDyn(metaDataNumber);
        return metaDataNumber;
    }

    private String getViewType(String entityNumber) {
        String tplType = EntityInfoUtils.getHrpiEntityInhRelationType(entityNumber);
        if (tplType.equals(HRPITplEnum.NONLINETIMESEQ_MULTPL.getNumber()) || tplType.equals(HRPITplEnum.LINETIMESEQ_MULTPL.getNumber())) {
            return "2";
        }
        return "1";
    }

    private List<String> getPageFieldNameList(DynamicObjectCollection fileEntryEntity) {
        ArrayList pageFieldNameList = Lists.newArrayListWithExpectedSize((int)4);
        if (fileEntryEntity == null || fileEntryEntity.size() == 0) {
            return pageFieldNameList;
        }
        Set bizTypeSet = fileEntryEntity.stream().filter(fileEntity -> HRStringUtils.isNotEmpty((String)fileEntity.getString("biztype"))).map(fileEntity -> fileEntity.getString("biztype")).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(bizTypeSet)) {
            return pageFieldNameList;
        }
        for (String bizType : bizTypeSet) {
            if ("1".equals(bizType)) {
                pageFieldNameList.add("employeepcview");
                pageFieldNameList.add("employeemobileview");
                continue;
            }
            if (!"0".equals(bizType)) continue;
            pageFieldNameList.add("pcview");
        }
        return pageFieldNameList;
    }

    private MetadataGenParam getMetadataGenParam(String metaDataNumber, String metaDataName, String parentFilePage, String paramNumber, String baseConfigKey, String entityNumber, String pluginParam, String filePluginParam) {
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        BaseParam baseParam = new BaseParam();
        metadataGenParam.setBaseParam(baseParam);
        baseParam.setMetadataName(metaDataName);
        baseParam.setMetadataNumber(metaDataNumber);
        Map<String, Object> parentNode = HRDTMetadataUtils.getDesignerMetadata(parentFilePage);
        if (CollectionUtils.isNotEmpty(parentNode)) {
            Object parentModelType;
            Object parentId = parentNode.get("id");
            if (parentId != null) {
                baseParam.setParentId(String.valueOf(parentId));
            }
            if ((parentModelType = parentNode.get("modelType")) != null) {
                baseParam.setModelType(String.valueOf(parentModelType));
            }
        }
        baseParam.setBizUnitId(MulPersonFileToolApplicationServiceImpl.getBizUnitIdByParamNumber(paramNumber));
        baseParam.setAppId("hspm");
        baseParam.setType(MetadataGenTypeEnum.NORMAL_METADATA);
        List formMetadata = MetadataUtils.getFormMetadata((String)entityNumber);
        List<ControlAp> fileAps = null;
        if (CollectionUtils.isNotEmpty((Collection)formMetadata)) {
            fileAps = formMetadata.stream().filter(form -> form instanceof AttachmentPanelAp).collect(Collectors.toList());
        }
        MetadataBo metadataBo = this.metadataDomainService.getMetaInfoByNumber(entityNumber, true, false);
        if (baseConfigKey.equals("hrdt_basecard_dyview") || baseConfigKey.equals("hrdt_pagebase_dyview")) {
            List<EntityItem<?>> metadataBoItems = metadataBo.getItems();
            metadataBoItems.forEach(dy -> {
                if (!dy.isInherit()) {
                    String fieldType = MetaFieldTypeUtils.getFieldType(dy);
                    FieldParam fieldParam = this.getFieldParam((EntityItem<?>)dy, fieldType);
                    metadataGenParam.getFieldParamList().add(fieldParam);
                }
            });
            if (fileAps != null && fileAps.size() > 0) {
                fileAps.forEach(ap -> {
                    FieldParam fieldParam = this.getAttachmentFieldParam((ControlAp<?>)ap);
                    metadataGenParam.getFieldParamList().add(fieldParam);
                });
            }
        }
        if (baseConfigKey.equals("hrdt_basecard_dyview") || baseConfigKey.equals("hrdt_basecard_pdyview") || baseConfigKey.equals("hrdt_basecard_mdv")) {
            String containerNumber = "contentap" + entityNumber.substring(entityNumber.lastIndexOf(95) + 1);
            ContainerParam containerParam1 = this.getContainerParam(containerNumber, PersonFileToolConstants.CONTENT, "FlexPanelAp", 3, false);
            metadataGenParam.getContainerParamList().add(containerParam1);
        }
        if (StringUtils.isNotEmpty((String)filePluginParam) && CollectionUtils.isNotEmpty(fileAps)) {
            pluginParam = filePluginParam;
        }
        if (StringUtils.isNotEmpty((String)pluginParam)) {
            String[] plugins = pluginParam.split(";");
            ArrayList formPluginParamList = Lists.newArrayListWithExpectedSize((int)plugins.length);
            for (String plugin : plugins) {
                FormPluginParam formPluginParam = new FormPluginParam();
                formPluginParam.setClassName(plugin);
                formPluginParam.setDescription(plugin);
                formPluginParam.setEnable(Boolean.TRUE);
                formPluginParamList.add(formPluginParam);
            }
            metadataGenParam.setFormPluginParamList((List)formPluginParamList);
        }
        return metadataGenParam;
    }

    private FieldParam getAttachmentFieldParam(ControlAp<?> ap) {
        FieldParam fieldParam = new FieldParam();
        fieldParam.setName(ap.getName().getLocaleValue());
        fieldParam.setNumber(ap.getKey());
        HashMap fieldRuleMap = Maps.newHashMapWithExpectedSize((int)1);
        fieldRuleMap.put("MustInput", 0);
        fieldParam.setFieldRuleMap((Map)fieldRuleMap);
        fieldParam.setType(AttachmentField.class.getSimpleName());
        fieldParam.setContainerNumber("fieldspermflex");
        return fieldParam;
    }

    private ContainerParam getContainerParam(String containerNumber, String containerName, String type, int index, boolean collapsible) {
        ContainerParam containerParam1 = new ContainerParam();
        containerParam1.setName(containerName);
        containerParam1.setNumber(containerNumber);
        containerParam1.setType(type);
        containerParam1.setIndex(index);
        containerParam1.setCollapsible(collapsible);
        return containerParam1;
    }

    private FieldParam getFieldParam(EntityItem<?> dy, String fieldType) {
        FieldParam fieldParam = new FieldParam();
        fieldParam.setName(dy.getName().getLocaleValue());
        fieldParam.setNumber(dy.getKey());
        Map<String, Object> fieldRuleMap = MulPersonFileToolApplicationServiceImpl.getFieldRuleMap(dy);
        fieldParam.setFieldRuleMap(fieldRuleMap);
        fieldParam.setType(fieldType);
        fieldParam.setContainerNumber("fieldspermflex");
        return fieldParam;
    }

    public static Map<String, Object> getFieldRuleMap(EntityItem<?> entityItem) {
        return FieldRuleHandleUtils.getFieldRuleMap(entityItem);
    }

    private static String getBizUnitIdByParamNumber(String paramNumber) {
        String bizUnitId = "3=XYUCG7ZPFL";
        switch (paramNumber) {
            case "employeemobileview.2": {
                bizUnitId = "3=YOG=DM3I5D";
                break;
            }
            case "employeemobileview.1": {
                bizUnitId = "3=YD6JY+L7W5";
                break;
            }
            case "employeepcview.2": {
                bizUnitId = "3=YO0W2I5H4F";
                break;
            }
            case "employeepcview.1": {
                bizUnitId = "3=YD2WEBN0X4";
                break;
            }
            case "pcview.2": {
                bizUnitId = "3=YD/Y6KQVES";
                break;
            }
            case "pcview.1": {
                bizUnitId = "3=YCY7C8R=KE";
                break;
            }
        }
        return bizUnitId;
    }
}

