/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.ContainerParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FormPluginParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.IPersonFileToolApplicationService;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.IPersonMassMaintenanceApplicationService;
import kd.hdtc.hrdt.business.common.constants.PersonFileToolConstants;
import kd.hdtc.hrdt.business.common.model.MetadataBo;
import kd.hdtc.hrdt.business.common.utils.FieldRuleHandleUtils;
import kd.hdtc.hrdt.business.common.utils.MetaFieldTypeUtils;
import kd.hdtc.hrdt.business.common.utils.platform.HRDTMetadataUtils;
import kd.hdtc.hrdt.business.domain.ext.IEntityForbidEntityService;
import kd.hdtc.hrdt.business.domain.ext.IInfoGroupFieldEntityService;
import kd.hdtc.hrdt.business.domain.ext.IInfoGroupPageRegisterEntityService;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hdtc.hrdt.business.domain.ext.IMultiViewConfigEmpEntityService;
import kd.hdtc.hrdt.business.domain.ext.IMultiViewConfigEntityService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelRecordDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultBo;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultDataBo;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.IPersonFileToolDomainService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class PersonFileToolApplicationServiceImpl
implements IPersonFileToolApplicationService {
    private static final Log LOG = LogFactory.getLog(PersonFileToolApplicationServiceImpl.class);
    private final IInfoGroupPageRegisterEntityService iInfoGroupPageRegisterEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IInfoGroupPageRegisterEntityService.class);
    private final IMultiViewConfigEmpEntityService iMultiViewConfigEmpEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IMultiViewConfigEmpEntityService.class);
    private final IMultiViewConfigEntityService iMultiViewConfigEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IMultiViewConfigEntityService.class);
    private final IEntityForbidEntityService iEntityForbidEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IEntityForbidEntityService.class);
    private final IInfoGroupFieldEntityService iInfoGroupFieldEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IInfoGroupFieldEntityService.class);
    private IBizModelRecordDomainService bizModelRecordDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IBizModelRecordDomainService.class);
    private IPersonFileToolDomainService personFileToolDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IPersonFileToolDomainService.class);
    private final IMetadataDomainService metadataDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IMetadataDomainService.class);
    private final IPersonMassMaintenanceApplicationService iPersonMassMaintenanceApplicationService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IPersonMassMaintenanceApplicationService.class);
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);

    @Override
    public ToolResultBo effect(DynamicObject dynamicObject) {
        ToolResultBo toolResultBo = new ToolResultBo();
        try {
            toolResultBo.setBizModelId(dynamicObject.getLong("bizmodel.id"));
            toolResultBo.setAbilityId(1692182687508395008L);
            String entityNumber = dynamicObject.getString("bizmodel.mainentity.number");
            String entityName = dynamicObject.getString("bizmodel.mainentity.name");
            Map<String, List<String>> viewTypeAndMetaDataNumberMap = this.generateMetaData(dynamicObject, toolResultBo);
            boolean existPersonEntityConfig = this.personFileToolDomainService.isExistPersonEntityConfig(entityNumber);
            if (!existPersonEntityConfig) {
                DynamicObject personEntityConfigDyn = this.personFileToolDomainService.toPersonEntityConfigDyn(entityNumber, entityName);
                OperationResult savePersonEntityConfigResult = this.personFileToolDomainService.savePersonEntityConfig(new DynamicObject[]{personEntityConfigDyn});
                toolResultBo.addData("hrpi_personentityconf", savePersonEntityConfigResult != null ? savePersonEntityConfigResult.getSuccessPkIds() : new ArrayList());
            }
            DynamicObject infoGroupPageRegisterDyn = this.personFileToolDomainService.toInfoGroupPageRegisterDyn(dynamicObject, viewTypeAndMetaDataNumberMap);
            OperationResult infoGroupPageRegisterResult = this.personFileToolDomainService.saveInfoGroupPageRegister(infoGroupPageRegisterDyn, toolResultBo);
            String dialogPc = infoGroupPageRegisterDyn.getString("dialogpc");
            if (StringUtils.isNotEmpty((String)dialogPc)) {
                this.addRelateRight(infoGroupPageRegisterDyn, dynamicObject, toolResultBo, dialogPc);
            }
            List<Object> infoGroupFieldIdList = this.iInfoGroupFieldEntityService.getInfoGroupFieldIdListByGroupId(infoGroupPageRegisterDyn.getLong("id"));
            toolResultBo.addData("hspm_infogroupfield", infoGroupFieldIdList);
            ToolResultDataBo toolResultDataBo = new ToolResultDataBo();
            Object[] multiViewConfigs = this.getMultiViewConfigDyns(dynamicObject, infoGroupPageRegisterDyn.getLong("id"), toolResultDataBo);
            if (!ObjectUtils.isEmpty((Object[])multiViewConfigs)) {
                toolResultDataBo.setNumber(multiViewConfigs[0].getDataEntityType().getName());
                OperationResult saveMultiViewConfigResult = this.personFileToolDomainService.saveMultiViewConfigDyn((DynamicObject[])multiViewConfigs);
                if (saveMultiViewConfigResult.isSuccess()) {
                    toolResultDataBo.setIds(saveMultiViewConfigResult.getSuccessPkIds());
                    if (infoGroupPageRegisterResult != null && infoGroupPageRegisterResult.isSuccess() && CollectionUtils.isNotEmpty((Collection)infoGroupPageRegisterResult.getSuccessPkIds())) {
                        HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMInfoGroupService", (String)"saveInfoGroupField", (Object[])new Object[]{infoGroupPageRegisterResult.getSuccessPkIds().get(0)});
                    }
                    toolResultBo.addData(toolResultDataBo);
                }
            }
            if (dynamicObject.getBoolean("isbatchmenu")) {
                ToolResultBo toolResultBo1 = this.iPersonMassMaintenanceApplicationService.generateMassMaintenanceInfoByNumber(entityNumber, dynamicObject.getLong("bizmodel.id"), false);
                if (toolResultBo1.getEffectiveStatus().equals("2")) {
                    toolResultBo.addAllDyns(toolResultBo1.getDyns());
                    toolResultBo.addDatas(toolResultBo1.getDatas());
                } else {
                    throw new HRDBSBizException(toolResultBo1.getErrorMsg());
                }
            }
            toolResultBo.setEffectiveStatus("2");
        }
        catch (Exception e) {
            this.bizModelRecordDomainService.rollBackModelRecord(Collections.singletonList(toolResultBo));
            toolResultBo.setEffectiveStatus("0");
            toolResultBo.setErrorMsg(e.getMessage());
            LOG.error("effect error {} {}", (Object)e.getCause(), (Object)e.getMessage());
            return toolResultBo;
        }
        toolResultBo.addData("hrdt_personfiletool", Collections.singletonList(dynamicObject.getLong("id")));
        this.bizModelRecordDomainService.saveBizModelRecord(Collections.singletonList(toolResultBo));
        return toolResultBo;
    }

    private void addRelateRight(DynamicObject infoGroupPageRegisterDyn, DynamicObject dynamicObject, ToolResultBo toolResultBo, String dialogPc) {
        OperationResult operationResult;
        String dyViewPc = infoGroupPageRegisterDyn.getString("dyviewpc");
        String dyViewMobile = infoGroupPageRegisterDyn.getString("dyviewmobile");
        String dialogMobile = infoGroupPageRegisterDyn.getString("dialogmobile");
        String bizType = dynamicObject.getString("biztype");
        ArrayList<DynamicObject> permRelateEntityList = new ArrayList<DynamicObject>(4);
        if (HRStringUtils.isNotEmpty((String)dyViewPc)) {
            List<DynamicObject> dyViewPermRelate = this.personFileToolDomainService.toPermRelateEntityDynList(dyViewPc, PersonFileToolConstants.CARD_PERM_ID_LIST, Collections.singletonList(dialogPc), bizType);
            permRelateEntityList.addAll(dyViewPermRelate);
        }
        if (HRStringUtils.isNotEmpty((String)dyViewMobile) && !HRStringUtils.equals((String)dyViewMobile, (String)dialogMobile)) {
            List<DynamicObject> dyViewMobilePermRelate = this.personFileToolDomainService.toPermRelateEntityDynList(dyViewMobile, PersonFileToolConstants.CARD_PERM_ID_LIST, Collections.singletonList(dialogMobile), bizType);
            permRelateEntityList.addAll(dyViewMobilePermRelate);
        }
        toolResultBo.addData("hrcs_permrelat", (operationResult = this.personFileToolDomainService.savePermRelate(permRelateEntityList.toArray(new DynamicObject[0]))) != null ? operationResult.getSuccessPkIds() : new ArrayList());
        if ("1".equals(bizType)) {
            Object[] result;
            List<DynamicObject> forbidEntityDynList = this.personFileToolDomainService.toEntityForbidEntityDynList(Arrays.asList(dialogPc, dyViewPc), "1WXBPN7+OHJZ", "3");
            if (HRStringUtils.isNotEmpty((String)dyViewMobile)) {
                List<DynamicObject> forbidEntityDyn = this.personFileToolDomainService.toEntityForbidEntityDynList(Arrays.asList(dyViewMobile, dialogMobile), "1WXBPN7+OHJZ", "3");
                forbidEntityDynList.addAll(forbidEntityDyn);
            }
            if ((result = this.iEntityForbidEntityService.save(forbidEntityDynList.toArray(new DynamicObject[0]))) != null) {
                ArrayList ids = Lists.newArrayListWithExpectedSize((int)result.length);
                for (Object entityFory : result) {
                    if (!(entityFory instanceof DynamicObject)) continue;
                    ids.add(((DynamicObject)entityFory).getLong("id"));
                }
                toolResultBo.addData("hrcs_entityforbid", ids);
            }
        }
    }

    private DynamicObject[] getMultiViewConfigDyns(DynamicObject personFileToolDyn, Long infoGroupPageRegisterId, ToolResultDataBo toolResultDataBo) {
        DynamicObject infoGroupPageRegister = this.iInfoGroupPageRegisterEntityService.queryOriginalOneById(infoGroupPageRegisterId);
        List<DynamicObject> infoGroupFieldList = this.iInfoGroupFieldEntityService.getInfoGroupFieldListByGroupId(infoGroupPageRegisterId);
        String dialogPc = infoGroupPageRegister.getString("dialogpc");
        if (CollectionUtils.isNotEmpty(infoGroupFieldList)) {
            Object[] multiViewConfigs = this.getMultiViewConfigs(personFileToolDyn);
            if (!ObjectUtils.isEmpty((Object[])multiViewConfigs)) {
                long[] entityIds = ID.genLongIds((int)multiViewConfigs.length);
                ToolResultDataBo entryData = new ToolResultDataBo("groupentity", Arrays.stream(entityIds).boxed().collect(Collectors.toList()));
                for (int index = 0; index < multiViewConfigs.length; ++index) {
                    long entityId = entityIds[index];
                    Object multiViewConfig = multiViewConfigs[index];
                    DynamicObjectCollection groupEntityCollection = multiViewConfig.getDynamicObjectCollection("groupentity");
                    DynamicObject dynamicObject = groupEntityCollection.addNew();
                    dynamicObject.set("id", (Object)entityId);
                    dynamicObject.set("groupid", (Object)infoGroupPageRegisterId);
                    dynamicObject.set("groupname", (Object)infoGroupPageRegister.getString("name"));
                    dynamicObject.set("relation", (Object)infoGroupPageRegisterId);
                    dynamicObject.set("allisedit", (Object)Boolean.FALSE);
                    dynamicObject.set("allisrequired", (Object)Boolean.FALSE);
                    dynamicObject.set("allisaudit", (Object)Boolean.FALSE);
                    dynamicObject.set("isallowadd", (Object)Boolean.FALSE);
                    dynamicObject.set("configarea", (Object)personFileToolDyn.getString("region"));
                    DynamicObjectCollection fieldEntityCollection = dynamicObject.getDynamicObjectCollection("fieldentity");
                    int seq = 1;
                    long[] subEntityIds = ID.genLongIds((int)infoGroupFieldList.size());
                    ToolResultDataBo subEntryData = new ToolResultDataBo("groupentity", Arrays.stream(entityIds).boxed().collect(Collectors.toList()));
                    entryData.addSubData(subEntryData);
                    int idx = 0;
                    for (DynamicObject field : infoGroupFieldList) {
                        if ("description".equals(field.getString("number")) || StringUtils.isEmpty((String)dialogPc) && "18".equals(field.getString("type"))) continue;
                        long subEntityId = subEntityIds[idx++];
                        DynamicObject fieldEntity = fieldEntityCollection.addNew();
                        fieldEntity.set("id", (Object)subEntityId);
                        fieldEntity.set("field", (Object)field);
                        fieldEntity.set("seq", (Object)seq++);
                        fieldEntity.set("isedit", (Object)field.getBoolean("isedit"));
                        fieldEntity.set("isrequired", (Object)field.getBoolean("isrequired"));
                        fieldEntity.set("isaudit", (Object)Boolean.FALSE);
                        if ("18".equals(field.getString("type"))) {
                            fieldEntity.set("fieldtype", (Object)"3");
                            continue;
                        }
                        if ("12".equals(field.getString("type"))) {
                            fieldEntity.set("fieldtype", (Object)"2");
                            continue;
                        }
                        fieldEntity.set("fieldtype", (Object)"1");
                    }
                }
                toolResultDataBo.addSubData(entryData);
            }
            return multiViewConfigs;
        }
        return new DynamicObject[0];
    }

    private DynamicObject[] getMultiViewConfigs(DynamicObject personFileToolDyn) {
        String bizType = personFileToolDyn.getString("biztype");
        String fileName = "1".equals(bizType) ? "pcfileviews" : "personfileviews";
        DynamicObjectCollection dynamicObjectCollection = personFileToolDyn.getDynamicObjectCollection(fileName);
        ArrayList multiViewConfigIdList = Lists.newArrayListWithExpectedSize((int)dynamicObjectCollection.size());
        if (CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection)) {
            dynamicObjectCollection.forEach(dy -> multiViewConfigIdList.add(dy.getLong("fbasedataid_id")));
        }
        if ("1".equals(bizType)) {
            return this.iMultiViewConfigEmpEntityService.queryMultiViewConfigEmpsByIdList(multiViewConfigIdList);
        }
        return this.iMultiViewConfigEntityService.queryMultiViewConfigsByIdList(multiViewConfigIdList);
    }

    private Map<String, List<String>> generateMetaData(DynamicObject dataEntity, ToolResultBo toolResultBo) {
        String entityNumber = dataEntity.getString("bizmodel.mainentity.number");
        String entityName = dataEntity.getString("bizmodel.name");
        List<String> pageFieldNameList = this.getPageFieldNameList(dataEntity);
        HashSet<String> sourceNumbers = new HashSet<String>();
        sourceNumbers.add(entityNumber);
        long fileTypeId = dataEntity.getLong("filetype.id");
        Map<String, Map<String, String>> sourceNumberMetaNumberMap = this.personFileToolDomainService.generateNumbers(sourceNumbers, fileTypeId);
        Map<String, String> metaDataNumberMap = sourceNumberMetaNumberMap.get(entityNumber);
        LinkedHashMap viewTypeAndMetaDataNumberMap = Maps.newLinkedHashMapWithExpectedSize((int)3);
        pageFieldNameList.forEach(pageView -> {
            String paramNumber;
            Map<String, String> numberValueMap;
            String viewValue = dataEntity.getString(pageView);
            if (StringUtils.isNotEmpty((String)viewValue) && ("1".equals(viewValue) || "2".equals(viewValue)) && CollectionUtils.isNotEmpty(numberValueMap = this.personFileToolDomainService.getPersonFilePages(paramNumber = pageView + "." + viewValue))) {
                Map<String, String> pluginMap = this.personFileToolDomainService.getPersonFileFormPlugin(numberValueMap.keySet());
                for (Map.Entry<String, String> numberValue : numberValueMap.entrySet()) {
                    String metaDataNumber = (String)metaDataNumberMap.get(PersonFileToolConstants.BASE_CONFIG_KEY_MEAT_DATA_NUMBER_KEY_MAP.getOrDefault(numberValue.getKey(), ""));
                    String plugin = CollectionUtils.isEmpty(pluginMap) ? "" : pluginMap.get(numberValue.getKey() + ".plugin");
                    String filePlugin = CollectionUtils.isEmpty(pluginMap) ? "" : pluginMap.get(numberValue.getKey() + ".plugin" + ".file");
                    MetadataGenParam metadataGenParam = this.getMetadataGenParam(metaDataNumber, entityName, numberValue.getValue(), paramNumber, numberValue.getKey(), entityNumber, plugin, filePlugin);
                    MetadataGenResult metadataGenResult = this.dynamicMetadataApplicationService.generate(metadataGenParam);
                    List metaDataNumberList = viewTypeAndMetaDataNumberMap.getOrDefault(paramNumber, new ArrayList());
                    if (StringUtils.isNotEmpty((String)metadataGenResult.getEntityNumber())) {
                        metaDataNumberList.add(metadataGenResult.getEntityNumber());
                        toolResultBo.addDyn(metadataGenResult.getEntityNumber());
                    }
                    if (!CollectionUtils.isNotEmpty((Collection)metaDataNumberList)) continue;
                    viewTypeAndMetaDataNumberMap.put(paramNumber, metaDataNumberList);
                }
            }
        });
        return viewTypeAndMetaDataNumberMap;
    }

    private List<String> getPageFieldNameList(DynamicObject dataEntity) {
        String bizType = dataEntity.getString("biztype");
        ArrayList pageFieldNameList = Lists.newArrayListWithExpectedSize((int)3);
        if ("1".equals(bizType)) {
            pageFieldNameList.add("employeepcview");
            String mobileView = dataEntity.getString("employeemobileview");
            if (!"0".equals(mobileView)) {
                pageFieldNameList.add("employeemobileview");
            }
        } else {
            pageFieldNameList.add("pcview");
        }
        return pageFieldNameList;
    }

    private MetadataGenParam getMetadataGenParam(String metaDataNumber, String metaDataName, String parentFilePage, String paramNumber, String baseConfigKey, String entityNumber, String pluginParam, String filePluginParam) {
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        BaseParam baseParam = new BaseParam();
        metadataGenParam.setBaseParam(baseParam);
        baseParam.setMetadataName(metaDataName);
        baseParam.setMetadataNumber(metaDataNumber);
        Map<String, Object> parentNode = HRDTMetadataUtils.getDesignerMetadata(parentFilePage);
        if (CollectionUtils.isNotEmpty(parentNode)) {
            Object parentModelType;
            Object parentId = parentNode.get("id");
            if (parentId != null) {
                baseParam.setParentId(String.valueOf(parentId));
            }
            if ((parentModelType = parentNode.get("modelType")) != null) {
                baseParam.setModelType(String.valueOf(parentModelType));
            }
        }
        baseParam.setBizUnitId(PersonFileToolApplicationServiceImpl.getBizUnitIdByParamNumber(paramNumber));
        baseParam.setAppId("hspm");
        baseParam.setType(MetadataGenTypeEnum.NORMAL_METADATA);
        List formMetadata = MetadataUtils.getFormMetadata((String)entityNumber);
        List<ControlAp> fileAps = null;
        if (CollectionUtils.isNotEmpty((Collection)formMetadata)) {
            fileAps = formMetadata.stream().filter(form -> form instanceof AttachmentPanelAp).collect(Collectors.toList());
        }
        MetadataBo metadataBo = this.metadataDomainService.getMetaInfoByNumber(entityNumber, true, false);
        if (baseConfigKey.equals("hrdt_basecard_dyview") || baseConfigKey.equals("hrdt_pagebase_dyview")) {
            List<EntityItem<?>> metadataBoItems = metadataBo.getItems();
            metadataBoItems.forEach(dy -> {
                if (!dy.isInherit()) {
                    String fieldType = MetaFieldTypeUtils.getFieldType(dy);
                    FieldParam fieldParam = this.getFieldParam((EntityItem<?>)dy, fieldType);
                    metadataGenParam.getFieldParamList().add(fieldParam);
                }
            });
            if (fileAps != null && fileAps.size() > 0) {
                fileAps.forEach(ap -> {
                    FieldParam fieldParam = this.getAttachmentFieldParam((ControlAp<?>)ap);
                    metadataGenParam.getFieldParamList().add(fieldParam);
                });
            }
        }
        if (baseConfigKey.equals("hrdt_basecard_dyview") || baseConfigKey.equals("hrdt_basecard_pdyview") || baseConfigKey.equals("hrdt_basecard_mdv")) {
            String containerNumber = "contentap" + entityNumber.substring(entityNumber.lastIndexOf(95) + 1);
            ContainerParam containerParam1 = this.getContainerParam(containerNumber, PersonFileToolConstants.CONTENT, "FlexPanelAp", 3, false);
            metadataGenParam.getContainerParamList().add(containerParam1);
        }
        if (StringUtils.isNotEmpty((String)filePluginParam) && CollectionUtils.isNotEmpty(fileAps)) {
            pluginParam = filePluginParam;
        }
        if (StringUtils.isNotEmpty((String)pluginParam)) {
            String[] plugins = pluginParam.split(";");
            ArrayList formPluginParamList = Lists.newArrayListWithExpectedSize((int)plugins.length);
            for (String plugin : plugins) {
                FormPluginParam formPluginParam = new FormPluginParam();
                formPluginParam.setClassName(plugin);
                formPluginParam.setDescription(plugin);
                formPluginParam.setEnable(Boolean.TRUE);
                formPluginParamList.add(formPluginParam);
            }
            metadataGenParam.setFormPluginParamList((List)formPluginParamList);
        }
        return metadataGenParam;
    }

    private FieldParam getAttachmentFieldParam(ControlAp<?> ap) {
        FieldParam fieldParam = new FieldParam();
        fieldParam.setName(ap.getName().getLocaleValue());
        fieldParam.setNumber(ap.getKey());
        HashMap fieldRuleMap = Maps.newHashMapWithExpectedSize((int)1);
        fieldRuleMap.put("MustInput", 0);
        fieldParam.setFieldRuleMap((Map)fieldRuleMap);
        fieldParam.setType(AttachmentField.class.getSimpleName());
        fieldParam.setContainerNumber("fieldspermflex");
        return fieldParam;
    }

    private ContainerParam getContainerParam(String containerNumber, String containerName, String type, int index, boolean collapsible) {
        ContainerParam containerParam1 = new ContainerParam();
        containerParam1.setName(containerName);
        containerParam1.setNumber(containerNumber);
        containerParam1.setType(type);
        containerParam1.setIndex(index);
        containerParam1.setCollapsible(collapsible);
        return containerParam1;
    }

    private FieldParam getFieldParam(EntityItem<?> dy, String fieldType) {
        FieldParam fieldParam = new FieldParam();
        fieldParam.setName(dy.getName().getLocaleValue());
        fieldParam.setNumber(dy.getKey());
        Map<String, Object> fieldRuleMap = PersonFileToolApplicationServiceImpl.getFieldRuleMap(dy);
        fieldParam.setFieldRuleMap(fieldRuleMap);
        fieldParam.setType(fieldType);
        fieldParam.setContainerNumber("fieldspermflex");
        return fieldParam;
    }

    public static Map<String, Object> getFieldRuleMap(EntityItem<?> entityItem) {
        return FieldRuleHandleUtils.getFieldRuleMap(entityItem);
    }

    private static String getBizUnitIdByParamNumber(String paramNumber) {
        String bizUnitId = "3=XYUCG7ZPFL";
        switch (paramNumber) {
            case "employeemobileview.2": {
                bizUnitId = "3=YOG=DM3I5D";
                break;
            }
            case "employeemobileview.1": {
                bizUnitId = "3=YD6JY+L7W5";
                break;
            }
            case "employeepcview.2": {
                bizUnitId = "3=YO0W2I5H4F";
                break;
            }
            case "employeepcview.1": {
                bizUnitId = "3=YD2WEBN0X4";
                break;
            }
            case "pcview.2": {
                bizUnitId = "3=YD/Y6KQVES";
                break;
            }
            case "pcview.1": {
                bizUnitId = "3=YCY7C8R=KE";
                break;
            }
        }
        return bizUnitId;
    }
}

