/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.designer.query.QueryDynSourcePlugIn;
import kd.bos.designer.query.QueryMetadataHelper;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.entity.IMetadataEntityService;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.IPersonMassMaintenanceApplicationService;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.handler.PersonMassMaintenanceFormHandler;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.handler.PersonMassMaintenancePresetHandler;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.handler.PersonMassMaintenanceQueryHandler;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person.handler.PersonMassMaintenanceQueryListHandler;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.impl.AbstractBaseEntityToolServiceImpl;
import kd.hdtc.hrdt.business.common.constants.PersonFileToolConstants;
import kd.hdtc.hrdt.business.common.model.MetadataBo;
import kd.hdtc.hrdt.business.common.utils.SplitNumberUtil;
import kd.hdtc.hrdt.business.common.utils.platform.HRDTMetadataUtils;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hdtc.hrdt.business.domain.ext.IPermRelateEntityService;
import kd.hdtc.hrdt.business.domain.ext.IPersonEntityConfigEntityService;
import kd.hdtc.hrdt.business.domain.ext.IPersonInfoClassifyCnfEntityService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelRecordDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultBo;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.impl.MassMaintenanceNumberGenerateDomainServiceImpl;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.common.util.HRStringUtils;

public class PersonMassMaintenanceApplicationServiceImpl
extends AbstractBaseEntityToolServiceImpl
implements IPersonMassMaintenanceApplicationService {
    private static final Log LOG = LogFactory.getLog(PersonMassMaintenanceApplicationServiceImpl.class);
    private final IMetadataEntityService metadataEntityService = (IMetadataEntityService)ServiceFactory.getService(IMetadataEntityService.class);
    private IMetadataDomainService metadataDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IMetadataDomainService.class);
    private final IPersonEntityConfigEntityService iPersonEntityConfigEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IPersonEntityConfigEntityService.class);
    private final IPermRelateEntityService permRelateEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IPermRelateEntityService.class);
    PersonMassMaintenanceFormHandler personMassMaintenanceFormHandler = null;
    PersonMassMaintenanceQueryHandler personMassMaintenanceQueryHandler = null;
    PersonMassMaintenanceQueryListHandler personMassMaintenanceQueryListHandler = null;
    PersonMassMaintenancePresetHandler personMassMaintenanceRelatePanelSetHandler = null;
    private final IDynamicMetadataApplicationService dynamicMetadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);
    private IBizModelRecordDomainService bizModelRecordDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IBizModelRecordDomainService.class);
    private final IPersonInfoClassifyCnfEntityService iPersonInfoClassifyCnfEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IPersonInfoClassifyCnfEntityService.class);

    @Override
    public ToolResultBo generateMassMaintenanceInfoByNumber(String number, Long bizModelId, boolean personal) {
        ToolResultBo toolResultBo = new ToolResultBo();
        try {
            boolean condition;
            if (!MetadataUtils.isExist((String)number)) {
                LOG.error("can not find this entity {}.", (Object)number);
                throw new HRDBSBizException("can not find this entity");
            }
            MetadataBo metadataBo = this.metadataDomainService.getMetaInfoByNumber(number, true, false);
            if (metadataBo == null) {
                LOG.error("can not find this metadata {}.", (Object)number);
                throw new HRDBSBizException("can not find this metadata");
            }
            boolean exist = this.existPersonInfoClassifyCnf(number);
            if (exist) {
                LOG.error("person info classify has exist {}.", (Object)number);
                throw new HRDBSBizException(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u6a21\u578b\u5b9e\u4f53\u5728\u3010\u4eba\u5458\u4fe1\u606f\u3011-\u3010\u4fe1\u606f\u6279\u91cf\u7ef4\u62a4\u3011\u4e2d\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"PersonMassMaintenanceApplicationServiceImpl_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
            }
            toolResultBo.setBizModelId(bizModelId);
            toolResultBo.setAbilityId(1692184033712205824L);
            ArrayList<String> formIdList = new ArrayList<String>();
            MassMaintenanceNumberGenerateDomainServiceImpl numberGenerateDomainService = new MassMaintenanceNumberGenerateDomainServiceImpl();
            Map<String, Map<String, String>> numberMap = numberGenerateDomainService.generateMulBySourceNumber((Set<String>)ImmutableSet.of((Object)metadataBo.getNumber()));
            Map<String, String> currentNumberMap = numberMap.get(metadataBo.getNumber());
            String queryNumber = currentNumberMap.get("query");
            String listNumber = currentNumberMap.get("list");
            String tabNumber = currentNumberMap.get("tab");
            boolean bl = condition = StringUtils.isBlank((CharSequence)queryNumber) || StringUtils.isBlank((CharSequence)listNumber) || StringUtils.isBlank((CharSequence)tabNumber);
            if (condition) {
                LOG.error("generateMulBySourceNumber error sourceNumber={},queryNumber={},listNumber={},tabNumber={}", new Object[]{metadataBo.getNumber(), queryNumber, listNumber, tabNumber});
                throw new HRDBSBizException(ResManager.loadKDString((String)"\u8be5\u4e1a\u52a1\u6a21\u578b\u5b9e\u4f53\u751f\u6210\u7f16\u7801\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5", (String)"PersonMassMaintenanceApplicationServiceImpl_1", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
            }
            this.personMassMaintenanceFormHandler = new PersonMassMaintenanceFormHandler(metadataBo.getNumber(), metadataBo.getName().getLocaleValue());
            String formId = this.generateMassMaintenanceForm(metadataBo);
            formIdList.add(formId);
            String formNumber = this.personMassMaintenanceFormHandler.getMetaDataNumber();
            toolResultBo.addDyn(formNumber, false);
            if (!this.iPersonEntityConfigEntityService.isExists(new QFilter("entity", "=", (Object)metadataBo.getNumber()))) {
                Long configId = this.savePersonEntityConfig(metadataBo);
                toolResultBo.addData("hrpi_personentityconf", Collections.singletonList(configId));
            }
            this.personMassMaintenanceQueryHandler = new PersonMassMaintenanceQueryHandler(formNumber, queryNumber);
            String queryId = this.generateMassMaintenanceQuery();
            formIdList.add(queryId);
            toolResultBo.addDyn(this.personMassMaintenanceQueryHandler.getMetaDataNumber());
            this.personMassMaintenanceQueryListHandler = new PersonMassMaintenanceQueryListHandler(listNumber, metadataBo.getName().getLocaleValue(), queryId);
            String queryListId = this.generateMassMaintenanceQueryList(this.personMassMaintenanceFormHandler.getMetaDataNumber());
            formIdList.add(queryListId);
            toolResultBo.addDyn(this.personMassMaintenanceQueryListHandler.getMetaDataNumber());
            this.personMassMaintenanceRelatePanelSetHandler = new PersonMassMaintenancePresetHandler(tabNumber, metadataBo.getName().getLocaleValue());
            MetadataGenParam relatePanelSetMetadataGenParam = this.personMassMaintenanceRelatePanelSetHandler.getMetadataGenParam();
            this.dynamicMetadataApplicationService.generate(relatePanelSetMetadataGenParam);
            toolResultBo.addDyn(this.personMassMaintenanceRelatePanelSetHandler.getMetaDataNumber());
            Object[] relatePanelSet = this.personMassMaintenanceRelatePanelSetHandler.saveRelatePanelSet(this.personMassMaintenanceRelatePanelSetHandler.getMetaDataNumber(), this.personMassMaintenanceFormHandler.getMetaDataNumber());
            if (!ObjectUtils.isEmpty((Object[])relatePanelSet)) {
                toolResultBo.addData("hbss_relatepanelset", Arrays.stream(relatePanelSet).map(dy -> dy.getLong("id")).collect(Collectors.toList()));
            }
            DynamicObject massMaPreset = (DynamicObject)this.personMassMaintenanceRelatePanelSetHandler.saveInfoClass(this.personMassMaintenanceFormHandler.getMetaDataNumber(), this.personMassMaintenanceQueryHandler.getMetaDataNumber(), this.personMassMaintenanceQueryListHandler.getMetaDataNumber(), this.personMassMaintenanceRelatePanelSetHandler.getMetaDataNumber(), this.personMassMaintenanceFormHandler.dataModelNumber, this.personMassMaintenanceQueryListHandler.getMetaDataName());
            toolResultBo.addData("hspm_infoclassifycnf", Collections.singletonList(massMaPreset.getLong("id")));
            this.savePermRelate(this.personMassMaintenanceQueryHandler.getMetaDataNumber(), this.personMassMaintenanceFormHandler.getMetaDataNumber(), toolResultBo);
            MetadataDao.clearSubRuntimeMeta(formIdList);
        }
        catch (Exception e) {
            this.bizModelRecordDomainService.rollBackModelRecord(Collections.singletonList(toolResultBo));
            toolResultBo.setEffectiveStatus("0");
            toolResultBo.setErrorMsg(e.getMessage());
            LOG.error("generateMassMaintenanceInfoByNumber error toolResultBo BizModelId:{} AbilityId:{} Dyns:{} Datas:{}", new Object[]{toolResultBo.getBizModelId(), toolResultBo.getAbilityId(), toolResultBo.getDyns(), toolResultBo.getDatas()});
            LOG.error("generateMassMaintenanceInfoByNumber error {} {}", (Object)e.getCause(), (Object)e.getMessage());
            return toolResultBo;
        }
        return toolResultBo;
    }

    private boolean existPersonInfoClassifyCnf(String key) {
        DynamicObjectCollection dynamicObjectCollection = this.iPersonInfoClassifyCnfEntityService.queryOriginalDataBySourceKey(Lists.newArrayList((Object[])new String[]{key}));
        return CollectionUtils.isNotEmpty((Collection)dynamicObjectCollection);
    }

    private void savePermRelate(String queryMetaDataNumber, String metaDataNumber, ToolResultBo toolResultBo) {
        boolean existPermRelate = this.permRelateEntityService.isExistPermRelate(queryMetaDataNumber);
        if (existPermRelate) {
            return;
        }
        if (!HRStringUtils.equals((String)queryMetaDataNumber, (String)metaDataNumber)) {
            List<DynamicObject> permRelateEntityList = this.permRelateEntityService.toPermRelateEntityDynList(queryMetaDataNumber, PersonFileToolConstants.QUERY_PERM_ID_LIST, Collections.singletonList(metaDataNumber), "0");
            OperationResult operationResult = this.permRelateEntityService.savePermRelate(permRelateEntityList.toArray(new DynamicObject[0]));
            toolResultBo.addData("hrcs_permrelat", operationResult != null ? operationResult.getSuccessPkIds() : new ArrayList());
        }
    }

    private String generateMassMaintenanceForm(MetadataBo metadataBo) {
        Map<String, Object> nodes = HRDTMetadataUtils.createBlankModel(this.personMassMaintenanceFormHandler.buildTplInfo());
        Map<String, Object> sourceMetaData = HRDTMetadataUtils.getDesignerMetadata(metadataBo.getNumber());
        this.addDiffInfo(sourceMetaData, nodes);
        boolean haveAttachment = this.addAttachmentPanelAp(sourceMetaData, nodes);
        this.addFormPlugins(nodes, haveAttachment);
        this.addOpPlugins(nodes);
        this.personMassMaintenanceFormHandler.setMetaData(nodes);
        HRDTMetadataUtils.save(nodes);
        String formId = (String)nodes.get("id");
        this.metadataEntityService.saveAppUnit(formId, this.personMassMaintenanceFormHandler.bizUnitId, this.personMassMaintenanceFormHandler.getCurrentAppId());
        return formId;
    }

    private String generateMassMaintenanceQuery() {
        FormShowParameter parameter = this.personMassMaintenanceQueryHandler.buildTplInfo();
        IFormView view = parameter.createView();
        view.addService(IPageCache.class, (Object)new PageCache(""));
        this.setFormConfig(parameter);
        view.initialize(parameter);
        IDataModel dataModel = view.getModel();
        DynamicObject dyn = this.personMassMaintenanceQueryHandler.buildQueryDyn();
        dataModel.createNewData((Object)dyn);
        QueryMetadataHelper queryMetadataHelper = new QueryMetadataHelper();
        QueryDynSourcePlugIn plugin = new QueryDynSourcePlugIn();
        plugin.setView(view);
        Map<String, List<Map<String, Object>>> relationConditionCache = this.personMassMaintenanceQueryHandler.buildPersonMassMaintenanceQueryRelationConditionCache();
        view.getPageCache().put("QueryDynSourcePlugInCache", SerializationUtils.toJsonString(relationConditionCache));
        Map<String, Object> ops = this.personMassMaintenanceQueryHandler.buildOps(this.personMassMaintenanceFormHandler.getMetaData());
        view.getPageCache().put("operations_control_val", SerializationUtils.toJsonString((Object)ops.get("operations_control_val")));
        view.getPageCache().put("permission_control_val", SerializationUtils.toJsonString((Object)ops.get("permission_control_val")));
        dataModel.setValue("group", (Object)this.personMassMaintenanceQueryHandler.getMassMaintenanceQueryUnit());
        String formId = queryMetadataHelper.saveQueryMetadata(plugin, dataModel);
        return formId;
    }

    private Long savePersonEntityConfig(MetadataBo metadataBo) {
        DynamicObject personEntityConfig = this.iPersonEntityConfigEntityService.generateEmptyDynamicObject();
        Long configId = ID.genLongId();
        String number = SplitNumberUtil.getSplitNumber(metadataBo.getNumber(), 20);
        personEntityConfig.set("id", (Object)configId);
        personEntityConfig.set("name", (Object)metadataBo.getNumber());
        personEntityConfig.set("number", (Object)number);
        personEntityConfig.set("classify", (Object)"perattached");
        personEntityConfig.set("historytype", (Object)this.getHistoryType(metadataBo.getNumber()));
        personEntityConfig.set("entity", (Object)metadataBo.getNumber());
        this.iPersonEntityConfigEntityService.save(personEntityConfig);
        return configId;
    }

    private String generateMassMaintenanceQueryList(String number) {
        Map<String, Object> param = this.personMassMaintenanceQueryListHandler.buildTplInfo();
        Map<String, Object> nodes = HRDTMetadataUtils.createBlankModel(param);
        DesignMetadataParser designMetadataParser = new DesignMetadataParser(nodes);
        List info = designMetadataParser.getFormMetadata();
        List resultNodeList = info.stream().filter(node -> "QueryListFormAp".equals(node.get("_Type_"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(resultNodeList)) {
            List<Map<String, Object>> plugins = this.personMassMaintenanceQueryListHandler.buildPlugins();
            Map baseInfo = (Map)resultNodeList.get(0);
            baseInfo.put("Plugins", plugins);
        }
        Map<String, Object> sourceMetaData = HRDTMetadataUtils.getDesignerMetadata(this.personMassMaintenanceQueryListHandler.getCopyQueryListNumber());
        DesignMetadataParser sourceDataDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        List formNodeList = sourceDataDesignMetadataParser.getFormMetadata();
        List addNodeList = formNodeList.stream().filter(node -> !"QueryListFormAp".equals(node.get("_Type_"))).collect(Collectors.toList());
        resultNodeList.addAll(addNodeList);
        Map formData = Optional.ofNullable(nodes).map(it -> (Map)it.get("formmeta")).get();
        List<Map<String, Object>> appendColumns = this.personMassMaintenanceQueryListHandler.buildNewDataColumns(number);
        if (CollectionUtils.isNotEmpty(appendColumns)) {
            resultNodeList.addAll(appendColumns);
        }
        formData.put("Items", resultNodeList);
        HRDTMetadataUtils.save(nodes);
        String formId = (String)nodes.get("id");
        this.metadataEntityService.saveAppUnit(formId, this.personMassMaintenanceQueryListHandler.bizUnitId, this.personMassMaintenanceQueryListHandler.getCurrentAppId());
        return formId;
    }

    private void setFormConfig(FormShowParameter parameter) {
        FormConfig config = FormMetadataCache.getFormConfig((String)parameter.getFormId());
        parameter.setFormConfig(config);
    }

    private void addDiffInfo(Map<String, Object> sourceMetaData, Map<String, Object> nodes) {
        DesignMetadataParser sourceDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        DesignMetadataParser newDesignMetadataParser = new DesignMetadataParser(nodes);
        Set<String> diffKeys = this.getDiffKeys(sourceDesignMetadataParser.getEntityMetadata(), newDesignMetadataParser.getEntityMetadata());
        Optional.ofNullable(nodes).map(it -> (Map)it.get("entitymeta")).map(it -> ((List)it.get("Items")).addAll(this.getDiffCommonData(sourceDesignMetadataParser.getEntityMetadata(), diffKeys, result -> {
            if (CollectionUtils.isNotEmpty((Collection)result)) {
                result.stream().forEach(metadata -> {
                    String key = String.valueOf(metadata.get("Key"));
                    if ("bsed".equals(key)) {
                        ImmutableMap defValueDesign = ImmutableMap.builder().put((Object)"_Type_", (Object)"DefValueDesign").put((Object)"FuncParameter", (Object)"#CurrentDate#").put((Object)"FuncType", (Object)"getToday").build();
                        metadata.put("DefValueDesign", defValueDesign);
                    }
                });
            }
        })));
        this.changeTableName(newDesignMetadataParser.getEntityMetadata(), this.getTableName(sourceDesignMetadataParser.getEntityMetadata()));
        List<Map<String, Object>> formMetaDataList = this.getDiffCommonData(sourceDesignMetadataParser.getFormMetadata(), diffKeys, result -> {
            if (CollectionUtils.isNotEmpty((Collection)result)) {
                result.stream().forEach(formMetadata -> {
                    Object inherit = formMetadata.get("Inherit");
                    if (inherit != null && ((Boolean)inherit).booleanValue()) {
                        formMetadata.put("ParentId", this.personMassMaintenanceFormHandler.getFsHideFormApId());
                    } else {
                        formMetadata.put("ParentId", this.personMassMaintenanceFormHandler.getFsFormApId());
                    }
                });
            }
        });
        List formNodeList = Optional.ofNullable(nodes).map(it -> (Map)it.get("formmeta")).map(it -> (List)it.get("Items")).get();
        formNodeList.addAll(formMetaDataList);
        List entityNodeList = Optional.ofNullable(nodes).map(it -> (Map)it.get("entitytree")).map(it -> (List)it.get("Items")).get();
        entityNodeList.addAll(this.getDiffCommonData(sourceDesignMetadataParser.getEntityTreeMetadata(), diffKeys, null));
    }

    private boolean addAttachmentPanelAp(Map<String, Object> sourceMetaData, Map<String, Object> nodes) {
        boolean haveAttachment = false;
        DesignMetadataParser sourceDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        List sourceFormData = sourceDesignMetadataParser.getFormMetadata();
        List attachments = sourceFormData.stream().filter(info -> String.valueOf(info.get("_Type_")).equals("AttachmentPanelAp")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(attachments)) {
            attachments.stream().forEach(formMetadata -> {
                formMetadata.put("ParentId", this.personMassMaintenanceFormHandler.getFormApId());
                formMetadata.put("Width", "100%");
                formMetadata.put("EntityId", sourceMetaData.get("id"));
                formMetadata.put("BizBasedata", Boolean.FALSE);
            });
            List formNodeList = Optional.ofNullable(nodes).map(it -> (Map)it.get("formmeta")).map(it -> (List)it.get("Items")).get();
            formNodeList.addAll(attachments);
            haveAttachment = true;
        }
        return haveAttachment;
    }

    private void addFormPlugins(Map<String, Object> nodes, boolean haveAttachment) {
        DesignMetadataParser designMetadataParser = new DesignMetadataParser(nodes);
        List formMeta = designMetadataParser.getFormMetadata();
        formMeta.forEach(node -> {
            if ("BasedataFormAp".equals(node.get("_Type_"))) {
                List<Map<String, Object>> plugins = this.personMassMaintenanceFormHandler.buildPlugins(haveAttachment);
                node.put("Plugins", plugins);
            }
        });
    }

    private void addOpPlugins(Map<String, Object> nodes) {
        DesignMetadataParser designMetadataParser = new DesignMetadataParser(nodes);
        List formMeta = designMetadataParser.getEntityMetadata();
        formMeta.forEach(node -> {
            List operations;
            if ("BaseEntity".equals(node.get("_Type_")) && CollectionUtils.isNotEmpty((Collection)(operations = (List)Optional.ofNullable(node.get("Operations")).get()))) {
                operations.forEach(operation -> {
                    String opKey = String.valueOf(operation.get("Key"));
                    if ("save".equals(opKey) || "update".equals(opKey) || "delete".equals(opKey) || "saveimport".equals(opKey)) {
                        List plugins = (List)Optional.ofNullable(operation.get("Plugins")).orElseGet(() -> new ArrayList());
                        List<Map<String, Object>> opPlugins = this.personMassMaintenanceFormHandler.buildSaveOpPlugins();
                        plugins.addAll(opPlugins);
                        operation.put("Plugins", plugins);
                    }
                });
            }
        });
    }

    private Set<String> getDiffKeys(List<Map<String, Object>> sourceEntityData, List<Map<String, Object>> newEntityData) {
        if (CollectionUtils.isEmpty(sourceEntityData)) {
            return null;
        }
        Set<String> sourceKeys = sourceEntityData.stream().filter(info -> !String.valueOf(info.get("_Type_")).equals("BaseEntity")).map(info -> String.valueOf(info.get("Key"))).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(newEntityData)) {
            return sourceKeys;
        }
        Set newKeys = newEntityData.stream().map(info -> String.valueOf(info.get("Key"))).collect(Collectors.toSet());
        HashSet<String> diffKeys = new HashSet<String>(sourceEntityData.size());
        for (String sourceKey : sourceKeys) {
            if (newKeys.contains(sourceKey)) continue;
            diffKeys.add(sourceKey);
        }
        return diffKeys;
    }

    private void changeTableName(List<Map<String, Object>> sourceEntityData, String tableName) {
        Optional.ofNullable(this.getBaseEntityInfo(sourceEntityData)).ifPresent(data -> data.put("TableName", tableName));
    }

    private Map<String, Object> getBaseEntityInfo(List<Map<String, Object>> sourceEntityData) {
        if (CollectionUtils.isEmpty(sourceEntityData)) {
            return null;
        }
        for (Map<String, Object> data : sourceEntityData) {
            if (!String.valueOf(data.get("_Type_")).equals("BaseEntity")) continue;
            return data;
        }
        return null;
    }

    private String getTableName(List<Map<String, Object>> sourceEntityData) {
        Map<String, Object> entityInfo = this.getBaseEntityInfo(sourceEntityData);
        Object tableName = Optional.ofNullable(entityInfo).map(info -> info.get("TableName")).get();
        return tableName == null ? "" : String.valueOf(tableName);
    }

    private List<Map<String, Object>> getDiffCommonData(List<Map<String, Object>> sourceFormData, Set<String> diffKeys, Consumer<List<Map<String, Object>>> consumer) {
        if (CollectionUtils.isEmpty(diffKeys)) {
            return null;
        }
        Map<String, Map> sourceKeyMap = sourceFormData.stream().collect(Collectors.toMap(info -> String.valueOf(info.get("Key")), v1 -> v1, (v1, v2) -> v2));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(diffKeys.size());
        for (String diffKey : diffKeys) {
            Map info2 = sourceKeyMap.get(diffKey);
            if (info2 == null) continue;
            result.add(info2);
        }
        if (consumer != null) {
            consumer.accept(result);
        }
        return result;
    }

    private String getHistoryType(String entityNumber) {
        String type = HisModelController.getInstance().entityInhRelation(entityNumber);
        return "1".equals(type) ? "time" : "nontime";
    }
}

