/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.extendplatform.tools.common.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.common.IToolsApplicationService;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelAbilityDomainService;

public class ToolsApplicationServiceImpl
implements IToolsApplicationService {
    private IBizModelAbilityDomainService bizModelAbilityDomainService = ServiceFactory.getService(IBizModelAbilityDomainService.class);

    @Override
    public QFilter buildBizModelQFilter(Long abilityId) {
        QFilter resultQFilter = new QFilter("1", "!=", (Object)1);
        DynamicObject ability = this.bizModelAbilityDomainService.queryBizModelAbilityById(abilityId);
        if (ability == null) {
            return resultQFilter;
        }
        Long bizModelTypeId = ability.getLong("bizmodeltype.id");
        DynamicObjectCollection useRanges = ability.getDynamicObjectCollection("entryentity");
        if (bizModelTypeId == null || bizModelTypeId <= 0L || CollectionUtils.isEmpty((Collection)useRanges)) {
            return resultQFilter;
        }
        ArrayList<QFilter> rangQFilterList = new ArrayList<QFilter>(useRanges.size());
        for (DynamicObject range : useRanges) {
            DynamicObject bizModel = range.getDynamicObject("bizmodel");
            if (bizModel == null) continue;
            String longNumber = bizModel.getString("longnumber");
            QFilter rangQFilter = new QFilter("longnumber", "like", (Object)(longNumber + "%"));
            rangQFilterList.add(rangQFilter);
        }
        if (CollectionUtils.isEmpty(rangQFilterList)) {
            return resultQFilter;
        }
        QFilter newQFilter = new QFilter("bizmodeltype.id", "=", (Object)bizModelTypeId);
        newQFilter.and(this.buildOrQFilter(rangQFilterList));
        return newQFilter;
    }

    private QFilter buildOrQFilter(List<QFilter> rangQFilterList) {
        QFilter filter = null;
        for (QFilter qFilter : rangQFilterList) {
            if (filter == null) {
                filter = qFilter;
                continue;
            }
            filter.or(qFilter);
        }
        return filter;
    }
}

