/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.extendplatform.tools.commontools.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.business.application.service.metadata.IDynamicMetadataApplicationService;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.common.enums.MetadataGenTypeEnum;
import kd.hdtc.hrdbs.common.pojo.metadata.BaseParam;
import kd.hdtc.hrdbs.common.pojo.metadata.ContainerParam;
import kd.hdtc.hrdbs.common.pojo.metadata.FieldParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenParam;
import kd.hdtc.hrdbs.common.pojo.metadata.MetadataGenResult;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdt.business.application.service.extendplatform.tools.commontools.IBizModelToolApplicationService;
import kd.hdtc.hrdt.business.common.constants.BizModelToolConstants;
import kd.hdtc.hrdt.business.common.metadatafield.IMetaDataFieldHandle;
import kd.hdtc.hrdt.business.common.metadatafield.MetaDataFieldHandleFactory;
import kd.hdtc.hrdt.business.common.utils.platform.ISVServiceUtils;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelRecordDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultBo;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.commontools.IBizModelToolDomainService;
import kd.hdtc.hrdt.common.util.HRDyObjectUtils;

public class BizModelToolApplicationServiceImpl
implements IBizModelToolApplicationService {
    private static final Log LOG = LogFactory.getLog(BizModelToolApplicationServiceImpl.class);
    private static final char SEPARATE = '.';
    private IBizModelToolDomainService bizModelToolDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IBizModelToolDomainService.class);
    private IBizModelDomainService bizModelDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IBizModelDomainService.class);
    private IBizModelRecordDomainService bizModelRecordDomainService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IBizModelRecordDomainService.class);
    private IDynamicMetadataApplicationService metadataApplicationService = (IDynamicMetadataApplicationService)ServiceFactory.getService(IDynamicMetadataApplicationService.class);

    @Override
    public List<ToolResultBo> bizModelToolEffect(List<DynamicObject> bizModelTools) {
        if (CollectionUtils.isEmpty(bizModelTools)) {
            return null;
        }
        ArrayList toolResultBoList = Lists.newArrayListWithExpectedSize((int)bizModelTools.size());
        List<DynamicObject> bizModels = this.generateBizModels(bizModelTools, toolResultBoList);
        this.bizModelDomainService.saveBizModels(bizModels);
        this.handleBizModelToolResult(bizModelTools, bizModels, toolResultBoList);
        this.bizModelToolDomainService.update(bizModelTools.toArray(new DynamicObject[0]));
        this.bizModelRecordDomainService.saveBizModelRecord(toolResultBoList);
        return toolResultBoList;
    }

    @Override
    public MetadataGenResult dynamicMetadataEffect(DynamicObject bizModelTool) {
        MetadataGenParam metadataGenParam = this.buildMetadataGenParam(bizModelTool);
        return this.metadataApplicationService.generate(metadataGenParam);
    }

    @Override
    public void updateBizModelTool(List<DynamicObject> bizModelTools) {
        if (CollectionUtils.isEmpty(bizModelTools)) {
            return;
        }
        this.bizModelToolDomainService.update(bizModelTools.toArray(new DynamicObject[0]));
    }

    private List<DynamicObject> generateBizModels(List<DynamicObject> bizModelTools, List<ToolResultBo> toolResultBoList) {
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"hrdt_bizmodelconfig");
        ArrayList bizModelList = Lists.newArrayListWithExpectedSize((int)bizModelTools.size());
        long[] genLongIds = ORM.create().genLongIds("hrdt_bizmodelconfig", bizModelTools.size());
        for (int i = 0; i < bizModelTools.size(); ++i) {
            DynamicObject bizModelTool = bizModelTools.get(i);
            if (bizModelTool.getLong("id") == 0L) {
                bizModelTool.set("id", (Object)genLongIds[i]);
            }
            DynamicObject bizModel = new DynamicObject((DynamicObjectType)dataEntityType);
            bizModel.set("id", (Object)genLongIds[i]);
            bizModel.set("number", (Object)bizModelTool.getString("number"));
            bizModel.set("name", (Object)bizModelTool.getString("name"));
            bizModel.set("bizmodeltype", (Object)1686373805922075648L);
            DynamicObject bizModelDynamicObject = bizModelTool.getDynamicObject("bizmodel");
            bizModel.set("parent", (Object)bizModelDynamicObject);
            bizModel.set("level", (Object)(bizModelDynamicObject.getInt("level") + 1));
            bizModel.set("longnumber", (Object)this.componentData(bizModelDynamicObject.getString("longnumber"), bizModelTool.getString("number")));
            bizModel.set("fullname", (Object)this.componentData(bizModelDynamicObject.getString("fullname"), bizModelTool.getString("name")));
            bizModel.set("isv", (Object)ISVServiceUtils.getCurrentISV());
            bizModel.set("isextdata", (Object)Boolean.TRUE);
            bizModel.set("isleaf", (Object)Boolean.TRUE);
            bizModel.set("mainentity", (Object)bizModelTool.getString("metanumber"));
            bizModel.set("status", (Object)"C");
            bizModel.set("creator", (Object)RequestContext.get().getCurrUserId());
            bizModel.set("enable", (Object)"1");
            bizModel.set("versionnumber", (Object)bizModelTool.getString("versionnumber"));
            bizModel.set("description", (Object)bizModelTool.getString("description"));
            bizModelList.add(bizModel);
            toolResultBoList.add(this.generateToolResultBo(bizModelTool.get("id"), bizModel));
        }
        return bizModelList;
    }

    private MetadataGenParam buildMetadataGenParam(DynamicObject bizModelTool) {
        MetadataGenParam metadataGenParam = new MetadataGenParam();
        BaseParam baseParam = new BaseParam();
        metadataGenParam.setBaseParam(baseParam);
        metadataGenParam.setFieldParamList(new ArrayList());
        baseParam.setMetadataName(bizModelTool.getString("name"));
        baseParam.setMetadataNumber(bizModelTool.getString("metanumber"));
        baseParam.setType(MetadataGenTypeEnum.NORMAL_METADATA);
        FormMetadata formMetadata = MetadataUtils.getFormMetadataByNumber((String)bizModelTool.getString("inherittpl"));
        baseParam.setParentId(formMetadata.getEntityId());
        baseParam.setModelType(formMetadata.getModelType());
        metadataGenParam.getContainerParamList().add(this.createContainerParam());
        DynamicObject dynamicObject = bizModelTool.getDynamicObject("bizmodel");
        DynamicObject appDy = dynamicObject.getDynamicObject("bizapp");
        baseParam.setAppId(appDy.getString("number"));
        baseParam.setBizUnitId(dynamicObject.getString("bizunit"));
        DynamicObjectCollection entryEntity = bizModelTool.getDynamicObjectCollection("entryentity");
        int fieldIndex = 1;
        for (DynamicObject field : entryEntity) {
            IMetaDataFieldHandle metaDataFieldHandle = MetaDataFieldHandleFactory.getMetaDataFieldHandle(field.getString("fieldtype"));
            FieldParam fieldParam = metaDataFieldHandle.initBaseParam(field);
            if (fieldParam != null) {
                this.putIndexToField(fieldParam, fieldIndex++);
                metadataGenParam.getFieldParamList().add(fieldParam);
            }
            metaDataFieldHandle.initBasePanel(field, metadataGenParam);
        }
        return metadataGenParam;
    }

    private void putIndexToField(FieldParam fieldParam, int index) {
        if (fieldParam != null) {
            Map ruleMap = fieldParam.getFieldRuleMap();
            ruleMap = ruleMap == null ? new HashMap(16) : ruleMap;
            Object indexStr = ruleMap.get("Index");
            if (indexStr == null) {
                ruleMap.put("Index", index);
            }
            fieldParam.setFieldRuleMap(ruleMap);
        }
    }

    private ContainerParam createContainerParam() {
        ContainerParam containerParam = new ContainerParam();
        containerParam.setName(BizModelToolConstants.CONTAIN_NAME);
        containerParam.setNumber("contentpaneladd");
        containerParam.setParentNumber("conentpanel");
        containerParam.setType("FieldsetPanelAp");
        containerParam.setIndex(100);
        return containerParam;
    }

    private String componentData(String pre, String last) {
        StringBuilder stringBuilder = new StringBuilder(pre);
        stringBuilder.append('.').append(last);
        return stringBuilder.toString();
    }

    private void handleBizModelToolResult(List<DynamicObject> bizModelTools, List<DynamicObject> bizModels, List<ToolResultBo> toolResultBoList) {
        if (CollectionUtils.isEmpty(toolResultBoList) || CollectionUtils.isEmpty(bizModelTools) || CollectionUtils.isEmpty(bizModels)) {
            return;
        }
        Map<Long, ToolResultBo> toolResultBoMap = toolResultBoList.stream().collect(Collectors.toMap(ToolResultBo::getBizModelId, bo -> bo));
        Map<String, Long> numberToId = bizModels.stream().collect(Collectors.toMap(model -> model.getString("number"), bizModel -> bizModel.getLong("id")));
        for (DynamicObject bizModelTool : bizModelTools) {
            ToolResultBo toolResultBo = toolResultBoMap.get(numberToId.get(bizModelTool.getString("number")));
            if (toolResultBo == null) continue;
            HRDyObjectUtils.setBigText((DynamicObject)bizModelTool, (String)"result", (String)toolResultBo.metaContentToJson());
        }
    }

    private ToolResultBo generateToolResultBo(Object BizMelToolId, DynamicObject bizModel) {
        ToolResultBo toolResultBo = new ToolResultBo();
        toolResultBo.setBizModelId(bizModel.getLong("id"));
        toolResultBo.setAbilityId(1692173864764765184L);
        toolResultBo.setObjectId(bizModel.getLong("parent.id"));
        toolResultBo.addDyn(bizModel.getString("mainentity"), bizModel.getString("versionnumber"));
        toolResultBo.addData("hrdt_bizmodelconfig", Collections.singletonList(bizModel.get("id")));
        toolResultBo.addData("hrdt_bizmodeladdtool", Collections.singletonList(BizMelToolId));
        return toolResultBo;
    }
}

