/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.mvc.SessionManager;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdt.business.application.service.IWorkBenchServiceApplication;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.utils.ConfigureUtils;
import kd.hdtc.hrdt.business.domain.workbench.IKnowledgeInfoDomainService;
import kd.hdtc.hrdt.business.domain.workbench.IToolDetailDomainService;
import kd.hdtc.hrdt.business.domain.workbench.IWorkBenchRoleDomainService;
import kd.hdtc.hrdt.business.domain.workbench.IWorkItemSetDomainService;
import kd.hr.hbp.common.util.HRObjectUtils;

public class WorkBenchServiceApplicationImpl
implements IWorkBenchServiceApplication {
    private IWorkBenchRoleDomainService workBenchRoleDomainService = ServiceFactory.getService(IWorkBenchRoleDomainService.class);
    private IWorkItemSetDomainService workItemSetDomainService = ServiceFactory.getService(IWorkItemSetDomainService.class);
    private IToolDetailDomainService toolDetailDomainService = ServiceFactory.getService(IToolDetailDomainService.class);
    private IKnowledgeInfoDomainService knowledgeInfoDomainService = ServiceFactory.getService(IKnowledgeInfoDomainService.class);

    @Override
    public boolean isFirstIntoWorkBench() {
        DynamicObject workBenchRole = this.workBenchRoleDomainService.queryCurrentRoleByUserId(RequestContext.get().getCurrUserId());
        return HRObjectUtils.isEmpty((Object)workBenchRole);
    }

    @Override
    public DynamicObject getWorkBenchRole(String sessionWorkBenchRole) {
        DynamicObject workBenchRole = null;
        if (StringUtils.isEmpty((String)sessionWorkBenchRole)) {
            workBenchRole = this.workBenchRoleDomainService.queryCurrentRoleByUserId(RequestContext.get().getCurrUserId());
        }
        if (HRObjectUtils.isEmpty(workBenchRole)) {
            workBenchRole = this.workBenchRoleDomainService.queryWorkBenchRole(StringUtils.isEmpty((String)sessionWorkBenchRole) ? 0L : Long.parseLong(sessionWorkBenchRole));
        }
        if (workBenchRole != null && StringUtils.isEmpty((String)sessionWorkBenchRole)) {
            this.saveWorkBenchRole(workBenchRole.getLong("id"));
        }
        return workBenchRole;
    }

    @Override
    public List<DynamicObject> queryAllWorkBenchRole() {
        DynamicObject[] allWorkBenchRole = this.workBenchRoleDomainService.queryAllWorkBenchRole();
        int limit = ConfigureUtils.getWorkBenchRoleSize();
        if (allWorkBenchRole != null && allWorkBenchRole.length > 0) {
            List<DynamicObject> workBenchRoleList = Arrays.asList(allWorkBenchRole);
            if (workBenchRoleList.size() > limit) {
                return workBenchRoleList.subList(0, limit);
            }
            return workBenchRoleList;
        }
        return null;
    }

    @Override
    public void saveWorkBenchRole(Long workBenchRoleId) {
        SessionManager currentSessionManager = SessionManager.getCurrent();
        String oldWorkBenchRole = currentSessionManager.get("workbenchrole");
        String newWorkBenchRole = String.valueOf(workBenchRoleId);
        if (StringUtils.isNotEmpty((String)newWorkBenchRole)) {
            if (StringUtils.equals((String)newWorkBenchRole, (String)oldWorkBenchRole)) {
                return;
            }
            SessionManager.getCurrent().put("workbenchrole", newWorkBenchRole);
            this.workBenchRoleDomainService.saveOrUpdateCurrentRole(RequestContext.get().getCurrUserId(), workBenchRoleId);
        }
    }

    @Override
    public List<DynamicObject> getWorkItemSets(Long workBenchRoleId, Integer limit) {
        return this.workItemSetDomainService.queryWorkItemSetList(workBenchRoleId, limit);
    }

    @Override
    public List<DynamicObject> getComTools(Long workBenchRoleId) {
        Object[] dynamicObjects = this.toolDetailDomainService.queryCommonTools(RequestContext.get().getCurrUserId(), workBenchRoleId);
        int limit = ConfigureUtils.getComToolSize();
        if (ObjectUtils.isEmpty((Object[])dynamicObjects)) {
            return null;
        }
        ArrayList<DynamicObject> comTools = new ArrayList<DynamicObject>();
        ArrayList toolIds = Lists.newArrayListWithExpectedSize((int)dynamicObjects.length);
        for (Object dynamicObject : dynamicObjects) {
            DynamicObject tool = dynamicObject.getDynamicObject("tool");
            if (tool == null || toolIds.contains(tool.getLong("id"))) continue;
            comTools.add(dynamicObject.getDynamicObject("tool"));
            toolIds.add(tool.getLong("id"));
        }
        if (comTools.size() > limit) {
            return comTools.subList(0, limit);
        }
        return comTools;
    }

    @Override
    public void saveOrUpdateCommonTool(Long userId, Long workBenchRoleId, Long toolId) {
        this.toolDetailDomainService.saveOrUpdateCommonTool(userId, workBenchRoleId, toolId);
    }

    @Override
    public Map<Long, List<DynamicObject>> getWorkItems(List<Long> workItemSetIds) {
        return this.workItemSetDomainService.queryWorkItemMap(workItemSetIds);
    }

    @Override
    public Map<String, List<DynamicObject>> getKnowledgeInfos() {
        HashMap knowledgeInfoMap = Maps.newHashMapWithExpectedSize((int)4);
        knowledgeInfoMap.put("common", new ArrayList());
        knowledgeInfoMap.put("hot", new ArrayList());
        Object[] knowledgeInfos = this.knowledgeInfoDomainService.queryKnowledge();
        if (ObjectUtils.isEmpty((Object[])knowledgeInfos)) {
            return knowledgeInfoMap;
        }
        for (Object knowledgeInfo : knowledgeInfos) {
            String number = knowledgeInfo.getString("number");
            if (number.startsWith("common")) {
                ((List)knowledgeInfoMap.get("common")).add(knowledgeInfo);
                continue;
            }
            if (!number.startsWith("hot")) continue;
            ((List)knowledgeInfoMap.get("hot")).add(knowledgeInfo);
        }
        return knowledgeInfoMap;
    }
}

