/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.application.service.transferconf.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MulComboProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.inte.api.EnabledLang;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.hdtc.hrdbs.common.util.BosApiUtil;
import kd.hdtc.hrdbs.common.util.BosHttpClientUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.ConvertUtils;
import kd.hdtc.hrdbs.common.util.DateTimeUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdt.business.application.service.transferconf.ITransferConfigCompareDataApplication;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.model.TransferConfigCompareDataBo;
import kd.hdtc.hrdt.business.common.model.TransferConfigCompareDataDetailBo;
import kd.hdtc.hrdt.business.common.model.TransferConfigCompareResultDataBo;
import kd.hdtc.hrdt.business.common.model.TransferDataTypeEnum;
import kd.hdtc.hrdt.business.domain.transfer.configitem.IConfigItemDomainService;
import kd.hdtc.hrdt.business.domain.transfer.configitem.model.TransferDataBo;
import kd.hdtc.hrdt.common.enums.CompareDetailTypeEnum;

public class TransferConfigCompareDataApplicationImpl
implements ITransferConfigCompareDataApplication {
    private static final String EVN_URL = "evnurl";
    private static final String APP_SECURE = "appsecuret";
    private static final String ACCOUNT_ID = "accountId";
    private static final String TARGET_DATACENTER_USER = "targetdatacenteruser";
    private static final String EVN_TYPE = "evntype";
    private static final String APP_ID = "appId";
    private static final String APP_ID_RICC = "ricc";
    private static final ThreadLocal<Map<String, MainEntityType>> ENTITY_MAP = new ThreadLocal();
    private static final ThreadLocal<List<EnabledLang>> ENABLE_LANG_LIST_THREAD = new ThreadLocal();

    @Override
    public String getConfigCompareDataByConfigInfo(List<TransferConfigCompareDataBo> boList) {
        if (CollectionUtils.isEmpty(boList)) {
            return null;
        }
        for (TransferConfigCompareDataBo bo2 : boList) {
            TransferDataBo transferDataBo = new TransferDataBo(bo2.getEntityNumber());
            transferDataBo.setCp("in");
            transferDataBo.setFieldValueList((List<Object>)ImmutableList.of((Object)bo2.getUniqueKeyValue()));
            transferDataBo.setFieldKey("id");
            ArrayList<Map<String, Object>> retDataList = new ArrayList<Map<String, Object>>(16);
            ArrayList<Map<String, Map<String, Object>>> sysConfItemDataList = new ArrayList<Map<String, Map<String, Object>>>(16);
            HashSet<String> confItemItselfNumSet = new HashSet<String>(16);
            IConfigItemDomainService configItemDomainService = ServiceFactory.createInstance(IConfigItemDomainService.class);
            List<Map<String, Object>> confItemData = configItemDomainService.getConfItemData(transferDataBo, retDataList, sysConfItemDataList, confItemItselfNumSet);
            List<TransferConfigCompareResultDataBo> currentData = this.buildCurrentData(bo2, confItemData);
            bo2.setResult(currentData);
        }
        HashMap queryParams = new HashMap(16);
        boList.stream().forEach(bo -> {
            List<TransferConfigCompareResultDataBo> compareList = bo.getResult();
            if (CollectionUtils.isEmpty(compareList)) {
                return;
            }
            for (TransferConfigCompareResultDataBo compareBo : compareList) {
                this.putDataToMap(queryParams, compareBo.getSubEntityNumber(), compareBo.getSubEntityUniqueKeyValue());
            }
        });
        TransferConfigCompareDataBo accountBo = boList.get(0);
        long accountId = accountBo.getTargetDataCenter().getLong("id");
        String targetUser = accountBo.getTargetDatacenterUser();
        if (CollectionUtils.isNotEmpty(queryParams)) {
            Map<String, Object> loginParams = TransferConfigCompareDataApplicationImpl.destAccountLoginParams(accountId, targetUser);
            JSONObject json = new JSONObject();
            json.put("dynDataModelMap", queryParams);
            String response = TransferConfigCompareDataApplicationImpl.getDestAccountData(json, loginParams);
            if (StringUtils.isNotEmpty((String)response)) {
                JSONObject responseJson = JSON.parseObject((String)response);
                if (responseJson.getBooleanValue("status")) {
                    JSONObject dataInfo = responseJson.getJSONObject("data");
                    if (dataInfo != null) {
                        this.buildTargetData(dataInfo, boList);
                    }
                } else {
                    String message = ResManager.loadKDString((String)"\u76ee\u6807\u73af\u5883\u6570\u636e\u83b7\u53d6\u5931\u8d25", (String)"TransferConfigCompareDataApplicationImpl_0", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
                    return message + "\n" + responseJson.getString("message");
                }
            }
        }
        this.buildCompareDetail(boList);
        return null;
    }

    private void putDataToMap(Map<String, List<Object>> queryParams, String entityNumber, Object id) {
        List<Object> dataList;
        if (queryParams == null) {
            queryParams = new HashMap<String, List<Object>>(4);
        }
        if ((dataList = queryParams.get(entityNumber)) == null) {
            dataList = new ArrayList<Object>(4);
        }
        if (id != null) {
            dataList.add(id);
        }
        queryParams.put(entityNumber, dataList);
    }

    private void buildCompareDetail(List<TransferConfigCompareDataBo> boList) {
        if (CollectionUtils.isEmpty(boList)) {
            return;
        }
        for (TransferConfigCompareDataBo bo : boList) {
            List<TransferConfigCompareResultDataBo> dataList = bo.getResult();
            if (CollectionUtils.isEmpty(dataList)) continue;
            dataList.stream().forEach(data -> {
                List<TransferConfigCompareDataDetailBo> details = this.getDiffCompareData(data.getCurrentValue(), data.getTargetValue(), (IDataEntityType)this.getMainEntityType(data.getSubEntityNumber()));
                data.setDetails(details);
                this.buildDiffCount((TransferConfigCompareResultDataBo)data);
            });
        }
    }

    private void buildDiffCount(TransferConfigCompareResultDataBo resultDataBo) {
        List<TransferConfigCompareDataDetailBo> details = resultDataBo.getDetails();
        if (CollectionUtils.isEmpty(details)) {
            return;
        }
        AtomicInteger newC = new AtomicInteger();
        AtomicInteger upC = new AtomicInteger();
        AtomicInteger delC = new AtomicInteger();
        details.forEach(data -> {
            CompareDetailTypeEnum type = data.getType();
            if (type == CompareDetailTypeEnum.ADD) {
                newC.getAndIncrement();
            } else if (type == CompareDetailTypeEnum.MODIFY) {
                upC.getAndIncrement();
            } else if (type == CompareDetailTypeEnum.DELETE) {
                delC.getAndIncrement();
            }
        });
        resultDataBo.setAddNum(newC.intValue());
        resultDataBo.setModifyNum(upC.intValue());
        resultDataBo.setDeleteNum(delC.intValue());
    }

    private List<TransferConfigCompareResultDataBo> buildCurrentData(TransferConfigCompareDataBo bo, List<Map<String, Object>> confItemData) {
        ArrayList<TransferConfigCompareResultDataBo> entityDataList = new ArrayList<TransferConfigCompareResultDataBo>(4);
        for (Map<String, Object> info : confItemData) {
            TransferConfigCompareDataBo infoBo = new TransferConfigCompareDataBo();
            infoBo.setUniqueKeyValue(bo.getUniqueKeyValue());
            infoBo.setConfigId(bo.getConfigId());
            infoBo.setConfigName(bo.getConfigName());
            infoBo.setTargetDataCenter(bo.getTargetDataCenter());
            infoBo.setTargetDatacenterUser(bo.getTargetDatacenterUser());
            infoBo.setEntityNumber(String.valueOf(info.get("entityNumber")));
            this.buildMainData(entityDataList, infoBo, info);
            this.buildOtherData(entityDataList, infoBo, info, TransferDataTypeEnum.HIS_MOD_REL_DATA);
            this.buildOtherData(entityDataList, infoBo, info, TransferDataTypeEnum.REL_SUB_DATA);
        }
        return entityDataList;
    }

    private void buildTargetData(JSONObject dataInfo, List<TransferConfigCompareDataBo> boList) {
        if (dataInfo == null || CollectionUtils.isEmpty(boList)) {
            return;
        }
        boList.stream().forEach(bo -> {
            List<TransferConfigCompareResultDataBo> compareList = bo.getResult();
            if (CollectionUtils.isEmpty(compareList)) {
                return;
            }
            for (TransferConfigCompareResultDataBo compareBo : compareList) {
                JSONObject dataMap = dataInfo.getJSONObject(compareBo.getSubEntityNumber());
                if (!CollectionUtils.isNotEmpty((Map)dataMap)) continue;
                compareBo.setTargetValue((Map)dataMap.get(compareBo.getSubEntityUniqueKeyValue()));
            }
        });
    }

    private TransferConfigCompareResultDataBo newMainEntity(TransferConfigCompareDataBo bo) {
        Object key = bo.getUniqueKeyValue();
        TransferConfigCompareResultDataBo resultDataBo = new TransferConfigCompareResultDataBo();
        resultDataBo.setEntityNumber(bo.getEntityNumber());
        MainEntityType mainType = this.getMainEntityType(bo.getEntityNumber());
        resultDataBo.setEntityName(mainType.getDisplayName().getLocaleValue());
        resultDataBo.setTableNumber(mainType.getAlias());
        resultDataBo.setEntityDisplayName(mainType.getDisplayName().getLocaleValue() + '(' + bo.getEntityNumber() + ')');
        resultDataBo.setUniqueKeyValue(key);
        resultDataBo.setConfigName(bo.getConfigName());
        return resultDataBo;
    }

    private void buildMainData(List<TransferConfigCompareResultDataBo> entityDataList, TransferConfigCompareDataBo compareDataBo, Map<String, Object> info) {
        List dataList = (List)info.get(TransferDataTypeEnum.DATA.getType());
        MainEntityType mainType = this.getMainEntityType(compareDataBo.getEntityNumber());
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            dataList.stream().forEach(data -> {
                TransferConfigCompareResultDataBo resultDataBo = this.newMainEntity(compareDataBo);
                resultDataBo.setSubTypeNumber(TransferDataTypeEnum.DATA.getType());
                resultDataBo.setSubTypeName(TransferDataTypeEnum.DATA.getTypeName());
                resultDataBo.setSubEntityName(mainType.getName());
                resultDataBo.setSubEntityNumber(compareDataBo.getEntityNumber());
                resultDataBo.setSubEntityName(mainType.getDisplayName().getLocaleValue());
                resultDataBo.setSubEntityTableNumber(mainType.getAlias());
                resultDataBo.setSubEntityDisplayName(mainType.getDisplayName().getLocaleValue() + '(' + compareDataBo.getEntityNumber() + ')');
                if (data instanceof Map) {
                    Map dataMap = (Map)data;
                    resultDataBo.setSubEntityUniqueKeyValue(dataMap.get("id"));
                    resultDataBo.setCurrentValue(dataMap);
                }
                entityDataList.add(resultDataBo);
            });
        }
    }

    private void buildOtherData(List<TransferConfigCompareResultDataBo> entityDataList, TransferConfigCompareDataBo compareDataBo, Map<String, Object> info, TransferDataTypeEnum type) {
        List dataList = (List)info.get(type.getType());
        if (CollectionUtils.isNotEmpty((Collection)dataList)) {
            dataList.stream().forEach(data -> {
                if (data instanceof Map) {
                    Map dataMap = (Map)data;
                    String subEntityNumber = (String)dataMap.get("entityNumber");
                    if (StringUtils.isEmpty((String)subEntityNumber)) {
                        return;
                    }
                    MainEntityType mainType = this.getMainEntityType(subEntityNumber);
                    List subDataList = (List)dataMap.get("data");
                    if (CollectionUtils.isNotEmpty((Collection)subDataList)) {
                        subDataList.forEach(subData -> {
                            TransferConfigCompareResultDataBo resultDataBo = this.newMainEntity(compareDataBo);
                            resultDataBo.setSubTypeNumber(type.getType());
                            resultDataBo.setSubTypeName(type.getTypeName());
                            resultDataBo.setSubEntityName(mainType.getName());
                            resultDataBo.setSubEntityNumber(subEntityNumber);
                            resultDataBo.setSubEntityName(mainType.getDisplayName().getLocaleValue());
                            resultDataBo.setSubEntityTableNumber(mainType.getAlias());
                            resultDataBo.setSubEntityDisplayName(mainType.getDisplayName().getLocaleValue() + '(' + subEntityNumber + ')');
                            resultDataBo.setSubEntityUniqueKeyValue(subData.get("id"));
                            resultDataBo.setCurrentValue((Map<String, Object>)subData);
                            entityDataList.add(resultDataBo);
                        });
                    }
                }
            });
        }
    }

    private MainEntityType getMainEntityType(String number) {
        MainEntityType mainType;
        Map<String, MainEntityType> map = ENTITY_MAP.get();
        if (map == null) {
            map = new HashMap<String, MainEntityType>(4);
        }
        if ((mainType = map.get(number)) == null) {
            mainType = EntityMetadataCache.getDataEntityType((String)number);
            map.put(number, mainType);
        }
        ENTITY_MAP.set(map);
        return mainType;
    }

    public static String getDestAccountData(Object data, Map<String, Object> loginParam) {
        String accessToken = BosApiUtil.doLoginByMobilePhone(loginParam);
        String url = loginParam.get(EVN_URL) + "/kapi/v2/hrdt/openapi/hrdt/getDynamicData?access_token=" + accessToken;
        String jsonStr = JSON.toJSONString((Object)data);
        return BosHttpClientUtils.doPostByHttpClient((String)url, (String)jsonStr);
    }

    public static Map<String, Object> destAccountLoginParams(long id, String targetDataCenter) {
        HashMap<String, Object> loginParams = new HashMap<String, Object>(5);
        boolean isExists = QueryServiceHelper.exists((String)"ricc_destaccount", (Object)id);
        if (isExists) {
            DynamicObject destAccount = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ricc_destaccount");
            loginParams.put(EVN_URL, destAccount.getString(EVN_URL));
            loginParams.put(APP_SECURE, destAccount.getString(APP_SECURE));
            loginParams.put(TARGET_DATACENTER_USER, targetDataCenter);
            loginParams.put(ACCOUNT_ID, destAccount.getString("number"));
            loginParams.put(EVN_TYPE, destAccount.getString(EVN_TYPE));
            loginParams.put(APP_ID, APP_ID_RICC);
        }
        return loginParams;
    }

    @Override
    public List<TransferConfigCompareDataDetailBo> getDiffCompareData(Map<String, Object> srcData, Map<String, Object> targetData, IDataEntityType entity) {
        boolean condition;
        boolean bl = condition = entity == null || CollectionUtils.isEmpty(srcData) && CollectionUtils.isEmpty(targetData);
        if (condition) {
            return null;
        }
        DataEntityPropertyCollection props = entity.getProperties();
        List<IDataEntityProperty> ppList = this.filterCompareProp(props);
        ArrayList<TransferConfigCompareDataDetailBo> resultList = new ArrayList<TransferConfigCompareDataDetailBo>(props.size());
        for (IDataEntityProperty prop : ppList) {
            List<TransferConfigCompareDataDetailBo> subBos;
            String number = prop.getName();
            LocaleString localeString = prop.getDisplayName();
            String displayName = localeString != null ? localeString.getLocaleValue() : number;
            TransferConfigCompareDataDetailBo bo = new TransferConfigCompareDataDetailBo();
            bo.setNumber(number);
            bo.setDisplayName(displayName);
            Object srcDataDetail = null;
            if (srcData != null) {
                srcDataDetail = srcData.get(number);
            }
            Object targetDataDetail = null;
            if (targetData != null) {
                targetDataDetail = targetData.get(number);
            }
            if (prop instanceof MuliLangTextProp) {
                subBos = this.compareAndAddMulLangTextCol(number, displayName, srcDataDetail, targetDataDetail);
                if (!CollectionUtils.isNotEmpty(subBos)) continue;
                resultList.addAll(subBos);
                continue;
            }
            if (prop instanceof EntryProp) {
                EntryProp entryProp = (EntryProp)prop;
                DynamicObjectType type = entryProp.getDynamicCollectionItemPropertyType();
                this.compareAndAddEntryCol(type, (List)srcDataDetail, (List)targetDataDetail, bo);
                resultList.add(bo);
                continue;
            }
            if (prop instanceof DateTimeProp || prop instanceof DateProp) {
                this.compareAndAddDateCol(srcDataDetail, targetDataDetail, bo);
                resultList.add(bo);
                continue;
            }
            if (prop instanceof BooleanProp) {
                this.compareAndAddBooleanCol(srcDataDetail, targetDataDetail, bo);
                resultList.add(bo);
                continue;
            }
            if (prop instanceof MulComboProp || prop instanceof ComboProp) {
                this.compareAndAddComboCol((ComboProp)prop, srcDataDetail, targetDataDetail, bo);
                resultList.add(bo);
                continue;
            }
            if (prop instanceof BasedataProp) {
                subBos = this.compareAndAddBaseDataCol(srcDataDetail, targetDataDetail, bo);
                if (!CollectionUtils.isNotEmpty(subBos)) continue;
                resultList.addAll(subBos);
                continue;
            }
            if (prop instanceof MulBasedataProp) {
                this.compareAndAddMulBaseDataCol((List)srcDataDetail, (List)targetDataDetail, bo);
                resultList.add(bo);
                continue;
            }
            bo.setCurrentData(ConvertUtils.toString((Object)srcDataDetail));
            bo.setCurrentDisplayData(ConvertUtils.toString((Object)srcDataDetail));
            bo.setTargetData(ConvertUtils.toString((Object)targetDataDetail));
            bo.setTargetDisplayData(ConvertUtils.toString((Object)targetDataDetail));
            resultList.add(bo);
        }
        this.dealAllCompareDetailResult(resultList);
        return resultList;
    }

    private void dealAllCompareDetailResult(List<TransferConfigCompareDataDetailBo> result) {
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        for (TransferConfigCompareDataDetailBo bo : result) {
            List<TransferConfigCompareDataDetailBo> children;
            String currentData = bo.getCurrentData();
            String targetData = bo.getTargetData();
            if (this.isEmptyString(currentData) && this.isEmptyString(targetData)) {
                bo.setType(CompareDetailTypeEnum.SAME);
                bo.setCurrentData("-");
                bo.setCurrentDisplayData("-");
                bo.setTargetData("-");
                bo.setTargetDisplayData("-");
            } else if (this.isEmptyString(currentData) && !this.isEmptyString(targetData)) {
                bo.setType(CompareDetailTypeEnum.ADD);
                bo.setCurrentData("-");
                bo.setCurrentDisplayData("-");
            } else if (!this.isEmptyString(currentData) && this.isEmptyString(targetData)) {
                bo.setType(CompareDetailTypeEnum.DELETE);
                bo.setTargetData("-");
                bo.setTargetDisplayData("-");
            } else if (!StringUtils.equals((String)currentData, (String)targetData)) {
                bo.setType(CompareDetailTypeEnum.MODIFY);
            } else {
                bo.setType(CompareDetailTypeEnum.SAME);
            }
            if (!CollectionUtils.isNotEmpty(children = bo.getChildren())) continue;
            this.dealAllCompareDetailResult(children);
            if (!children.stream().anyMatch(data -> data.getType() != CompareDetailTypeEnum.SAME)) continue;
            bo.setType(CompareDetailTypeEnum.MODIFY);
        }
    }

    private boolean isEmptyString(String data) {
        return StringUtils.isEmpty((String)data) || StringUtils.equals((String)"null", (String)data);
    }

    private List<TransferConfigCompareDataDetailBo> compareAndAddMulLangTextCol(String number, String displayName, Object srcDataDetail, Object targetDataDetail) {
        ILocaleString srcLocale = this.buildLangInfo(srcDataDetail);
        ILocaleString targetLocale = this.buildLangInfo(targetDataDetail);
        ArrayList<TransferConfigCompareDataDetailBo> bos = new ArrayList<TransferConfigCompareDataDetailBo>(8);
        List<EnabledLang> enableLangList = this.getEnableLang();
        if (CollectionUtils.isEmpty(enableLangList)) {
            return bos;
        }
        for (EnabledLang lang : enableLangList) {
            TransferConfigCompareDataDetailBo bo = new TransferConfigCompareDataDetailBo();
            String lanNumber = lang.getNumber();
            bo.setNumber(number + "." + lanNumber);
            bo.setDisplayName(displayName + "." + lang.getName());
            bo.setCurrentData(String.valueOf(srcLocale.get((Object)lanNumber)));
            bo.setCurrentDisplayData(String.valueOf(srcLocale.get((Object)lanNumber)));
            bo.setTargetData(String.valueOf(targetLocale.get((Object)lanNumber)));
            bo.setTargetDisplayData(String.valueOf(targetLocale.get((Object)lanNumber)));
            bos.add(bo);
        }
        return bos;
    }

    private ILocaleString buildLangInfo(Object srcDataDetail) {
        LocaleString srcLocale = new LocaleString();
        if (srcDataDetail instanceof JSONObject || srcDataDetail instanceof Map) {
            Map srcMap = (Map)srcDataDetail;
            if (CollectionUtils.isNotEmpty((Map)srcMap)) {
                srcLocale.putAll(srcMap);
            }
        } else if (srcDataDetail instanceof ILocaleString) {
            srcLocale = (ILocaleString)srcDataDetail;
        }
        return srcLocale;
    }

    private List<EnabledLang> getEnableLang() {
        List enableLangList = ENABLE_LANG_LIST_THREAD.get();
        if (CollectionUtils.isEmpty(enableLangList)) {
            enableLangList = InteServiceHelper.getEnabledLang();
            ENABLE_LANG_LIST_THREAD.set(enableLangList);
        }
        return enableLangList;
    }

    private void compareAndAddEntryCol(DynamicObjectType type, List<Map<String, Object>> srcEntry, List<Map<String, Object>> targetEntry, TransferConfigCompareDataDetailBo entryBo) {
        if (CollectionUtils.isEmpty(srcEntry) && CollectionUtils.isEmpty(targetEntry)) {
            return;
        }
        ArrayList<TransferConfigCompareDataDetailBo> children = new ArrayList<TransferConfigCompareDataDetailBo>(16);
        HashSet ids = new HashSet(16);
        Map<Object, Object> srcMap = new HashMap(4);
        if (CollectionUtils.isNotEmpty(srcEntry)) {
            srcMap = srcEntry.stream().collect(Collectors.toMap(data -> String.valueOf(data.get("id")), da -> da, (v1, v2) -> v2));
        }
        ids.addAll(srcMap.keySet());
        Map<Object, Object> targetMap = new HashMap(4);
        if (CollectionUtils.isNotEmpty(targetEntry)) {
            targetMap = targetEntry.stream().collect(Collectors.toMap(data -> String.valueOf(data.get("id")), da -> da, (v1, v2) -> v2));
        }
        ids.addAll(targetMap.keySet());
        for (String id : ids) {
            TransferConfigCompareDataDetailBo bo = new TransferConfigCompareDataDetailBo();
            bo.setNumber(id);
            bo.setDisplayName(id);
            bo.setCurrentDisplayData(ResManager.loadKDString((String)"\u5206\u5f55\uff0c\u70b9\u51fb\u67e5\u770b", (String)"TransferConfigCompareDataApplicationImpl_4", (String)"hdtc-hrdt-business", (Object[])new Object[0]));
            bo.setTargetDisplayData(ResManager.loadKDString((String)"\u5206\u5f55\uff0c\u70b9\u51fb\u67e5\u770b", (String)"TransferConfigCompareDataApplicationImpl_4", (String)"hdtc-hrdt-business", (Object[])new Object[0]));
            Map src = (Map)srcMap.get(id);
            Map target = (Map)targetMap.get(id);
            if (CollectionUtils.isEmpty((Map)src) && CollectionUtils.isEmpty((Map)target)) continue;
            List<TransferConfigCompareDataDetailBo> entryChildren = this.getDiffCompareData(src, target, (IDataEntityType)type);
            bo.setChildren(entryChildren);
            children.add(bo);
        }
        entryBo.setCurrentDisplayData(ResManager.loadKDString((String)"\u5206\u5f55\uff0c\u70b9\u51fb\u67e5\u770b", (String)"TransferConfigCompareDataApplicationImpl_4", (String)"hdtc-hrdt-business", (Object[])new Object[0]));
        entryBo.setTargetDisplayData(ResManager.loadKDString((String)"\u5206\u5f55\uff0c\u70b9\u51fb\u67e5\u770b", (String)"TransferConfigCompareDataApplicationImpl_4", (String)"hdtc-hrdt-business", (Object[])new Object[0]));
        entryBo.setChildren(children);
    }

    private void compareAndAddDateCol(Object srcDataDetail, Object targetDataDetail, TransferConfigCompareDataDetailBo bo) {
        String targetDateStr;
        String srcDateStr = String.valueOf(srcDataDetail);
        if (!this.isEmptyString(srcDateStr)) {
            bo.setCurrentData(srcDateStr);
            Date srcDate = new Date(Long.parseLong(srcDateStr));
            bo.setCurrentDisplayData(DateTimeUtils.format((Date)srcDate));
        }
        if (!this.isEmptyString(targetDateStr = String.valueOf(targetDataDetail))) {
            bo.setTargetData(targetDateStr);
            Date targetDate = new Date(Long.parseLong(targetDateStr));
            bo.setTargetDisplayData(DateTimeUtils.format((Date)targetDate));
        }
    }

    private void compareAndAddBooleanCol(Object srcDataDetail, Object targetDataDetail, TransferConfigCompareDataDetailBo bo) {
        String srcInfo = ResManager.loadKDString((String)"\u5426", (String)"TransferConfigCompareDataApplicationImpl_5", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
        if (StringUtils.equals((String)String.valueOf(srcDataDetail), (String)"1")) {
            srcInfo = ResManager.loadKDString((String)"\u662f", (String)"TransferConfigCompareDataApplicationImpl_6", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
        }
        bo.setCurrentData(String.valueOf(srcDataDetail));
        bo.setCurrentDisplayData(srcInfo);
        String targetInfo = ResManager.loadKDString((String)"\u5426", (String)"TransferConfigCompareDataApplicationImpl_5", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
        if (StringUtils.equals((String)String.valueOf(targetDataDetail), (String)"1")) {
            targetInfo = ResManager.loadKDString((String)"\u662f", (String)"TransferConfigCompareDataApplicationImpl_6", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
        }
        bo.setTargetData(String.valueOf(targetDataDetail));
        bo.setTargetDisplayData(targetInfo);
    }

    private void compareAndAddComboCol(ComboProp mulComboProp, Object srcDataDetail, Object targetDataDetail, TransferConfigCompareDataDetailBo bo) {
        String targetDateStr;
        String srcDateStr = String.valueOf(srcDataDetail);
        if (!this.isEmptyString(srcDateStr)) {
            bo.setCurrentData(srcDateStr);
            bo.setCurrentDisplayData(mulComboProp.getItemByName(srcDateStr));
        }
        if (!this.isEmptyString(targetDateStr = String.valueOf(targetDataDetail))) {
            bo.setTargetData(targetDateStr);
            bo.setTargetDisplayData(mulComboProp.getItemByName(targetDateStr));
        }
    }

    private List<TransferConfigCompareDataDetailBo> compareAndAddBaseDataCol(Object srcDataDetail, Object targetDataDetail, TransferConfigCompareDataDetailBo bo) {
        ArrayList<TransferConfigCompareDataDetailBo> bos = new ArrayList<TransferConfigCompareDataDetailBo>(8);
        HashSet baseDataKeys = new HashSet(4);
        Map srcDataMap = new HashMap(4);
        Map targetDataMap = new HashMap(4);
        if (srcDataDetail != null) {
            srcDataMap = (Map)srcDataDetail;
            baseDataKeys.addAll(srcDataMap.keySet());
        }
        if (targetDataDetail != null) {
            targetDataMap = (Map)targetDataDetail;
            baseDataKeys.addAll(targetDataMap.keySet());
        }
        if (CollectionUtils.isEmpty(baseDataKeys)) {
            bos.add(bo);
        } else {
            for (String baseDataKey : baseDataKeys) {
                TransferConfigCompareDataDetailBo subBo = new TransferConfigCompareDataDetailBo();
                subBo.setNumber(bo.getNumber());
                subBo.setDisplayName(bo.getDisplayName() + '.' + baseDataKey);
                subBo.setCurrentData(String.valueOf(srcDataMap.get(baseDataKey)));
                subBo.setCurrentDisplayData(String.valueOf(srcDataMap.get(baseDataKey)));
                subBo.setTargetData(String.valueOf(targetDataMap.get(baseDataKey)));
                subBo.setTargetDisplayData(String.valueOf(targetDataMap.get(baseDataKey)));
                bos.add(subBo);
            }
        }
        return bos;
    }

    private void compareAndAddMulBaseDataCol(List<Map<String, Object>> srcMulBaseData, List<Map<String, Object>> targetMulBaseData, TransferConfigCompareDataDetailBo entryBo) {
        if (CollectionUtils.isEmpty(srcMulBaseData) && CollectionUtils.isEmpty(targetMulBaseData)) {
            return;
        }
        ArrayList<TransferConfigCompareDataDetailBo> children = new ArrayList<TransferConfigCompareDataDetailBo>(16);
        HashSet ids = new HashSet(16);
        Map<Object, Object> srcMap = new HashMap(4);
        if (CollectionUtils.isNotEmpty(srcMulBaseData)) {
            srcMap = srcMulBaseData.stream().collect(Collectors.toMap(data -> String.valueOf(data.get("pkid")), da -> da, (v1, v2) -> v2));
        }
        ids.addAll(srcMap.keySet());
        Map<Object, Object> targetMap = new HashMap(4);
        if (CollectionUtils.isNotEmpty(targetMulBaseData)) {
            targetMap = targetMulBaseData.stream().collect(Collectors.toMap(data -> String.valueOf(data.get("pkid")), da -> da, (v1, v2) -> v2));
        }
        ids.addAll(targetMap.keySet());
        ImmutableSet showCols = ImmutableSet.of((Object)"pkid", (Object)"fbasedataid_id");
        for (String id : ids) {
            TransferConfigCompareDataDetailBo bo = new TransferConfigCompareDataDetailBo();
            bo.setNumber(id);
            bo.setDisplayName(id);
            bo.setCurrentDisplayData(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\uff0c\u70b9\u51fb\u67e5\u770b", (String)"TransferConfigCompareDataApplicationImpl_7", (String)"hdtc-hrdt-business", (Object[])new Object[0]));
            bo.setTargetDisplayData(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\uff0c\u70b9\u51fb\u67e5\u770b", (String)"TransferConfigCompareDataApplicationImpl_7", (String)"hdtc-hrdt-business", (Object[])new Object[0]));
            Map src = (Map)srcMap.get(id);
            Map target = (Map)targetMap.get(id);
            if (CollectionUtils.isEmpty((Map)src) && CollectionUtils.isEmpty((Map)target)) continue;
            ArrayList<TransferConfigCompareDataDetailBo> entryChildren = new ArrayList<TransferConfigCompareDataDetailBo>(showCols.size());
            for (String showCol : showCols) {
                TransferConfigCompareDataDetailBo showBo = new TransferConfigCompareDataDetailBo();
                showBo.setNumber(showCol);
                showBo.setDisplayName(showCol);
                showBo.setCurrentData(String.valueOf(src.get(showCol)));
                showBo.setCurrentDisplayData(String.valueOf(src.get(showCol)));
                showBo.setTargetData(String.valueOf(target.get(showCol)));
                showBo.setTargetDisplayData(String.valueOf(target.get(showCol)));
                entryChildren.add(showBo);
            }
            bo.setChildren(entryChildren);
            children.add(bo);
        }
        entryBo.setCurrentDisplayData(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\uff0c\u70b9\u51fb\u67e5\u770b", (String)"TransferConfigCompareDataApplicationImpl_7", (String)"hdtc-hrdt-business", (Object[])new Object[0]));
        entryBo.setTargetDisplayData(ResManager.loadKDString((String)"\u591a\u9009\u57fa\u7840\u8d44\u6599\uff0c\u70b9\u51fb\u67e5\u770b", (String)"TransferConfigCompareDataApplicationImpl_7", (String)"hdtc-hrdt-business", (Object[])new Object[0]));
        entryBo.setChildren(children);
    }

    private List<IDataEntityProperty> filterCompareProp(DataEntityPropertyCollection props) {
        List<IDataEntityProperty> pps = props.stream().filter(data -> data instanceof BasedataProp || data instanceof MulBasedataProp || !data.isDbIgnore() && (!(data instanceof LongProp) || !((LongProp)data).isRefId()) && !"multilanguagetext".equals(data.getName())).collect(Collectors.toList());
        return pps;
    }
}

