/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.common;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.hdtc.hrdbs.common.util.ServiceFactoryUtils;

public class ServiceFactory {
    private static final Log LOG = LogFactory.getLog(ServiceFactory.class);
    private static final Map<String, String> SERVICE_MAP = new HashMap<String, String>();
    private static volatile boolean inited = false;
    private static final Map<String, String> SCAN_PACKAGE_MAP = ImmutableMap.builder().put((Object)"kd.hdtc.hrdt.business.application.external", (Object)"").put((Object)"kd.hdtc.hrdt.business.application.service", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.workbench", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.workbench.entity", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.ext", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.config", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.config.entity", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.extendplatform.base", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.extendplatform.base.entity", (Object)"").put((Object)"kd.hdtc.hrdt.business.application.service.extendplatform.client", (Object)"").put((Object)"kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.person", (Object)"").put((Object)"kd.hdtc.hrdt.business.application.service.extendplatform.tools.biztools.cadre", (Object)"").put((Object)"kd.hdtc.hrdt.business.application.service.extendplatform.tools.commontools", (Object)"").put((Object)"kd.hdtc.hrdt.business.application.service.extendplatform.tools.common", (Object)"").put((Object)"kd.hdtc.hrdt.business.application.service.extendplatform.base", (Object)"").put((Object)"kd.hdtc.hrdt.business.application.service.transferconf", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.entity", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.extendplatform.tools.commontools", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.extendplatform.tools.commontools.entity", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.file", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.file.entity", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.transfer.configgroup", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.transfer.configitem", (Object)"").put((Object)"kd.hdtc.hrdt.business.domain.common.entity", (Object)"kd.hdtc.hrdt.business.domain.transfer.entity.impl").build();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initServiceMap() {
        if (inited) return;
        Class<ServiceFactory> clazz = ServiceFactory.class;
        synchronized (ServiceFactory.class) {
            if (inited) return;
            SERVICE_MAP.putAll(ServiceFactoryUtils.getServiceInfo(SCAN_PACKAGE_MAP));
            inited = true;
            LOG.info("ServiceFactory inited, {} service inited", (Object)SERVICE_MAP.size());
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static <T> T getService(Class<T> clazz) {
        return (T)ServiceFactory.getService(clazz.getSimpleName());
    }

    public static <T> T createInstance(Class<T> clazz) {
        return (T)TypesContainer.createInstance((String)ServiceFactory.getServiceName(clazz.getSimpleName()));
    }

    public static Object getService(String serviceName) {
        return TypesContainer.getOrRegisterSingletonInstance((String)ServiceFactory.getServiceName(serviceName));
    }

    private static String getServiceName(String serviceName) {
        ServiceFactory.initServiceMap();
        String className = SERVICE_MAP.get(serviceName);
        if (className == null) {
            throw new RuntimeException(String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"ServiceFactory_0", (String)"hdtc-hrdt-business", (Object[])new Object[0]), serviceName));
        }
        return className;
    }
}

