/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.common.metadatafield.parse;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdt.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrdt.business.common.metadatafield.parse.BaseDataMetaDataFieldParser;
import kd.hdtc.hrdt.business.common.metadatafield.parse.ComboMetaDataFieldParser;
import kd.hdtc.hrdt.business.common.metadatafield.parse.DecimalMetaDataFieldParser;
import kd.hdtc.hrdt.business.common.metadatafield.parse.IMetaDataFieldParser;
import kd.hdtc.hrdt.business.common.metadatafield.parse.TextMetaDataFieldParser;

public class MetaDataFieldParserFactory {
    public static final Map<String, String> META_FIELD_MAP = ImmutableMap.builder().put((Object)"kd.bos.metadata.entity.commonfield.TextField", (Object)"TextField").put((Object)"kd.bos.metadata.entity.commonfield.MuliLangTextField", (Object)"MuliLangTextField").put((Object)"kd.bos.metadata.entity.commonfield.LargeTextField", (Object)"LargeTextField").put((Object)"kd.bos.metadata.entity.businessfield.BasedataField", (Object)"BasedataField").put((Object)"kd.bos.metadata.entity.businessfield.MulBasedataField", (Object)"MulBasedataField").put((Object)"kd.bos.metadata.entity.commonfield.DateField", (Object)"DateField").put((Object)"kd.bos.metadata.entity.commonfield.DateTimeField", (Object)"DateTimeField").put((Object)"kd.bos.metadata.entity.commonfield.ComboField", (Object)"ComboField").put((Object)"kd.bos.metadata.entity.commonfield.MulComboField", (Object)"MulComboField").put((Object)"kd.bos.metadata.entity.commonfield.CheckBoxField", (Object)"CheckBoxField").put((Object)"kd.bos.metadata.entity.commonfield.IntegerField", (Object)"IntegerField").put((Object)"kd.bos.metadata.entity.commonfield.BigIntField", (Object)"BigIntField").put((Object)"kd.bos.metadata.entity.commonfield.DecimalField", (Object)"DecimalField").put((Object)"kd.bos.metadata.entity.businessfield.AmountField", (Object)"AmountField").put((Object)"kd.bos.metadata.entity.commonfield.AttachmentField", (Object)"AttachmentField").put((Object)"kd.bos.metadata.form.control.AttachmentPanelAp", (Object)"AttachmentPanelAp").put((Object)"kd.bos.metadata.entity.commonfield.PictureField", (Object)"PictureField").build();
    public static String ATTACHMENT_PANEL_AP_CLASS = "kd.bos.metadata.form.control.AttachmentPanelAp";

    public static IMetaDataFieldParser getMetaDataFieldParser(String fieldType) {
        FieldTypeEnum fieldTypeEnum = FieldTypeEnum.getFieldType(fieldType);
        if (FieldTypeEnum.TEXTFIELD == fieldTypeEnum || FieldTypeEnum.MULILANGTEXTFIELD == fieldTypeEnum || FieldTypeEnum.LARGETEXTFIELD == fieldTypeEnum) {
            return new TextMetaDataFieldParser();
        }
        if (FieldTypeEnum.BASEDATAFIELD == fieldTypeEnum || FieldTypeEnum.MULBASEDATAFIELD == fieldTypeEnum) {
            return new BaseDataMetaDataFieldParser();
        }
        if (FieldTypeEnum.DECIMALFIELD == fieldTypeEnum) {
            return new DecimalMetaDataFieldParser();
        }
        if (FieldTypeEnum.COMBOFIELD == fieldTypeEnum || FieldTypeEnum.MULCOMBOFIELD == fieldTypeEnum) {
            return new ComboMetaDataFieldParser();
        }
        return null;
    }

    public static IMetaDataFieldParser getMetaDataFieldParserByClassName(String fieldClassName) {
        String fieldType = META_FIELD_MAP.get(fieldClassName);
        if (StringUtils.isEmpty((String)fieldType)) {
            return null;
        }
        return MetaDataFieldParserFactory.getMetaDataFieldParser(fieldType);
    }

    public static String getAttachmentPanelClassName() {
        return ATTACHMENT_PANEL_AP_CLASS;
    }
}

