/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.common.metadatafield.parse;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdt.business.common.metadatafield.parse.IMetaDataFieldParser;

public class TextMetaDataFieldParser
implements IMetaDataFieldParser<Map<String, Integer>> {
    private static final String MAX_LENGTH = "MaxLength";
    private static final String MIN_LENGTH = "MinLength";

    @Override
    public Map<String, Integer> parseItems(String fieldConfig) {
        if (StringUtils.isEmpty((String)fieldConfig)) {
            return null;
        }
        Map items = (Map)SerializationUtils.fromJsonString((String)fieldConfig, Map.class);
        return items;
    }

    @Override
    public String parseAlias(String fieldConfig) {
        Object items = this.parseItems(fieldConfig);
        if (CollectionUtils.isNotEmpty((Map)items)) {
            StringBuilder builder = new StringBuilder("[");
            Integer maxLength = (Integer)items.get(MAX_LENGTH);
            Integer minLength = (Integer)items.get(MIN_LENGTH);
            builder.append(minLength).append(",").append(maxLength).append("]");
            return builder.toString();
        }
        return null;
    }

    @Override
    public String getMetaDataNumber() {
        return "hrdt_text_page";
    }

    @Override
    public String fieldConfigContent(EntityItem<?> entityItem) {
        HashMap items = Maps.newHashMapWithExpectedSize((int)4);
        if (entityItem instanceof TextField) {
            TextField textField = (TextField)entityItem;
            items.put(MIN_LENGTH, textField.getMinLength());
            items.put(MAX_LENGTH, textField.getMaxLength());
        }
        return SerializationUtils.toJsonString((Object)items);
    }
}

