/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.common.model.confitem;

import com.alibaba.fastjson.JSONArray;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdt.business.common.model.confitem.EntityBo;
import kd.hdtc.hrdt.business.common.model.confitem.EntityPropertyTypeEnum;
import kd.hdtc.hrdt.business.common.model.confitem.EntityRelF7FilterBo;
import kd.hdtc.hrdt.business.common.model.confitem.F7DataParamBo;
import kd.hdtc.hrdt.business.common.model.confitem.F7FieldValidBo;
import kd.hdtc.hrdt.business.common.model.confitem.FieldBo;
import kd.hdtc.hrdt.business.common.model.confitem.MainEntityBo;
import kd.hdtc.hrdt.business.common.model.confitem.RelEntityBo;
import kd.hdtc.hrdt.business.common.model.confitem.RowDataBo;
import kd.hdtc.hrdt.business.common.model.confitem.RowDataValidCueBo;
import kd.hdtc.hrdt.business.common.utils.confItem.ConfItemUtils;
import kd.hdtc.hrdt.business.domain.common.entity.impl.CommonServiceImpl;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfItemValidBo {
    private String confItemEntityNumber;
    private List<RowDataValidCueBo> f7RowDataValidCueBoList = new ArrayList<RowDataValidCueBo>(10);
    private boolean isAllSuccess = true;
    private Long curUserId = RequestContext.get().getCurrUserId();
    private String langName = RequestContext.get().getLang().name();
    private Map<Object, RowDataBo> confItemRowDataMap = new HashMap<Object, RowDataBo>(16);
    private EntityBo entityBo = new EntityBo();

    public ConfItemValidBo() {
    }

    public ConfItemValidBo(String confItemEntityNumber) {
        this.confItemEntityNumber = confItemEntityNumber;
    }

    public ConfItemValidBo validConfItemData(MainEntityBo confItemEntityBo) {
        List<RowDataBo> rowDataBoList = confItemEntityBo.getRowDataBoList();
        Map<String, String> confItemF7ProVsF7EntityNumMap = confItemEntityBo.getRelF7ProVsF7EntityNumMap();
        String confItemEntityNumber = confItemEntityBo.getEntityNumber();
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)confItemEntityNumber);
        Set<String> relF7ProSet = confItemEntityBo.getRelF7ProSet();
        this.validEntityRelF7Data(confItemEntityNumber, confItemEntityNumber, rowDataBoList, confItemF7ProVsF7EntityNumMap, true);
        List<RelEntityBo> relEntityBoList = confItemEntityBo.getRelEntityBoList();
        for (RelEntityBo relEntityBo : relEntityBoList) {
            String relEntityNumber = relEntityBo.getEntityNumber();
            Map<String, String> relEntityF7ProVsF7EntityNumMap = confItemEntityBo.getRelF7ProVsF7EntityNumMap();
            List<RowDataBo> relEntityRowDataBoList = relEntityBo.getRowDataBoList();
            this.validEntityRelF7Data(confItemEntityNumber, relEntityNumber, relEntityRowDataBoList, relEntityF7ProVsF7EntityNumMap, false);
        }
        return this;
    }

    public DynamicObject[] loadBaseDataFromDB(String entityType, List<Object> idList, List<String> numberList) {
        if (entityType == null || ObjectUtils.isEmpty(idList)) {
            return null;
        }
        String selectedProperties = "id";
        CommonServiceImpl serviceHelper = new CommonServiceImpl(entityType);
        BasedataEntityType dataEntityType = (BasedataEntityType)MetadataUtils.getMainEntityType((String)entityType);
        QFilter filter = new QFilter("id", "in", idList);
        if (this.entityContainsNumber(dataEntityType)) {
            selectedProperties = selectedProperties + ",number";
            if (!ObjectUtils.isEmpty(numberList)) {
                filter.or(new QFilter("number", "in", numberList));
            }
        }
        return serviceHelper.query(selectedProperties, new QFilter[]{filter});
    }

    public boolean entityContainsNumber(BasedataEntityType dataEntityType) {
        DataEntityPropertyCollection properties = dataEntityType.getProperties();
        IDataEntityProperty numberProp = (IDataEntityProperty)properties.get((Object)"number");
        return Objects.nonNull(numberProp) && HRStringUtils.isNotEmpty((String)numberProp.getAlias());
    }

    private void validEntityRelF7Data(String confItemEntityNum, String entityNumber, List<RowDataBo> rowDataBoList, Map<String, String> f7ProVsF7EntityNumMap, boolean isMainEntity) {
        boolean ctrEntity = this.entityBo.isCtrEntity(entityNumber);
        for (Map.Entry<String, String> f7Entry : f7ProVsF7EntityNumMap.entrySet()) {
            String proName = f7Entry.getKey();
            String baseEntityId = f7Entry.getValue();
            if (CollectionUtils.isEmpty(rowDataBoList) || StringUtils.isBlank((CharSequence)proName)) {
                return;
            }
            EntityRelF7FilterBo relF7FilterBo = this.getEntityRelF7FilterBo(rowDataBoList, proName);
            F7DataParamBo f7DataParamBo = new F7DataParamBo(confItemEntityNum, entityNumber, proName);
            f7DataParamBo.setProName(proName).setF7EntityNumber(baseEntityId).setConfItemEntity(isMainEntity);
            f7DataParamBo.setFieldType(ConfItemUtils.getRelFieldKeyType(entityNumber, proName));
            if (CollectionUtils.isEmpty(relF7FilterBo.getIdList())) continue;
            Object[] baseDataDynArr = this.loadBaseDataFromDB(baseEntityId, relF7FilterBo.getIdList(), relF7FilterBo.getNumberList());
            if (ObjectUtils.isEmpty((Object[])baseDataDynArr)) {
                rowDataBoList.forEach(rowDataBo -> {
                    RowDataValidCueBo rowDataValidCueBo = new RowDataValidCueBo(entityNumber, isMainEntity);
                    rowDataValidCueBo.setValidSuccess(false);
                    F7FieldValidBo f7FieldValidBo = new F7FieldValidBo(baseEntityId, proName);
                    f7FieldValidBo.setF7ProDisplayName(this.entityBo.getProDisplayName(entityNumber, proName));
                    f7FieldValidBo.setRelF7Exist(false);
                    rowDataValidCueBo.getF7FieldValidBoList().add(f7FieldValidBo);
                    this.assemblyValidFailCueBoList(f7DataParamBo, (RowDataBo)rowDataBo, rowDataValidCueBo);
                });
                continue;
            }
            HashSet<Object> dbRelF7IdSet = new HashSet<Object>(16);
            HashSet<String> dbRelF7NumSet = new HashSet<String>(16);
            HashMap<String, Object> dbF7EntityIdVsNumMap = new HashMap<String, Object>(16);
            Arrays.stream(baseDataDynArr).forEach(dyn -> {
                String f7Number = dyn.getString("number");
                Object f7Id = dyn.get("id");
                dbRelF7IdSet.add(dyn.get("id"));
                dbRelF7NumSet.add(f7Number);
                dbF7EntityIdVsNumMap.put(f7Number, f7Id);
            });
            HashMap<Object, Boolean> entityOrgCtrInfo = new HashMap(16);
            if (ctrEntity && "bos_org".equals(baseEntityId)) {
                entityOrgCtrInfo = this.entityBo.getEntityOrgCtrInfo(entityNumber, dbRelF7IdSet);
            }
            f7DataParamBo.setDbF7NumberVsIdMap(dbF7EntityIdVsNumMap).setDbRelF7IdSet(dbRelF7IdSet).setDbRelF7NumSet(dbRelF7NumSet);
            this.validF7Data(rowDataBoList, entityOrgCtrInfo, f7DataParamBo);
        }
    }

    private void validF7Data(List<RowDataBo> rowDataBoList, Map<Object, Boolean> entityOrgCtrInfo, F7DataParamBo f7DataParamBo) {
        Boolean confItemEntity = f7DataParamBo.getConfItemEntity();
        String mainEntityNumber = f7DataParamBo.getMainEntityNumber();
        boolean ctrEntity = this.entityBo.isCtrEntity(mainEntityNumber);
        for (RowDataBo rowDataBo : rowDataBoList) {
            List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
            RowDataValidCueBo rowDataValidCueBo = new RowDataValidCueBo(mainEntityNumber, confItemEntity);
            if (confItemEntity.booleanValue()) {
                rowDataValidCueBo.setConfItemEntityNumber(mainEntityNumber);
            }
            for (FieldBo fieldBo : fieldBoList) {
                F7FieldValidBo f7FieldValidBo = new F7FieldValidBo(f7DataParamBo.getF7EntityNumber(), f7DataParamBo.getProName());
                String fieldName = fieldBo.getFieldName();
                String fieldType = fieldBo.getFieldType();
                if (StringUtils.isBlank((CharSequence)fieldType)) continue;
                f7FieldValidBo.setF7ProDisplayName(this.entityBo.getProDisplayName(f7DataParamBo.getMainEntityNumber(), fieldName));
                if (f7DataParamBo.getProName().equals(fieldName) && EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(fieldType)) {
                    List f7BoList = JSONArray.parseArray((String)fieldBo.getFieldValue().toString(), FieldBo.class);
                    Object f7PkIdVal = ((FieldBo)f7BoList.get(0)).getFieldValue();
                    String f7NumberVal = ((FieldBo)f7BoList.get(1)).getFieldValue().toString();
                    f7DataParamBo.setF7PkIdVal(f7PkIdVal).setF7NumberVal(f7NumberVal).setF7BoList(f7BoList);
                    this.comparisonF7DataAndUpdate(fieldBo, f7DataParamBo, f7FieldValidBo);
                    if (ctrEntity && !ObjectUtils.isEmpty(entityOrgCtrInfo) && f7FieldValidBo.isRelF7Exist() && !entityOrgCtrInfo.get(Long.parseLong(f7PkIdVal.toString())).booleanValue()) {
                        f7FieldValidBo.setBuInCtrRangeExist(false);
                    }
                } else if (f7DataParamBo.getProName().equals(fieldName) && EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(fieldType)) {
                    f7DataParamBo.setFieldType(EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType());
                    List mulBaseRowDataBoList = JSONArray.parseArray((String)fieldBo.getFieldValue().toString(), RowDataBo.class);
                    ArrayList allMulBaseDataFieldBoList = new ArrayList(10);
                    for (RowDataBo mulBaseRowDataBo : mulBaseRowDataBoList) {
                        allMulBaseDataFieldBoList.addAll(mulBaseRowDataBo.getFieldBoList().stream().filter(bo -> "fbasedataid".equals(bo.getFieldName())).collect(Collectors.toList()));
                    }
                    List<FieldBo> f7BoList = f7DataParamBo.getF7BoList();
                    for (FieldBo mulBaseFieldBo : allMulBaseDataFieldBoList) {
                        Object mulMulBaseFieldValue = mulBaseFieldBo.getFieldValue();
                        f7BoList.addAll(JSONArray.parseArray((String)mulMulBaseFieldValue.toString(), FieldBo.class));
                    }
                    this.comparisonF7DataAndUpdate(fieldBo, f7DataParamBo, f7FieldValidBo);
                } else if (fieldType.equals(EntityPropertyTypeEnum.ENTRY_PROP.getByType())) {
                    List entryRowDataBoList = JSONArray.parseArray((String)fieldBo.getFieldValue().toString(), RowDataBo.class);
                    this.comparisonEntryF7DataAndUpdate(f7DataParamBo, f7FieldValidBo, fieldName, entryRowDataBoList);
                }
                if (f7FieldValidBo.isRelF7Exist() && f7FieldValidBo.isBuInCtrRangeExist()) continue;
                List<F7FieldValidBo> f7FieldValidBoList = rowDataValidCueBo.getF7FieldValidBoList();
                f7FieldValidBoList.add(f7FieldValidBo);
                rowDataValidCueBo.setValidSuccess(false);
                break;
            }
            this.confItemRowDataMap.put(rowDataBo.getPkId(), rowDataBo);
            this.assemblyValidFailCueBoList(f7DataParamBo, rowDataBo, rowDataValidCueBo);
        }
    }

    private void assemblyValidFailCueBoList(F7DataParamBo f7DataParamBo, RowDataBo rowDataBo, RowDataValidCueBo rowDataValidCueBo) {
        if (!rowDataValidCueBo.getValidSuccess().booleanValue()) {
            String f7ProNotExists = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u5b9e\u4f53\u4e3a{0}\uff0c\u6570\u636eid\u4e3a{1}\uff0c\u6570\u636e\u6807\u8bc6\u4e3a{2}\uff0c\u5f15\u7528\u57fa\u7840\u8d44\u6599\u201c{3}\u201d\u4e0d\u5b58\u5728", (String)"ConfItemValidBo_0", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
            String buInCtrRangeNotExist = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u5b9e\u4f53\u4e3a{0}\uff0c\u6570\u636eid\u4e3a{1}\uff0c\u6570\u636e\u6807\u8bc6\u4e3a{2}\uff0c\u521b\u5efa\u7ec4\u7ec7\u3001\u4f7f\u7528\u7ec4\u7ec7\u5728\u6240\u5c5e\u7ba1\u7406\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"ConfItemValidBo_1", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
            String relF7ProNotExists = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u5b9e\u4f53\u4e3a{0}\uff0c\u6570\u636eid\u4e3a{1}\uff0c\u6570\u636e\u6807\u8bc6\u4e3a{2}\u7684\u5173\u8054\u7684\u5b9e\u4f53\u4e3a{3}\uff0c\u5f15\u7528\u57fa\u7840\u8d44\u6599\u201c{4}\u201d\u4e0d\u5b58\u5728", (String)"ConfItemValidBo_2", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
            String relBuInCtrRangeNotExist = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u5b9e\u4f53\u4e3a{0}\uff0c\u6570\u636eid\u4e3a{1}\uff0c\u6570\u636e\u6807\u8bc6\u4e3a{2}\u7684\u5173\u8054\u7684\u5b9e\u4f53\u4e3a{3}\u7684\u6570\u636e\u6807\u8bc6{4}\uff0c\u521b\u5efa\u7ec4\u7ec7\u3001\u4f7f\u7528\u7ec4\u7ec7\u5728\u6240\u5c5e\u7ba1\u7406\u89c6\u56fe\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (String)"ConfItemValidBo_3", (String)"hdtc-hrdt-business", (Object[])new Object[0]);
            String mainEntityNumber = f7DataParamBo.getMainEntityNumber();
            String entityDataIde = this.getEntityDataIde(f7DataParamBo.getContainNameField(), f7DataParamBo.getContainNumberField(), rowDataBo.getFieldBoList());
            List<F7FieldValidBo> f7FieldValidBoList = rowDataValidCueBo.getF7FieldValidBoList();
            List<F7FieldValidBo> f7FieldNotExistList = f7FieldValidBoList.stream().filter(f7FieldValidBo -> !f7FieldValidBo.isRelF7Exist()).collect(Collectors.toList());
            List buInCtrRangeNotExistList = f7FieldValidBoList.stream().filter(f7FieldValidBo -> !f7FieldValidBo.isBuInCtrRangeExist()).collect(Collectors.toList());
            if (f7DataParamBo.getConfItemEntity().booleanValue()) {
                if (CollectionUtils.isNotEmpty(f7FieldNotExistList)) {
                    String f7FieldNotExistStr = this.getF7FieldValidFailStr(f7FieldNotExistList);
                    rowDataValidCueBo.getF7ProNotExistsSb().append(MessageFormat.format(f7ProNotExists, f7DataParamBo.getConfItemEntityNum(), rowDataBo.getPkId(), entityDataIde, f7FieldNotExistStr)).append("\r\n");
                }
                if (CollectionUtils.isNotEmpty(buInCtrRangeNotExistList)) {
                    rowDataValidCueBo.getBuInCtrRangeNotExistSb().append(MessageFormat.format(buInCtrRangeNotExist, f7DataParamBo.getConfItemEntityNum(), rowDataBo.getPkId(), entityDataIde)).append("\r\n");
                }
            } else {
                String confItemIdStr = rowDataBo.getStructLongId().split("!")[0];
                RowDataBo confItemRowDataBo = this.confItemRowDataMap.get(confItemIdStr);
                String confItemEntityDataIde = this.getEntityDataIde(f7DataParamBo.getContainNameField(), f7DataParamBo.getContainNumberField(), confItemRowDataBo.getFieldBoList());
                rowDataValidCueBo.setConfItemEntityNumber(f7DataParamBo.getConfItemEntityNum()).setConfItemDataPkId(confItemIdStr).setConfItemDataIde(confItemEntityDataIde);
                rowDataValidCueBo.setEntityNumber(mainEntityNumber).setEntityDataPkId(rowDataBo.getPkId()).setEntityDataIde(entityDataIde);
                if (CollectionUtils.isNotEmpty(f7FieldNotExistList)) {
                    String f7FieldNotExistStr = this.getF7FieldValidFailStr(f7FieldNotExistList);
                    rowDataValidCueBo.getF7ProNotExistsSb().append(MessageFormat.format(relF7ProNotExists, f7DataParamBo.getConfItemEntityNum(), confItemRowDataBo.getPkId(), confItemEntityDataIde, f7DataParamBo.getMainEntityNumber(), f7FieldNotExistStr)).append("\r\n");
                }
                if (CollectionUtils.isNotEmpty(buInCtrRangeNotExistList)) {
                    rowDataValidCueBo.getBuInCtrRangeNotExistSb().append(MessageFormat.format(relBuInCtrRangeNotExist, f7DataParamBo.getConfItemEntityNum(), confItemRowDataBo.getPkId(), confItemEntityDataIde, f7DataParamBo.getMainEntityNumber(), rowDataBo.getPkId())).append("\r\n");
                }
            }
            this.f7RowDataValidCueBoList.add(rowDataValidCueBo);
        }
    }

    public String getF7FieldValidFailStr(List<F7FieldValidBo> f7FieldValidBoList) {
        StringBuilder f7FieldValidSb = new StringBuilder();
        f7FieldValidBoList.forEach(f7FieldValidBo -> f7FieldValidSb.append(f7FieldValidBo.getF7ProName()).append("(").append(f7FieldValidBo.getF7ProDisplayName()).append(")").append(";"));
        return f7FieldValidSb.toString();
    }

    private String getEntityDataIde(boolean isContainNameField, boolean isContainNumberField, List<FieldBo> fieldBoList) {
        String entityDataIde = "";
        if (CollectionUtils.isEmpty(fieldBoList)) {
            return entityDataIde;
        }
        for (FieldBo fieldBo : fieldBoList) {
            if (!isContainNameField || !"name".equals(fieldBo.getFieldName())) continue;
            List mulLangFieldBoList = JSONArray.parseArray((String)fieldBo.getFieldValue().toString(), FieldBo.class);
            FieldBo localFieldBo = mulLangFieldBoList.stream().filter(bo -> this.langName.equals(bo.getFieldName())).findAny().get();
            entityDataIde = (String)localFieldBo.getFieldValue();
        }
        if (StringUtils.isBlank((CharSequence)entityDataIde) && isContainNumberField) {
            for (FieldBo fieldBo : fieldBoList) {
                if (!"number".equals(fieldBo.getFieldName())) continue;
                entityDataIde = (String)fieldBo.getFieldValue();
            }
        }
        return entityDataIde;
    }

    private void comparisonEntryF7DataAndUpdate(F7DataParamBo f7DataParamBo, F7FieldValidBo f7FieldValidBo, String fieldName, List<RowDataBo> entryRowDataBoList) {
        for (RowDataBo entryRowBo : entryRowDataBoList) {
            for (FieldBo entryFbo : entryRowBo.getFieldBoList()) {
                String entryFboType = entryFbo.getFieldType();
                if (StringUtils.isNotBlank((CharSequence[])new CharSequence[]{entryFboType}) || !EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(entryFboType) || !f7DataParamBo.getProName().equals(fieldName)) continue;
                this.comparisonF7DataAndUpdate(entryFbo, f7DataParamBo, f7FieldValidBo);
            }
        }
    }

    private void comparisonF7DataAndUpdate(FieldBo fieldBo, F7DataParamBo f7DataParamBo, F7FieldValidBo f7FieldValidBo) {
        Map<String, Object> dbF7EntityIdVsNumMap = f7DataParamBo.getDbF7NumberVsIdMap();
        Set<Object> dbRelF7IdSet = f7DataParamBo.getDbRelF7IdSet();
        Set<String> dbRelF7NumSet = f7DataParamBo.getDbRelF7NumSet();
        String f7NumberVal = f7DataParamBo.getF7NumberVal();
        String proName = f7DataParamBo.getProName();
        Object f7PkIdVal = f7DataParamBo.getF7PkIdVal();
        List<FieldBo> f7BoList = f7DataParamBo.getF7BoList();
        if (EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType()) && dbRelF7IdSet.contains(f7PkIdVal)) {
            return;
        }
        if (EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            ArrayList<Object> mulBaseIdList = new ArrayList<Object>(10);
            List<FieldBo> mulBaseFieldBoList = f7DataParamBo.getF7BoList();
            for (FieldBo mulBaseFieldBo : mulBaseFieldBoList) {
                if (!"fbasedataid".equals(mulBaseFieldBo.getFieldName())) continue;
                mulBaseIdList.add(mulBaseFieldBo.getFieldValue());
            }
        }
        if (EntityPropertyTypeEnum.BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType()) && dbRelF7NumSet.contains(f7NumberVal)) {
            Object dbF7Id = dbF7EntityIdVsNumMap.get(f7NumberVal);
            f7BoList.get(0).setFieldValue(dbF7Id);
            f7BoList.get(0).setRelF7IdVal(dbF7Id);
            fieldBo.setRelF7IdVal(dbF7Id);
            fieldBo.setFieldValue(f7BoList);
            return;
        }
        if (!EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType().equals(f7DataParamBo.getFieldType())) {
            if ("creator".equals(proName) || "modifier".equals(proName) || "disabler".equals(proName)) {
                f7FieldValidBo.setRelF7Exist(true);
                fieldBo.setRelF7IdVal(this.curUserId);
                fieldBo.setFieldValue(f7BoList);
                return;
            }
            f7FieldValidBo.setRelF7Exist(false);
        }
    }

    private EntityRelF7FilterBo getEntityRelF7FilterBo(List<RowDataBo> rowDataBoList, String proName) {
        EntityRelF7FilterBo relF7FilterBo = new EntityRelF7FilterBo();
        if (CollectionUtils.isEmpty(rowDataBoList)) {
            return relF7FilterBo;
        }
        List<FieldBo> relF7FieldBoList = ConfItemUtils.getRelF7FieldBoByPropName(rowDataBoList, proName);
        for (FieldBo f7FieldBo : relF7FieldBoList) {
            if ("id".equals(f7FieldBo.getFieldName())) {
                relF7FilterBo.getIdList().add(f7FieldBo.getFieldValue());
                continue;
            }
            relF7FilterBo.getNumberList().add(f7FieldBo.getFieldValue().toString());
        }
        return relF7FilterBo;
    }

    private Map<String, String> getEntityF7FieldNumVsNameMap(String entityNumber, MainEntityType mainEntityType) {
        HashMap<String, String> entityFieldNumVsNameMap = new HashMap<String, String>(16);
        for (IDataEntityProperty prop : mainEntityType.getProperties()) {
            if (prop instanceof BasedataProp) {
                this.getF7ProFieldNumVsNameMap(entityFieldNumVsNameMap, prop);
                continue;
            }
            if (!(prop instanceof EntryProp)) continue;
            DataEntityPropertyCollection entryItemTypeCol = ((EntryProp)prop).getItemType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : entryItemTypeCol) {
                if (!(iDataEntityProperty instanceof BasedataProp)) continue;
                this.getF7ProFieldNumVsNameMap(entityFieldNumVsNameMap, iDataEntityProperty);
            }
        }
        return entityFieldNumVsNameMap;
    }

    private void getF7ProFieldNumVsNameMap(Map<String, String> entityFieldNumVsName, IDataEntityProperty prop) {
        String fieldNumber = prop.getName();
        LocaleString displayName = prop.getDisplayName();
        String fieldName = displayName.getLocaleValue();
        entityFieldNumVsName.put(fieldNumber, fieldName);
    }

    public String getConfItemEntityNumber() {
        return this.confItemEntityNumber;
    }

    public void setConfItemEntityNumber(String confItemEntityNumber) {
        this.confItemEntityNumber = confItemEntityNumber;
    }

    public boolean isAllSuccess() {
        return this.isAllSuccess;
    }

    public void setAllSuccess(boolean allSuccess) {
        this.isAllSuccess = allSuccess;
    }

    public List<RowDataValidCueBo> getF7RowDataValidCueBoList() {
        return this.f7RowDataValidCueBoList;
    }

    public void setF7RowDataValidCueBoList(List<RowDataValidCueBo> f7RowDataValidCueBoList) {
        this.f7RowDataValidCueBoList = f7RowDataValidCueBoList;
    }
}

