/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.common.model.confitem;

import com.alibaba.fastjson.JSONArray;
import com.google.common.base.Joiner;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.sqlscript.PreInsDataScriptBuilder;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.platform.MetadataUtils;
import kd.hdtc.hrdt.business.common.model.confitem.CtrlRelTableBo;
import kd.hdtc.hrdt.business.common.model.confitem.EntityPropertyTypeEnum;
import kd.hdtc.hrdt.business.common.model.confitem.FieldBo;
import kd.hdtc.hrdt.business.common.model.confitem.HisEventBo;
import kd.hdtc.hrdt.business.common.model.confitem.RowDataBo;
import kd.hdtc.hrdt.business.domain.common.entity.impl.CommonServiceImpl;
import kd.hdtc.hrdt.business.domain.transfer.configitem.model.TransferDataBo;
import kd.hr.hbp.business.domain.service.impl.newhismodel.HisCommonService;
import kd.hr.hbp.business.domain.service.impl.newhismodel.revocation.HisModelEventDataService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.constants.newhismodel.EnumEntityTpl;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class EntityBo
implements Serializable {
    private static final Log LOG = LogFactory.getLog(EntityBo.class);
    private static final long serialVersionUID = 6422184573884861517L;
    private String parentEntity;
    private Boolean isControlMod;
    private Boolean isHisMod;
    private Boolean isNeedAllHis;
    private String appId;
    private String entityNumber;
    private String dbRouteKey;
    private Set<String> relF7ProSet = new HashSet<String>();
    private Map<String, String> relF7ProVsF7EntityNumMap = new HashMap<String, String>();
    private List<CtrlRelTableBo> ctrlRelTableBoList = new ArrayList<CtrlRelTableBo>();
    private List<HisEventBo> hisEventBoList = new ArrayList<HisEventBo>();
    private List<RowDataBo> rowDataBoList = new ArrayList<RowDataBo>();
    private String mainTableName;
    private Map<String, Boolean> ctrlEntityMap = new HashMap<String, Boolean>(16);

    public EntityBo() {
    }

    public EntityBo(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public EntityBo(String entityNumber, String parentEntity, Boolean isNeedAllHis) {
        this.entityNumber = entityNumber;
        this.parentEntity = parentEntity;
        this.isNeedAllHis = isNeedAllHis;
    }

    public void generateEntityData(List<TransferDataBo> transferDataBoList) {
        this.analysisEntityInfo(transferDataBoList);
        QFilter dataFilter = this.getTransferEntityDataFilter(transferDataBoList);
        CommonServiceImpl entityService = new CommonServiceImpl(this.entityNumber);
        DynamicObject[] entityDataArr = entityService.loadDynamicObjectArray(new QFilter[]{dataFilter});
        if (entityDataArr == null) {
            LOG.info("generateEntityFieldData,entityDataArr is null");
            return;
        }
        if (this.isHisMod.booleanValue()) {
            this.queryHisEventData(entityDataArr);
        }
        if (this.isControlMod.booleanValue()) {
            this.queryCtrRelTableData(entityDataArr);
        }
        this.handleDataInfo(entityDataArr);
        this.handleStructLongId(transferDataBoList);
        this.setRowDataIdx(transferDataBoList);
    }

    protected void handleDataInfo(DynamicObject[] entityDataArr) {
        Arrays.stream(entityDataArr).forEach(dyn -> {
            RowDataBo rowDataBo = this.convertDynToRowBo((DynamicObject)dyn);
            rowDataBo.setPkId(dyn.get("id"));
            if (this.isHisMod.booleanValue()) {
                rowDataBo.setBoId(dyn.getLong("boid"));
            }
            this.rowDataBoList.add(rowDataBo);
        });
    }

    protected void handleStructLongId(List<TransferDataBo> transferDataBoList) {
        for (RowDataBo rowDataBo : this.rowDataBoList) {
            rowDataBo.setStructLongId(rowDataBo.getPkId().toString());
        }
    }

    protected void setRowDataIdx(List<TransferDataBo> transferDataBoList) {
    }

    private void analysisEntityInfo(List<TransferDataBo> transferDataBoList) {
        TransferDataBo transferDataBo = transferDataBoList.get(0);
        MainEntityType dataEntityType = transferDataBo.getDataEntityType();
        this.dbRouteKey = dataEntityType.getDBRouteKey();
        this.appId = dataEntityType.getAppId();
        this.isControlMod = this.isCtrEntity(this.entityNumber);
        this.isHisMod = this.isHisModEntity(this.entityNumber);
        this.mainTableName = dataEntityType.getAlias();
        this.analysisEntityAllRefF7Pro(dataEntityType);
        this.analysisOtherBiz();
    }

    public void queryCtrRelTableData(DynamicObject[] entityDataArr) {
        CtrlRelTableBo ctrlRelTableUBo;
        CtrlRelTableBo ctrlRelTableExcBo;
        List<Long> entityDataIdList = Arrays.stream(entityDataArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toList());
        CtrlRelTableBo ctrlRelTableUserEgBo = this.getTableKsqlData(this.mainTableName + "usereg", "FDATAID", entityDataIdList);
        if (!ObjectUtils.isEmpty((Object)ctrlRelTableUserEgBo)) {
            this.ctrlRelTableBoList.add(ctrlRelTableUserEgBo);
        }
        if (!ObjectUtils.isEmpty((Object)(ctrlRelTableExcBo = this.getTableKsqlData(this.mainTableName + "exc", "FDATAID", entityDataIdList)))) {
            this.ctrlRelTableBoList.add(ctrlRelTableExcBo);
        }
        if (!ObjectUtils.isEmpty((Object)(ctrlRelTableUBo = this.getTableKsqlData(this.mainTableName + "_u", "FDATAID", entityDataIdList)))) {
            this.ctrlRelTableBoList.add(ctrlRelTableUBo);
        }
    }

    public void queryHisEventData(DynamicObject[] mainEntityDataArr) {
        DynamicObject dyEventGroup;
        Set<Long> vidSet = Arrays.stream(mainEntityDataArr).map(dyn -> dyn.getLong("id")).collect(Collectors.toSet());
        if (!ObjectUtils.isEmpty(vidSet) && (dyEventGroup = HisModelEventDataService.getInstance().getEventGroupDyByEntity(this.entityNumber)) != null) {
            DynamicObject dyEvent = dyEventGroup.getDynamicObject("evententity");
            DynamicObject dyBsEvent = dyEventGroup.getDynamicObject("busevententity");
            DynamicObject dyVersionEvent = dyEventGroup.getDynamicObject("hisevententity");
            String eventEntityNumber = dyEvent.getString("number");
            String bussEventEntityNumber = dyBsEvent.getString("number");
            String versionEventEntityNumber = dyVersionEvent.getString("number");
            CommonServiceImpl eventServiceHelper = new CommonServiceImpl(eventEntityNumber);
            CommonServiceImpl bussEventServiceHelper = new CommonServiceImpl(bussEventEntityNumber);
            CommonServiceImpl versionEventServiceHelper = new CommonServiceImpl(versionEventEntityNumber);
            Object[] versionEventDataArr = versionEventServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("vid", "in", (Object)vidSet.toArray(new Long[0]))});
            if (ObjectUtils.isEmpty((Object[])versionEventDataArr)) {
                return;
            }
            this.setHisEventBoList(versionEventEntityNumber, (DynamicObject[])versionEventDataArr);
            Set bizIds = Arrays.stream(versionEventDataArr).map(data -> data.getLong("busievent")).collect(Collectors.toSet());
            Object[] dyBussEvents = bussEventServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", bizIds)});
            if (ObjectUtils.isEmpty((Object[])dyBussEvents)) {
                return;
            }
            this.setHisEventBoList(bussEventEntityNumber, (DynamicObject[])dyBussEvents);
            Set eventIdSet = Arrays.stream(dyBussEvents).map(data -> data.getLong("event")).collect(Collectors.toSet());
            Object[] eventDynArr = eventServiceHelper.loadDynamicObjectArray(new QFilter[]{new QFilter("id", "in", eventIdSet)});
            if (!ObjectUtils.isEmpty((Object[])eventDynArr)) {
                this.setHisEventBoList(eventEntityNumber, (DynamicObject[])eventDynArr);
            }
        }
    }

    private void setHisEventBoList(String hisEventEntityNum, DynamicObject[] eventDataArr) {
        HisEventBo verHisEventBo = new HisEventBo(this.entityNumber, this.appId, this.dbRouteKey, hisEventEntityNum);
        ArrayList<RowDataBo> versionEvenBotList = new ArrayList<RowDataBo>(10);
        Arrays.stream(eventDataArr).forEach(dyn -> {
            RowDataBo rowDataBo = this.convertDynToRowBo((DynamicObject)dyn);
            rowDataBo.setPkId(dyn.getLong("id"));
            versionEvenBotList.add(rowDataBo);
        });
        verHisEventBo.setRowDataBoList(versionEvenBotList);
        this.hisEventBoList.add(verHisEventBo);
    }

    public CtrlRelTableBo getTableKsqlData(String tableName, String filterField, List<Long> entityDataIdList) {
        StringBuilder strWhere;
        if (HRStringUtils.isEmpty((String)tableName)) {
            return null;
        }
        CtrlRelTableBo ctrlRelTableBo = new CtrlRelTableBo(this.entityNumber, this.appId, this.dbRouteKey);
        DBRoute dbRoute = DBRoute.of((String)this.dbRouteKey);
        if (DB.exitsTable((DBRoute)dbRoute, (String)tableName)) {
            strWhere = new StringBuilder();
            if (!ObjectUtils.isEmpty(entityDataIdList) && HRStringUtils.isNotEmpty((String)filterField)) {
                strWhere.append(filterField).append(" in (").append(Joiner.on((char)',').join(entityDataIdList)).append(") ");
            }
        } else {
            return null;
        }
        PreInsDataScriptBuilder preInsDataScriptBuilder = new PreInsDataScriptBuilder();
        List columnNames = DB.getColumnNames((DBRoute)dbRoute, (String)tableName);
        String ksql = preInsDataScriptBuilder.genInsertSQLScript(dbRoute, tableName, String.join((CharSequence)",", columnNames), strWhere.toString(), null, null).get("sql").toString();
        ctrlRelTableBo.setTableName(tableName);
        ctrlRelTableBo.setKsql(ksql);
        return ctrlRelTableBo;
    }

    private QFilter getTransferEntityDataFilter(List<TransferDataBo> transferDataBoList) {
        QFilter filter = null;
        if (ObjectUtils.isEmpty(transferDataBoList)) {
            return null;
        }
        for (TransferDataBo entityFilterBo : transferDataBoList) {
            String cpFieldPro = entityFilterBo.getFieldKey();
            if (filter != null) continue;
            if (this.isHisMod.booleanValue() && "id".equals(cpFieldPro)) {
                filter = new QFilter("boid", "in", entityFilterBo.getFieldValueList());
                continue;
            }
            filter = new QFilter(entityFilterBo.getFieldKey(), entityFilterBo.getCp(), entityFilterBo.getFieldValueList());
        }
        if (filter == null) {
            return null;
        }
        if (this.isHisMod.booleanValue() && !this.isNeedAllHis.booleanValue()) {
            filter.and(new QFilter("datastatus", "=", (Object)"1"));
        }
        return filter;
    }

    public RowDataBo convertDynToRowBo(DynamicObject dyn) {
        if (dyn == null) {
            return null;
        }
        DataEntityPropertyCollection dePros = dyn.getDataEntityType().getProperties();
        if (dePros == null || dePros.size() == 0) {
            return null;
        }
        RowDataBo rowDataBo = new RowDataBo();
        List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
        for (IDataEntityProperty pro : dePros) {
            String proName = pro.getName();
            Object value = dyn.get(proName);
            if (ObjectUtils.isEmpty((Object)value) || proName.endsWith("_id")) continue;
            FieldBo fieldBo = new FieldBo();
            if (value instanceof DynamicObject) {
                this.setBaseData(proName, (DynamicObject)value, fieldBo);
            } else if (value instanceof DynamicObjectCollection && pro instanceof EntryProp) {
                ArrayList<RowDataBo> entryRowBoList = new ArrayList<RowDataBo>(10);
                DynamicObjectCollection dyEntryCol = (DynamicObjectCollection)value;
                for (DynamicObject dyEntry : dyEntryCol) {
                    entryRowBoList.add(this.convertDynToRowBo(dyEntry));
                }
                fieldBo.setFieldName(proName).setFieldValue(entryRowBoList);
                fieldBo.setFieldType(EntityPropertyTypeEnum.ENTRY_PROP.getByType());
            } else if (pro instanceof MuliLangTextProp) {
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)value;
                ArrayList<FieldBo> mulFieldBoList = new ArrayList<FieldBo>(10);
                for (Map.Entry ormLocal : ormLocaleValue.entrySet()) {
                    FieldBo mulFieldBo = new FieldBo();
                    mulFieldBo.setFieldName((String)ormLocal.getKey()).setFieldValue(ormLocal.getValue());
                    mulFieldBoList.add(mulFieldBo);
                }
                fieldBo.setFieldName(proName).setFieldValue(mulFieldBoList);
                fieldBo.setFieldType(EntityPropertyTypeEnum.MUL_I_LANG_TEXT_PROP.getByType());
            } else if (pro instanceof DateTimeProp || pro instanceof DateProp) {
                this.setDateTypeData(proName, value, fieldBo);
            } else if (pro instanceof MulBasedataProp && value instanceof MulBasedataDynamicObjectCollection) {
                MulBasedataDynamicObjectCollection mulBaseDataDynCol = (MulBasedataDynamicObjectCollection)value;
                ArrayList<RowDataBo> mulBaseRowBoList = new ArrayList<RowDataBo>(10);
                for (DynamicObject mulBaseDyn : mulBaseDataDynCol) {
                    mulBaseRowBoList.add(this.convertDynToRowBo(mulBaseDyn));
                }
                fieldBo.setFieldName(proName).setFieldValue(mulBaseRowBoList);
                fieldBo.setFieldType(EntityPropertyTypeEnum.MUL_BASE_DATA_PROP.getByType());
            } else if (pro instanceof LongProp && HRStringUtils.isEmpty((String)pro.getAlias())) {
                fieldBo.setFieldName(proName).setFieldValue(value);
            } else {
                if (HRStringUtils.isEmpty((String)pro.getAlias())) continue;
                fieldBo.setFieldName(proName).setFieldValue(value);
            }
            fieldBoList.add(fieldBo);
        }
        rowDataBo.setFieldBoList(fieldBoList);
        return rowDataBo;
    }

    private void setBaseData(String proName, DynamicObject value, FieldBo fieldBo) {
        DynamicObject baseDyn = value;
        DataEntityPropertyCollection baseDataPros = baseDyn.getDataEntityType().getProperties();
        Object pkId = baseDyn.get("id");
        ArrayList<FieldBo> f7BoList = new ArrayList<FieldBo>(10);
        FieldBo f7IdBo = new FieldBo();
        f7IdBo.setFieldName("id").setFieldValue(pkId);
        f7BoList.add(f7IdBo);
        Set baseDataFieldNameSet = baseDataPros.stream().map(IMetadata::getName).collect(Collectors.toSet());
        if (baseDataFieldNameSet.contains("number")) {
            FieldBo f7NumBo = new FieldBo();
            f7NumBo.setFieldName("number").setFieldValue(baseDyn.getString("number"));
            f7BoList.add(f7NumBo);
        }
        fieldBo.setFieldName(proName).setFieldValue(f7BoList).setRelF7IdVal(pkId);
        fieldBo.setFieldType(EntityPropertyTypeEnum.BASE_DATA_PROP.getByType());
    }

    private void setDateTypeData(String proName, Object value, FieldBo fieldBo) {
        if (value instanceof Date) {
            fieldBo.setFieldName(proName).setFieldValue(((Date)value).getTime());
        } else {
            Timestamp time = (Timestamp)value;
            if (time != null) {
                fieldBo.setFieldName(proName).setFieldValue(time.getTime());
            }
        }
    }

    public boolean isHisModEntity(String entityNum) {
        LOG.info("ConfigItemDomainServiceImpl config item entity number is {}", (Object)entityNum);
        String inhRelation = HisCommonService.getInstance().entityInhRelation(entityNum);
        return EnumEntityTpl.NONLINETIMESEQ_TPL.getNumber().equals(inhRelation) || EnumEntityTpl.LINETIMESEQ_TPL.getNumber().equals(inhRelation);
    }

    public void analysisEntityAllRefF7Pro(MainEntityType dataEntityType) {
        DataEntityPropertyCollection entityProperties = dataEntityType.getProperties();
        for (IDataEntityProperty property : entityProperties) {
            if (property instanceof IBasedataField) {
                String proName = property.getName();
                String baseEntityId = ((IBasedataField)property).getBaseEntityId();
                this.relF7ProVsF7EntityNumMap.put(proName, baseEntityId);
                this.relF7ProSet.add(proName);
                continue;
            }
            if (!(property instanceof EntryProp)) continue;
            DataEntityPropertyCollection entryItemTypeCol = ((EntryProp)property).getItemType().getProperties();
            for (IDataEntityProperty iDataEntityProperty : entryItemTypeCol) {
                if (!(iDataEntityProperty instanceof BasedataProp)) continue;
                String proName = iDataEntityProperty.getName();
                String baseEntityId = ((IBasedataField)iDataEntityProperty).getBaseEntityId();
                this.relF7ProVsF7EntityNumMap.put(proName, baseEntityId);
                this.relF7ProSet.add(proName);
            }
        }
    }

    protected void analysisOtherBiz() {
    }

    public void boToDynamicObject(DynamicObject currentObj, RowDataBo rowDataBo) {
        if (rowDataBo == null || currentObj == null || rowDataBo.getFieldBoList() == null) {
            return;
        }
        IDataEntityType curEntityDataEntityType = currentObj.getDataEntityType();
        String entityName = curEntityDataEntityType.getName();
        DataEntityPropertyCollection properties = curEntityDataEntityType.getProperties();
        for (FieldBo fieldBo : rowDataBo.getFieldBoList()) {
            String propName;
            String boProName = fieldBo.getFieldName();
            IDataEntityProperty prop = this.getProperty(properties, boProName);
            if (prop == null || (propName = prop.getName()).endsWith("_id")) continue;
            Object fieldValue = fieldBo.getFieldValue();
            if (propName.equals("id")) {
                currentObj.set(prop, this.idCovert(entityName, fieldValue));
                continue;
            }
            if (prop instanceof BasedataProp) {
                this.setBaseDataPro(currentObj, fieldValue, prop, prop.getName());
                continue;
            }
            if (prop instanceof MulBasedataProp) {
                List mulBaseRowBoList = JSONArray.parseArray((String)fieldBo.getFieldValue().toString(), RowDataBo.class);
                this.handleMulBaseDataPro(currentObj, mulBaseRowBoList, propName);
                continue;
            }
            if (prop instanceof DateTimeProp) {
                currentObj.set(propName, (Object)this.objToTime(fieldValue));
                continue;
            }
            if (prop instanceof DecimalProp) {
                currentObj.set(prop, (Object)this.num(fieldValue));
                continue;
            }
            if (prop instanceof BooleanProp) {
                currentObj.set(propName, (Object)this.booleanPro(fieldValue));
                continue;
            }
            if (prop instanceof EntryProp) {
                List entryRowBoList = JSONArray.parseArray((String)fieldValue.toString(), RowDataBo.class);
                this.boToEntry(currentObj, entryRowBoList, prop.getName());
                continue;
            }
            if (prop instanceof MuliLangTextProp) {
                List mulFieldBoList = JSONArray.parseArray((String)fieldBo.getFieldValue().toString(), FieldBo.class);
                this.setMulLangTextPro(currentObj, mulFieldBoList, propName);
                continue;
            }
            currentObj.set(propName, fieldValue);
        }
    }

    public IDataEntityProperty getProperty(DataEntityPropertyCollection properties, String proKey) {
        String bdKey;
        IDataEntityProperty bdProp;
        IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)proKey);
        if (proKey.endsWith("_id") && (bdProp = (IDataEntityProperty)properties.get((Object)(bdKey = proKey.substring(0, proKey.lastIndexOf("_id"))))) != null) {
            prop = bdProp;
        }
        return prop;
    }

    public Object idCovert(String entityName, Object id) {
        if (!("sch_job".equals(entityName) || "sch_schedule".equals(entityName) || "bos_entityobject".equals(entityName) || "sch_taskdefine".equals(entityName))) {
            return id;
        }
        try {
            id = Long.parseLong(id.toString());
        }
        catch (NumberFormatException e) {
            LOG.error("idCovert\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return id;
        }
        return id;
    }

    public void setBaseDataPro(DynamicObject currentObj, Object f7FieldValue, IDataEntityProperty prop, String baseProName) {
        List f7FieldBoList = f7FieldValue instanceof JSONArray ? JSONArray.parseArray((String)f7FieldValue.toString(), FieldBo.class) : (List)f7FieldValue;
        if (CollectionUtils.isEmpty((Collection)f7FieldBoList)) {
            return;
        }
        BasedataProp baseDataPro = (BasedataProp)prop;
        String baseEntityId = baseDataPro.getBaseEntityId();
        HRBaseServiceHelper refBaseHelper = new HRBaseServiceHelper(baseEntityId);
        DynamicObject baseDyn = refBaseHelper.generateEmptyDynamicObject();
        FieldBo idFieldBo = (FieldBo)f7FieldBoList.get(0);
        boolean isContainNumber = baseDyn.getDataEntityType().getProperties().containsKey((Object)"number");
        if (isContainNumber && f7FieldBoList.size() == 2) {
            baseDyn.set("number", ((FieldBo)f7FieldBoList.get(1)).getFieldValue());
        }
        baseDyn.set("id", idFieldBo.getFieldValue());
        currentObj.set(baseProName, (Object)baseDyn);
    }

    public void handleMulBaseDataPro(DynamicObject currentObj, List<RowDataBo> mulBaseRowBoList, String propName) {
        MulBasedataDynamicObjectCollection mulBaseColDyn = (MulBasedataDynamicObjectCollection)currentObj.getDynamicObjectCollection(propName);
        DynamicObjectType dynamicObjectType = currentObj.getDynamicObjectCollection(propName).getDynamicObjectType();
        if (ObjectUtils.isEmpty(mulBaseRowBoList)) {
            return;
        }
        for (RowDataBo rowDataBo : mulBaseRowBoList) {
            List<FieldBo> fieldBoList = rowDataBo.getFieldBoList();
            for (FieldBo fieldBo : fieldBoList) {
                DynamicObject mulBaseDyn = new DynamicObject(dynamicObjectType);
                DataEntityPropertyCollection mulProCol = mulBaseDyn.getDataEntityType().getProperties();
                for (IDataEntityProperty property : mulProCol) {
                    if (property instanceof BasedataProp && "fbasedataid".equals(property.getName())) {
                        String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityId);
                        DynamicObject baseDyn = new DynamicObject((DynamicObjectType)dataEntityType);
                        String fieldName = fieldBo.getFieldName();
                        if ("id".equals(fieldName)) {
                            baseDyn.set("id", fieldBo.getFieldValue());
                        }
                        if ("fbasedataid".equals(fieldName)) {
                            baseDyn.set("id", fieldBo.getFieldValue());
                        }
                        mulBaseDyn.set("fbasedataid", (Object)baseDyn);
                        continue;
                    }
                    if (!(property instanceof LongProp) || !"pkid".equals(property.getName())) continue;
                    mulBaseDyn.set("pkid", fieldBo.getFieldValue());
                }
                mulBaseColDyn.add(mulBaseDyn);
            }
        }
    }

    public Timestamp objToTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        if (value instanceof Double) {
            double dou = (Double)value * 8.64E7;
            Timestamp zero = this.objToTime("1899-12-30");
            return new Timestamp((long)dou + (zero != null ? ((Date)zero).getTime() : 0L));
        }
        if (value instanceof String) {
            String dateStr = String.valueOf(value);
            Date date = null;
            int length = dateStr.length();
            if (length == DatePattern.YYYY_MM_DD.getValue().length()) {
                date = DateUtils.stringToDate((String)value.toString(), (DatePattern)DatePattern.YYYY_MM_DD);
            } else if (length == DatePattern.YYYY_MM_DD_HH_MM_SS.getValue().length()) {
                date = DateUtils.stringToDate((String)value.toString(), (DatePattern)DatePattern.YYYY_MM_DD_HH_MM_SS);
            }
            if (date != null) {
                return new Timestamp(date.getTime());
            }
            return null;
        }
        String s0 = value.toString();
        if (s0 == null) {
            return null;
        }
        String str = s0.trim();
        if (str.length() == 0) {
            return null;
        }
        if (this.isLong(str)) {
            return new Timestamp(Long.parseLong(str));
        }
        return null;
    }

    public BigDecimal num(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Boolean) {
            return Boolean.TRUE.equals(value) ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        String strVal = value.toString().trim();
        if (strVal.length() == 0) {
            return BigDecimal.ZERO;
        }
        if (strVal.indexOf(44) >= 0) {
            strVal = strVal.replace(",", "");
        }
        return "-".equals(strVal) ? BigDecimal.ZERO : new BigDecimal(strVal);
    }

    public boolean booleanPro(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        String str = obj.toString().trim();
        if (str.length() == 0) {
            return false;
        }
        return "true".equalsIgnoreCase(str) || "1".equalsIgnoreCase(str) || "off".equalsIgnoreCase(str) || "success".equalsIgnoreCase(str) || "yes".equalsIgnoreCase(str) || "ok".equalsIgnoreCase(str);
    }

    private void boToEntry(DynamicObject currentObj, List<RowDataBo> entryRowBoList, String entryKey) {
        String curEntityNumber = currentObj.getDynamicObjectType().getName();
        DynamicObjectCollection entryCol = currentObj.getDynamicObjectCollection(entryKey);
        entryCol.clear();
        DataEntityPropertyCollection properties = entryCol.getDynamicObjectType().getProperties();
        for (int i = 0; i < entryRowBoList.size(); ++i) {
            List<FieldBo> fieldBoList = entryRowBoList.get(i).getFieldBoList();
            DynamicObject newEntry = entryCol.addNew();
            for (FieldBo fieldBo : fieldBoList) {
                String propKey = fieldBo.getFieldName();
                Object fieldValue = fieldBo.getFieldValue();
                IDataEntityProperty prop = this.getProperty(properties, propKey);
                if (prop == null) continue;
                String propName = prop.getName();
                if (propName.equals("id") || prop.getName().equals("entryid")) {
                    newEntry.set(prop, this.idCovert(curEntityNumber, fieldValue));
                    continue;
                }
                if (prop instanceof BasedataProp) {
                    this.setBaseDataPro(newEntry, fieldValue, prop, propName);
                    continue;
                }
                if (prop instanceof MulBasedataProp) continue;
                Object value = fieldValue;
                if (prop instanceof DateTimeProp) {
                    newEntry.set(propName, (Object)this.objToTime(fieldValue));
                    continue;
                }
                if (prop instanceof DecimalProp) {
                    newEntry.set(propName, (Object)this.num(value));
                    continue;
                }
                if (prop instanceof BooleanProp) {
                    newEntry.set(propName, (Object)this.booleanPro(value));
                    continue;
                }
                if (prop instanceof EntryProp) {
                    List subEntryRowBoList = (List)fieldValue;
                    if (CollectionUtils.isEmpty((Collection)subEntryRowBoList)) {
                        return;
                    }
                    DynamicObjectCollection subs = newEntry.getDynamicObjectCollection(propName);
                    for (RowDataBo subRowDataBo : subEntryRowBoList) {
                        DynamicObject infoDyn = subs.addNew();
                        this.boToDynamicObject(infoDyn, subRowDataBo);
                    }
                    continue;
                }
                if (prop instanceof MuliLangTextProp) {
                    List mulFieldBoList = JSONArray.parseArray((String)fieldBo.getFieldValue().toString(), FieldBo.class);
                    this.setMulLangTextPro(newEntry, mulFieldBoList, propName);
                    continue;
                }
                if (prop instanceof DynamicLocaleProperty) continue;
                newEntry.set(propName, value);
            }
        }
    }

    private void setMulLangTextPro(DynamicObject newEntry, List<FieldBo> mulFieldBoList, String propName) {
        LocaleString localeObj = new LocaleString();
        for (FieldBo fieldBo : mulFieldBoList) {
            localeObj.put(fieldBo.getFieldName(), (Object)fieldBo.getFieldValue().toString());
        }
        newEntry.set(propName, (Object)localeObj);
    }

    public boolean isLong(String dStr) {
        int j = dStr.length();
        for (int flag = 0; flag < j; ++flag) {
            char charAt = dStr.charAt(flag);
            if (charAt >= '0' && charAt <= '9') continue;
            return false;
        }
        return true;
    }

    public Map<Object, Boolean> getEntityOrgCtrInfo(String entityKey, Set<Object> orgIds) {
        HashMap<Object, Boolean> retMap = new HashMap<Object, Boolean>(16);
        if (HRStringUtils.isEmpty((String)entityKey) || ObjectUtils.isEmpty(orgIds)) {
            return retMap;
        }
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entityKey);
        if (ctrlView == null) {
            return retMap;
        }
        Set<Long> orgIdSet = this.getCuOrgIds(ctrlView, new ArrayList<Object>(orgIds));
        orgIdSet.forEach(orgId -> retMap.put(orgId, Boolean.TRUE));
        orgIds.forEach(orgId -> retMap.putIfAbsent(orgId, Boolean.FALSE));
        return retMap;
    }

    private Set<Long> getCuOrgIds(DynamicObject ctrlView, List<Object> orgIds) {
        Long viewId = (Long)ctrlView.getPkValue();
        SqlBuilder builder = new SqlBuilder();
        builder.append("select forgid from t_org_structure where fviewid = ", new Object[0]).append(viewId.toString(), new Object[0]);
        builder.append(" and fisctrlunit = '1' and ", new Object[0]);
        builder.appendIn("forgid", orgIds);
        return (Set)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)builder, resultSet -> {
            HashSet<Long> result = new HashSet<Long>(16);
            while (resultSet.next()) {
                result.add(resultSet.getLong("forgid"));
            }
            return result;
        });
    }

    public boolean isCtrEntity(String entityKey) {
        Boolean ctrEntity = this.ctrlEntityMap.get(entityKey);
        if (ctrEntity != null) {
            return ctrEntity;
        }
        ctrEntity = BaseDataServiceHelper.checkBaseDataCtrl((String)entityKey);
        this.ctrlEntityMap.put(entityKey, ctrEntity);
        return ctrEntity;
    }

    public String getProDisplayName(String entityNumber, String propName) {
        MainEntityType mainEntityType = MetadataUtils.getMainEntityType((String)entityNumber);
        for (IDataEntityProperty property : mainEntityType.getProperties()) {
            if (!propName.equals(property.getName())) continue;
            LocaleString displayName = property.getDisplayName();
            return displayName.getLocaleValue();
        }
        return null;
    }

    public String getParentEntity() {
        return this.parentEntity;
    }

    public void setParentEntity(String parentEntity) {
        this.parentEntity = parentEntity;
    }

    public Boolean getControlMod() {
        return this.isControlMod;
    }

    public void setControlMod(Boolean controlMod) {
        this.isControlMod = controlMod;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getEntityNumber() {
        return this.entityNumber;
    }

    public void setEntityNumber(String entityNumber) {
        this.entityNumber = entityNumber;
    }

    public String getDbRouteKey() {
        return this.dbRouteKey;
    }

    public void setDbRouteKey(String dbRouteKey) {
        this.dbRouteKey = dbRouteKey;
    }

    public Set<String> getRelF7ProSet() {
        return this.relF7ProSet;
    }

    public void setRelF7ProSet(Set<String> relF7ProSet) {
        this.relF7ProSet = relF7ProSet;
    }

    public Map<String, String> getRelF7ProVsF7EntityNumMap() {
        return this.relF7ProVsF7EntityNumMap;
    }

    public void setRelF7ProVsF7EntityNumMap(Map<String, String> relF7ProVsF7EntityNumMap) {
        this.relF7ProVsF7EntityNumMap = relF7ProVsF7EntityNumMap;
    }

    public Boolean getHisMod() {
        return this.isHisMod;
    }

    public void setHisMod(Boolean hisMod) {
        this.isHisMod = hisMod;
    }

    public List<HisEventBo> getHisEventBoList() {
        return this.hisEventBoList;
    }

    public void setHisEventBoList(List<HisEventBo> hisEventBoList) {
        this.hisEventBoList = hisEventBoList;
    }

    public Boolean getNeedAllHis() {
        return this.isNeedAllHis;
    }

    public void setNeedAllHis(Boolean needAllHis) {
        this.isNeedAllHis = needAllHis;
    }

    public List<CtrlRelTableBo> getCtrlRelTableBoList() {
        return this.ctrlRelTableBoList;
    }

    public void setCtrlRelTableBoList(List<CtrlRelTableBo> ctrlRelTableBoList) {
        this.ctrlRelTableBoList = ctrlRelTableBoList;
    }

    public List<RowDataBo> getRowDataBoList() {
        return this.rowDataBoList;
    }

    public void setRowDataBoList(List<RowDataBo> rowDataBoList) {
        this.rowDataBoList = rowDataBoList;
    }

    public String getMainTableName() {
        return this.mainTableName;
    }

    public void setMainTableName(String mainTableName) {
        this.mainTableName = mainTableName;
    }
}

