/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.common.utils;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.BooleanProp;
import kd.bos.entity.property.DateProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.DecimalProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.DatePattern;
import kd.hr.hbp.common.util.DateUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfItemDyObjectUtils {
    private static final Log LOG = LogFactory.getLog(ConfItemDyObjectUtils.class);
    private static final Date ZERO = ConfItemDyObjectUtils.objToTime("1899-12-30");

    public static Map<String, Object> convertDynamicObjectToMap(DynamicObject dy) throws KDBizException {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        if (dy == null) {
            return map;
        }
        DataEntityPropertyCollection dePros = dy.getDataEntityType().getProperties();
        if (dePros == null || dePros.size() == 0) {
            return map;
        }
        for (IDataEntityProperty pro : dePros) {
            String proName = pro.getName();
            Object value = dy.get(proName);
            if (value instanceof DynamicObject) {
                DynamicObject baseDyn = (DynamicObject)value;
                DataEntityPropertyCollection baseDataPros = baseDyn.getDataEntityType().getProperties();
                HashMap<String, Object> f7Map = new HashMap<String, Object>(2);
                f7Map.put("id", baseDyn.get("id"));
                f7Map.putIfAbsent("number", "");
                Set baseDataFieldNameSet = baseDataPros.stream().map(IMetadata::getName).collect(Collectors.toSet());
                if (baseDataFieldNameSet.contains("number")) {
                    f7Map.put("number", baseDyn.getString("number"));
                }
                map.put(proName, f7Map);
                continue;
            }
            if (value instanceof DynamicObjectCollection && pro instanceof EntryProp) {
                ArrayList<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>();
                DynamicObjectCollection dyEntryCol = (DynamicObjectCollection)value;
                for (DynamicObject dyEntry : dyEntryCol) {
                    entryList.add(ConfItemDyObjectUtils.convertDynamicObjectToMap(dyEntry));
                }
                map.put(proName, entryList);
                continue;
            }
            if (pro instanceof MuliLangTextProp) {
                OrmLocaleValue ormLocaleValue = (OrmLocaleValue)value;
                map.put(proName, ormLocaleValue);
                continue;
            }
            if (pro instanceof DateTimeProp || pro instanceof DateProp) {
                if (value instanceof Date) {
                    map.put(proName, ((Date)value).getTime());
                    continue;
                }
                Timestamp time = (Timestamp)value;
                if (time == null) continue;
                map.put(proName, time.getTime());
                continue;
            }
            if (pro instanceof MulBasedataProp && value instanceof MulBasedataDynamicObjectCollection) {
                MulBasedataDynamicObjectCollection mulBaseDataDynCol = (MulBasedataDynamicObjectCollection)value;
                ArrayList<Map<String, Object>> mulBaseDataMapList = new ArrayList<Map<String, Object>>();
                for (DynamicObject mulBaseDyn : mulBaseDataDynCol) {
                    mulBaseDataMapList.add(ConfItemDyObjectUtils.convertDynamicObjectToMap(mulBaseDyn));
                }
                map.put(proName, mulBaseDataMapList);
                continue;
            }
            if (pro instanceof LongProp && HRStringUtils.isEmpty((String)pro.getAlias())) {
                map.put(proName, value);
                continue;
            }
            if (HRStringUtils.isEmpty((String)pro.getAlias())) continue;
            map.put(proName, value);
        }
        return map;
    }

    public static void map2DynamicObject(DynamicObject currentObj, Map<String, Object> dataMap) {
        if (dataMap == null || currentObj == null) {
            return;
        }
        IDataEntityType curEntityDataEntityType = currentObj.getDataEntityType();
        String name = curEntityDataEntityType.getName();
        DataEntityPropertyCollection properties = curEntityDataEntityType.getProperties();
        for (Map.Entry<String, Object> entry : dataMap.entrySet()) {
            String key = entry.getKey();
            IDataEntityProperty prop = ConfItemDyObjectUtils.getProperty(properties, key);
            if (prop == null) continue;
            String propName = prop.getName();
            if (propName.equals("id")) {
                currentObj.set(prop, ConfItemDyObjectUtils.idCovert(name, entry.getValue()));
                continue;
            }
            if (prop instanceof BasedataProp) {
                ConfItemDyObjectUtils.setBaseDataPro(currentObj, dataMap, prop, prop.getName());
                continue;
            }
            if (prop instanceof MulBasedataProp) {
                ConfItemDyObjectUtils.handleMulBaseDataPro(currentObj, entry, propName);
                continue;
            }
            if (prop instanceof DateTimeProp) {
                currentObj.set(propName, (Object)ConfItemDyObjectUtils.objToTime(entry.getValue()));
                continue;
            }
            if (prop instanceof DecimalProp) {
                currentObj.set(prop, (Object)ConfItemDyObjectUtils.num(entry.getValue()));
                continue;
            }
            if (prop instanceof BooleanProp) {
                currentObj.set(propName, (Object)ConfItemDyObjectUtils.booleanPro(entry.getValue()));
                continue;
            }
            if (prop instanceof EntryProp) {
                ConfItemDyObjectUtils.map2Entry(currentObj, dataMap, prop.getName());
                continue;
            }
            if (prop instanceof MuliLangTextProp) {
                ConfItemDyObjectUtils.setMulLangTextPro(currentObj, entry, propName);
                continue;
            }
            currentObj.set(propName, entry.getValue());
        }
    }

    private static void setBaseDataPro(DynamicObject currentObj, Map<String, Object> dataMap, IDataEntityProperty prop, String name2) {
        BasedataProp baseDataPro = (BasedataProp)prop;
        String baseEntityId = baseDataPro.getBaseEntityId();
        HRBaseServiceHelper refBaseHelper = new HRBaseServiceHelper(baseEntityId);
        DynamicObject baseDyn = refBaseHelper.generateEmptyDynamicObject();
        Map refBaseEntityMap = (Map)dataMap.get(prop.getName());
        if (refBaseEntityMap != null) {
            baseDyn.set("id", refBaseEntityMap.get("id"));
            currentObj.set(name2, (Object)baseDyn);
        }
    }

    private static void handleMulBaseDataPro(DynamicObject currentObj, Map.Entry<String, Object> entry, String propName) {
        MulBasedataDynamicObjectCollection mulBaseColDyn = (MulBasedataDynamicObjectCollection)currentObj.getDynamicObjectCollection(propName);
        DynamicObjectType dynamicObjectType = currentObj.getDynamicObjectCollection(propName).getDynamicObjectType();
        Object mulValue = entry.getValue();
        if (ObjectUtils.isEmpty((Object)mulValue)) {
            return;
        }
        if (mulValue instanceof List) {
            List list = (List)mulValue;
            for (Map mulMap : list) {
                DynamicObject mulBaseDyn = new DynamicObject(dynamicObjectType);
                DataEntityPropertyCollection mulProCol = mulBaseDyn.getDataEntityType().getProperties();
                for (IDataEntityProperty property : mulProCol) {
                    if (property instanceof BasedataProp && "fbasedataid".equals(property.getName())) {
                        String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)baseEntityId);
                        DynamicObject baseDyn = new DynamicObject((DynamicObjectType)dataEntityType);
                        Map mulBaseData = (Map)mulMap.get("fbasedataid");
                        if (ObjectUtils.isEmpty((Object)mulBaseData)) continue;
                        baseDyn.set("id", mulBaseData.get("id"));
                        mulBaseDyn.set("fbasedataid", (Object)baseDyn);
                        continue;
                    }
                    if (!(property instanceof LongProp) || !"pkid".equals(property.getName())) continue;
                    mulBaseDyn.set("pkid", (Object)Long.parseLong(mulMap.get("pkid").toString()));
                }
                mulBaseColDyn.add(mulBaseDyn);
            }
        }
    }

    private static void map2Entry(DynamicObject currentObj, Map<String, Object> dataMap, String entryKey) {
        String curEntityNumber = currentObj.getDynamicObjectType().getName();
        DynamicObjectCollection entryCol = currentObj.getDynamicObjectCollection(entryKey);
        entryCol.clear();
        List entryDataList = (List)dataMap.get(entryKey);
        DataEntityPropertyCollection properties = entryCol.getDynamicObjectType().getProperties();
        for (int i = 0; i < entryDataList.size(); ++i) {
            Map entryDataMap = (Map)entryDataList.get(i);
            DynamicObject newEntry = entryCol.addNew();
            for (Map.Entry<String, Object> entry : entryDataMap.entrySet()) {
                String propKey = (String)entry.getKey();
                IDataEntityProperty prop = ConfItemDyObjectUtils.getProperty(properties, propKey);
                if (prop == null) continue;
                String propName = prop.getName();
                if (propName.equals("id") || prop.getName().equals("entryid")) {
                    newEntry.set(prop, ConfItemDyObjectUtils.idCovert(curEntityNumber, entry.getValue()));
                    continue;
                }
                if (prop instanceof BasedataProp) {
                    ConfItemDyObjectUtils.setBaseDataPro(newEntry, entryDataMap, prop, propName);
                    continue;
                }
                if (prop instanceof MulBasedataProp) continue;
                Object value = entry.getValue();
                if (prop instanceof DateTimeProp) {
                    newEntry.set(propName, (Object)ConfItemDyObjectUtils.objToTime(entry.getValue()));
                    continue;
                }
                if (prop instanceof DecimalProp) {
                    newEntry.set(propName, (Object)ConfItemDyObjectUtils.num(value));
                    continue;
                }
                if (prop instanceof BooleanProp) {
                    newEntry.set(propName, (Object)ConfItemDyObjectUtils.booleanPro(value));
                    continue;
                }
                if (prop instanceof EntryProp) {
                    Object subE = entry.getValue();
                    if (!(subE instanceof List)) continue;
                    DynamicObjectCollection subs = newEntry.getDynamicObjectCollection(propName);
                    List infoList = (List)subE;
                    if (!CollectionUtils.isNotEmpty((Collection)infoList)) continue;
                    for (Map info : infoList) {
                        DynamicObject infoDyn = subs.addNew();
                        ConfItemDyObjectUtils.map2DynamicObject(infoDyn, info);
                    }
                    continue;
                }
                if (prop instanceof MuliLangTextProp) {
                    ConfItemDyObjectUtils.setMulLangTextPro(newEntry, entry, propName);
                    continue;
                }
                if (prop instanceof DynamicLocaleProperty) {
                    Object object = entry.getValue();
                    continue;
                }
                newEntry.set(propName, value);
            }
        }
    }

    private static void setMulLangTextPro(DynamicObject newEntry, Map.Entry<String, Object> entry, String propName) {
        Map ormLocalMap = (Map)entry.getValue();
        LocaleString localeObj = new LocaleString();
        localeObj.putAll(ormLocalMap);
        newEntry.set(propName, (Object)localeObj);
    }

    private static IDataEntityProperty getProperty(DataEntityPropertyCollection properties, String proKey) {
        String bdKey;
        IDataEntityProperty bdProp;
        IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)proKey);
        if (proKey.endsWith("_id") && (bdProp = (IDataEntityProperty)properties.get((Object)(bdKey = proKey.substring(0, proKey.lastIndexOf("_id"))))) != null) {
            prop = bdProp;
        }
        return prop;
    }

    public static BigDecimal num(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Boolean) {
            return Boolean.TRUE.equals(value) ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        String strVal = value.toString().trim();
        if (strVal.length() == 0) {
            return BigDecimal.ZERO;
        }
        if (strVal.indexOf(44) >= 0) {
            strVal = strVal.replace(",", "");
        }
        return "-".equals(strVal) ? BigDecimal.ZERO : new BigDecimal(strVal);
    }

    private static boolean booleanPro(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        String str = obj.toString().trim();
        if (str.length() == 0) {
            return false;
        }
        return "true".equalsIgnoreCase(str) || "1".equalsIgnoreCase(str) || "off".equalsIgnoreCase(str) || "success".equalsIgnoreCase(str) || "yes".equalsIgnoreCase(str) || "ok".equalsIgnoreCase(str);
    }

    public static Object idCovert(String entityName, Object id) {
        if (!("sch_job".equals(entityName) || "sch_schedule".equals(entityName) || "bos_entityobject".equals(entityName) || "sch_taskdefine".equals(entityName))) {
            return id;
        }
        try {
            id = Long.parseLong(id.toString());
        }
        catch (NumberFormatException e) {
            LOG.error("idCovert\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return id;
        }
        return id;
    }

    public static Timestamp objToTime(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Timestamp) {
            return (Timestamp)value;
        }
        if (value instanceof Date) {
            return new Timestamp(((Date)value).getTime());
        }
        if (value instanceof Long) {
            return new Timestamp((Long)value);
        }
        if (value instanceof Double) {
            double dou = (Double)value * 8.64E7;
            return new Timestamp((long)dou + (ZERO != null ? ZERO.getTime() : 0L));
        }
        if (value instanceof String) {
            String dateStr = String.valueOf(value);
            Date date = null;
            int length = dateStr.length();
            if (length == DatePattern.YYYY_MM_DD.getValue().length()) {
                date = DateUtils.stringToDate((String)value.toString(), (DatePattern)DatePattern.YYYY_MM_DD);
            } else if (length == DatePattern.YYYY_MM_DD_HH_MM_SS.getValue().length()) {
                date = DateUtils.stringToDate((String)value.toString(), (DatePattern)DatePattern.YYYY_MM_DD_HH_MM_SS);
            }
            if (date != null) {
                return new Timestamp(date.getTime());
            }
            return null;
        }
        String s0 = value.toString();
        if (s0 == null) {
            return null;
        }
        String str = s0.trim();
        if (str.length() == 0) {
            return null;
        }
        if (ConfItemDyObjectUtils.isLong(str)) {
            return new Timestamp(Long.parseLong(str));
        }
        return null;
    }

    public static boolean isLong(String dStr) {
        int j = dStr.length();
        for (int flag = 0; flag < j; ++flag) {
            char charAt = dStr.charAt(flag);
            if (charAt >= '0' && charAt <= '9') continue;
            return false;
        }
        return true;
    }
}

