/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.common.utils;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.BigIntField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.ComboItem;
import kd.bos.metadata.entity.commonfield.DateField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.DateTimeField;
import kd.bos.metadata.entity.commonfield.DecimalField;
import kd.bos.metadata.entity.commonfield.IconField;
import kd.bos.metadata.entity.commonfield.IntegerField;
import kd.bos.metadata.entity.commonfield.LargeTextField;
import kd.bos.metadata.entity.commonfield.MulComboField;
import kd.bos.metadata.entity.commonfield.MuliLangTextField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.metadata.entity.commonfield.TextAreaField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeField;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class FieldRuleHandleUtils {
    public static Map<String, Object> getFieldRuleMap(EntityItem<?> entityItem) {
        HashMap fieldRuleMap = Maps.newHashMapWithExpectedSize((int)1);
        if (entityItem instanceof BigIntField) {
            fieldRuleMap.put("MustInput", ((BigIntField)entityItem).getMustInputType());
        } else if (entityItem instanceof IntegerField) {
            fieldRuleMap.put("MustInput", ((IntegerField)entityItem).getMustInputType());
        } else if (entityItem instanceof DecimalField) {
            fieldRuleMap.put("MustInput", ((DecimalField)entityItem).getMustInputType());
            fieldRuleMap.put("Scale", ((DecimalField)entityItem).getScale());
        } else if (entityItem instanceof LargeTextField) {
            fieldRuleMap.put("MustInput", ((LargeTextField)entityItem).getMustInputType());
        } else if (entityItem instanceof DateField) {
            fieldRuleMap.put("MustInput", ((DateField)entityItem).getMustInputType());
        } else if (entityItem instanceof MuliLangTextField) {
            fieldRuleMap.put("MustInput", ((MuliLangTextField)entityItem).getMustInputType());
            fieldRuleMap.put("MaxLength", ((MuliLangTextField)entityItem).getMaxLength());
        } else if (entityItem instanceof TimeField) {
            fieldRuleMap.put("MustInput", ((TimeField)entityItem).getMustInputType());
        } else if (entityItem instanceof CheckBoxField) {
            fieldRuleMap.put("MustInput", ((CheckBoxField)entityItem).getMustInputType());
        } else if (entityItem instanceof RadioGroupField) {
            fieldRuleMap.put("MustInput", ((RadioGroupField)entityItem).getMustInputType());
        } else if (entityItem instanceof MulComboField) {
            fieldRuleMap.put("MustInput", ((MulComboField)entityItem).getMustInputType());
            List<Map<String, Object>> itemsMap = FieldRuleHandleUtils.getItems((ComboField)entityItem);
            fieldRuleMap.put("Items", itemsMap);
        } else if (entityItem instanceof ComboField) {
            fieldRuleMap.put("MustInput", ((ComboField)entityItem).getMustInputType());
            List<Map<String, Object>> itemsMap = FieldRuleHandleUtils.getItems((ComboField)entityItem);
            fieldRuleMap.put("Items", itemsMap);
        } else if (entityItem instanceof TextAreaField) {
            fieldRuleMap.put("MustInput", ((TextAreaField)entityItem).getMustInputType());
            fieldRuleMap.put("MaxLength", ((TextAreaField)entityItem).getMaxLength());
        } else if (entityItem instanceof TextField) {
            fieldRuleMap.put("MustInput", ((TextField)entityItem).getMustInputType());
            fieldRuleMap.put("MaxLength", ((TextField)entityItem).getMaxLength());
        } else if (entityItem instanceof DateTimeField) {
            fieldRuleMap.put("MustInput", ((DateTimeField)entityItem).getMustInputType());
        } else if (entityItem instanceof DateRangeField) {
            fieldRuleMap.put("MustInput", ((DateRangeField)entityItem).getMustInputType());
        } else if (entityItem instanceof PictureField) {
            fieldRuleMap.put("MustInput", ((PictureField)entityItem).getMustInputType());
        } else if (entityItem instanceof IconField) {
            fieldRuleMap.put("MustInput", ((IconField)entityItem).getMustInputType());
        } else if (entityItem instanceof RadioField) {
            fieldRuleMap.put("MustInput", ((RadioField)entityItem).getMustInputType());
        } else if (entityItem instanceof AttachmentField) {
            fieldRuleMap.put("MustInput", ((AttachmentField)entityItem).getMustInputType());
        } else if (entityItem instanceof BasedataField) {
            fieldRuleMap.put("MustInput", ((BasedataField)entityItem).getMustInputType());
            fieldRuleMap.put("BaseEntityId", ((BasedataField)entityItem).getBaseEntityId());
        } else if (entityItem instanceof MulBasedataField) {
            fieldRuleMap.put("MustInput", ((MulBasedataField)entityItem).getMustInputType());
            fieldRuleMap.put("BaseEntityId", ((MulBasedataField)entityItem).getBaseEntityId());
        }
        return fieldRuleMap;
    }

    private static List<Map<String, Object>> getItems(ComboField entityItem) {
        ArrayList itemsMap = Lists.newArrayListWithExpectedSize((int)8);
        List items = entityItem.getItems();
        if (CollectionUtils.isNotEmpty((Collection)items)) {
            for (ComboItem item : items) {
                HashMap map = Maps.newHashMapWithExpectedSize((int)4);
                map.put("_Type", "ComboItem");
                map.put("Value", item.getValue());
                map.put("Caption", item.getCaption());
                itemsMap.add(map);
            }
        }
        return itemsMap;
    }
}

