/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.list.ListShowParameter;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.mvc.SessionManager;
import kd.bos.portal.util.OpenPageUtils;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.util.StringUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hr.hbp.common.util.HRStringUtils;

public class OpenPageCommonUtils {
    private static final String APP = "app";
    private static final String RIGHT_APP = "rightapp";
    private static final String SUB_MAIN_TAB = "_submaintab_";
    private static final String APPMAINNUMBER = "appmainnumber";
    private static final String CURRENT_ENV = "${current_env.}";
    private static Set<String> excludeKey = ImmutableSet.of((Object)"billformid", (Object)"formid", (Object)"type", (Object)"app", (Object)"rightapp");

    public static void openToolPageLine(IFormView view, String linePageParams, Function<Object, Object> func) {
        if (HRStringUtils.isNotEmpty((String)linePageParams)) {
            Map linkPageMap = (Map)SerializationUtils.fromJsonString((String)linePageParams, Map.class);
            String key = (String)linkPageMap.get("key");
            String value = (String)linkPageMap.get("value");
            if (value.contains("pageUrl")) {
                String urlStr = JSONObject.parseObject((String)value).getString("pageUrl");
                OpenPageCommonUtils.openLine(view, urlStr, func);
            } else {
                OpenPageCommonUtils.openMenu(view, key, value, func);
            }
        }
    }

    public static void openLine(IFormView view, String urlStr, Function<Object, Object> func) {
        if ((urlStr = urlStr.toLowerCase(Locale.ROOT)).contains(CURRENT_ENV)) {
            Map urlParam = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)urlStr.substring(urlStr.indexOf(63) + 1));
            OpenPageCommonUtils.openPageInAppView(view, urlParam, func);
        } else {
            view.openUrl(urlStr);
        }
    }

    private static void openPageInAppView(IFormView view, Map<String, String> urlParam, Function<Object, Object> func) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)urlParam.get("billformid"));
        String openAppId = urlParam.get(APP) == null ? dataEntityType.getAppId() : urlParam.get(APP);
        OpenPageUtils.openAppAndPage((String)openAppId, null, OpenPageCommonUtils.getParamMap(view, openAppId), (IFormView)view);
        String type = urlParam.get("type");
        if ("form".equals(type)) {
            OpenPageCommonUtils.openPageWhenAppFormPageOpen(view, openAppId, urlParam);
        } else {
            OpenPageCommonUtils.openPageWhenAppPageOpen(view, openAppId, urlParam, func);
        }
    }

    private static void openPageWhenAppPageOpen(IFormView view, String openAppId, Map<String, String> urlParam, Function<Object, Object> func) {
        OpenPageCommonUtils.openPageWhenAppPageOpenMul(view, openAppId, urlParam, null, func);
    }

    private static void openPageWhenAppPageOpenMul(IFormView view, String openAppId, Map<String, String> urlParam, String targetKey, Function<Object, Object> func) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)urlParam.get("billformid"));
        String checkRightAppId = urlParam.get(RIGHT_APP) == null ? openAppId : urlParam.get(RIGHT_APP);
        String formPageId = "hrdt" + urlParam.get("billformid") + urlParam.get("formid") + view.getPageId();
        IFormView appPageView = view.getMainView().getView(openAppId + view.getMainView().getPageId());
        if (appPageView != null) {
            Tab subTab = (Tab)appPageView.getControl(SUB_MAIN_TAB);
            for (Control item : subTab.getItems()) {
                if (!item.getKey().startsWith(formPageId)) continue;
                subTab.activeTab(item.getKey());
                view.sendFormAction(appPageView);
                return;
            }
        }
        ListShowParameter show = new ListShowParameter();
        show.setFormId(urlParam.get("formid"));
        show.setBillFormId(urlParam.get("billformid"));
        show.setAppId(openAppId);
        show.setRootPageId(view.getMainView().getPageId());
        show.setParentPageId(openAppId + view.getMainView().getPageId());
        show.setCustomParam("checkRightAppId", (Object)checkRightAppId);
        show.setCustomParam("parentPageId", (Object)view.getPageId());
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (func != null) {
            func.apply(show);
        }
        if (StringUtils.isNotEmpty((String)targetKey)) {
            show.getOpenStyle().setShowType(ShowType.InContainer);
            show.getOpenStyle().setTargetKey(targetKey);
        }
        show.setPageId(formPageId + StringUtils.randomNumber((int)16));
        String caption = dataEntityType.getDisplayName().getLocaleValue();
        show.setCaption(caption);
        if (view.getFormShowParameter().getOpenStyle().getShowType().compareTo((Enum)ShowType.Modal) == 0) {
            view.getFormShowParameter().getOpenStyle().setShowType(ShowType.MainNewTabPage);
        }
        view.showForm((FormShowParameter)show);
    }

    private static void openPageWhenAppFormPageOpen(IFormView view, String openAppId, Map<String, String> urlParam) {
        OpenPageCommonUtils.openPageWhenAppFormPageOpenMul(view, openAppId, urlParam, null);
    }

    private static void openPageWhenAppFormPageOpenMul(IFormView view, String openAppId, Map<String, String> urlParam, String targetKey) {
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)urlParam.get("billformid"));
        String checkRightAppId = urlParam.get(RIGHT_APP) == null ? openAppId : urlParam.get(RIGHT_APP);
        String formPageId = "hrdt" + urlParam.get("billformid") + urlParam.get("formid") + view.getPageId();
        IFormView appPageView = view.getMainView().getView(openAppId + view.getMainView().getPageId());
        if (appPageView != null) {
            Tab subTab = (Tab)appPageView.getControl(SUB_MAIN_TAB);
            for (Control item : subTab.getItems()) {
                if (!item.getKey().startsWith(formPageId)) continue;
                subTab.activeTab(item.getKey());
                view.sendFormAction(appPageView);
                return;
            }
        }
        String currentWorkBenchRoleId = (String)view.getFormShowParameter().getCustomParam("currentWorkBenchRoleId");
        FormShowParameter show = new FormShowParameter();
        show.setFormId(urlParam.get("formid"));
        show.setAppId(openAppId);
        show.setRootPageId(view.getMainView().getPageId());
        show.setParentPageId(openAppId + view.getMainView().getPageId());
        show.setCustomParam("checkRightAppId", (Object)checkRightAppId);
        if (HRStringUtils.isNotEmpty((String)currentWorkBenchRoleId)) {
            show.setCustomParam("currentWorkBenchRoleId", (Object)currentWorkBenchRoleId);
        }
        show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if (StringUtils.isNotEmpty((String)targetKey)) {
            show.getOpenStyle().setShowType(ShowType.InContainer);
            show.getOpenStyle().setTargetKey(targetKey);
        }
        show.setPageId(formPageId + StringUtils.randomNumber((int)16));
        String caption = dataEntityType.getDisplayName().getLocaleValue();
        show.setCaption(caption);
        view.showForm(show);
    }

    private static IFormView openPageWhenAppFormPageInContainer(IFormView view, String openAppId, Map<String, String> urlParam, String targetKey, CloseCallBack callBack) {
        String showType;
        String checkRightAppId = urlParam.get(RIGHT_APP) == null ? openAppId : urlParam.get(RIGHT_APP);
        String formPageId = "hrdt" + urlParam.get("billformid") + urlParam.get("formid") + view.getPageId();
        String currentWorkBenchRoleId = (String)view.getFormShowParameter().getCustomParam("currentWorkBenchRoleId");
        BillShowParameter show = new BillShowParameter();
        show.setFormId(urlParam.get("formid"));
        show.setAppId(openAppId);
        show.setCustomParam("checkRightAppId", (Object)checkRightAppId);
        if (HRStringUtils.isNotEmpty((String)currentWorkBenchRoleId)) {
            show.setCustomParam("currentWorkBenchRoleId", (Object)currentWorkBenchRoleId);
        }
        for (Map.Entry<String, String> paramKey : urlParam.entrySet()) {
            if (excludeKey.contains(paramKey.getKey())) continue;
            show.setCustomParam(paramKey.getKey(), (Object)paramKey.getValue());
        }
        String bizModelId = view.getPageCache().get("bizmodel.id");
        if (StringUtils.isNotEmpty((String)bizModelId)) {
            show.setCustomParam("bizmodel.id", (Object)bizModelId);
        }
        if (StringUtils.isNotEmpty((String)(showType = urlParam.get("showtype"))) && HRStringUtils.equalsIgnoreCase((String)showType, (String)ShowType.Modal.name())) {
            show.getOpenStyle().setShowType(ShowType.Modal);
        } else {
            show.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            if (StringUtils.isNotEmpty((String)targetKey)) {
                show.getOpenStyle().setShowType(ShowType.InContainer);
                show.getOpenStyle().setTargetKey(targetKey);
            }
        }
        show.setPageId(formPageId + StringUtils.randomNumber((int)16));
        show.setCloseCallBack(callBack);
        view.showForm((FormShowParameter)show);
        return SessionManager.getCurrent().getView(show.getPageId());
    }

    private static Map<String, Object> getParamMap(IFormView view, String openAppId) {
        AppInfo app = AppMetadataCache.getAppInfo((String)openAppId);
        HashMap paramMap = Maps.newHashMap();
        String appName = HRStringUtils.isNotEmpty((String)app.getName().getLocaleValue()) ? app.getName().getLocaleValue() : app.getNumber();
        paramMap.put("view", view);
        paramMap.put("appname", appName);
        paramMap.put(APPMAINNUMBER, app.getHomeNum());
        return paramMap;
    }

    public static void openMenu(IFormView view, String bizAppId, String menuItemId, Function<Object, Object> func) {
        Map<String, Object> parameterMap = OpenPageCommonUtils.acquireMenuParams(bizAppId, menuItemId);
        if (func != null) {
            func.apply(parameterMap);
        }
        OpenPageUtils.openMenu((IFormView)view, (String)menuItemId, (String)bizAppId, parameterMap);
    }

    public static Map<String, Object> acquireMenuParams(String bizAppId, String menuItemId) {
        String parameters;
        List appMenus;
        Map<String, Object> parameterMap = new HashMap<String, Object>(16);
        AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataFromCacheById((String)bizAppId, (boolean)false);
        if (appMetadata != null && CollectionUtils.isNotEmpty((Collection)(appMenus = appMetadata.getAppMenus())) && HRStringUtils.isNotEmpty((String)(parameters = appMenus.stream().filter(app -> HRStringUtils.equals((String)menuItemId, (String)app.getId())).map(AppMenuElement::getParameter).collect(Collectors.joining())))) {
            parameterMap = (Map)SerializationUtils.fromJsonString((String)parameters, HashMap.class);
        }
        return parameterMap;
    }

    public static void openPageInContainer(IFormView view, String targetKey, String linePageParams, CloseCallBack callBack, Function<Object, Object> func) {
        if (HRStringUtils.isNotEmpty((String)linePageParams)) {
            Map linkPageMap = (Map)SerializationUtils.fromJsonString((String)linePageParams, Map.class);
            String key = (String)linkPageMap.get("key");
            String value = (String)linkPageMap.get("value");
            if (value.contains("pageUrl")) {
                String urlStr = JSONObject.parseObject((String)value).getString("pageUrl");
                if ((urlStr = urlStr.toLowerCase(Locale.ROOT)).contains(CURRENT_ENV)) {
                    Map urlParam = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)urlStr.substring(urlStr.indexOf(63) + 1));
                    String type = (String)urlParam.get("type");
                    if ("form".equals(type)) {
                        IFormView openView = OpenPageCommonUtils.openPageWhenAppFormPageInContainer(view, view.getFormShowParameter().getAppId(), urlParam, targetKey, callBack);
                        if (openView != null) {
                            func.apply(urlParam);
                        }
                    } else {
                        OpenPageCommonUtils.openPageWhenAppPageOpenMul(view, view.getFormShowParameter().getAppId(), urlParam, targetKey, null);
                    }
                } else {
                    view.openUrl(urlStr);
                }
            } else {
                OpenPageCommonUtils.openMenu(view, key, value, null);
            }
        }
    }

    public static Map<String, String> getParamsFromPageUrl(String linePageParams) {
        Map urlParam = null;
        if (HRStringUtils.isNotEmpty((String)linePageParams)) {
            Map linkPageMap = (Map)SerializationUtils.fromJsonString((String)linePageParams, Map.class);
            String key = (String)linkPageMap.get("key");
            String value = (String)linkPageMap.get("value");
            if (value.contains("pageUrl")) {
                String urlStr = JSONObject.parseObject((String)value).getString("pageUrl");
                if ((urlStr = urlStr.toLowerCase(Locale.ROOT)).contains(CURRENT_ENV)) {
                    urlParam = Splitter.on((String)"&").withKeyValueSeparator("=").split((CharSequence)urlStr.substring(urlStr.indexOf(63) + 1));
                }
            }
        }
        return urlParam;
    }
}

