/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.common.utils;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.AppMenuInfo;
import kd.bos.metadata.form.Margin;
import kd.bos.metadata.form.Style;
import kd.bos.metadata.form.container.FlexPanelAp;
import kd.bos.metadata.form.control.IconAp;
import kd.bos.metadata.form.control.LabelAp;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Pair;

public class PagePaintingUtils {
    public static FlexPanelAp createFlexAp(String prefix, Object obj, AppMenuInfo appMenuInfo, int count, OperationStatus status) {
        FlexPanelAp flexAp = PagePaintingUtils.createFlexPanelAp(prefix, count);
        IconAp icon = PagePaintingUtils.createIconAp(prefix, appMenuInfo, count, obj);
        if (!HRStringUtils.equals((String)OperationStatus.VIEW.name(), (String)status.name())) {
            PagePaintingUtils.createDelIcom(flexAp, prefix, count);
        }
        PagePaintingUtils.createLableAp(appMenuInfo, count, obj, flexAp, icon);
        return flexAp;
    }

    private static void createLableAp(AppMenuInfo appMenuInfo, int count, Object obj, FlexPanelAp flexAp, IconAp icon) {
        LabelAp label = new LabelAp();
        label.setKey("ilabel" + count);
        if (ObjectUtils.isEmpty((Object)appMenuInfo)) {
            label.setName(new LocaleString(PagePaintingUtils.getShowName(obj)));
        } else {
            label.setName(appMenuInfo.getName());
        }
        label.setWidth(new LocaleString("90px"));
        label.setHeight(new LocaleString("30px"));
        label.setTextAlign("center");
        label.setAutoTextWrap(true);
        label.setLineHeight("15px");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("3px");
        style.setMargin(margin);
        label.setStyle(style);
        flexAp.getItems().add(icon);
        flexAp.getItems().add(label);
    }

    private static void createDelIcom(FlexPanelAp flexAp, String prefix, int count) {
        IconAp icondel = new IconAp();
        icondel.setKey(prefix + "iconap_del" + count);
        icondel.setName(new LocaleString("delete"));
        icondel.setImageKey("/icons/pc/other/deleteicon_normal.png");
        icondel.setHeight(new LocaleString("19px"));
        icondel.setWidth(new LocaleString("19px"));
        icondel.setZIndex(1);
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("-10px");
        margin.setLeft("42px");
        style.setMargin(margin);
        icondel.setStyle(style);
        flexAp.getItems().add(icondel);
    }

    private static IconAp createIconAp(String prefix, AppMenuInfo appMenuInfo, int count, Object obj) {
        IconAp icon = new IconAp();
        icon.setKey(prefix + "iconap" + count);
        String iconUrl = "/icons/pc/entrance/default_48_48.png";
        if (ObjectUtils.isEmpty((Object)appMenuInfo)) {
            String url = "";
            if (obj instanceof Pair) {
                url = JSONObject.parseObject((String)((String)((Pair)obj).getValue())).getString("imgUrl");
            } else if (obj instanceof ImmutableTriple) {
                url = JSONObject.parseObject((String)((String)((ImmutableTriple)obj).getRight())).getString("imgUrl");
            }
            icon.setName(new LocaleString(PagePaintingUtils.getShowName(obj)));
            if (HRStringUtils.isNotEmpty((String)url)) {
                iconUrl = url;
            }
        } else {
            icon.setName(appMenuInfo.getName());
            iconUrl = HRStringUtils.isEmpty((String)appMenuInfo.getShortcutIcon()) ? iconUrl : appMenuInfo.getShortcutIcon();
        }
        icon.setImageKey(iconUrl);
        icon.setClickable(true);
        icon.setHeight(new LocaleString("48px"));
        icon.setWidth(new LocaleString("48px"));
        icon.setRadius("6px");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setBottom("3px");
        style.setMargin(margin);
        icon.setStyle(style);
        return icon;
    }

    private static String getShowName(Object obj) {
        if (obj instanceof Pair) {
            return PagePaintingUtils.getShowName(((Pair)obj).getKey());
        }
        String localeName = RequestContext.get().getLang().getLangTag();
        String newLocaleName = localeName.replace("-", "_");
        Map localeNameMap = (Map)SerializationUtils.fromJsonString((String)((String)obj), Map.class);
        return HRStringUtils.isNotEmpty((String)((String)localeNameMap.get(localeName))) ? (String)localeNameMap.get(localeName) : (String)localeNameMap.get(newLocaleName);
    }

    private static FlexPanelAp createFlexPanelAp(String prefix, int count) {
        FlexPanelAp flexAp = new FlexPanelAp();
        flexAp.setKey(prefix + "iflexpanel" + count);
        flexAp.setDirection("column");
        flexAp.setAlignItems("center");
        flexAp.setGrow(0);
        flexAp.setJustifyContent("center");
        flexAp.setAlignItems("center");
        flexAp.setShrink(0);
        flexAp.setWidth(new LocaleString("90px"));
        flexAp.setOverflow("hidden");
        Style style = new Style();
        Margin margin = new Margin();
        margin.setRight("5px");
        margin.setLeft("5px");
        margin.setTop("15px");
        style.setMargin(margin);
        flexAp.setStyle(style);
        return flexAp;
    }
}

