/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.common.entity.handler;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Optional;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.IDynamicMetadataDomainService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;

public class ExtAppInfoHandler {
    private static final ThreadLocal<Map<String, AppInfo>> EXT_APP_INFO_THREAD_LOCAL = new ThreadLocal();
    private static IDynamicMetadataDomainService dynamicMetadataDomainService = (IDynamicMetadataDomainService)ServiceFactory.getService(IDynamicMetadataDomainService.class);

    public static String getExtAppId(String sourceNumber) {
        Map appInfo = Optional.ofNullable(EXT_APP_INFO_THREAD_LOCAL.get()).orElseGet(() -> Maps.newHashMap());
        AppInfo info = null;
        if (CollectionUtils.isNotEmpty((Map)appInfo)) {
            info = (AppInfo)appInfo.get(sourceNumber);
        }
        if (info == null) {
            AppInfo newInfo = ExtAppInfoHandler.getCurrentAppInfo(sourceNumber);
            appInfo.put(sourceNumber, newInfo);
            info = newInfo;
        }
        EXT_APP_INFO_THREAD_LOCAL.set(appInfo);
        return info.getExtAppId();
    }

    public static String getExtAppNumber(String sourceNumber) {
        Map appInfo = Optional.ofNullable(EXT_APP_INFO_THREAD_LOCAL.get()).orElseGet(() -> Maps.newHashMap());
        AppInfo info = null;
        if (CollectionUtils.isNotEmpty((Map)appInfo)) {
            info = (AppInfo)appInfo.get(sourceNumber);
        }
        if (info == null) {
            AppInfo newInfo = ExtAppInfoHandler.getCurrentAppInfo(sourceNumber);
            appInfo.put(sourceNumber, newInfo);
            info = newInfo;
        }
        EXT_APP_INFO_THREAD_LOCAL.set(appInfo);
        return info.getExtAppNumber();
    }

    private static AppInfo getCurrentAppInfo(String sourceNumber) {
        String appNumber = dynamicMetadataDomainService.getOrCreateExtIsvAppId(sourceNumber);
        String id = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        AppInfo info = new AppInfo();
        info.setExtAppId(id);
        info.setExtAppNumber(appNumber);
        return info;
    }

    static class AppInfo {
        private String extAppNumber;
        private String extAppId;

        AppInfo() {
        }

        public String getExtAppNumber() {
            return this.extAppNumber;
        }

        public void setExtAppNumber(String extAppNumber) {
            this.extAppNumber = extAppNumber;
        }

        public String getExtAppId() {
            return this.extAppId;
        }

        public void setExtAppId(String extAppId) {
            this.extAppId = extAppId;
        }
    }
}

