/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.ext.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.business.domain.metadata.impl.context.DesignMetadataParser;
import kd.hdtc.hrdbs.business.domain.metadata.impl.util.MetadataUtils;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdt.business.common.model.MetadataBo;
import kd.hdtc.hrdt.business.common.utils.platform.HRDTMetadataUtils;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class MetadataDomainServiceImpl
implements IMetadataDomainService {
    private static final Log logger = LogFactory.getLog(MetadataDomainServiceImpl.class);

    @Override
    public MetadataBo getMetaInfoByNumber(String number, boolean getEntityItems, boolean isSupportStandardField) {
        logger.info("MetadataDomainServiceImpl getMetaInfoByNumber {}", (Object)number);
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)number);
        if (mainType == null) {
            logger.info("MetadataDomainServiceImpl getMetaInfoByNumber can not find MainEntityType {}", (Object)number);
            return null;
        }
        MetadataBo bo = new MetadataBo();
        bo.setNumber(number);
        bo.setName(mainType.getDisplayName());
        bo.setAlias(mainType.getAlias());
        bo.setInheritPath(mainType.getInheritPath());
        bo.setAppId(mainType.getAppId());
        bo.setDbRouteKey(mainType.getDBRouteKey());
        bo.setVersion(mainType.getVersion());
        bo.setMainType(mainType);
        if (getEntityItems) {
            EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)mainType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
            if (entityMetadata == null) {
                logger.info("MetadataDomainServiceImpl getMetaInfoByNumber can not find EntityMetadata {}", (Object)number);
                return null;
            }
            bo.setParentId(entityMetadata.getParentId());
            String isv = entityMetadata.getIsv();
            if (HRStringUtils.equals((String)isv, (String)"")) {
                isv = "kingdee";
            }
            bo.setIsv(isv);
            List items = entityMetadata.getItems();
            if (CollectionUtils.isNotEmpty((Collection)items)) {
                bo.setItems(items);
            }
            ArrayList<Map<String, Object>> attachmentItems = new ArrayList<Map<String, Object>>();
            Map<String, Object> sourceMetaData = HRDTMetadataUtils.getDesignerMetadata(mainType.getName());
            this.getAttachmentPanelAp(sourceMetaData, attachmentItems);
            bo.setAttachmentItems(attachmentItems);
            if (isSupportStandardField && !HRStringUtils.equals((String)isv, (String)"kingdee")) {
                this.handleStandardFields(entityMetadata.getParentId(), bo);
            }
        }
        return bo;
    }

    private void handleStandardFields(String parentId, MetadataBo bo) {
        if (HRStringUtils.isNotEmpty((String)parentId)) {
            EntityMetadata parentEntityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)parentId, (MetaCategory)MetaCategory.Entity);
            String isv = parentEntityMetadata.getIsv();
            String id = parentEntityMetadata.getParentId();
            if (HRStringUtils.equals((String)isv, (String)"kingdee")) {
                List parentItems = parentEntityMetadata.getItems();
                ArrayList standardFieldList = Lists.newArrayList();
                parentItems.forEach(item -> standardFieldList.add(item.getKey()));
                bo.setStandardFields(standardFieldList);
                Map sourceMetaData = MetadataDao.loadDesignerMetadata((String)id, (String)RequestContext.get().getLang().toString());
                DesignMetadataParser sourceDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
                List sourceFormData = sourceDesignMetadataParser.getFormMetadata();
                List<String> standardAttachmentNumberList = sourceFormData.stream().filter(info -> String.valueOf(info.get("_Type_")).equals("AttachmentPanelAp")).map(info -> info.get("key")).filter(Objects::nonNull).map(info -> (String)info).collect(Collectors.toList());
                bo.setStandardAttachmentNumbers(standardAttachmentNumberList);
                return;
            }
            this.handleStandardFields(id, bo);
        }
    }

    private boolean getAttachmentPanelAp(Map<String, Object> sourceMetaData, List<Map<String, Object>> attachmentItems) {
        boolean haveAttachment = false;
        DesignMetadataParser sourceDesignMetadataParser = new DesignMetadataParser(sourceMetaData);
        List sourceFormData = sourceDesignMetadataParser.getFormMetadata();
        List attachments = sourceFormData.stream().filter(info -> String.valueOf(info.get("_Type_")).equals("AttachmentPanelAp")).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(attachments)) {
            attachmentItems.addAll(attachments);
        }
        return haveAttachment;
    }

    @Override
    public DynamicObject[] getBosFormMetaByEntityNumbers(List<String> entityNumber) {
        HRBaseServiceHelper metaHelper = new HRBaseServiceHelper("bos_formmeta");
        QFilter sonFilter = new QFilter("number", "in", entityNumber);
        return metaHelper.query("number,bizappid", sonFilter.toArray());
    }

    @Override
    public DynamicObject[] getBosFormBizAppNumberByBizAppIds(Set<String> ids) {
        HRBaseServiceHelper metaHelper = new HRBaseServiceHelper("bos_devportal_bizapp");
        QFilter sonFilter = new QFilter("id", "in", ids);
        return metaHelper.query("number", sonFilter.toArray());
    }

    @Override
    public Map<String, Boolean> isExistMetaData(Collection<String> numbers) {
        if (CollectionUtils.isEmpty(numbers)) {
            return null;
        }
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(numbers.size());
        for (String number : numbers) {
            result.put(number, MetadataUtils.checkNumber((String)number) ? Boolean.TRUE : Boolean.FALSE);
        }
        return result;
    }
}

