/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.ext.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrdbs.business.entity.AbstractBaseEntityService;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.constants.PersonFileToolConstants;
import kd.hdtc.hrdt.business.domain.ext.IBosEntityObjectEntityService;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hdtc.hrdt.business.domain.ext.IPermRelateEntityService;
import kd.hr.hbp.common.util.HRStringUtils;
import org.apache.commons.lang3.ArrayUtils;

public class PermRelateEntityServiceImpl
extends AbstractBaseEntityService
implements IPermRelateEntityService {
    private static final Log LOG = LogFactory.getLog(PermRelateEntityServiceImpl.class);
    private final IBosEntityObjectEntityService bosEntityObjectEntityService = ServiceFactory.getService(IBosEntityObjectEntityService.class);
    private final IMetadataDomainService metadataDomainService = ServiceFactory.getService(IMetadataDomainService.class);

    public PermRelateEntityServiceImpl() {
        super("hrcs_permrelat");
    }

    @Override
    public boolean isExistPermRelate(String entityTypeNumber) {
        if (HRStringUtils.isEmpty((String)entityTypeNumber)) {
            return false;
        }
        QFilter entityTypeFilter = new QFilter("entitytype.number", "=", (Object)entityTypeNumber);
        List permRelateList = this.queryOriginalList("id, entitytype", new QFilter[]{entityTypeFilter});
        return !CollectionUtils.isEmpty((Collection)permRelateList);
    }

    @Override
    public List<DynamicObject> toPermRelateEntityDynList(String entityType, List<String> mainPermItemList, List<String> entityTypeIdList, String bizType) {
        if (CollectionUtils.isEmpty(mainPermItemList) || CollectionUtils.isEmpty(entityTypeIdList) || StringUtils.isEmpty((CharSequence)entityType)) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList entityNumberList = Lists.newArrayListWithExpectedSize((int)(entityTypeIdList.size() + 1));
        entityNumberList.addAll(entityTypeIdList);
        entityNumberList.add(entityType);
        Map<String, DynamicObject> numberDyMap = this.bosEntityObjectEntityService.queryOneByNumberList(entityNumberList);
        String appId = "0".equals(bizType) ? "1WXBPN7+OHJZ" : "2ZK3NJ2OQYKX";
        Object[] bosFormBizApps = this.metadataDomainService.getBosFormBizAppNumberByBizAppIds(Collections.singleton(appId));
        Object app = ArrayUtils.isNotEmpty((Object[])bosFormBizApps) ? bosFormBizApps[0] : null;
        ArrayList permRelateEntityDynList = Lists.newArrayListWithExpectedSize((int)mainPermItemList.size());
        mainPermItemList.forEach(arg_0 -> this.lambda$toPermRelateEntityDynList$1(numberDyMap, entityType, appId, entityTypeIdList, (DynamicObject)app, permRelateEntityDynList, arg_0));
        return permRelateEntityDynList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult savePermRelate(DynamicObject[] dynamicObjects) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        try (TXHandle txHandle = TX.requiresNew();){
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"hrcs_permrelat", (DynamicObject[])dynamicObjects, (OperateOption)option);
        }
        if (!operationResult.isSuccess()) {
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence)operationResult.getMessage()) ? operationResult.getMessage() : ResManager.loadKDString((String)"\u4fdd\u5b58\u5173\u8054\u6743\u9650\u9879\u5931\u8d25", (String)"PersonFileToolDomainServiceImpl_3", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        }
        return operationResult;
    }

    private /* synthetic */ void lambda$toPermRelateEntityDynList$1(Map numberDyMap, String entityType, String appId, List entityTypeIdList, DynamicObject app, List permRelateEntityDynList, String mainPermItem) {
        DynamicObject permRelateEntityDyn = this.generateEmptyDynamicObject();
        permRelateEntityDyn.set("entitytype", numberDyMap.get(entityType));
        permRelateEntityDyn.set("bizapp", (Object)appId);
        permRelateEntityDyn.set("appcombo", (Object)PersonFileToolConstants.APP_ID_AND_APP_NAME_MAP.get(appId));
        permRelateEntityDyn.set("mainpermitem", (Object)mainPermItem);
        DynamicObjectCollection dynamicObjectCollection = permRelateEntityDyn.getDynamicObjectCollection("entryentity");
        entityTypeIdList.forEach(entityTypeId -> {
            DynamicObject entry = dynamicObjectCollection.addNew();
            entry.set("entitytypeid", numberDyMap.get(entityTypeId));
            entry.set("app", (Object)app);
            entry.set("permitemid", (Object)mainPermItem);
            entry.set("permitem", (Object)PersonFileToolConstants.PERM_ID_AND_PERM_NAME_MAP.get(mainPermItem));
            entry.set("issyspreset", (Object)Boolean.FALSE);
        });
        permRelateEntityDynList.add(permRelateEntityDyn);
    }
}

