/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.extendplatform.base.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.metadata.AbstractElement;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.model.MetadataBo;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelAbilityDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.entity.IBizModelAbilityEntityService;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;

public class BizModelAbilityDomainServiceImpl
implements IBizModelAbilityDomainService {
    private static final String DEFAULT_PROPERTIES = "id, number, name, index, description, bizmodeltype,parent.id,type, tool, knowledge, entryentity, entryentity.bizmodel";
    private IBizModelAbilityEntityService bizModelAbilityEntityService = ServiceFactory.getService(IBizModelAbilityEntityService.class);
    IMetadataDomainService iMetadataDomainService = ServiceFactory.getService(IMetadataDomainService.class);

    @Override
    public DynamicObject[] queryBizModelAbility(long bizModelTypeId, int bizModelLevel) {
        QFilter bizModelTypeFilter = new QFilter("bizmodeltype", "=", (Object)bizModelTypeId);
        QFilter levelFilter = new QFilter("entryentity.bizmodel.level", "<=", (Object)bizModelLevel);
        return this.bizModelAbilityEntityService.query(DEFAULT_PROPERTIES, new QFilter[]{bizModelTypeFilter, levelFilter, QFilterConstants.Q_ENABLE});
    }

    @Override
    public DynamicObject[] queryAllEnableBizModelAbility() {
        return this.bizModelAbilityEntityService.query(DEFAULT_PROPERTIES, new QFilter[]{QFilterConstants.Q_ENABLE}, "index asc");
    }

    @Override
    public DynamicObject queryBizModelAbilityById(Long id) {
        return this.bizModelAbilityEntityService.queryOne(DEFAULT_PROPERTIES, id);
    }

    @Override
    public Map<String, Integer> queryToolNoEffectCount(String bizModelLongNumber, Set<String> toolCodes) {
        if (CollectionUtils.isEmpty(toolCodes)) {
            return null;
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>(toolCodes.size());
        for (String toolCode : toolCodes) {
            Optional<String> condition;
            List<EntityItem<?>> items;
            result.put(toolCode, 0);
            MetadataBo mainMetaInfo = this.iMetadataDomainService.getMetaInfoByNumber(toolCode, true, false);
            if (mainMetaInfo == null || CollectionUtils.isEmpty(items = mainMetaInfo.getItems()) || !(condition = items.stream().map(AbstractElement::getKey).filter(data -> data.equalsIgnoreCase("effectivestatus")).findAny()).isPresent()) continue;
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(toolCode);
            QFilter statusFilter = new QFilter("effectivestatus", "=", (Object)"1");
            Optional<String> bizModelCondition = items.stream().filter(data -> {
                if (data.getKey().equalsIgnoreCase("bizmodel") && data instanceof BasedataField) {
                    return StringUtils.isNotEmpty((String)((BasedataField)data).getFieldName());
                }
                return false;
            }).map(AbstractElement::getKey).findAny();
            if (bizModelCondition.isPresent()) {
                statusFilter.and(new QFilter("bizmodel.longnumber", "like", (Object)(bizModelLongNumber + "%")));
            }
            int count = hrBaseServiceHelper.count(toolCode, new QFilter[]{statusFilter});
            result.put(toolCode, count);
        }
        return result;
    }
}

