/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.extendplatform.base.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.metadata.entity.BaseEntity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.constants.QFilterConstants;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.metadatafield.FieldTypeEnum;
import kd.hdtc.hrdt.business.common.metadatafield.parse.IMetaDataFieldParser;
import kd.hdtc.hrdt.business.common.metadatafield.parse.MetaDataFieldParserFactory;
import kd.hdtc.hrdt.business.common.model.MetadataBo;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.entity.IBizModelEntityService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.BizModelConfigFieldBo;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.BizModelMainEntityBo;
import kd.hr.hbp.common.util.HRStringUtils;

public class BizModelDomainServiceImpl
implements IBizModelDomainService {
    private static final String DEFAULTPROPERTIES = "id, number, name, index, description, bizmodeltype, parent, knowledge, bizapp, bizunit,isv,isextdata,level,longnumber, isaddmodel, mainentity, ismodmodel, isaddfield, inheritentryentity, inheritentryentity.inheritpath, subentryentity, subentryentity.subentity";
    private static final String DEFAULT_ORDER_BY = "level asc";
    private static final String DEFAULT_BIZ_ORDER_BY = "index asc,number asc";
    private IBizModelEntityService modelEntityService = ServiceFactory.getService(IBizModelEntityService.class);
    IMetadataDomainService iMetadataDomainService = ServiceFactory.getService(IMetadataDomainService.class);

    @Override
    public DynamicObject[] queryAllBizModel() {
        return this.modelEntityService.query(DEFAULTPROPERTIES, new QFilter[]{QFilterConstants.Q_ENABLE}, DEFAULT_BIZ_ORDER_BY);
    }

    @Override
    public DynamicObject[] queryAllEnableSubBizModel(List<Long> parentBizModelIds) {
        QFilter parentFilter = new QFilter("parent", "in", parentBizModelIds);
        return this.modelEntityService.query(DEFAULTPROPERTIES, new QFilter[]{parentFilter, QFilterConstants.Q_ENABLE});
    }

    @Override
    public Object[] saveBizModels(List<DynamicObject> bizModels) {
        if (CollectionUtils.isEmpty(bizModels)) {
            return null;
        }
        return this.modelEntityService.save(bizModels.toArray(new DynamicObject[0]));
    }

    @Override
    public DynamicObject queryById(long id) {
        return this.modelEntityService.queryOne(DEFAULTPROPERTIES, id);
    }

    @Override
    public List<BizModelConfigFieldBo> getEntityFields(String metaNumber) {
        MetadataBo bo = this.iMetadataDomainService.getMetaInfoByNumber(metaNumber, true, false);
        if (bo == null || CollectionUtils.isEmpty(bo.getItems())) {
            return null;
        }
        List<EntityItem<?>> items = bo.getItems();
        ArrayList<BizModelConfigFieldBo> fields = new ArrayList<BizModelConfigFieldBo>(items.size());
        items.stream().forEach(item -> {
            BizModelConfigFieldBo fieldBo = new BizModelConfigFieldBo();
            fieldBo.setNumber(item.getKey());
            fieldBo.setName(item.getName().toString());
            fieldBo.setType(item.getClass().getName());
            fieldBo.setInherit(item.isInherit());
            fieldBo.setCanModify(true);
            fieldBo.setCanModifyMustInput(false);
            fieldBo.setCanModifyDisplay(false);
        });
        return fields;
    }

    @Override
    public BizModelMainEntityBo getBizModelMainEntityBo(String mainEntityNumber, boolean dealInherit) {
        List<Map<String, Object>> attachmentItems;
        MetadataBo mainMetaInfo = this.iMetadataDomainService.getMetaInfoByNumber(mainEntityNumber, true, true);
        if (mainMetaInfo == null) {
            return null;
        }
        BizModelMainEntityBo bizModelMainEntityBo = new BizModelMainEntityBo();
        bizModelMainEntityBo.setNumber(mainMetaInfo.getNumber());
        bizModelMainEntityBo.setName(mainMetaInfo.getName().getLocaleValue());
        bizModelMainEntityBo.setParentId(mainMetaInfo.getParentId());
        List<EntityItem<?>> items = mainMetaInfo.getItems();
        if (CollectionUtils.isEmpty(items)) {
            return bizModelMainEntityBo;
        }
        ArrayList bizModelConfigFieldBos = Lists.newArrayListWithExpectedSize((int)items.size());
        bizModelMainEntityBo.setMainEntityFields(bizModelConfigFieldBos);
        ArrayList originItems = Lists.newArrayListWithExpectedSize((int)items.size());
        HashMap FieldToParserMap = Maps.newHashMapWithExpectedSize((int)4);
        items.stream().forEach(item -> {
            boolean condition;
            boolean bl = condition = !(item instanceof BaseEntity) && (dealInherit || !item.isInherit());
            if (condition) {
                String fieldClassName = item.getClass().getName();
                IMetaDataFieldParser iMetaDataFieldParser = (IMetaDataFieldParser)FieldToParserMap.get(fieldClassName);
                if (iMetaDataFieldParser == null && (iMetaDataFieldParser = MetaDataFieldParserFactory.getMetaDataFieldParserByClassName(fieldClassName)) != null) {
                    FieldToParserMap.put(fieldClassName, iMetaDataFieldParser);
                }
                originItems.add(item);
            }
        });
        String isv = mainMetaInfo.getIsv();
        if (CollectionUtils.isNotEmpty((Collection)originItems)) {
            for (EntityItem originItem : originItems) {
                bizModelConfigFieldBos.add(this.buildBizModelConfigFieldBo(originItem, (IMetaDataFieldParser)FieldToParserMap.get(originItem.getClass().getName()), mainMetaInfo.getStandardFields(), isv));
            }
        }
        if (CollectionUtils.isNotEmpty(attachmentItems = mainMetaInfo.getAttachmentItems())) {
            for (Map<String, Object> item2 : attachmentItems) {
                bizModelConfigFieldBos.add(this.buildBizModelConfigAttachmentFieldBo(item2, isv, mainMetaInfo.getStandardAttachmentNumbers()));
            }
        }
        return bizModelMainEntityBo;
    }

    private BizModelConfigFieldBo buildBizModelConfigFieldBo(EntityItem<?> originItem, IMetaDataFieldParser metaDataFieldParser, List<String> standardFieldList, String isv) {
        BizModelConfigFieldBo bizModelConfigFieldBo = new BizModelConfigFieldBo();
        bizModelConfigFieldBo.setName(originItem.getName().getLocaleValue());
        bizModelConfigFieldBo.setNumber(originItem.getKey());
        bizModelConfigFieldBo.setType(originItem.getClass().getName());
        bizModelConfigFieldBo.setInherit(originItem.isInherit());
        if (!HRStringUtils.equals((String)isv, (String)"kingdee") && !standardFieldList.contains(originItem.getKey())) {
            bizModelConfigFieldBo.setExt(true);
        }
        bizModelConfigFieldBo.setFieldType(MetaDataFieldParserFactory.META_FIELD_MAP.get(originItem.getClass().getName()));
        if (metaDataFieldParser != null) {
            bizModelConfigFieldBo.setFieldRuleContent(metaDataFieldParser.fieldConfigContent(originItem));
        }
        return bizModelConfigFieldBo;
    }

    private BizModelConfigFieldBo buildBizModelConfigAttachmentFieldBo(Map<String, Object> attachment, String isv, List<String> standardAttachmentNumberList) {
        BizModelConfigFieldBo bizModelConfigFieldBo = new BizModelConfigFieldBo();
        bizModelConfigFieldBo.setName((String)attachment.get("Name"));
        bizModelConfigFieldBo.setNumber((String)attachment.get("Key"));
        bizModelConfigFieldBo.setType(MetaDataFieldParserFactory.getAttachmentPanelClassName());
        bizModelConfigFieldBo.setFieldType(FieldTypeEnum.ATTACHMENTPANEL.getType());
        Boolean inherit = (Boolean)attachment.get("Inherit");
        if (inherit != null) {
            bizModelConfigFieldBo.setInherit(inherit);
        }
        if (!HRStringUtils.equals((String)isv, (String)"kingdee") && !standardAttachmentNumberList.contains(attachment.get("key"))) {
            bizModelConfigFieldBo.setExt(true);
        }
        return bizModelConfigFieldBo;
    }
}

