/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.extendplatform.base.impl;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.hdtc.hrdbs.business.common.ServiceFactory;
import kd.hdtc.hrdbs.business.domain.metadata.IDynamicMetadataDomainService;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdt.business.domain.extendplatform.base.IBizModelRecordDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.entity.IBizModelRecordEntityService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultBo;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultDataBo;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultDynBo;
import kd.hdtc.hrdt.common.util.HRDyObjectUtils;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class BizModelRecordDomainServiceImpl
implements IBizModelRecordDomainService {
    private static final Log LOG = LogFactory.getLog(BizModelRecordDomainServiceImpl.class);
    IBizModelRecordEntityService iBizModelRecordEntityService = kd.hdtc.hrdt.business.common.ServiceFactory.getService(IBizModelRecordEntityService.class);
    private static final String QUERY_FIELD = "bizmodel,entryentity.result,entryentity.ability,result_tag,objectid,entryentity.operator,entryentity.operatetime";
    IDynamicMetadataDomainService dynamicMetadataDomainService = (IDynamicMetadataDomainService)ServiceFactory.getService(IDynamicMetadataDomainService.class);

    @Override
    public boolean saveBizModelRecord(List<ToolResultBo> toolResultBoList) {
        if (!this.checkParams(toolResultBoList)) {
            return false;
        }
        this.addDynVersion(toolResultBoList);
        Map<Long, List<ToolResultBo>> toolResultMap = toolResultBoList.stream().collect(Collectors.groupingBy(it -> it.getBizModelId()));
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>(toolResultMap.size());
        Set<Long> bizModelIdList = toolResultMap.keySet();
        DynamicObject[] bizModels = this.iBizModelRecordEntityService.query(QUERY_FIELD, new QFilter("bizmodel", "in", bizModelIdList).toArray());
        Map<Long, DynamicObject> bizModelMap = Arrays.stream(bizModels).collect(Collectors.toMap(it -> it.getDynamicObject("bizmodel").getLong("id"), it -> it));
        for (Map.Entry<Long, List<ToolResultBo>> map : toolResultMap.entrySet()) {
            DynamicObject modelRecord;
            if (bizModelMap.containsKey(map.getKey())) {
                modelRecord = bizModelMap.get(map.getKey());
            } else {
                modelRecord = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"hrdt_bizmodelrecord"));
                modelRecord.set("bizmodel", (Object)map.getKey());
                modelRecord.set("creator", (Object)UserServiceHelper.getCurrentUserId());
            }
            map.getValue().forEach(it -> {
                DynamicObject entryEntity = modelRecord.getDynamicObjectCollection("entryentity").addNew();
                entryEntity.set("ability", (Object)it.getAbilityId());
                entryEntity.set("objectid", (Object)it.getObjectId());
                HRDyObjectUtils.setBigText((DynamicObject)entryEntity, (String)"result", (String)it.metaContentToJson());
            });
            resultList.add(modelRecord);
        }
        this.iBizModelRecordEntityService.save(resultList.toArray(new DynamicObject[0]));
        return true;
    }

    private void addDynVersion(List<ToolResultBo> toolResultBoList) {
        List<ToolResultDynBo> dynBoList;
        if (CollectionUtils.isEmpty(toolResultBoList)) {
            return;
        }
        HashSet noVersionMetadataNumbers = new HashSet(toolResultBoList.size());
        HashMap<String, String> allVersion = new HashMap<String, String>(toolResultBoList.size());
        for (ToolResultBo bo : toolResultBoList) {
            dynBoList = bo.getDyns();
            if (CollectionUtils.isEmpty(dynBoList)) continue;
            dynBoList.forEach(dynBo -> {
                String number = dynBo.getNumber();
                if (StringUtils.isNotEmpty((String)number)) {
                    String versionNumber = dynBo.getVersionNumber();
                    if (StringUtils.isNotEmpty((String)versionNumber)) {
                        allVersion.put(number, versionNumber);
                    } else {
                        noVersionMetadataNumbers.add(number);
                    }
                }
            });
        }
        if (CollectionUtils.isNotEmpty(noVersionMetadataNumbers)) {
            for (String number : noVersionMetadataNumbers) {
                String version = EntityMetadataCache.getRuntimeMetadataVersion((String)number);
                if (!StringUtils.isNotEmpty((String)version)) continue;
                allVersion.put(number, version);
            }
        }
        for (ToolResultBo bo : toolResultBoList) {
            dynBoList = bo.getDyns();
            if (CollectionUtils.isEmpty(dynBoList)) continue;
            dynBoList.forEach(dynBo -> {
                String version;
                String number = dynBo.getNumber();
                if (StringUtils.isNotEmpty((String)number) && StringUtils.isNotEmpty((String)(version = (String)allVersion.get(number)))) {
                    dynBo.setVersionNumber(version);
                }
            });
        }
    }

    private boolean checkParams(List<ToolResultBo> toolResultBoList) {
        if (CollectionUtils.isEmpty(toolResultBoList)) {
            return false;
        }
        return !toolResultBoList.stream().anyMatch(it -> !this.checkBo((ToolResultBo)it));
    }

    private boolean checkBo(ToolResultBo toolResultBo) {
        if (toolResultBo.getBizModelId() == 0L || toolResultBo.getAbilityId() == 0L) {
            return false;
        }
        if (toolResultBo.getDyns().stream().anyMatch(it -> HRStringUtils.isEmpty((String)it.getNumber()))) {
            return false;
        }
        return !toolResultBo.getDatas().stream().anyMatch(it -> HRStringUtils.isEmpty((String)it.getNumber()) || CollectionUtils.isEmpty(it.getIds()));
    }

    @Override
    public DynamicObject getBizModelRecordById(Long id) {
        return this.iBizModelRecordEntityService.queryOne(QUERY_FIELD, new QFilter("id", "=", (Object)id).toArray());
    }

    @Override
    public void rollBackModelRecord(List<ToolResultBo> toolResultBoList) {
        LOG.info("rollBackModelRecord start");
        if (CollectionUtils.isNotEmpty(toolResultBoList)) {
            for (ToolResultBo toolResultBo : toolResultBoList) {
                try {
                    List dynList = toolResultBo.getDyns();
                    if (CollectionUtils.isNotEmpty(dynList)) {
                        dynList = Lists.reverse(dynList);
                        for (ToolResultDynBo dyn : dynList) {
                            LOG.info("rollBackModelRecord delete DynamicObject:{} start", (Object)dyn.getNumber());
                            this.dynamicMetadataDomainService.deleteMetadata(dyn.getNumber(), false);
                            LOG.info("rollBackModelRecord delete DynamicObject:{} end", (Object)dyn.getNumber());
                        }
                    }
                }
                catch (Exception e) {
                    LOG.error("rollBackModelRecord delete DynamicObject error", (Throwable)e);
                }
                try {
                    this.deletePresetData(toolResultBo.getDatas());
                }
                catch (Exception e) {
                    LOG.error("rollBackModelRecord delete presetData error", (Throwable)e);
                }
            }
        }
        LOG.info("rollBackModelRecord end");
    }

    private void deletePresetData(List<ToolResultDataBo> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            return;
        }
        for (ToolResultDataBo toolResultDataBo : dataList) {
            String number = toolResultDataBo.getNumber();
            List<Object> ids = toolResultDataBo.getIds();
            if (!StringUtils.isNotEmpty((String)number) || !CollectionUtils.isNotEmpty(ids)) continue;
            LOG.info("rollBackModelRecord delete presetData:number:{} ids:{} start", (Object)number, ids);
            HRBaseServiceHelper hrBaseServiceHelper = new HRBaseServiceHelper(number);
            List<ToolResultDataBo> subDataList = toolResultDataBo.getSubDataList();
            if (CollectionUtils.isEmpty(subDataList)) {
                hrBaseServiceHelper.delete(ids.toArray(new Object[0]));
            } else {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)number);
                DataEntityPropertyCollection props = type.getProperties();
                HashSet<String> finalProp = new HashSet<String>(subDataList.size());
                Set propSelect = subDataList.stream().map(ToolResultDataBo::getNumber).collect(Collectors.toSet());
                for (IDataEntityProperty property : props) {
                    if (!propSelect.contains(property.getName()) || !(property instanceof EntryProp)) continue;
                    finalProp.add(property.getName());
                }
                if (CollectionUtils.isEmpty(finalProp)) continue;
                Object[] dynList = hrBaseServiceHelper.loadDynamicObjectArray(ids.toArray(new Object[0]));
                Map<String, List> subDataMap = subDataList.stream().collect(Collectors.toMap(ToolResultDataBo::getNumber, ToolResultDataBo::getIds, (v1, v2) -> v2));
                if (!ObjectUtils.isEmpty((Object[])dynList)) {
                    for (Object dyn : dynList) {
                        finalProp.stream().forEach(arg_0 -> this.lambda$deletePresetData$10(subDataMap, (DynamicObject)dyn, arg_0));
                    }
                    hrBaseServiceHelper.save((DynamicObject[])dynList);
                }
            }
            LOG.info("rollBackModelRecord delete presetData:number:{} ids:{} end", (Object)number, ids);
        }
    }

    private void removeEntryPropData(String prop, Map<String, List<Object>> subDataMap, DynamicObject dyn) {
        List<Object> subData = subDataMap.get(prop);
        DynamicObjectCollection collectionData = dyn.getDynamicObjectCollection(prop);
        if (CollectionUtils.isEmpty(subData) || CollectionUtils.isEmpty((Collection)collectionData)) {
            return;
        }
        Set subDataVal = subData.stream().map(data -> String.valueOf(data)).collect(Collectors.toSet());
        for (int collectIndex = 0; collectIndex < collectionData.size(); ++collectIndex) {
            Object id = ((DynamicObject)collectionData.get(collectIndex)).get("id");
            if (!subDataVal.contains(String.valueOf(id))) continue;
            collectionData.remove(collectIndex);
        }
        dyn.set(prop, (Object)collectionData);
    }

    private /* synthetic */ void lambda$deletePresetData$10(Map subDataMap, DynamicObject dyn, String prop) {
        this.removeEntryPropData(prop, subDataMap, dyn);
    }
}

