/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.extendplatform.base.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import kd.bos.dataentity.resource.ResManager;
import kd.hdtc.hrdbs.common.exception.HDTCBizException;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdbs.common.util.StringUtils;
import kd.hdtc.hrdt.business.common.utils.SplitNumberUtil;
import kd.hdtc.hrdt.business.common.utils.platform.ISVServiceUtils;
import kd.hdtc.hrdt.business.domain.extendplatform.base.INumberGenerateDomainService;

public class NumberGenerateDomainServiceImpl
implements INumberGenerateDomainService {
    private boolean isKingdeeISV = true;
    private String currentIsv;

    @Override
    public Map<String, Map<String, String>> generateMulBySourceNumber(Set<String> sourceNumbers) {
        if (CollectionUtils.isEmpty(sourceNumbers)) {
            return null;
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(sourceNumbers.size());
        this.currentIsv = ISVServiceUtils.getCurrentISV();
        this.isKingdeeISV = ISVServiceUtils.isKingdeeISV();
        for (String sourceNumber : sourceNumbers) {
            HashMap<String, String> numberMap = new HashMap<String, String>(4);
            String number = sourceNumber;
            Function<String, String> mainFunc = this.getMainFunc();
            if (mainFunc != null) {
                number = mainFunc.apply(number);
            }
            number = this.setISVNumber(number);
            number = this.dealLargeNumber(number);
            numberMap.put("current_entity_number_func", number);
            Map<String, Function<String, String>> mulFunc = this.getMulFunc();
            if (CollectionUtils.isNotEmpty(mulFunc)) {
                for (Map.Entry<String, Function<String, String>> mFunc : mulFunc.entrySet()) {
                    if (mFunc.getValue() == null) continue;
                    numberMap.put(mFunc.getKey(), mFunc.getValue().apply(number));
                }
            }
            result.put(sourceNumber, numberMap);
        }
        return result;
    }

    @Override
    public Map<String, Map<String, String>> generateMulBySourceNumber(Set<String> sourceNumbers, Map<String, Object> params) {
        if (CollectionUtils.isEmpty(sourceNumbers)) {
            return null;
        }
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>(sourceNumbers.size());
        this.currentIsv = ISVServiceUtils.getCurrentISV();
        this.isKingdeeISV = ISVServiceUtils.isKingdeeISV();
        Iterator<String> iterator = sourceNumbers.iterator();
        while (iterator.hasNext()) {
            String sourceNumber;
            String number = sourceNumber = iterator.next();
            HashMap<String, String> numberMap = new HashMap<String, String>(4);
            Function<String, String> mainFunc = this.getMainFunc();
            if (mainFunc != null) {
                number = mainFunc.apply(sourceNumber);
            }
            number = this.setISVNumber(number);
            number = this.dealLargeNumber(number);
            numberMap.put("current_entity_number_func", number);
            Map<String, Function<String, String>> mulFunc = this.getMulFunc(params);
            if (CollectionUtils.isNotEmpty(mulFunc)) {
                for (Map.Entry<String, Function<String, String>> mFunc : mulFunc.entrySet()) {
                    if (mFunc.getValue() == null) continue;
                    numberMap.put(mFunc.getKey(), mFunc.getValue().apply(number));
                }
            }
            result.put(sourceNumber, numberMap);
        }
        return result;
    }

    protected Function<String, String> getMainFunc() {
        return null;
    }

    protected Map<String, Function<String, String>> getMulFunc() {
        return null;
    }

    protected int getLargestLength() {
        return 25;
    }

    protected Map<String, Function<String, String>> getMulFunc(Map<String, Object> params) {
        return null;
    }

    private String setISVNumber(String number) {
        if (!this.isKingdeeISV && StringUtils.isNotEmpty((String)number) && !number.startsWith(this.currentIsv)) {
            number = this.currentIsv + "_" + number;
        }
        return number;
    }

    private Map<String, String> dealLongerNumber(Set<String> sourceNumbers) {
        if (CollectionUtils.isEmpty(sourceNumbers)) {
            return new HashMap<String, String>(16);
        }
        HashMap<String, String> resultMap = new HashMap<String, String>(sourceNumbers.size());
        StringBuilder errorInfo = new StringBuilder();
        for (String sourceNumber : sourceNumbers) {
            String number = this.dealLargeNumber(sourceNumber);
            String mapNumber = (String)resultMap.get(number);
            if (StringUtils.isNotEmpty((String)mapNumber)) {
                errorInfo.append(String.format(ResManager.loadKDString((String)"%1$s\u4e0e%2$s\u5b9e\u4f53\u7f16\u7801\u975e\u6cd5\uff0c\u4f1a\u751f\u6210\u76f8\u540c\u7f16\u7801\uff0c\u8bf7\u786e\u8ba4", (String)"NumberGenerateDomainServiceImpl_1", (String)"hdtc-hrdt-business", (Object[])new Object[0]), sourceNumber, mapNumber));
                continue;
            }
            resultMap.put(number, sourceNumber);
        }
        if (StringUtils.isNotEmpty((String)errorInfo.toString())) {
            throw new HDTCBizException(errorInfo.toString());
        }
        return resultMap;
    }

    public String dealLargeNumber(String number) {
        int largestNumberLeg = this.getLargestLength();
        if (StringUtils.isEmpty((String)number)) {
            return number;
        }
        return SplitNumberUtil.getSplitNumber(number, largestNumberLeg);
    }
}

