/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.constants.PersonFileToolConstants;
import kd.hdtc.hrdt.business.common.utils.SplitNumberUtil;
import kd.hdtc.hrdt.business.domain.config.IHRDTBaseConfigDomainService;
import kd.hdtc.hrdt.business.domain.ext.IBosEntityObjectEntityService;
import kd.hdtc.hrdt.business.domain.ext.ICadreInfoGroupPageRegisterEntityService;
import kd.hdtc.hrdt.business.domain.ext.IEntityForbidEntityService;
import kd.hdtc.hrdt.business.domain.ext.IMetadataDomainService;
import kd.hdtc.hrdt.business.domain.ext.IPermRelateEntityService;
import kd.hdtc.hrdt.business.domain.ext.IPersonEntityConfigEntityService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultBo;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.ICadreFileToolDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.impl.CadreFileToolNumberGenerateDomainServiceImpl;
import kd.hr.hbp.business.application.impl.newhismodel.HisModelController;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import org.apache.commons.lang3.ArrayUtils;

public class CadreFileToolDomainServiceImpl
implements ICadreFileToolDomainService {
    private static final Log LOG = LogFactory.getLog(CadreFileToolDomainServiceImpl.class);
    private final IPersonEntityConfigEntityService iPersonEntityConfigEntityService = ServiceFactory.getService(IPersonEntityConfigEntityService.class);
    private final IPermRelateEntityService iPermRelateEntityService = ServiceFactory.getService(IPermRelateEntityService.class);
    private final IEntityForbidEntityService iEntityForbidEntityService = ServiceFactory.getService(IEntityForbidEntityService.class);
    private final ICadreInfoGroupPageRegisterEntityService iCadreInfoGroupPageRegisterEntityService = ServiceFactory.getService(ICadreInfoGroupPageRegisterEntityService.class);
    private final IHRDTBaseConfigDomainService ihrdtBaseConfigDomainService = ServiceFactory.getService(IHRDTBaseConfigDomainService.class);
    private final IBosEntityObjectEntityService iBosEntityObjectEntityService = ServiceFactory.getService(IBosEntityObjectEntityService.class);
    IMetadataDomainService iMetadataDomainService = ServiceFactory.getService(IMetadataDomainService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult saveMultiViewConfigDyn(DynamicObject[] dynamicObjects) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        try (TXHandle txHandle = TX.requiresNew();){
            String entityNumber = dynamicObjects[0].getDataEntityType().getName();
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])dynamicObjects, (OperateOption)option);
        }
        if (!operationResult.isSuccess()) {
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence)operationResult.getMessage()) ? operationResult.getMessage() : ResManager.loadKDString((String)"\u4fdd\u5b58\u4eba\u5458\u89c6\u56fe\u6a21\u578b\u4fe1\u606f\u5931\u8d25", (String)"CadreFileToolDomainServiceImpl_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        }
        return operationResult;
    }

    @Override
    public boolean isExistPersonEntityConfig(String entityNumber) {
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return false;
        }
        QFilter intSourceIdFilter = new QFilter("entity", "=", (Object)entityNumber);
        QFilter classifyFilter = new QFilter("classify", "=", (Object)"perattached");
        return this.iPersonEntityConfigEntityService.isExists(intSourceIdFilter.and(classifyFilter));
    }

    @Override
    public boolean isExistInfoGroupPageRegister(String number) {
        if (StringUtils.isEmpty((CharSequence)number)) {
            return false;
        }
        QFilter numberFilter = new QFilter("number", "=", (Object)number);
        return this.iCadreInfoGroupPageRegisterEntityService.isExists(numberFilter);
    }

    @Override
    public String generateInfoGroupPageRegisterNumber(String entityNumber, String bizType, long fileTypeId) {
        if (StringUtils.isEmpty((CharSequence)entityNumber) || StringUtils.isEmpty((CharSequence)bizType)) {
            return "";
        }
        String finalFileType = fileTypeId / 10L % 100L + "";
        String number = SplitNumberUtil.getSplitNumber(entityNumber, 20);
        return number + "_" + bizType + "_" + finalFileType + "_extpl";
    }

    @Override
    public DynamicObject toPersonEntityConfigDyn(String entityNumber, String entityName) {
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            return null;
        }
        DynamicObject personEntityConfig = this.iPersonEntityConfigEntityService.generateEmptyDynamicObject();
        String number = entityNumber + "_extpl";
        number = number.length() > 20 ? number.substring(0, 20) : number;
        personEntityConfig.set("name", (Object)entityName);
        personEntityConfig.set("number", (Object)number);
        personEntityConfig.set("classify", (Object)"perattached");
        personEntityConfig.set("historytype", (Object)this.getHistoryType(entityNumber));
        personEntityConfig.set("entity", (Object)entityNumber);
        return personEntityConfig;
    }

    @Override
    public List<DynamicObject> toPermRelateEntityDynList(String entityType, List<String> mainPermItemList, List<String> entityTypeIdList, String bizType) {
        if (CollectionUtils.isEmpty(mainPermItemList) || CollectionUtils.isEmpty(entityTypeIdList) || StringUtils.isEmpty((CharSequence)entityType)) {
            return new ArrayList<DynamicObject>();
        }
        ArrayList entityNumberList = Lists.newArrayListWithExpectedSize((int)(entityTypeIdList.size() + 1));
        entityNumberList.addAll(entityTypeIdList);
        entityNumberList.add(entityType);
        Map<String, DynamicObject> numberDyMap = this.iBosEntityObjectEntityService.queryOneByNumberList(entityNumberList);
        String appId = "0".equals(bizType) ? "3CUZVOXOG9E8" : "2ZK3NJ2OQYKX";
        Object[] bosFormBizApps = this.iMetadataDomainService.getBosFormBizAppNumberByBizAppIds(Collections.singleton(appId));
        Object app = ArrayUtils.isNotEmpty((Object[])bosFormBizApps) ? bosFormBizApps[0] : null;
        ArrayList permRelateEntityDynList = Lists.newArrayListWithExpectedSize((int)mainPermItemList.size());
        mainPermItemList.forEach(arg_0 -> this.lambda$toPermRelateEntityDynList$1(numberDyMap, entityType, appId, entityTypeIdList, (DynamicObject)app, permRelateEntityDynList, arg_0));
        return permRelateEntityDynList;
    }

    @Override
    public List<DynamicObject> toEntityForbidEntityDynList(List<String> entityNumberList, String appId, String forbidType) {
        if (CollectionUtils.isEmpty(entityNumberList)) {
            return new ArrayList<DynamicObject>();
        }
        Object[] bosFormBizApps = this.iMetadataDomainService.getBosFormBizAppNumberByBizAppIds(Collections.singleton(appId));
        Object app = ArrayUtils.isNotEmpty((Object[])bosFormBizApps) ? bosFormBizApps[0] : null;
        Map<String, DynamicObject> numberDyMap = this.iBosEntityObjectEntityService.queryOneByNumberList(entityNumberList);
        ArrayList entityForbidDynList = Lists.newArrayListWithExpectedSize((int)entityNumberList.size());
        entityNumberList.forEach(arg_0 -> this.lambda$toEntityForbidEntityDynList$2(numberDyMap, (DynamicObject)app, forbidType, entityForbidDynList, arg_0));
        return entityForbidDynList;
    }

    private String getHistoryType(String entityNumber) {
        String type = HisModelController.getInstance().entityInhRelation(entityNumber);
        return "1".equals(type) ? "time" : "nontime";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult savePersonEntityConfig(DynamicObject[] dynamicObjects) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        try (TXHandle txHandle = TX.requiresNew();){
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"hrpi_personentityconf", (DynamicObject[])dynamicObjects, (OperateOption)option);
        }
        if (!operationResult.isSuccess()) {
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence)operationResult.getMessage()) ? operationResult.getMessage() : ResManager.loadKDString((String)"\u4fdd\u5b58\u4eba\u5458\u6a21\u578b\u914d\u7f6e\u4fe1\u606f\u5931\u8d25", (String)"PersonFileToolDomainServiceImpl_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        }
        return operationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult savePermRelate(DynamicObject[] dynamicObjects) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        try (TXHandle txHandle = TX.requiresNew();){
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"hrcs_permrelat", (DynamicObject[])dynamicObjects, (OperateOption)option);
        }
        if (!operationResult.isSuccess()) {
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence)operationResult.getMessage()) ? operationResult.getMessage() : ResManager.loadKDString((String)"\u4fdd\u5b58\u5173\u8054\u6743\u9650\u9879\u5931\u8d25", (String)"PersonFileToolDomainServiceImpl_3", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        }
        return operationResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResult saveEntityForbid(DynamicObject[] dynamicObjects) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        try (TXHandle txHandle = TX.requiresNew();){
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"hrcs_entityforbid", (DynamicObject[])dynamicObjects, (OperateOption)option);
            LOG.info("CadreFileToolDomainServiceImpl saveEntityForbid success size {}", (Object)dynamicObjects.length);
            LOG.info("CadreFileToolDomainServiceImpl saveEntityForbid operationResult isSucess:{},message:", (Object)operationResult.isSuccess(), (Object)operationResult.getMessage());
        }
        if (!operationResult.isSuccess()) {
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence)operationResult.getMessage()) ? operationResult.getMessage() : ResManager.loadKDString((String)"\u4fdd\u5b58\u7981\u6b62\u914d\u7f6e\u5b9e\u4f53\u5931\u8d25", (String)"PersonFileToolDomainServiceImpl_4", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        }
        return operationResult;
    }

    @Override
    public DynamicObject toInfoGroupPageRegisterDyn(DynamicObject personFileToolDyn, Map<String, List<String>> viewTypeAndMetaDataNumberMap) {
        String bizType = personFileToolDyn.getString("biztype");
        long fileTypeId = personFileToolDyn.getLong("filetype.id");
        DynamicObject infoGroupPageRegister = this.iCadreInfoGroupPageRegisterEntityService.generateEmptyDynamicObject();
        String entityNumber = personFileToolDyn.getString("bizmodel.mainentity.number");
        String entityName = personFileToolDyn.getString("bizmodel.mainentity.name");
        String infoGroupPageRegisterNumber = this.generateInfoGroupPageRegisterNumber(entityNumber, bizType, fileTypeId);
        infoGroupPageRegister.set("number", (Object)infoGroupPageRegisterNumber.toUpperCase(Locale.ROOT));
        infoGroupPageRegister.set("name", (Object)entityName);
        infoGroupPageRegister.set("enable", (Object)"1");
        infoGroupPageRegister.set("modifytime", (Object)new Date());
        infoGroupPageRegister.set("group", (Object)personFileToolDyn.getDynamicObject("filetype"));
        DynamicObject pageInfo = personFileToolDyn.getDynamicObject("bizmodel.mainentity");
        infoGroupPageRegister.set("pageinfo", (Object)pageInfo);
        infoGroupPageRegister.set("pagetype", (Object)"3");
        infoGroupPageRegister.set("viewlocation", (Object)personFileToolDyn.getString("region"));
        infoGroupPageRegister.set("businesstype", (Object)personFileToolDyn.getString("biztype"));
        this.setManageInfoGroupPageRegisterParam(personFileToolDyn, viewTypeAndMetaDataNumberMap, infoGroupPageRegister);
        return infoGroupPageRegister;
    }

    private void setEmployeeInfoGroupPageRegisterParam(DynamicObject personFileToolDyn, Map<String, List<String>> viewTypeAndMetaDataNumberMap, DynamicObject infoGroupPageRegister) {
        String pcView = personFileToolDyn.getString("employeepcview");
        String pcParamNumber = "employeepcview." + pcView;
        List<String> metaDataNumbers = viewTypeAndMetaDataNumberMap.get(pcParamNumber);
        if ("1".equals(pcView)) {
            infoGroupPageRegister.set("dyviewpc", (Object)(CollectionUtils.isNotEmpty(metaDataNumbers) ? metaDataNumbers.get(0) : ""));
        } else if (CollectionUtils.isNotEmpty(metaDataNumbers) && metaDataNumbers.size() >= 2) {
            for (String metaDataNumber : metaDataNumbers) {
                if (metaDataNumber.endsWith("_pdv")) {
                    infoGroupPageRegister.set("dyviewpc", (Object)metaDataNumber);
                    continue;
                }
                if (!metaDataNumber.endsWith("_pdg")) continue;
                infoGroupPageRegister.set("dialogpc", (Object)metaDataNumber);
            }
        }
        String mobileView = personFileToolDyn.getString("employeemobileview");
        String mobileParamNumber = "employeemobileview." + mobileView;
        List<String> mobileMetaDataNumbers = viewTypeAndMetaDataNumberMap.get(mobileParamNumber);
        if ("1".equals(mobileView)) {
            String mobileMetaDataNumber = CollectionUtils.isNotEmpty(mobileMetaDataNumbers) ? mobileMetaDataNumbers.get(0) : "";
            infoGroupPageRegister.set("dyviewmobile", (Object)mobileMetaDataNumber);
            infoGroupPageRegister.set("dialogmobile", (Object)mobileMetaDataNumber);
        } else {
            String mobileMetaDataNumber = CollectionUtils.isNotEmpty(mobileMetaDataNumbers) ? mobileMetaDataNumbers.get(0) : "";
            String mobileDialogMetaDataNumber = "";
            if (CollectionUtils.isNotEmpty(mobileMetaDataNumbers) && mobileMetaDataNumbers.size() > 1) {
                mobileDialogMetaDataNumber = mobileMetaDataNumbers.get(1);
            }
            if (mobileMetaDataNumber.indexOf("_mdv") >= 0) {
                infoGroupPageRegister.set("dyviewmobile", (Object)mobileMetaDataNumber);
                infoGroupPageRegister.set("dialogmobile", (Object)mobileDialogMetaDataNumber);
            } else {
                infoGroupPageRegister.set("dialogmobile", (Object)mobileMetaDataNumber);
                infoGroupPageRegister.set("dyviewmobile", (Object)mobileDialogMetaDataNumber);
            }
        }
    }

    private void setManageInfoGroupPageRegisterParam(DynamicObject personFileToolDyn, Map<String, List<String>> viewTypeAndMetaDataNumberMap, DynamicObject infoGroupPageRegister) {
        String pcView = personFileToolDyn.getString("pcview");
        String pcParamNumber = "pcview." + pcView;
        List<String> metaDataNumbers = viewTypeAndMetaDataNumberMap.get(pcParamNumber);
        if ("1".equals(pcView)) {
            infoGroupPageRegister.set("dyviewpc", (Object)(CollectionUtils.isNotEmpty(metaDataNumbers) ? metaDataNumbers.get(0) : ""));
        } else if (CollectionUtils.isNotEmpty(metaDataNumbers) && metaDataNumbers.size() >= 2) {
            for (String metaDataNumber : metaDataNumbers) {
                if (metaDataNumber.endsWith("_dv")) {
                    infoGroupPageRegister.set("dyviewpc", (Object)metaDataNumber);
                    continue;
                }
                if (!metaDataNumber.endsWith("_dg")) continue;
                infoGroupPageRegister.set("dialogpc", (Object)metaDataNumber);
            }
        }
    }

    @Override
    public OperationResult saveInfoGroupPageRegister(DynamicObject dynamicObject, ToolResultBo toolResultBo) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        try {
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"soebs_infogrouppagereg", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)option);
            dynamicObject.set("id", operationResult.getSuccessPkIds().get(0));
            toolResultBo.addData("soebs_infogrouppagereg", operationResult.getSuccessPkIds());
        }
        catch (Exception ex) {
            LOG.error("CadreFileToolDomainServiceImpl saveInfoGroupPageRegister error", (Throwable)ex);
            return null;
        }
        if (!operationResult.isSuccess()) {
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence)operationResult.getMessage()) ? operationResult.getMessage() : ResManager.loadKDString((String)"\u4fdd\u5b58\u5e72\u90e8\u4fe1\u606f\u7ec4\u9875\u9762\u6ce8\u518c\u6570\u636e\u5931\u8d25", (String)"CadreFileToolDomainServiceImpl_1", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        }
        LOG.info("CadreFileToolDomainServiceImpl ISOEBSInfoGroupService saveInfoGroupField start");
        HRMServiceHelper.invokeBizService((String)"sihc", (String)"soebs", (String)"ISOEBSInfoGroupService", (String)"saveInfoGroupField", (Object[])new Object[]{operationResult.getSuccessPkIds().get(0)});
        LOG.info("CadreFileToolDomainServiceImpl ISOEBSInfoGroupService saveInfoGroupField end");
        return operationResult;
    }

    @Override
    public Map<String, String> getPersonFilePages(String paramNumber) {
        Map<Object, Object> numberValueMap = Maps.newLinkedHashMapWithExpectedSize((int)2);
        if (StringUtils.isEmpty((CharSequence)paramNumber)) {
            return numberValueMap;
        }
        String baseConfigKeys = PersonFileToolConstants.CADRE_FIELD_NAME_AND_BASE_CONFIG_KEY_MAP.get(paramNumber);
        if (StringUtils.isEmpty((CharSequence)paramNumber)) {
            return numberValueMap;
        }
        String[] personFilePages = baseConfigKeys.split(",");
        numberValueMap = this.ihrdtBaseConfigDomainService.queryBaseConfigValueByNumberList(Arrays.asList(personFilePages));
        return numberValueMap;
    }

    @Override
    public Map<String, String> getPersonFileFormPlugin(Set<String> numberSet) {
        if (CollectionUtils.isEmpty(numberSet)) {
            return null;
        }
        List<String> numberList = numberSet.stream().map(number -> number + ".plugin").collect(Collectors.toList());
        Map<String, String> numberValueMap = this.ihrdtBaseConfigDomainService.queryBaseConfigValueByNumberList(numberList);
        return numberValueMap;
    }

    @Override
    public Map<String, Map<String, String>> generateNumbers(Set<String> sourceNumbers, Long fileTypeId) {
        CadreFileToolNumberGenerateDomainServiceImpl numberGenerateDomainService = new CadreFileToolNumberGenerateDomainServiceImpl();
        HashMap params = Maps.newHashMapWithExpectedSize((int)3);
        params.put("fileTypeId", fileTypeId);
        return numberGenerateDomainService.generateMulBySourceNumber(sourceNumbers, params);
    }

    private /* synthetic */ void lambda$toEntityForbidEntityDynList$2(Map numberDyMap, DynamicObject app, String forbidType, List entityForbidDynList, String entityNumber) {
        DynamicObject entityForbidDyn = this.iEntityForbidEntityService.generateEmptyDynamicObject();
        entityForbidDyn.set("entitytypeid", numberDyMap.get(entityNumber));
        entityForbidDyn.set("app", (Object)app);
        entityForbidDyn.set("forbidtype", (Object)forbidType);
        entityForbidDyn.set("issyspreset", (Object)Boolean.TRUE);
        LOG.info("CadreFileToolDomainServiceImpl toEntityForbidEntityDynList entitytypeid:{}, app:{},forbidtype:{}", new Object[]{numberDyMap.get(entityNumber), app.get("number"), forbidType});
        entityForbidDynList.add(entityForbidDyn);
    }

    private /* synthetic */ void lambda$toPermRelateEntityDynList$1(Map numberDyMap, String entityType, String appId, List entityTypeIdList, DynamicObject app, List permRelateEntityDynList, String mainPermItem) {
        DynamicObject permRelateEntityDyn = this.iPermRelateEntityService.generateEmptyDynamicObject();
        permRelateEntityDyn.set("entitytype", numberDyMap.get(entityType));
        permRelateEntityDyn.set("bizapp", (Object)appId);
        permRelateEntityDyn.set("appcombo", (Object)PersonFileToolConstants.CADRE_APP_ID_AND_APP_NAME_MAP.get(appId));
        permRelateEntityDyn.set("mainpermitem", (Object)mainPermItem);
        DynamicObjectCollection dynamicObjectCollection = permRelateEntityDyn.getDynamicObjectCollection("entryentity");
        entityTypeIdList.forEach(entityTypeId -> {
            DynamicObject entry = dynamicObjectCollection.addNew();
            entry.set("entitytypeid", numberDyMap.get(entityTypeId));
            entry.set("app", (Object)app);
            entry.set("permitemid", (Object)mainPermItem);
            entry.set("permitem", (Object)PersonFileToolConstants.PERM_ID_AND_PERM_NAME_MAP.get(mainPermItem));
            entry.set("issyspreset", (Object)Boolean.FALSE);
        });
        permRelateEntityDynList.add(permRelateEntityDyn);
    }
}

