/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.hdtc.hrdbs.common.exception.HRDBSBizException;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.constants.PersonFileToolConstants;
import kd.hdtc.hrdt.business.common.utils.SplitNumberUtil;
import kd.hdtc.hrdt.business.domain.ext.IEntityForbidEntityService;
import kd.hdtc.hrdt.business.domain.ext.IInfoGroupFieldEntityService;
import kd.hdtc.hrdt.business.domain.ext.IInfoGroupPageRegisterEntityService;
import kd.hdtc.hrdt.business.domain.ext.IMultiViewConfigEmpEntityService;
import kd.hdtc.hrdt.business.domain.ext.IMultiViewConfigEntityService;
import kd.hdtc.hrdt.business.domain.ext.IPermRelateEntityService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultBo;
import kd.hdtc.hrdt.business.domain.extendplatform.base.model.ToolResultDataBo;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.biztools.IMulPersonFileToolDomainService;
import kd.hr.hbp.business.servicehelper.HRMServiceHelper;
import kd.hr.hbp.common.util.HRStringUtils;

public class MulPersonFileToolDomainServiceImpl
implements IMulPersonFileToolDomainService {
    private static final Log LOG = LogFactory.getLog(MulPersonFileToolDomainServiceImpl.class);
    private final IInfoGroupPageRegisterEntityService infoGroupPageRegisterEntityService = ServiceFactory.getService(IInfoGroupPageRegisterEntityService.class);
    private final IInfoGroupFieldEntityService infoGroupFieldEntityService = ServiceFactory.getService(IInfoGroupFieldEntityService.class);
    private final IPermRelateEntityService permRelateEntityService = ServiceFactory.getService(IPermRelateEntityService.class);
    private final IMultiViewConfigEmpEntityService multiViewConfigEmpEntityService = ServiceFactory.getService(IMultiViewConfigEmpEntityService.class);
    private final IMultiViewConfigEntityService multiViewConfigEntityService = ServiceFactory.getService(IMultiViewConfigEntityService.class);
    private final IEntityForbidEntityService entityForbidEntityService = ServiceFactory.getService(IEntityForbidEntityService.class);

    @Override
    public Map<DynamicObject, DynamicObject> registerPersonInfoGroupPage(DynamicObject mulPersonFileData, Map<String, List<String>> viewTypeAndMetaDataNumberMap, ToolResultBo toolResultBo) {
        DynamicObjectCollection mulPersonFileEntryData = mulPersonFileData.getDynamicObjectCollection("personfileentry");
        HashMap mulPersonFileAndInfoGroupMap = Maps.newHashMapWithExpectedSize((int)mulPersonFileEntryData.size());
        List<DynamicObject> personInfoGroupPage = this.generatePersonInfoGroupPage(mulPersonFileData, viewTypeAndMetaDataNumberMap, mulPersonFileAndInfoGroupMap);
        OperationResult operationResult = this.saveInfoGroupPageRegister(personInfoGroupPage, toolResultBo);
        if (operationResult != null) {
            this.refreshInfoGroupField(operationResult);
            List<Object> infoGroupFieldIds = this.infoGroupFieldEntityService.queryInfoGroupFieldIdByGroupIds(operationResult.getSuccessPkIds());
            toolResultBo.addData("hspm_infogroupfield", infoGroupFieldIds);
        }
        return mulPersonFileAndInfoGroupMap;
    }

    @Override
    public void addPermRelate(String viewType, Map<DynamicObject, DynamicObject> mulPersonFileAndInfoGroupMap, ToolResultBo toolResultBo) {
        if (CollectionUtils.isEmpty(mulPersonFileAndInfoGroupMap)) {
            LOG.info("MulPersonFileToolDomainServiceImpl addPermRelate mulPersonFileAndInfoGroupMap is empty");
            return;
        }
        if ("1".equals(viewType)) {
            LOG.info("MulPersonFileToolDomainServiceImpl addPermRelate viewType\uff1a {}", (Object)viewType);
            return;
        }
        ArrayList entityTypeNumbers = Lists.newArrayListWithExpectedSize((int)mulPersonFileAndInfoGroupMap.size());
        ArrayList<DynamicObject> permRelateEntityList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> forbidEntityDynList = new ArrayList<DynamicObject>(10);
        for (Map.Entry<DynamicObject, DynamicObject> mulPersonFileAndInfoGroupEntry : mulPersonFileAndInfoGroupMap.entrySet()) {
            DynamicObject mulPersonFileEntry = mulPersonFileAndInfoGroupEntry.getKey();
            DynamicObject infoGroupEntry = mulPersonFileAndInfoGroupEntry.getValue();
            String bizType = mulPersonFileEntry.getString("biztype");
            String dyViewPc = infoGroupEntry.getString("dyviewpc");
            String dialogPc = infoGroupEntry.getString("dialogpc");
            if (HRStringUtils.isNotEmpty((String)dyViewPc)) {
                this.generatePermRelate(dyViewPc, dialogPc, entityTypeNumbers, permRelateEntityList, forbidEntityDynList, bizType);
            }
            String dyViewMobile = infoGroupEntry.getString("dyviewmobile");
            String dialogMobile = infoGroupEntry.getString("dialogmobile");
            if (!HRStringUtils.isNotEmpty((String)dyViewMobile)) continue;
            this.generatePermRelate(dyViewMobile, dialogMobile, entityTypeNumbers, permRelateEntityList, forbidEntityDynList, bizType);
        }
        if (CollectionUtils.isNotEmpty(permRelateEntityList)) {
            OperationResult operationResult = this.permRelateEntityService.savePermRelate(permRelateEntityList.toArray(new DynamicObject[0]));
            toolResultBo.addData("hrcs_permrelat", operationResult != null ? operationResult.getSuccessPkIds() : new ArrayList());
        }
        if (CollectionUtils.isNotEmpty(forbidEntityDynList)) {
            Object[] result = this.entityForbidEntityService.save(forbidEntityDynList.toArray(new DynamicObject[0]));
            if (result == null) {
                return;
            }
            ArrayList ids = Lists.newArrayListWithExpectedSize((int)result.length);
            for (Object entityFory : result) {
                if (!(entityFory instanceof DynamicObject)) continue;
                ids.add(((DynamicObject)entityFory).getLong("id"));
            }
            toolResultBo.addData("hrcs_entityforbid", ids);
        }
    }

    @Override
    public void registerMultiViewConfig(Map<DynamicObject, DynamicObject> mulPersonFileAndInfoGroupMap, ToolResultBo toolResultBo) {
        if (CollectionUtils.isEmpty(mulPersonFileAndInfoGroupMap)) {
            LOG.info("MulPersonFileToolDomainServiceImpl registerMultiViewConfig mulPersonFileAndInfoGroupMap is empty");
            return;
        }
        ArrayList infoGroupPageIds = Lists.newArrayListWithExpectedSize((int)mulPersonFileAndInfoGroupMap.size());
        mulPersonFileAndInfoGroupMap.forEach((key, dy) -> infoGroupPageIds.add(dy.getLong("id")));
        Map<Long, List<DynamicObject>> groupIdAndInfoGroupFieldMap = this.infoGroupFieldEntityService.queryInfoGroupFieldByGroupIds(infoGroupPageIds);
        if (CollectionUtils.isEmpty(groupIdAndInfoGroupFieldMap)) {
            LOG.info("MulPersonFileToolDomainServiceImpl registerMultiViewConfig groupIdAndInfoGroupFieldMap is empty");
            return;
        }
        ArrayList<DynamicObject> multiViewConfigList = new ArrayList<DynamicObject>(10);
        ToolResultDataBo toolResultDataBo = new ToolResultDataBo();
        ArrayList<DynamicObject> empMultiViewConfigList = new ArrayList<DynamicObject>(10);
        ToolResultDataBo empToolResultDataBo = new ToolResultDataBo();
        for (Map.Entry<DynamicObject, DynamicObject> mulPersonFileAndInfoGroupEntry : mulPersonFileAndInfoGroupMap.entrySet()) {
            DynamicObject mulPersonFileEntry = mulPersonFileAndInfoGroupEntry.getKey();
            DynamicObject infoGroupEntry = mulPersonFileAndInfoGroupEntry.getValue();
            String bizType = mulPersonFileEntry.getString("biztype");
            if ("1".equals(bizType)) {
                Object[] empMultiViewConfigs = this.generateMultiViewConfig(mulPersonFileEntry, infoGroupEntry, groupIdAndInfoGroupFieldMap.get(infoGroupEntry.getLong("id")), empToolResultDataBo);
                if (!ArrayUtils.isNotEmpty((Object[])empMultiViewConfigs)) continue;
                empMultiViewConfigList.addAll(Arrays.asList(empMultiViewConfigs));
                continue;
            }
            Object[] multiViewConfigs = this.generateMultiViewConfig(mulPersonFileEntry, infoGroupEntry, groupIdAndInfoGroupFieldMap.get(infoGroupEntry.getLong("id")), toolResultDataBo);
            if (!ArrayUtils.isNotEmpty((Object[])multiViewConfigs)) continue;
            multiViewConfigList.addAll(Arrays.asList(multiViewConfigs));
        }
        if (!CollectionUtils.isEmpty(empMultiViewConfigList)) {
            this.saveMultiViewConfigDyn(empMultiViewConfigList, empToolResultDataBo, toolResultBo);
        }
        if (!CollectionUtils.isEmpty(multiViewConfigList)) {
            this.saveMultiViewConfigDyn(multiViewConfigList, toolResultDataBo, toolResultBo);
        }
    }

    private void saveMultiViewConfigDyn(List<DynamicObject> multiViewConfigs, ToolResultDataBo toolResultDataBo, ToolResultBo toolResultBo) {
        toolResultDataBo.setNumber(multiViewConfigs.get(0).getDataEntityType().getName());
        OperationResult operationResult = this.doSaveMultiViewConfig(multiViewConfigs.toArray(new DynamicObject[0]));
        if (operationResult != null && operationResult.isSuccess()) {
            toolResultDataBo.setIds(operationResult.getSuccessPkIds());
            toolResultBo.addData(toolResultDataBo);
        }
    }

    private void generatePermRelate(String dyView, String dialog, List<String> entityTypeNumbers, List<DynamicObject> permRelateEntityList, List<DynamicObject> forbidEntityDynList, String bizType) {
        List<DynamicObject> entityForbidEntityDynList;
        List<DynamicObject> permRelateEntityDynList;
        if (entityTypeNumbers.contains(dyView)) {
            return;
        }
        boolean existPermRelate = this.permRelateEntityService.isExistPermRelate(dyView);
        if (existPermRelate) {
            return;
        }
        if (!HRStringUtils.equals((String)dyView, (String)dialog) && CollectionUtils.isNotEmpty(permRelateEntityDynList = this.permRelateEntityService.toPermRelateEntityDynList(dyView, PersonFileToolConstants.CARD_PERM_ID_LIST, Collections.singletonList(dialog), bizType))) {
            permRelateEntityList.addAll(permRelateEntityDynList);
        }
        if ("1".equals(bizType) && CollectionUtils.isNotEmpty(entityForbidEntityDynList = this.entityForbidEntityService.toEntityForbidEntityDynList(Arrays.asList(dialog, dyView), "1WXBPN7+OHJZ", "3"))) {
            forbidEntityDynList.addAll(entityForbidEntityDynList);
        }
        entityTypeNumbers.add(dyView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationResult doSaveMultiViewConfig(DynamicObject[] empMultiViewConfigs) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        try (TXHandle txHandle = TX.requiresNew();){
            String entityNumber = empMultiViewConfigs[0].getDataEntityType().getName();
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)entityNumber, (DynamicObject[])empMultiViewConfigs, (OperateOption)option);
        }
        if (!operationResult.isSuccess()) {
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence)operationResult.getMessage()) ? operationResult.getMessage() : ResManager.loadKDString((String)"\u4fdd\u5b58\u4eba\u5458\u89c6\u56fe\u6a21\u578b\u4fe1\u606f\u5931\u8d25", (String)"PersonFileToolDomainServiceImpl_0", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        }
        return operationResult;
    }

    private DynamicObject[] generateMultiViewConfig(DynamicObject mulPersonFileEntry, DynamicObject infoGroupEntry, List<DynamicObject> infoGroupFields, ToolResultDataBo toolResultDataBo) {
        if (CollectionUtils.isEmpty(infoGroupFields)) {
            return null;
        }
        String dialogPc = infoGroupEntry.getString("dialogpc");
        String bizType = mulPersonFileEntry.getString("biztype");
        Object[] multiViewConfigs = this.getMultiViewConfigs(mulPersonFileEntry, bizType);
        if (ArrayUtils.isEmpty((Object[])multiViewConfigs)) {
            return null;
        }
        long infoGroupPageRegisterId = infoGroupEntry.getLong("id");
        long[] entityIds = ID.genLongIds((int)multiViewConfigs.length);
        ToolResultDataBo entryData = new ToolResultDataBo("groupentity", Arrays.stream(entityIds).boxed().collect(Collectors.toList()));
        for (int index = 0; index < multiViewConfigs.length; ++index) {
            Object multiViewConfig = multiViewConfigs[index];
            DynamicObjectCollection groupEntityCollection = multiViewConfig.getDynamicObjectCollection("groupentity");
            DynamicObject dynamicObject = groupEntityCollection.addNew();
            dynamicObject.set("id", (Object)entityIds[index]);
            dynamicObject.set("groupid", (Object)infoGroupPageRegisterId);
            dynamicObject.set("groupname", (Object)infoGroupEntry.getString("name"));
            dynamicObject.set("relation", (Object)infoGroupPageRegisterId);
            dynamicObject.set("allisedit", (Object)Boolean.FALSE);
            dynamicObject.set("allisrequired", (Object)Boolean.FALSE);
            dynamicObject.set("allisaudit", (Object)Boolean.FALSE);
            dynamicObject.set("isallowadd", (Object)Boolean.FALSE);
            String viewLocation = mulPersonFileEntry.getString("region");
            if (HRStringUtils.isEmpty((String)viewLocation)) {
                viewLocation = "1";
            }
            dynamicObject.set("configarea", (Object)viewLocation);
            DynamicObjectCollection fieldEntityCollection = dynamicObject.getDynamicObjectCollection("fieldentity");
            int seq = 1;
            long[] subEntityIds = ID.genLongIds((int)infoGroupFields.size());
            ToolResultDataBo subEntryData = new ToolResultDataBo("fieldentity", Arrays.stream(subEntityIds).boxed().collect(Collectors.toList()));
            entryData.addSubData(subEntryData);
            int idx = 0;
            for (DynamicObject field : infoGroupFields) {
                if ("description".equals(field.getString("number")) || HRStringUtils.isEmpty((String)dialogPc) && "18".equals(field.getString("type"))) continue;
                long subEntityId = subEntityIds[idx++];
                DynamicObject fieldEntity = fieldEntityCollection.addNew();
                fieldEntity.set("id", (Object)subEntityId);
                fieldEntity.set("field", (Object)field);
                fieldEntity.set("seq", (Object)seq++);
                fieldEntity.set("isedit", (Object)field.getBoolean("isedit"));
                fieldEntity.set("isrequired", (Object)field.getBoolean("isrequired"));
                fieldEntity.set("isaudit", (Object)Boolean.FALSE);
                if ("18".equals(field.getString("type"))) {
                    fieldEntity.set("fieldtype", (Object)"3");
                    continue;
                }
                if ("12".equals(field.getString("type"))) {
                    fieldEntity.set("fieldtype", (Object)"2");
                    continue;
                }
                fieldEntity.set("fieldtype", (Object)"1");
            }
        }
        toolResultDataBo.addSubData(entryData);
        return multiViewConfigs;
    }

    private DynamicObject[] getMultiViewConfigs(DynamicObject mulPersonFileEntry, String bizType) {
        String fileName = "1".equals(bizType) ? "pcfileviews" : "personfileviews";
        DynamicObjectCollection multiViewConfigs = mulPersonFileEntry.getDynamicObjectCollection(fileName);
        ArrayList multiViewConfigIdList = Lists.newArrayListWithExpectedSize((int)multiViewConfigs.size());
        if (CollectionUtils.isNotEmpty((Collection)multiViewConfigs)) {
            multiViewConfigs.forEach(dy -> multiViewConfigIdList.add(dy.getLong("fbasedataid_id")));
        }
        if ("1".equals(bizType)) {
            return this.multiViewConfigEmpEntityService.queryMultiViewConfigEmpsByIdList(multiViewConfigIdList);
        }
        return this.multiViewConfigEntityService.queryMultiViewConfigsByIdList(multiViewConfigIdList);
    }

    private OperationResult saveInfoGroupPageRegister(List<DynamicObject> personInfoGroupPage, ToolResultBo toolResultBo) {
        OperationResult operationResult;
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", Boolean.TRUE.toString());
        try {
            DynamicObject[] personInfoGroupPageDy = personInfoGroupPage.toArray(new DynamicObject[0]);
            operationResult = OperationServiceHelper.executeOperate((String)"save", (String)"hspm_infogrouppagereg", (DynamicObject[])personInfoGroupPageDy, (OperateOption)option);
            toolResultBo.addData("hspm_infogrouppagereg", operationResult.getSuccessPkIds());
        }
        catch (Exception ex) {
            LOG.error("MulPersonFileToolDomainServiceImpl saveInfoGroupPageRegister error", (Throwable)ex);
            throw new HRDBSBizException(ex.getMessage());
        }
        if (!operationResult.isSuccess()) {
            throw new HRDBSBizException(StringUtils.isNotBlank((CharSequence)operationResult.getMessage()) ? operationResult.getMessage() : ResManager.loadKDString((String)"\u4fdd\u5b58\u4eba\u5458\u4fe1\u606f\u7ec4\u9875\u9762\u6ce8\u518c\u6570\u636e\u5931\u8d25", (String)"PersonFileToolDomainServiceImpl_1", (String)"hdtc-hrdbs-business", (Object[])new Object[0]));
        }
        return operationResult;
    }

    private void refreshInfoGroupField(OperationResult operationResult) {
        List successPkIds = operationResult.getSuccessPkIds();
        if (CollectionUtils.isEmpty((Collection)successPkIds)) {
            LOG.error("MulPersonFileToolDomainServiceImpl saveInfoGroupField successPkIds is empty");
            return;
        }
        for (Object successPkId : successPkIds) {
            LOG.error("MulPersonFileToolDomainServiceImpl saveInfoGroupField start id is {}", successPkId);
            HRMServiceHelper.invokeHRService((String)"hspm", (String)"IHSPMInfoGroupService", (String)"saveInfoGroupField", (Object[])new Object[]{successPkId});
        }
    }

    private List<DynamicObject> generatePersonInfoGroupPage(DynamicObject mulPersonFileData, Map<String, List<String>> viewTypeAndMetaDataNumberMap, Map<DynamicObject, DynamicObject> mulPersonFileAndInfoGroupMap) {
        String entityNumber = mulPersonFileData.getString("bizmodel.mainentity.number");
        String entityName = mulPersonFileData.getString("bizmodel.mainentity.name");
        DynamicObject pageInfo = mulPersonFileData.getDynamicObject("bizmodel.mainentity");
        DynamicObjectCollection mulPersonFileEntryData = mulPersonFileData.getDynamicObjectCollection("personfileentry");
        ArrayList personInfoGroupList = Lists.newArrayListWithExpectedSize((int)mulPersonFileEntryData.size());
        long[] ids = ORM.create().genLongIds("hspm_infogrouppagereg", mulPersonFileEntryData.size());
        int index = 0;
        for (DynamicObject mulPersonFileEntry : mulPersonFileEntryData) {
            long infoGroupPageId = ids[index++];
            String bizType = mulPersonFileEntry.getString("biztype");
            long fileTypeId = mulPersonFileEntry.getLong("filetype.id");
            DynamicObject infoGroupPageRegister = this.infoGroupPageRegisterEntityService.generateEmptyDynamicObject();
            infoGroupPageRegister.set("id", (Object)infoGroupPageId);
            infoGroupPageRegister.set("number", (Object)this.generateInfoGroupPageRegisterNumber(entityNumber, bizType, fileTypeId).toUpperCase(Locale.ROOT));
            infoGroupPageRegister.set("name", (Object)entityName);
            infoGroupPageRegister.set("enable", (Object)"1");
            infoGroupPageRegister.set("modifytime", (Object)new Date());
            infoGroupPageRegister.set("createtime", (Object)new Date());
            infoGroupPageRegister.set("status", (Object)"C");
            infoGroupPageRegister.set("group", (Object)mulPersonFileEntry.getDynamicObject("filetype"));
            infoGroupPageRegister.set("pageinfo", (Object)pageInfo);
            infoGroupPageRegister.set("pagetype", (Object)"3");
            String viewLocation = mulPersonFileEntry.getString("region");
            if (HRStringUtils.isEmpty((String)viewLocation)) {
                viewLocation = "3";
            }
            infoGroupPageRegister.set("viewlocation", (Object)viewLocation);
            infoGroupPageRegister.set("businesstype", (Object)bizType);
            if ("0".equals(bizType)) {
                this.setManageInfoGroupPageRegisterParam(mulPersonFileEntry, viewTypeAndMetaDataNumberMap, infoGroupPageRegister);
            } else {
                this.setEmployeeInfoGroupPageRegisterParam(mulPersonFileEntry, viewTypeAndMetaDataNumberMap, infoGroupPageRegister);
            }
            personInfoGroupList.add(infoGroupPageRegister);
            mulPersonFileAndInfoGroupMap.put(mulPersonFileEntry, infoGroupPageRegister);
        }
        return personInfoGroupList;
    }

    @Override
    public String generateInfoGroupPageRegisterNumber(String entityNumber, String bizType, long fileTypeId) {
        if (StringUtils.isEmpty((CharSequence)entityNumber) || StringUtils.isEmpty((CharSequence)bizType)) {
            return "";
        }
        String finalFileType = fileTypeId / 10L % 100L + "";
        String number = SplitNumberUtil.getSplitNumber(entityNumber, 20);
        return number + "_" + bizType + "_" + finalFileType + "_extpl";
    }

    private void setManageInfoGroupPageRegisterParam(DynamicObject mulPersonFileEntry, Map<String, List<String>> viewTypeAndMetaDataNumberMap, DynamicObject infoGroupPageRegister) {
        String pcView = mulPersonFileEntry.getString("pcview");
        String pcParamNumber = "pcview." + pcView;
        List<String> metaDataNumbers = viewTypeAndMetaDataNumberMap.get(pcParamNumber);
        if (CollectionUtils.isEmpty(metaDataNumbers)) {
            return;
        }
        if ("1".equals(pcView)) {
            infoGroupPageRegister.set("dyviewpc", (Object)(CollectionUtils.isNotEmpty(metaDataNumbers) ? metaDataNumbers.get(0) : ""));
        } else {
            for (String metaDataNumber : metaDataNumbers) {
                if (metaDataNumber.endsWith("_dv")) {
                    infoGroupPageRegister.set("dyviewpc", (Object)metaDataNumber);
                    continue;
                }
                if (!metaDataNumber.endsWith("_dg")) continue;
                infoGroupPageRegister.set("dialogpc", (Object)metaDataNumber);
            }
        }
    }

    private void setEmployeeInfoGroupPageRegisterParam(DynamicObject mulPersonFileEntry, Map<String, List<String>> viewTypeAndMetaDataNumberMap, DynamicObject infoGroupPageRegister) {
        String pcView = mulPersonFileEntry.getString("employeepcview");
        String pcParamNumber = "employeepcview." + pcView;
        List<String> metaDataNumbers = viewTypeAndMetaDataNumberMap.get(pcParamNumber);
        if (CollectionUtils.isNotEmpty(metaDataNumbers)) {
            if ("1".equals(pcView)) {
                infoGroupPageRegister.set("dyviewpc", (Object)(CollectionUtils.isNotEmpty(metaDataNumbers) ? metaDataNumbers.get(0) : ""));
            } else {
                for (String metaDataNumber : metaDataNumbers) {
                    if (metaDataNumber.endsWith("_pdv")) {
                        infoGroupPageRegister.set("dyviewpc", (Object)metaDataNumber);
                        continue;
                    }
                    if (!metaDataNumber.endsWith("_pdg")) continue;
                    infoGroupPageRegister.set("dialogpc", (Object)metaDataNumber);
                }
            }
        }
        String mobileView = mulPersonFileEntry.getString("employeemobileview");
        String mobileParamNumber = "employeemobileview." + mobileView;
        List<String> mobileMetaDataNumbers = viewTypeAndMetaDataNumberMap.get(mobileParamNumber);
        if (CollectionUtils.isEmpty(mobileMetaDataNumbers)) {
            return;
        }
        if ("1".equals(mobileView)) {
            String mobileMetaDataNumber = mobileMetaDataNumbers.get(0);
            infoGroupPageRegister.set("dyviewmobile", (Object)mobileMetaDataNumber);
            infoGroupPageRegister.set("dialogmobile", (Object)mobileMetaDataNumber);
        } else {
            for (String mobileMetaDataNumber : mobileMetaDataNumbers) {
                if (mobileMetaDataNumber.endsWith("_mdv")) {
                    infoGroupPageRegister.set("dyviewmobile", (Object)mobileMetaDataNumber);
                    continue;
                }
                if (!mobileMetaDataNumber.endsWith("_mdg")) continue;
                infoGroupPageRegister.set("dialogmobile", (Object)mobileMetaDataNumber);
            }
        }
    }
}

