/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.extendplatform.tools.commontools.impl;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdbs.common.util.CollectionUtils;
import kd.hdtc.hrdt.business.common.ServiceFactory;
import kd.hdtc.hrdt.business.common.utils.platform.ISVServiceUtils;
import kd.hdtc.hrdt.business.domain.ext.IBosFormMetaEntityService;
import kd.hdtc.hrdt.business.domain.extendplatform.base.entity.IBizModelEntityService;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.commontools.IBizModelToolDomainService;
import kd.hdtc.hrdt.business.domain.extendplatform.tools.commontools.entity.IBizModelToolEntityService;
import kd.hdtc.hrdt.common.msgenum.BizModeMsgEnum;

public class BizModelToolDomainServiceImpl
implements IBizModelToolDomainService {
    private static final Log LOG = LogFactory.getLog(BizModelToolDomainServiceImpl.class);
    private IBizModelToolEntityService bizModelToolEntityService = ServiceFactory.getService(IBizModelToolEntityService.class);
    private IBosFormMetaEntityService iBosFormMetaEntityService = ServiceFactory.getService(IBosFormMetaEntityService.class);
    private IBizModelEntityService iBizModelEntityService = ServiceFactory.getService(IBizModelEntityService.class);

    @Override
    public Object[] update(DynamicObject[] bizModelTools) {
        return this.bizModelToolEntityService.save(bizModelTools);
    }

    @Override
    public DynamicObject[] getFormMetaByEntityIdList(List<String> dEentityIdList) {
        return this.iBosFormMetaEntityService.getFormMetaByEntityIdList(dEentityIdList);
    }

    @Override
    public boolean batchSaveBizModeConfig(DynamicObject batchBizModeDyc) {
        DynamicObject parent = batchBizModeDyc.getDynamicObject("bizmodel");
        DynamicObjectCollection entryDys = batchBizModeDyc.getDynamicObjectCollection("entryentity");
        ArrayList bizModeList = Lists.newArrayListWithCapacity((int)entryDys.size());
        long currUserId = RequestContext.get().getCurrUserId();
        LinkedList idQueue = new LinkedList();
        Arrays.stream(ID.genLongIds((int)entryDys.size())).forEach(id -> idQueue.offer(id));
        entryDys.stream().forEach(entry -> {
            DynamicObject bizMode = this.iBizModelEntityService.generateEmptyDynamicObject();
            Long id = (Long)idQueue.poll();
            bizMode.set("id", (Object)id);
            bizMode.set("masterid", (Object)id);
            bizMode.set("number", entry.get("enumber"));
            bizMode.set("name", entry.get("ename"));
            bizMode.set("bizmodeltype", (Object)1686373805922075648L);
            bizMode.set("parent", (Object)parent);
            bizMode.set("level", (Object)(parent.getInt("level") + 1));
            bizMode.set("longnumber", (Object)(parent.getString("longnumber") + "." + entry.get("enumber")));
            bizMode.set("fullname", (Object)(parent.getString("fullname") + "." + entry.get("ename")));
            bizMode.set("mainentity", entry.get("mainentity"));
            bizMode.set("isaddmodel", (Object)true);
            bizMode.set("ismodmodel", (Object)true);
            bizMode.set("isaddfield", (Object)true);
            if (!ISVServiceUtils.isKingdeeISV()) {
                bizMode.set("isextdata", (Object)Boolean.TRUE);
            }
            bizMode.set("isv", (Object)ISVServiceUtils.getCurrentISV());
            bizMode.set("enable", (Object)"1");
            bizMode.set("status", (Object)"C");
            bizMode.set("creator", (Object)currUserId);
            bizModeList.add(bizMode);
        });
        try {
            this.iBizModelEntityService.save(bizModeList.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            LOG.error("batchSaveBizModeConfig error:", (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public void validateBizModelNumberAndNameRepeat(DynamicObjectCollection dys, List<String> msgList) {
        List<String> numberList = dys.stream().map(entry -> entry.getString("enumber")).filter(Objects::nonNull).collect(Collectors.toList());
        List<String> nameList = dys.stream().map(entry -> entry.getString("ename")).filter(Objects::nonNull).collect(Collectors.toList());
        this.checkPageNumberOrNameRepeat(numberList, msgList, "number", BizModeMsgEnum.NUMBER_ALREADY_EXISTS_MSG.get());
        this.checkPageNumberOrNameRepeat(nameList, msgList, "name", BizModeMsgEnum.NAME_ALREADY_EXISTS_MSG.get());
    }

    private void checkPageNumberOrNameRepeat(List<String> paramList, List<String> msgList, String fieldStr, String msgSuffix) {
        ArrayList paramMsgList = Lists.newArrayList();
        HashMap countMap = Maps.newHashMap();
        for (String param : paramList) {
            if (countMap.containsKey(param)) {
                countMap.put(param, (Integer)countMap.get(param) + 1);
                continue;
            }
            countMap.put(param, 1);
        }
        countMap.entrySet().stream().forEach(entry -> {
            if ((Integer)entry.getValue() >= 2) {
                paramMsgList.add(String.format(Locale.ROOT, msgSuffix, entry.getKey()));
            }
        });
        if (CollectionUtils.isEmpty((Collection)paramMsgList)) {
            DynamicObject[] result = this.iBizModelEntityService.query("id,number,name", new QFilter(fieldStr, "in", paramList).toArray());
            Arrays.stream(result).forEach(res -> paramMsgList.add(String.format(Locale.ROOT, msgSuffix, res.getString(fieldStr))));
        }
        msgList.addAll(paramMsgList);
    }
}

