/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.file.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.util.StringUtils;

public class MetaDataConfigBo {
    Map<String, String> referenceMap = new HashMap<String, String>();
    private String name;
    private String alias;
    private String appId;
    private String tableGroup;
    private String dbRouteKey;
    private List<String> indexList = new ArrayList<String>();
    private String where;
    private static final String APPEND_SPLIT = "_";
    private LocaleString displayName;
    private List<IDataEntityProperty> propList = new ArrayList<IDataEntityProperty>();
    private List<IDataEntityProperty> pkList = new ArrayList<IDataEntityProperty>();

    public MetaDataConfigBo(MainEntityType mainEntityType, String tableGroup) {
        this.name = this.upperCase(mainEntityType.getName());
        this.alias = this.upperCase(mainEntityType.getAlias());
        this.appId = this.upperCase(mainEntityType.getAppId());
        this.displayName = mainEntityType.getDisplayName();
        this.tableGroup = tableGroup;
        this.setPkList(mainEntityType);
        ArrayList tmp = new ArrayList(mainEntityType.getProperties());
        this.setInitPropList(tmp);
        this.dbRouteKey = mainEntityType.getDBRouteKey();
    }

    public MetaDataConfigBo(String name, String alias, String appId, LocaleString displayName, String dbRouteKey) {
        this.name = this.upperCase(name);
        this.alias = this.upperCase(alias);
        this.appId = this.upperCase(appId);
        this.displayName = displayName;
        this.dbRouteKey = dbRouteKey;
    }

    public String getWhere() {
        return this.where;
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public String getTableGroup() {
        return this.tableGroup;
    }

    public void setTableGroup(String tableGroup) {
        this.tableGroup = tableGroup;
        if (StringUtils.isNotEmpty((String)tableGroup) && !this.alias.endsWith(this.upperCase(APPEND_SPLIT + tableGroup))) {
            this.alias = this.alias + APPEND_SPLIT + tableGroup;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAlias() {
        return this.alias;
    }

    public Map<String, String> getReferenceMap() {
        return this.referenceMap;
    }

    public void setReferenceMap(Map<String, String> referenceMap) {
        this.referenceMap = referenceMap;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public LocaleString getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(LocaleString displayName) {
        this.displayName = displayName;
    }

    public List<IDataEntityProperty> getPropList() {
        return this.propList;
    }

    public List<String> getIndexList() {
        return this.indexList;
    }

    public void addIndex(String name) {
        if (!StringUtils.isEmpty((String)name) && !this.indexList.contains(name)) {
            this.indexList.add(name);
        }
    }

    public void addIndex(List<String> list) {
        for (String str : list) {
            this.addIndex(str);
        }
    }

    private <T extends IDataEntityProperty> void setInitPropList(List<T> propList) {
        List list = propList.stream().filter(arg -> !this.isContains((IDataEntityProperty)arg, (List)this.propList)).collect(Collectors.toList());
        this.propList.addAll(list);
    }

    public <T extends IDataEntityProperty> void setPropList(List<T> propList) {
        List list = propList.stream().filter(arg -> !this.isContains((IDataEntityProperty)arg, (List)this.propList)).collect(Collectors.toList());
        this.propList.addAll(list);
    }

    private <T extends IDataEntityProperty> boolean isContains(IDataEntityProperty iDataEntityProperty, List<T> listProp) {
        if (iDataEntityProperty == null) {
            return true;
        }
        return listProp.stream().filter(Objects::nonNull).filter(arg -> StringUtils.isNotEmpty((String)arg.getAlias())).anyMatch(arg -> arg.getAlias().equalsIgnoreCase(iDataEntityProperty.getAlias()));
    }

    public List<IDataEntityProperty> getPkList() {
        return this.pkList;
    }

    private void setPkList(MainEntityType mainEntityType) {
        if (mainEntityType == null) {
            return;
        }
        mainEntityType.getAllFields();
        List list = mainEntityType.getProperties().stream().filter(Objects::nonNull).filter(arg -> arg instanceof PKFieldProp).map(arg -> (PKFieldProp)arg).filter(PKFieldProp::isPrimaryKey).collect(Collectors.toList());
        for (IDataEntityProperty property : list) {
            if (this.isContains(property, this.pkList)) continue;
            this.pkList.add(property);
        }
    }

    public void initPKList() {
        List list = this.propList.stream().filter(Objects::nonNull).filter(arg -> arg instanceof PKFieldProp).map(arg -> (PKFieldProp)arg).filter(PKFieldProp::isPrimaryKey).collect(Collectors.toList());
        for (IDataEntityProperty property : list) {
            if (this.isContains(property, this.pkList)) continue;
            this.pkList.add(property);
        }
    }

    public void addPKList(PKFieldProp pkFieldProp) {
        if (this.isContains((IDataEntityProperty)pkFieldProp, this.pkList)) {
            this.pkList.add((IDataEntityProperty)pkFieldProp);
        }
    }

    public <T extends IDataEntityProperty> void addPKList(List<T> pkFieldPropList) {
        for (IDataEntityProperty t : pkFieldPropList) {
            if (this.isContains(t, this.pkList)) continue;
            this.pkList.add(t);
        }
    }

    public void addProp(IDataEntityProperty property) {
        if (!this.isContains(property, this.propList)) {
            this.propList.add(property);
        }
    }

    public void addProp(List<IDataEntityProperty> list) {
        for (IDataEntityProperty property : list) {
            if (this.isContains(property, this.propList)) continue;
            this.propList.add(property);
        }
    }

    private String upperCase(String str) {
        return str == null ? "" : str.trim().toUpperCase(Locale.ROOT);
    }

    public String getDbRouteKey() {
        return this.dbRouteKey;
    }
}

