/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.file.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.LongProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.entity.property.PKFieldProp;
import kd.bos.orm.util.CollectionUtils;
import kd.hdtc.hrdt.business.domain.file.model.MainTableDecodeBo;
import kd.hdtc.hrdt.business.domain.file.model.MetaDataConfigBo;
import kd.hdtc.hrdt.business.domain.file.model.MultiBaseDataDecodeBo;
import kd.hdtc.hrdt.business.domain.file.model.MultilingualDecodeBo;

public class MultiTableDecodeBo
extends MainTableDecodeBo {
    public MultiTableDecodeBo(List<MetaDataConfigBo> metaDataConfigBos) {
        this.metaList = metaDataConfigBos;
    }

    public void addMetaData(MetaDataConfigBo mainMeteConfig) {
        List<IDataEntityProperty> list = this.addProp(mainMeteConfig, new MuliLangTextProp());
        if (!CollectionUtils.isEmpty(list)) {
            MetaDataConfigBo metaDataConfigBo = this.getMetaData(mainMeteConfig, list);
            MultiTableDecodeBo.addMetaDataConfig(metaDataConfigBo, this.metaList, null);
        }
    }

    public void parseMainMetaData(MetaDataConfigBo metaDataConfigBo) {
        if (this.isContainMulTab(metaDataConfigBo, new MuliLangTextProp(), true)) {
            new MultilingualDecodeBo(this.metaList).addMetaData(metaDataConfigBo);
        }
        if (this.isContainMulTab(metaDataConfigBo, new MulBasedataProp(), false)) {
            new MultiBaseDataDecodeBo(this.metaList).addMetaData(metaDataConfigBo);
        }
    }

    public static void addMetaDataConfig(MetaDataConfigBo metaDataConfigBo, List<MetaDataConfigBo> list, String tableGroup) {
        String appId;
        if (metaDataConfigBo == null) {
            return;
        }
        String alias = MultiTableDecodeBo.getAlias(metaDataConfigBo);
        Optional<MetaDataConfigBo> optional = MultiTableDecodeBo.getOptionalMeta(alias, appId = metaDataConfigBo.getAppId().trim().toUpperCase(Locale.ROOT), list);
        if (optional.isPresent()) {
            MetaDataConfigBo tmp = optional.get();
            tmp.setPropList(metaDataConfigBo.getPropList());
            tmp.addPKList(metaDataConfigBo.getPkList());
        } else {
            metaDataConfigBo.setTableGroup(tableGroup);
            metaDataConfigBo.initPKList();
            list.add(metaDataConfigBo);
        }
    }

    private static Optional<MetaDataConfigBo> getOptionalMeta(String alias, String appId, List<MetaDataConfigBo> list) {
        return list.stream().filter(Objects::nonNull).filter(arg -> alias.equalsIgnoreCase(arg.getAlias()) && appId.equals(arg.getAppId())).findAny();
    }

    public static <T> String getAlias(T tmp) {
        return MultiTableDecodeBo.getCode(tmp);
    }

    protected void addReference(MetaDataConfigBo mainMetaConfig, MetaDataConfigBo metaDataConfigBo) {
        Optional<String> optional = super.getFKProp(mainMetaConfig).stream().filter(Objects::nonNull).map(IMetadata::getAlias).findAny();
        if (!"blank".equalsIgnoreCase(metaDataConfigBo.getAlias()) && optional.isPresent()) {
            Map<String, String> referenceMap = metaDataConfigBo.getReferenceMap();
            String alias = MultiTableDecodeBo.getAlias(metaDataConfigBo);
            String mainAlias = MultiTableDecodeBo.getAlias(mainMetaConfig);
            String appId = mainMetaConfig.getAppId();
            String tmp = optional.get();
            referenceMap.put(this.upperCase(alias + "." + tmp), this.upperCase(appId + "." + mainAlias + "." + tmp));
        }
    }

    public static <T> String getCode(T object) {
        String name;
        String alias;
        if (!(object instanceof MainEntityType) && !(object instanceof MetaDataConfigBo)) {
            return "";
        }
        if (object instanceof MainEntityType) {
            alias = ((MainEntityType)object).getAlias();
            name = ((MainEntityType)object).getName();
        } else {
            alias = ((MetaDataConfigBo)object).getAlias();
            name = ((MetaDataConfigBo)object).getName();
        }
        if (StringUtils.isNotEmpty((CharSequence)alias)) {
            return alias.trim().toUpperCase(Locale.ROOT);
        }
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            return name.trim().toUpperCase(Locale.ROOT);
        }
        return "";
    }

    protected <T extends IDataEntityProperty> MetaDataConfigBo getMetaData(MetaDataConfigBo mainMeta, List<T> list) {
        String name = this.getTableName(mainMeta);
        String alis = this.getTableAlias(mainMeta);
        String appId = mainMeta.getAppId();
        LocaleString displayName = this.getTableDisplayName(mainMeta);
        MetaDataConfigBo metaDataConfigBo = new MetaDataConfigBo(name, alis, appId, displayName, mainMeta.getDbRouteKey());
        metaDataConfigBo.setPropList(list);
        this.addIndex(mainMeta, metaDataConfigBo);
        return metaDataConfigBo;
    }

    protected <T extends IDataEntityProperty> List<IDataEntityProperty> addProp(MetaDataConfigBo metaDataConfigBo, T tmp) {
        if (tmp == null) {
            return new ArrayList<IDataEntityProperty>(16);
        }
        ArrayList<PKFieldProp> list = new ArrayList<PKFieldProp>(super.getFKProp(metaDataConfigBo, this.getPkInfo()));
        List<IDataEntityProperty> otherProp = this.getOtherProp(metaDataConfigBo);
        if (otherProp != null) {
            list.addAll(otherProp);
        }
        list.addAll(this.getMultiTableProp(metaDataConfigBo, tmp));
        return list;
    }

    protected <T extends IDataEntityProperty> List<T> getMultiTableProp(MetaDataConfigBo metaDataConfigBo, T tmp) {
        if (metaDataConfigBo == null || tmp == null) {
            return new ArrayList();
        }
        return metaDataConfigBo.getPropList().stream().filter(Objects::nonNull).filter(arg -> tmp.getClass().isAssignableFrom(arg.getClass())).map(arg -> arg).filter(MultiTableDecodeBo.distinctByKey(IMetadata::getName)).collect(Collectors.toList());
    }

    protected LocaleString getTableDisplayName(MetaDataConfigBo metaDataConfigBo) {
        return new LocaleString();
    }

    protected String getTableAlias(MetaDataConfigBo metaDataConfigBo) {
        return "blank";
    }

    protected String getTableName(MetaDataConfigBo mainEntityType) {
        return "blank";
    }

    protected void addIndex(MetaDataConfigBo mainMetaConfig, MetaDataConfigBo metaDataConfigBo) {
    }

    protected PKFieldProp getDefaultPkProperty(PKFieldProp pkFieldProp) {
        if (pkFieldProp == null) {
            pkFieldProp = new LongProp();
        }
        pkFieldProp.setAlias("FPKID");
        pkFieldProp.setName(ResManager.loadKDString((String)"\u4e3b\u952e", (String)"MultiTableDecodeBo_0", (String)"hdtc-hrdt-business", (Object[])new Object[0]));
        pkFieldProp.setPrimaryKey(true);
        return pkFieldProp;
    }

    protected List<IDataEntityProperty> getOtherProp(MetaDataConfigBo metaDataConfigBo) {
        return new ArrayList<IDataEntityProperty>();
    }

    protected static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap(16);
        return arg -> seen.putIfAbsent(keyExtractor.apply(arg), Boolean.TRUE) == null;
    }
}

