/*
 * Decompiled with CFR 0.152.
 */
package kd.hdtc.hrdt.business.domain.transfer.configgroup.impl;

import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hdtc.hrdt.business.domain.transfer.configgroup.IConfigGroupDomainService;
import kd.hdtc.hrdt.business.domain.transfer.entity.IConfigGroupEntityService;
import kd.hdtc.hrdt.business.domain.transfer.entity.impl.ConfigGroupEntityServiceImpl;
import kd.hr.hbp.common.util.HRStringUtils;

public class ConfigGroupDomainServiceImpl
implements IConfigGroupDomainService {
    private Log log = LogFactory.getLog(ConfigGroupDomainServiceImpl.class);
    private IConfigGroupEntityService configGroupEntityService = new ConfigGroupEntityServiceImpl();

    @Override
    public String queryMaxConfigGroupOrderField(Long parentId) {
        if (parentId == null) {
            return "01";
        }
        QFilter filter = new QFilter("parent", "=", (Object)parentId);
        filter.or(new QFilter("id", "=", (Object)parentId));
        Object[] dynArr = this.configGroupEntityService.query("id,parent.id,number,orderfield", new QFilter[]{filter}, "orderfield desc", 1);
        if (!ObjectUtils.isEmpty((Object[])dynArr)) {
            Object confGroupDyn = dynArr[0];
            long id = confGroupDyn.getLong("id");
            if (parentId == id) {
                return confGroupDyn.getString("orderfield") + "." + "01";
            }
            String curOrderField = confGroupDyn.getString("orderfield");
            this.log.info("queryMaxConfigGroupOrderField,parentId={},curOrderField={}", (Object)parentId, (Object)curOrderField);
            if (HRStringUtils.isNotEmpty((String)curOrderField)) {
                String[] orderFieldArr = curOrderField.split("\\.");
                if (orderFieldArr.length <= 1) {
                    int maxOrderNum = Integer.parseInt(curOrderField) + 1;
                    return this.getNewOrderNum(maxOrderNum);
                }
                String lastOrderNumStr = orderFieldArr[orderFieldArr.length - 1];
                String prefixOrderNum = curOrderField.substring(0, curOrderField.lastIndexOf(lastOrderNumStr));
                int maxOrderNum = Integer.parseInt(lastOrderNumStr) + 1;
                return prefixOrderNum + this.getNewOrderNum(maxOrderNum);
            }
        }
        return "01";
    }

    private String getNewOrderNum(int maxOrderNum) {
        return maxOrderNum > 10 ? "" + maxOrderNum : "0" + maxOrderNum;
    }

    @Override
    public boolean isSysPresetById(Long id) {
        QFilter filter = new QFilter("issyspreset", "=", (Object)"1");
        filter.and(new QFilter("id", "=", (Object)id));
        return this.configGroupEntityService.isExists(filter);
    }
}

